/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.ConnectionPartition;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class XnfUpd
extends XjunctPartialQuantifierElimination {
    public XnfUpd(ManagedScript script, IUltimateServiceProvider services) {
        super(script, services);
    }

    @Override
    public String getName() {
        return "unconnected parameter drop";
    }

    @Override
    public String getAcronym() {
        return "UPD";
    }

    @Override
    public boolean resultIsXjunction() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Term[] tryToEliminate(int quantifier, Term[] dualJuncts, Set<TermVariable> eliminatees) {
        HashSet<TermVariable> occuringVars = new HashSet<TermVariable>();
        Term[] termArray = dualJuncts;
        int n = dualJuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term param = termArray[n2];
            occuringVars.addAll(Arrays.asList(param.getFreeVars()));
            ++n2;
        }
        eliminatees.retainAll(occuringVars);
        ConnectionPartition connection = new ConnectionPartition(Arrays.asList(dualJuncts));
        ArrayList<TermVariable> removeableTvs = new ArrayList<TermVariable>();
        ArrayList<TermVariable> unremoveableTvs = new ArrayList<TermVariable>();
        ArrayList<Term> removeableTerms = new ArrayList<Term>();
        ArrayList<Term> unremoveableTerms = new ArrayList<Term>();
        for (Set<NonTheorySymbol<?>> connectedSymbols : connection.getConnectedNonTheorySymbols()) {
            Term simplified;
            boolean isSuperfluous;
            Set<Term> connectedTerms = connection.getTermsOfConnectedNonTheorySymbols(connectedSymbols);
            Set<TermVariable> freeVarsOfConnectedTerms = SmtUtils.getFreeVars(connectedTerms);
            if (!XnfUpd.containsOnlyVariables(connectedSymbols)) {
                isSuperfluous = false;
            } else if (quantifier == 0) {
                simplified = XnfUpd.isSuperfluousConjunction(this.mScript, connectedTerms, freeVarsOfConnectedTerms, eliminatees);
                if (SmtUtils.isTrueLiteral(simplified)) {
                    isSuperfluous = true;
                } else {
                    if (SmtUtils.isFalseLiteral(simplified)) {
                        return new Term[]{simplified};
                    }
                    if (simplified != null) throw new AssertionError((Object)"illegal case");
                    isSuperfluous = false;
                }
            } else {
                if (quantifier != 1) throw new AssertionError((Object)"unknown quantifier");
                simplified = XnfUpd.isSuperfluousDisjunction(this.mScript, connectedTerms, freeVarsOfConnectedTerms, eliminatees);
                if (SmtUtils.isFalseLiteral(simplified)) {
                    isSuperfluous = true;
                } else {
                    if (SmtUtils.isTrueLiteral(simplified)) {
                        return new Term[]{simplified};
                    }
                    if (simplified != null) throw new AssertionError((Object)"illegal case");
                    isSuperfluous = false;
                }
            }
            if (isSuperfluous) {
                removeableTvs.addAll(freeVarsOfConnectedTerms);
                removeableTerms.addAll(connectedTerms);
                continue;
            }
            unremoveableTvs.addAll(freeVarsOfConnectedTerms);
            unremoveableTerms.addAll(connectedTerms);
        }
        List<Term> termsWithoutTvs = connection.getTermsWithNonTheorySymbols();
        assert (occuringVars.size() == removeableTvs.size() + unremoveableTvs.size());
        assert (dualJuncts.length == removeableTerms.size() + unremoveableTerms.size() + termsWithoutTvs.size());
        for (Term termWithoutTvs : termsWithoutTvs) {
            Script.LBool sat = Util.checkSat((Script)this.mScript, (Term)termWithoutTvs);
            if (sat == Script.LBool.UNSAT) {
                if (quantifier == 0) {
                    eliminatees.clear();
                    return new Term[]{this.mScript.term("false", new Term[0])};
                }
                if (quantifier != 1) {
                    throw new AssertionError((Object)"unknown quantifier");
                }
                continue;
            }
            if (sat != Script.LBool.SAT) throw new AssertionError((Object)"expecting sat or unsat");
            if (quantifier == 0) continue;
            if (quantifier != 1) throw new AssertionError((Object)"unknown quantifier");
            eliminatees.clear();
            return new Term[]{this.mScript.term("true", new Term[0])};
        }
        if (removeableTerms.isEmpty()) {
            return dualJuncts;
        }
        eliminatees.removeAll(removeableTvs);
        if (!unremoveableTerms.isEmpty()) return unremoveableTerms.toArray(new Term[unremoveableTerms.size()]);
        if (quantifier == 0) {
            return new Term[]{this.mScript.term("true", new Term[0])};
        }
        if (quantifier != 1) throw new AssertionError((Object)"unknown quantifier");
        return new Term[]{this.mScript.term("false", new Term[0])};
    }

    private static boolean containsOnlyVariables(Set<NonTheorySymbol<?>> connectedSymbols) {
        Predicate<NonTheorySymbol> predicate = x -> x instanceof NonTheorySymbol.Variable;
        return connectedSymbols.stream().allMatch(predicate);
    }

    public static Term isSuperfluousConjunction(Script script, Set<Term> terms, Set<TermVariable> connectedVars, Set<TermVariable> quantifiedVars) {
        if (quantifiedVars.containsAll(connectedVars)) {
            Term conjunction = SmtUtils.and(script, terms);
            Script.LBool isSat = Util.checkSat((Script)script, (Term)conjunction);
            if (isSat == Script.LBool.SAT) {
                return script.term("true", new Term[0]);
            }
            if (isSat == Script.LBool.UNSAT) {
                return script.term("false", new Term[0]);
            }
        }
        return null;
    }

    public static Term isSuperfluousDisjunction(Script script, Set<Term> terms, Set<TermVariable> connectedVars, Set<TermVariable> quantifiedVars) {
        if (quantifiedVars.containsAll(connectedVars)) {
            Term disjunction = SmtUtils.or(script, terms.toArray(new Term[terms.size()]));
            Script.LBool isSat = Util.checkSat((Script)script, (Term)SmtUtils.not(script, disjunction));
            if (isSat == Script.LBool.SAT) {
                return script.term("false", new Term[0]);
            }
            if (isSat == Script.LBool.UNSAT) {
                return script.term("true", new Term[0]);
            }
        }
        return null;
    }
}

