/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XjunctPartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XnfUsr
extends XjunctPartialQuantifierElimination {
    private final Set<TermVariable> affectedEliminatees = new HashSet<TermVariable>();

    public XnfUsr(ManagedScript script, IUltimateServiceProvider services) {
        super(script, services);
    }

    @Override
    public String getName() {
        return "unimportant select removal";
    }

    @Override
    public String getAcronym() {
        return "USR";
    }

    @Override
    public boolean resultIsXjunction() {
        return true;
    }

    @Override
    public Term[] tryToEliminate(int quantifier, Term[] dualJuncts, Set<TermVariable> eliminatees) {
        HashRelation var2arrays = new HashRelation();
        HashRelation var2parameters = new HashRelation();
        HashSet<TermVariable> blacklist = new HashSet<TermVariable>();
        Term[] termArray = dualJuncts;
        int n = dualJuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term param = termArray[n2];
            Set<ApplicationTerm> storeTerms = new ApplicationTermFinder("store", true).findMatchingSubterms(param);
            if (storeTerms.isEmpty()) {
                List<MultiDimensionalSelect> slects = MultiDimensionalSelect.extractSelectDeep(param, false);
                for (MultiDimensionalSelect mds : slects) {
                    Set<TermVariable> indexFreeVars = mds.getIndex().getFreeVars();
                    for (TermVariable tv : indexFreeVars) {
                        if (!eliminatees.contains(tv)) continue;
                        var2arrays.addPair((Object)tv, (Object)mds.getArray());
                        var2parameters.addPair((Object)tv, (Object)param);
                    }
                }
            } else {
                blacklist.addAll(Arrays.asList(param.getFreeVars()));
            }
            ++n2;
        }
        HashSet superfluousParams = new HashSet();
        for (TermVariable eliminatee : var2arrays.getDomain()) {
            if (blacklist.contains(eliminatee) || var2arrays.getImage((Object)eliminatee).size() != 1 || var2parameters.getImage((Object)eliminatee).size() != 1) continue;
            superfluousParams.addAll(var2parameters.getImage((Object)eliminatee));
            this.affectedEliminatees.add(eliminatee);
        }
        ArrayList<Term> resultAtoms = new ArrayList<Term>();
        Term[] termArray2 = dualJuncts;
        int n3 = dualJuncts.length;
        int n4 = 0;
        while (n4 < n3) {
            Term oldParam = termArray2[n4];
            if (!superfluousParams.contains(oldParam)) {
                resultAtoms.add(oldParam);
            }
            ++n4;
        }
        return resultAtoms.toArray(new Term[resultAtoms.size()]);
    }

    public Set<TermVariable> getAffectedEliminatees() {
        return this.affectedEliminatees;
    }
}

