/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EqualityInformation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.List;
import java.util.Set;

public class ArrayIndexEqualityUtils {
    public static boolean addComplimentaryEqualityInformation(Script script, int quantifier, Term[] context, Term term, ThreeValuedEquivalenceRelation<Term> equalityInformation) {
        Set antiDerTerms;
        Set derTerms;
        equalityInformation.addElement((Object)term);
        Pair<Set<Term>, Set<Term>> indexEqual = EqualityInformation.getEqTerms(script, term, context, null);
        if (quantifier == 0) {
            derTerms = (Set)indexEqual.getFirst();
            antiDerTerms = (Set)indexEqual.getSecond();
        } else if (quantifier == 1) {
            derTerms = (Set)indexEqual.getSecond();
            antiDerTerms = (Set)indexEqual.getFirst();
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        for (Term equal : derTerms) {
            equalityInformation.addElement((Object)equal);
            equalityInformation.reportEquality((Object)term, (Object)equal);
            if (!equalityInformation.isInconsistent()) continue;
            return true;
        }
        for (Term disequal : antiDerTerms) {
            equalityInformation.addElement((Object)disequal);
            equalityInformation.reportDisequality((Object)term, (Object)disequal);
            if (!equalityInformation.isInconsistent()) continue;
            return true;
        }
        return false;
    }

    static ThreeValuedEquivalenceRelation<Term> collectComplimentaryEqualityInformation(Script script, int quantifier, Term preprocessedInput, List<MultiDimensionalSelect> selectTerms, List<MultiDimensionalNestedStore> stores) {
        ThreeValuedEquivalenceRelation equalityInformation = new ThreeValuedEquivalenceRelation();
        Term[] context = QuantifierUtils.getXjunctsInner(quantifier, preprocessedInput);
        boolean inconsistencyDetected = false;
        for (MultiDimensionalSelect selectTerm : selectTerms) {
            for (Term entry : selectTerm.getIndex()) {
                if (!(inconsistencyDetected |= ArrayIndexEqualityUtils.addComplimentaryEqualityInformation(script, quantifier, context, entry, (ThreeValuedEquivalenceRelation<Term>)equalityInformation))) continue;
                return null;
            }
            if (!(inconsistencyDetected |= ArrayIndexEqualityUtils.addComplimentaryEqualityInformation(script, quantifier, context, selectTerm.toTerm(script), (ThreeValuedEquivalenceRelation<Term>)equalityInformation))) continue;
            return null;
        }
        for (MultiDimensionalNestedStore arrayStore : stores) {
            for (ArrayIndex ai : arrayStore.getIndices()) {
                for (Term entry : ai) {
                    if (!(inconsistencyDetected |= ArrayIndexEqualityUtils.addComplimentaryEqualityInformation(script, quantifier, context, entry, (ThreeValuedEquivalenceRelation<Term>)equalityInformation))) continue;
                    return null;
                }
            }
            for (Term value : arrayStore.getValues()) {
                if (!(inconsistencyDetected |= ArrayIndexEqualityUtils.addComplimentaryEqualityInformation(script, quantifier, context, value, (ThreeValuedEquivalenceRelation<Term>)equalityInformation))) continue;
                return null;
            }
        }
        return equalityInformation;
    }

    static ThreeValuedEquivalenceRelation<Term> analyzeIndexEqualities(Script script, ArrayIndex selectIndex, ArrayIndex storeIndex, int quantifier, Term[] context) {
        ThreeValuedEquivalenceRelation tver = new ThreeValuedEquivalenceRelation();
        for (Term term : selectIndex) {
            ArrayIndexEqualityUtils.addComplimentaryEqualityInformation(script, quantifier, context, term, (ThreeValuedEquivalenceRelation<Term>)tver);
        }
        for (Term term : storeIndex) {
            ArrayIndexEqualityUtils.addComplimentaryEqualityInformation(script, quantifier, context, term, (ThreeValuedEquivalenceRelation<Term>)tver);
        }
        return tver;
    }

    private static Term getIndexOfSelect(ApplicationTerm appTerm) {
        assert (appTerm.getParameters().length == 2) : "no select";
        assert (appTerm.getFunction().getName().equals("select")) : "no select";
        return appTerm.getParameters()[1];
    }
}

