/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ArrayIndexReplacementConstructor {
    private final TermVariable mForbiddenTv;
    private final ConstructionCache<Term, Term> mEntryConstrCache;
    private final ConstructionCache<ArrayIndex, ArrayIndex> mIndexConstrCache;
    private final Map<TermVariable, Term> mAuxVar2Definition = new LinkedHashMap<TermVariable, Term>();
    private boolean mConstructionDone;

    public ArrayIndexReplacementConstructor(final ManagedScript mgdScript, final String auxVarPrefix, TermVariable forbiddenTv) {
        this.mForbiddenTv = forbiddenTv;
        ConstructionCache.IValueConstruction<Term, Term> entryValueConstruction = new ConstructionCache.IValueConstruction<Term, Term>(){

            public Term constructValue(Term indexEntry) {
                TermVariable entryReplacement = mgdScript.constructFreshTermVariable(auxVarPrefix, indexEntry.getSort());
                ArrayIndexReplacementConstructor.this.mAuxVar2Definition.put(entryReplacement, indexEntry);
                return entryReplacement;
            }
        };
        this.mEntryConstrCache = new ConstructionCache((ConstructionCache.IValueConstruction)entryValueConstruction);
        ConstructionCache.IValueConstruction<ArrayIndex, ArrayIndex> indexValueConstruction = new ConstructionCache.IValueConstruction<ArrayIndex, ArrayIndex>(){

            public ArrayIndex constructValue(ArrayIndex index) {
                ArrayList<Term> resultIndexEntries = new ArrayList<Term>();
                int i = 0;
                while (i < index.size()) {
                    Term entry = index.get(i);
                    Term newEntry = ArrayIndexReplacementConstructor.this.entryContainsForbiddenTv(entry) ? (Term)ArrayIndexReplacementConstructor.this.mEntryConstrCache.getOrConstruct((Object)entry) : entry;
                    resultIndexEntries.add(newEntry);
                    ++i;
                }
                return new ArrayIndex(resultIndexEntries);
            }
        };
        this.mIndexConstrCache = new ConstructionCache((ConstructionCache.IValueConstruction)indexValueConstruction);
    }

    private boolean entryContainsForbiddenTv(Term entry) {
        return Arrays.asList(entry.getFreeVars()).contains(this.mForbiddenTv);
    }

    private boolean indexContainsForbiddenTv(ArrayIndex index) {
        return index.stream().anyMatch(x -> this.entryContainsForbiddenTv((Term)x));
    }

    public ArrayIndex constructIndexReplacementIfNeeded(ArrayIndex index) {
        if (this.mConstructionDone) {
            throw new IllegalStateException("Definitions already constructed or auxVars already returned");
        }
        ArrayIndex result = this.indexContainsForbiddenTv(index) ? (ArrayIndex)this.mIndexConstrCache.getOrConstruct((Object)index) : index;
        return result;
    }

    public Term constructTermReplacementIfNeeded(Term term) {
        if (this.mConstructionDone) {
            throw new IllegalStateException("Definitions already constructed or auxVars already returned");
        }
        Term result = this.entryContainsForbiddenTv(term) ? (Term)this.mEntryConstrCache.getOrConstruct((Object)term) : term;
        return result;
    }

    public Set<TermVariable> getConstructedAuxVars() {
        this.mConstructionDone = true;
        return this.mAuxVar2Definition.keySet();
    }

    public Term constructDefinitions(Script script, int quantifier) {
        this.mConstructionDone = true;
        List<Term> dualJuncts = this.mAuxVar2Definition.entrySet().stream().map(x -> QuantifierUtils.applyDerOperator(script, quantifier, (Term)x.getKey(), (Term)x.getValue())).collect(Collectors.toList());
        Term dualJunction = QuantifierUtils.applyDualFiniteConnective(script, quantifier, dualJuncts);
        return dualJunction;
    }
}

