/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.NestedArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTaskSimple;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfDer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayQuantifierEliminationMain {
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final Script mScript;
    private final Set<TermVariable> mEliminatees;
    private final Set<TermVariable> mNewExistEliminatees;
    private final Set<TermVariable> mNewValueEliminatees;
    private final Set<TermVariable> mNewIndexEliminatees;
    private int mRecursiveCallCounter = 0;
    private ThreeValuedEquivalenceRelation<Term> mTVER;

    public ArrayQuantifierEliminationMain(ManagedScript mgdScript, IUltimateServiceProvider services, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mMgdScript = mgdScript;
        this.mScript = this.mMgdScript.getScript();
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
        this.mEliminatees = new HashSet<TermVariable>();
        this.mNewExistEliminatees = new HashSet<TermVariable>();
        this.mNewValueEliminatees = new HashSet<TermVariable>();
        this.mNewIndexEliminatees = new HashSet<TermVariable>();
        this.mTVER = new ThreeValuedEquivalenceRelation();
    }

    public EliminationTaskSimple elimAllRec(EliminationTaskSimple eTask) {
        this.mEliminatees.addAll(eTask.getEliminatees());
        this.mLogger.info((Object)"ArrayQuantifierEliminationMain: ");
        this.mLogger.debug((Object)("Recursion:" + this.mRecursiveCallCounter + " Eliminatees: " + this.mEliminatees));
        ++this.mRecursiveCallCounter;
        this.mLogger.debug((Object)("Term: " + eTask.getTerm()));
        EliminationTaskSimple recTask = eTask;
        recTask = this.elimQuantifiedArray(recTask);
        Term quantifiedTerm = recTask.getTerm();
        quantifiedTerm = SmtUtils.quantifier(this.mScript, eTask.getQuantifier(), this.mNewValueEliminatees, quantifiedTerm);
        quantifiedTerm = SmtUtils.quantifier(this.mScript, 0, this.mNewExistEliminatees, quantifiedTerm);
        quantifiedTerm = SmtUtils.quantifier(this.mScript, 1, this.mNewIndexEliminatees, quantifiedTerm);
        this.mEliminatees.addAll(this.mNewValueEliminatees);
        if (eTask.getQuantifier() == 0) {
            this.mEliminatees.addAll(this.mNewExistEliminatees);
        } else {
            this.mEliminatees.addAll(this.mNewIndexEliminatees);
        }
        this.mLogger.debug((Object)("Result term: " + recTask.getTerm()));
        recTask = this.recursivCall(eTask, quantifiedTerm);
        return recTask;
    }

    private EliminationTaskSimple recursivCall(EliminationTaskSimple eTask, Term quantifiedTerm) {
        Term nnf = new NnfTransformer(this.mMgdScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(quantifiedTerm);
        Term pushed = QuantifierPusher.eliminate(this.mServices, this.mMgdScript, true, QuantifierPusher.PqeTechniques.ALL_LOCAL, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, nnf);
        Term pnf = new PrenexNormalForm(this.mMgdScript).transform(pushed);
        QuantifierSequence qs = new QuantifierSequence(this.mMgdScript, pnf);
        Term matrix = qs.getInnerTerm();
        List<QuantifierSequence.QuantifiedVariables> qvs = qs.getQuantifierBlocks();
        int i = qvs.size() - 1;
        while (i >= 0) {
            QuantifierSequence.QuantifiedVariables qv = qvs.get(i);
            HashSet<TermVariable> eliminatees = new HashSet<TermVariable>(qv.getVariables());
            if (!eliminatees.equals(eTask.getEliminatees())) {
                matrix = SmtUtils.simplify(this.mMgdScript, matrix, this.mServices, this.mSimplificationTechnique);
                EliminationTaskSimple recResult = new EliminationTaskSimple(qv.getQuantifier(), eliminatees, matrix);
                recResult = this.elimAllRec(recResult);
                matrix = recResult.getTerm();
                matrix = SmtUtils.quantifier(this.mMgdScript.getScript(), qv.getQuantifier(), eliminatees, matrix);
                matrix = QuantifierPusher.eliminate(this.mServices, this.mMgdScript, true, QuantifierPusher.PqeTechniques.ONLY_DER, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, matrix);
            }
            --i;
        }
        return new EliminationTaskSimple(eTask.getQuantifier(), this.mEliminatees, matrix);
    }

    private EliminationTaskSimple elimQuantifiedArray(EliminationTaskSimple recTask) {
        if (recTask.getTerm() instanceof ApplicationTerm) {
            this.mTVER = this.calcThreeValuedEquiRel(recTask);
            for (TermVariable array : recTask.getEliminatees()) {
                Term taskTerm = recTask.getTerm();
                taskTerm = this.selectOverStore(taskTerm, array);
                taskTerm = this.storeOverStore(taskTerm, array);
                recTask = new EliminationTaskSimple(recTask.getQuantifier(), this.mEliminatees, taskTerm);
                recTask = this.elimStores(recTask, array);
            }
        }
        return recTask;
    }

    private Term storeOverStore(Term term, TermVariable qarray) {
        MultiDimensionalStore mds = MultiDimensionalStore.convert(term);
        List<MultiDimensionalStore> storeterms = MultiDimensionalStore.extractArrayStoresShallow(term);
        for (MultiDimensionalStore storeOuter : storeterms) {
            NestedArrayStore nas = NestedArrayStore.convert((Term)storeOuter.getStoreTerm());
            if (nas.getIndices().size() <= 1) continue;
            if (qarray.equals(nas.getArray()) && this.testIndexVarTerm(nas.getIndices().get(0), nas.getIndices().get(1)) && this.mTVER.getEqualityStatus((Object)nas.getIndices().get(0), (Object)nas.getIndices().get(1)) == EqualityStatus.EQUAL) {
                Term newStore = SmtUtils.store(this.mScript, nas.getArray(), nas.getIndices().get(0), nas.getValues().get(1));
                Term noSOSterm = Substitution.apply(this.mMgdScript, Collections.singletonMap(storeOuter.getStoreTerm(), newStore), term);
                return this.storeOverStore(noSOSterm, qarray);
            }
            TermVariable newarrayvar = this.mMgdScript.constructFreshTermVariable("a_sos", storeOuter.getArray().getSort());
            Term innerStore = SmtUtils.store(this.mScript, nas.getArray(), nas.getIndices().get(0), nas.getValues().get(0));
            Term noSOSterm = Substitution.apply(this.mMgdScript, Collections.singletonMap(innerStore, newarrayvar), term);
            this.mNewExistEliminatees.add(newarrayvar);
            Term factorOutStore = SmtUtils.binaryEquality(this.mScript, (Term)newarrayvar, innerStore);
            Term newTerm = SmtUtils.and(this.mScript, factorOutStore, noSOSterm);
            return this.storeOverStore(newTerm, qarray);
        }
        return term;
    }

    private Term indexEQ(Term index, MultiDimensionalSelect select) {
        Term indexeq = SmtUtils.binaryEquality(this.mScript, index, select.getIndex().get(0));
        if (this.testIndexVarTerm(index, select.getIndex().get(0))) {
            if (this.mTVER.getDisequalities().containsPair((Object)index, (Object)select.getIndex().get(0))) {
                indexeq = this.mScript.term("false", new Term[0]);
            } else if (this.mTVER.getEqualityStatus((Object)index, (Object)select.getIndex().get(0)).compareTo((Enum)EqualityStatus.EQUAL) == 0) {
                indexeq = this.mScript.term("true", new Term[0]);
            }
        }
        return indexeq;
    }

    private Term selectOverStore(Term term, TermVariable qarray) {
        MultiDimensionalSelect mds = new MultiDimensionalSelect(term);
        List<MultiDimensionalSelect> selectterms = MultiDimensionalSelect.extractSelectDeep(term, false);
        for (MultiDimensionalSelect select : selectterms) {
            MultiDimensionalStore innerStore;
            NestedArrayStore nas;
            if (SmtUtils.isBasicArrayTerm(select.getArray()) || !qarray.equals((nas = NestedArrayStore.convert((Term)(innerStore = MultiDimensionalStore.convert(select.getArray())).getStoreTerm())).getArray())) continue;
            Term disjunction = this.mScript.term("false", new Term[0]);
            Term allindexnoteq = this.mScript.term("true", new Term[0]);
            int i = nas.getIndices().size() - 1;
            while (i >= 0) {
                Term index = nas.getIndices().get(i);
                Term indexeq = this.indexEQ(index, select);
                Term indexnoteq = SmtUtils.not(this.mScript, indexeq);
                Map<Term, Term> substitutionMappin = Collections.singletonMap(select.getSelectTerm(), nas.getValues().get(nas.getIndices().indexOf(index)));
                Term subtermlhs = Substitution.apply(this.mMgdScript, substitutionMappin, term);
                Term lhs = SmtUtils.and(this.mScript, indexeq, subtermlhs, allindexnoteq);
                disjunction = SmtUtils.or(this.mScript, lhs, disjunction);
                allindexnoteq = SmtUtils.and(this.mScript, indexnoteq, allindexnoteq);
                --i;
            }
            Map<Term, Term> map = Collections.singletonMap(select.getSelectTerm(), SmtUtils.select(this.mScript, nas.getArray(), select.getIndex().get(0)));
            Term subtermrhs = Substitution.apply(this.mMgdScript, map, term);
            Term rhs = SmtUtils.and(this.mScript, allindexnoteq, subtermrhs);
            return SmtUtils.or(this.mScript, disjunction, rhs);
        }
        return term;
    }

    private boolean testIndexVarTerm(Term index1, Term index2) {
        return this.mTVER.getAllElements().contains(index1) && this.mTVER.getAllElements().contains(index2) && !(index1 instanceof ConstantTerm) && !(index2 instanceof ConstantTerm);
    }

    private ThreeValuedEquivalenceRelation<Term> calcThreeValuedEquiRel(EliminationTaskSimple eTask) {
        ApplicationTerm appterm = (ApplicationTerm)eTask.getTerm();
        ThreeValuedEquivalenceRelation tVER = new ThreeValuedEquivalenceRelation();
        if (SmtUtils.isFunctionApplication(eTask.getTerm(), "and")) {
            Term[] termArray = appterm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                if (term.getSort().getName().equals("Bool")) {
                    ApplicationTerm eqterm;
                    ApplicationTerm boolterm = (ApplicationTerm)term;
                    if (SmtUtils.isFunctionApplication((Term)boolterm, "=")) {
                        tVER.addElement((Object)boolterm.getParameters()[0]);
                        tVER.addElement((Object)boolterm.getParameters()[1]);
                        tVER.reportEquality((Object)boolterm.getParameters()[0], (Object)boolterm.getParameters()[1]);
                    } else if (SmtUtils.isFunctionApplication((Term)boolterm, "not") && SmtUtils.isFunctionApplication((Term)(eqterm = (ApplicationTerm)boolterm.getParameters()[0]), "=")) {
                        tVER.addElement((Object)eqterm.getParameters()[0]);
                        tVER.addElement((Object)eqterm.getParameters()[1]);
                        tVER.reportDisequality((Object)eqterm.getParameters()[0], (Object)eqterm.getParameters()[1]);
                    }
                }
                ++n2;
            }
        }
        return tVER;
    }

    private Set<Pair<ApplicationTerm, ApplicationTerm>> calcIndexCombinations(Set<ApplicationTerm> selectterms, TermVariable eliminate) {
        HashSet<Pair<ApplicationTerm, ApplicationTerm>> indexCombinations = new HashSet<Pair<ApplicationTerm, ApplicationTerm>>();
        ArrayList<ApplicationTerm> selecttermList = new ArrayList<ApplicationTerm>(selectterms);
        int l = 1;
        while (l < selecttermList.size()) {
            int i = 0;
            while (i < l) {
                if (eliminate.equals(((ApplicationTerm)selecttermList.get(i)).getParameters()[0]) && eliminate.equals(((ApplicationTerm)selecttermList.get(l)).getParameters()[0])) {
                    indexCombinations.add((Pair<ApplicationTerm, ApplicationTerm>)new Pair((Object)((ApplicationTerm)selecttermList.get(i)), (Object)((ApplicationTerm)selecttermList.get(l))));
                }
                ++i;
            }
            ++l;
        }
        if (indexCombinations.isEmpty()) {
            for (ApplicationTerm i : selectterms) {
                if (!eliminate.equals(i.getParameters()[0])) continue;
                indexCombinations.add((Pair<ApplicationTerm, ApplicationTerm>)new Pair((Object)i, (Object)i));
            }
        }
        return indexCombinations;
    }

    private Term indexEQvalueEQ(Pair<ApplicationTerm, ApplicationTerm> comb, TermVariable si, TermVariable sj, int quantifier) {
        Term lhs = SmtUtils.binaryEquality(this.mScript, ((ApplicationTerm)comb.getFirst()).getParameters()[1], ((ApplicationTerm)comb.getSecond()).getParameters()[1]);
        Term rhs = SmtUtils.binaryEquality(this.mScript, (Term)si, (Term)sj);
        Term iEvE = SmtUtils.or(this.mScript, SmtUtils.not(this.mScript, lhs), rhs);
        if (quantifier == 1) {
            iEvE = SmtUtils.not(this.mScript, iEvE);
        }
        return iEvE;
    }

    public EliminationTaskSimple elimArrayBySelects(Term eTerm, TermVariable eliminate, int quantifier) {
        Set<ApplicationTerm> selectterms = new ApplicationTermFinder("select", false).findMatchingSubterms(eTerm);
        Set<Pair<ApplicationTerm, ApplicationTerm>> indexCombinations = this.calcIndexCombinations(selectterms, eliminate);
        HashSet<TermVariable> neweliminatees = new HashSet<TermVariable>();
        Term newTerm = this.mScript.term("true", new Term[0]);
        HashMap<Term, TermVariable> submap = new HashMap<Term, TermVariable>();
        if (!indexCombinations.isEmpty()) {
            for (Pair<ApplicationTerm, ApplicationTerm> comb : indexCombinations) {
                TermVariable si = this.mMgdScript.constructFreshTermVariable("si", ((ApplicationTerm)comb.getFirst()).getSort());
                TermVariable sj = this.mMgdScript.constructFreshTermVariable("sj", ((ApplicationTerm)comb.getSecond()).getSort());
                if (!submap.containsKey(comb.getFirst())) {
                    neweliminatees.add(si);
                    submap.put((Term)comb.getFirst(), si);
                } else {
                    si = (TermVariable)submap.get(comb.getFirst());
                }
                if (!submap.containsKey(comb.getSecond())) {
                    neweliminatees.add(sj);
                    submap.put((Term)comb.getSecond(), sj);
                } else {
                    sj = (TermVariable)submap.get(comb.getSecond());
                }
                Term iEvE = this.indexEQvalueEQ(comb, si, sj, quantifier);
                newTerm = SmtUtils.and(this.mScript, iEvE, newTerm);
            }
            Term newTerm2 = Substitution.apply(this.mMgdScript, submap, eTerm);
            newTerm = QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifier, newTerm2, newTerm);
            neweliminatees.add(eliminate);
            this.mNewValueEliminatees.addAll(neweliminatees);
            return new EliminationTaskSimple(quantifier, neweliminatees, newTerm);
        }
        HashSet<TermVariable> oldeliminatees = new HashSet<TermVariable>();
        oldeliminatees.add(eliminate);
        this.mEliminatees.addAll(oldeliminatees);
        return new EliminationTaskSimple(quantifier, oldeliminatees, eTerm);
    }

    private Term elimStoreEQ(TermVariable newindexvar, TermVariable newarrayvar, ApplicationTerm store, Term storeEQ, Term newterm) {
        Term indexnoteq = SmtUtils.not(this.mScript, SmtUtils.binaryEquality(this.mScript, (Term)newindexvar, store.getParameters()[1]));
        Term arrayeq = SmtUtils.binaryEquality(this.mScript, SmtUtils.select(this.mScript, (Term)newarrayvar, (Term)newindexvar), SmtUtils.select(this.mScript, store.getParameters()[0], (Term)newindexvar));
        Term elimtermlhs = SmtUtils.implies(this.mScript, indexnoteq, arrayeq);
        Term indexeq = SmtUtils.binaryEquality(this.mScript, (Term)newindexvar, store.getParameters()[1]);
        Term selectvalue = SmtUtils.binaryEquality(this.mScript, SmtUtils.select(this.mScript, (Term)newarrayvar, store.getParameters()[1]), store.getParameters()[2]);
        Term elimtermrhs = SmtUtils.implies(this.mScript, indexeq, selectvalue);
        Term elimterm = SmtUtils.and(this.mScript, elimtermlhs, elimtermrhs);
        newterm = Substitution.apply(this.mMgdScript, Collections.singletonMap(storeEQ, elimterm), newterm);
        return newterm;
    }

    private Term dER(Term newterm, TermVariable newarrayvar) {
        XnfDer xnfDer = new XnfDer(this.mMgdScript, this.mServices);
        Term[] oldParams = QuantifierUtils.getXjunctsOuter(0, newterm);
        Term[] newParams = new Term[oldParams.length];
        HashSet<TermVariable> eliminateesDER = new HashSet<TermVariable>();
        eliminateesDER.add(newarrayvar);
        int i = 0;
        while (i < oldParams.length) {
            Term[] oldAtoms = QuantifierUtils.getXjunctsInner(0, oldParams[i]);
            newParams[i] = QuantifierUtils.applyDualFiniteConnective(this.mScript, 0, Arrays.asList(xnfDer.tryToEliminate(0, oldAtoms, eliminateesDER)));
            ++i;
        }
        newterm = QuantifierUtils.applyCorrespondingFiniteConnective(this.mScript, 0, newParams);
        return newterm;
    }

    private EliminationTaskSimple elimStores(EliminationTaskSimple eTask, TermVariable qarray) {
        Set<ApplicationTerm> storeterms = new ApplicationTermFinder("store", false).findMatchingSubterms(eTask.getTerm());
        Term newterm = eTask.getTerm();
        HashSet<TermVariable> neweliminatees2 = new HashSet<TermVariable>();
        for (ApplicationTerm term : storeterms) {
            if (!qarray.equals(term.getParameters()[0])) continue;
            TermVariable newarrayvar = this.mMgdScript.constructFreshTermVariable("a_new", term.getParameters()[0].getSort());
            newterm = Substitution.apply(this.mMgdScript, Collections.singletonMap(term, newarrayvar), newterm);
            Term eqterm = SmtUtils.binaryEquality(this.mScript, (Term)newarrayvar, (Term)term);
            newterm = SmtUtils.and(this.mScript, newterm, eqterm);
            TermVariable newindexvar = this.mMgdScript.constructFreshTermVariable("j", term.getParameters()[1].getSort());
            neweliminatees2.add(newindexvar);
            newterm = this.elimStoreEQ(newindexvar, newarrayvar, term, eqterm, newterm);
            newterm = this.dER(newterm, newarrayvar);
            if (!Arrays.asList(newterm.getFreeVars()).contains(newarrayvar)) continue;
            this.mNewExistEliminatees.add(newarrayvar);
        }
        EliminationTaskSimple newETask = this.elimArrayBySelects(newterm, qarray, eTask.getQuantifier());
        this.mNewIndexEliminatees.addAll(neweliminatees2);
        return newETask;
    }
}

