/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverStore;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.List;

public class ArrayQuantifierEliminationUtils {
    public static Term transformMultiDimensionalSelectOverStoreToIte(MultiDimensionalSelectOverStore mdsos, ManagedScript mgdScript, ArrayIndexEqualityManager aiem) {
        ArrayIndex selectIndex = mdsos.getSelect().getIndex();
        ArrayIndex storeIndex = mdsos.getStore().getIndex();
        Term eq = aiem.constructIndexEquality(selectIndex, storeIndex);
        Term equalsReplacement = mdsos.constructEqualsReplacement();
        Term notEquasReplacement = mdsos.constructNotEqualsReplacement(mgdScript.getScript());
        return SmtUtils.ite(mgdScript.getScript(), eq, equalsReplacement, notEquasReplacement);
    }

    public static Term transformMultiDimensionalSelectOverNestedStoreToIte(MultiDimensionalSelectOverNestedStore mdsos, ManagedScript mgdScript, ArrayIndexEqualityManager aiem) {
        ArrayIndex selectIndex = mdsos.getSelect().getIndex();
        List<ArrayIndex> storeIndices = mdsos.getNestedStore().getIndices();
        Term ite = mdsos.constructNotEqualsReplacement(mgdScript.getScript());
        int i = 0;
        while (i < storeIndices.size()) {
            ArrayIndex indexOfCurrentStore = mdsos.getNestedStore().getIndices().get(i);
            Term eq = aiem.constructIndexEquality(selectIndex, indexOfCurrentStore);
            Term valueOfCurrentStore = mdsos.getNestedStore().getValues().get(i);
            ite = SmtUtils.ite(mgdScript.getScript(), eq, valueOfCurrentStore, ite);
            ++i;
        }
        return ite;
    }
}

