/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.BinaryEqualityRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ArrayIndexReplacementConstructor;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ElimStorePlain;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DerPreprocessor
extends TermTransformer {
    private static final String AUX_VAR_PREFIX = "DerPreprocessor";
    private final List<TermVariable> mNewAuxVars;
    private final Term mResult;
    private final boolean mIntroducedDerPossibility;

    public DerPreprocessor(IUltimateServiceProvider services, ManagedScript mgdScript, int quantifier, TermVariable eliminatee, Term input, List<BinaryEqualityRelation> bers, ArrayIndexEqualityManager aiem) throws ElimStorePlain.ElimStorePlainException {
        Map<Term, Term> substitutionMapping;
        HashRelation<DerCase, BinaryEqualityRelation> classification = DerPreprocessor.classify(mgdScript.getScript(), bers, eliminatee);
        boolean existsEqualityThatIsNotOnTopLevel = false;
        BinaryEqualityRelation someTopLevelEquality = null;
        DerCase derCase = null;
        Set topLevelDualJuncts = Arrays.stream(QuantifierUtils.getXjunctsInner(quantifier, input)).collect(Collectors.toSet());
        Iterator iterator = classification.getImage((Object)DerCase.CLASSICAL_DER).iterator();
        if (iterator.hasNext()) {
            BinaryEqualityRelation ber = (BinaryEqualityRelation)iterator.next();
            if (topLevelDualJuncts.contains(ber.toTerm(mgdScript.getScript()))) {
                throw new AssertionError((Object)"Should have been eliminated by DER");
            }
            throw new ElimStorePlain.ElimStorePlainException("DER that is not on top-level");
        }
        for (BinaryEqualityRelation ber : classification.getImage((Object)DerCase.EQ_SELECT)) {
            if (topLevelDualJuncts.contains(ber.toTerm(mgdScript.getScript()))) {
                if (someTopLevelEquality != null) continue;
                someTopLevelEquality = ber;
                derCase = DerCase.EQ_SELECT;
                continue;
            }
            existsEqualityThatIsNotOnTopLevel = true;
        }
        for (BinaryEqualityRelation ber : classification.getImage((Object)DerCase.EQ_STORE)) {
            Term toterm = ber.toTerm(mgdScript.getScript());
            if (topLevelDualJuncts.contains(toterm)) {
                if (someTopLevelEquality != null) continue;
                someTopLevelEquality = ber;
                derCase = DerCase.EQ_STORE;
                continue;
            }
            existsEqualityThatIsNotOnTopLevel = true;
        }
        ArrayIndexReplacementConstructor airc = new ArrayIndexReplacementConstructor(mgdScript, AUX_VAR_PREFIX, eliminatee);
        if (someTopLevelEquality != null) {
            Term derEnabler = DerPreprocessor.constructDerEnabler(someTopLevelEquality, mgdScript, eliminatee, quantifier, derCase, airc, aiem);
            substitutionMapping = Collections.singletonMap(someTopLevelEquality.toTerm(mgdScript.getScript()), derEnabler);
            this.mIntroducedDerPossibility = true;
        } else {
            if (existsEqualityThatIsNotOnTopLevel) {
                throw new AssertionError((Object)"Some non-self update cases but no top-level DER relation");
            }
            substitutionMapping = DerPreprocessor.handleAllSelfUpdates(classification.getImage((Object)DerCase.SELF_UPDATE), mgdScript, eliminatee, quantifier, airc, aiem);
            this.mIntroducedDerPossibility = false;
        }
        Term inputReplacement = Substitution.apply(mgdScript, substitutionMapping, input);
        Term allAuxVarDefs = airc.constructDefinitions(mgdScript.getScript(), quantifier);
        this.mNewAuxVars = new ArrayList<TermVariable>(airc.getConstructedAuxVars());
        this.mResult = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), quantifier, inputReplacement, allAuxVarDefs);
    }

    private static Map<Term, Term> handleAllSelfUpdates(Set<BinaryEqualityRelation> selfupdates, ManagedScript mgdScript, TermVariable eliminatee, int quantifier, ArrayIndexReplacementConstructor airc, ArrayIndexEqualityManager aiem) {
        HashMap<Term, Term> substitutionMapping = new HashMap<Term, Term>();
        for (BinaryEqualityRelation selfUpdate : selfupdates) {
            Term otherSide = DerPreprocessor.getOtherSide(selfUpdate, eliminatee);
            MultiDimensionalNestedStore nas = MultiDimensionalNestedStore.convert(mgdScript.getScript(), otherSide);
            Term selfUpdateReplacement = DerPreprocessor.constructReplacementForStoreCase(nas, mgdScript, eliminatee, quantifier, airc, aiem);
            substitutionMapping.put(selfUpdate.toTerm(mgdScript.getScript()), selfUpdateReplacement);
        }
        return substitutionMapping;
    }

    private static Term constructDerEnabler(BinaryEqualityRelation someTopLevelEquality, ManagedScript mgdScript, TermVariable eliminatee, int quantifier, DerCase derCase, ArrayIndexReplacementConstructor airc, ArrayIndexEqualityManager aiem) {
        Term result;
        Term otherSide = DerPreprocessor.getOtherSide(someTopLevelEquality, eliminatee);
        switch (derCase) {
            case EQ_SELECT: {
                MultiDimensionalSelect as = MultiDimensionalSelect.convert(otherSide);
                result = DerPreprocessor.constructReplacementForSelectCase(as.getArray(), as.getIndex(), mgdScript, eliminatee, quantifier, airc);
                break;
            }
            case EQ_STORE: {
                MultiDimensionalNestedStore nas = MultiDimensionalNestedStore.convert(mgdScript.getScript(), otherSide);
                result = DerPreprocessor.constructReplacementForStoreCase(nas, mgdScript, eliminatee, quantifier, airc, aiem);
                break;
            }
            default: {
                throw new AssertionError((Object)"only select case and store case possible");
            }
        }
        return result;
    }

    private static HashRelation<DerCase, BinaryEqualityRelation> classify(Script script, List<BinaryEqualityRelation> bers, TermVariable eliminatee) throws ElimStorePlain.ElimStorePlainException {
        HashRelation result = new HashRelation();
        for (BinaryEqualityRelation ber : bers) {
            Term otherSide = DerPreprocessor.getOtherSide(ber, eliminatee);
            DerCase derCase = DerPreprocessor.classify(script, otherSide, eliminatee);
            result.addPair((Object)derCase, (Object)ber);
        }
        return result;
    }

    private static Term getOtherSide(BinaryEqualityRelation ber, TermVariable oneSide) {
        Term otherSide;
        if (ber.getLhs().equals(oneSide)) {
            otherSide = ber.getRhs();
        } else if (ber.getRhs().equals(oneSide)) {
            otherSide = ber.getLhs();
        } else {
            throw new AssertionError((Object)"has to be on one side");
        }
        return otherSide;
    }

    private static DerCase classify(Script script, Term otherSide, TermVariable eliminatee) throws ElimStorePlain.ElimStorePlainException {
        if (!Arrays.asList(otherSide.getFreeVars()).contains(eliminatee)) {
            return DerCase.CLASSICAL_DER;
        }
        MultiDimensionalNestedStore mdns = MultiDimensionalNestedStore.convert(script, otherSide);
        if (mdns != null) {
            if (mdns.getArray() == eliminatee) {
                return DerCase.SELF_UPDATE;
            }
            if (Arrays.asList(mdns.getArray().getFreeVars()).contains(eliminatee)) {
                throw new AssertionError((Object)("Complicated and unsupported kind of self-update: " + mdns.getArray()));
            }
            return DerCase.EQ_STORE;
        }
        MultiDimensionalSelect arraySelect = MultiDimensionalSelect.convert(otherSide);
        if (arraySelect != null) {
            return DerCase.EQ_SELECT;
        }
        throw new UnsupportedOperationException("DerPreprocessor supports only store and select, but not " + otherSide);
    }

    public List<TermVariable> getNewAuxVars() {
        return this.mNewAuxVars;
    }

    public Term getResult() {
        return this.mResult;
    }

    public boolean introducedDerPossibility() {
        return this.mIntroducedDerPossibility;
    }

    private static Term constructReplacementForStoreCase(MultiDimensionalNestedStore nas, ManagedScript mgdScript, TermVariable eliminatee, int quantifier, ArrayIndexReplacementConstructor airc, ArrayIndexEqualityManager aiem) {
        Term result;
        ArrayList<ArrayIndex> newIndices = new ArrayList<ArrayIndex>();
        for (ArrayIndex idx : nas.getIndices()) {
            ArrayIndex newIdx = airc.constructIndexReplacementIfNeeded(idx);
            newIndices.add(newIdx);
        }
        ArrayList<Term> newValues = new ArrayList<Term>();
        for (Term value : nas.getValues()) {
            Term newValue = airc.constructTermReplacementIfNeeded(value);
            newValues.add(newValue);
        }
        if (nas.getArray().equals(eliminatee)) {
            LinkedList<ArrayIndex> indices = new LinkedList<ArrayIndex>(newIndices);
            LinkedList values = new LinkedList(newValues);
            Term[] resultDualFiniteJuncts = new Term[indices.size()];
            int i = 0;
            while (i < newIndices.size()) {
                ArrayIndex innermostIndex = (ArrayIndex)indices.removeFirst();
                Term innermostValue = (Term)values.removeFirst();
                resultDualFiniteJuncts[i] = DerPreprocessor.constructDisjointIndexImplication(innermostIndex, indices, innermostValue, (Term)eliminatee, mgdScript.getScript(), quantifier, aiem);
                ++i;
            }
            assert (indices.isEmpty());
            values.isEmpty();
            result = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), quantifier, resultDualFiniteJuncts);
        } else {
            if (Arrays.asList(nas.getArray().getFreeVars()).contains(eliminatee)) {
                throw new UnsupportedOperationException("We have to descend beyond store chains. Introduce auxiliary variables only for arrays of lower dimension to avoid non-termination.");
            }
            result = QuantifierUtils.applyDerOperator(mgdScript.getScript(), quantifier, new MultiDimensionalNestedStore(mgdScript.getScript(), nas.getArray(), newIndices, newValues).toTerm(mgdScript.getScript()), (Term)eliminatee);
        }
        return result;
    }

    private static List<Term> constructReplacementsIfNeeded(List<Term> indices, ConstructionCache<Term, TermVariable> auxVarCc, TermVariable eliminatee) {
        ArrayList<Term> newIndices = new ArrayList<Term>();
        boolean replacementMade = false;
        for (Term index : indices) {
            Term newIndex;
            if (Arrays.asList(index.getFreeVars()).contains(eliminatee)) {
                newIndex = (Term)auxVarCc.getOrConstruct((Object)index);
                replacementMade = true;
            } else {
                newIndex = index;
            }
            newIndices.add(newIndex);
        }
        if (replacementMade) {
            return newIndices;
        }
        return indices;
    }

    private static Term constructReplacementForSelectCase(Term array, ArrayIndex arrayIndex, ManagedScript mgdScript, TermVariable eliminatee, int quantifier, ArrayIndexReplacementConstructor airc) {
        ArrayIndex newIndex = airc.constructIndexReplacementIfNeeded(arrayIndex);
        if (newIndex == arrayIndex) {
            throw new AssertionError((Object)"no need to replace index");
        }
        MultiDimensionalSelect mds = new MultiDimensionalSelect(array, newIndex, mgdScript.getScript());
        Term result = QuantifierUtils.applyDerOperator(mgdScript.getScript(), quantifier, (Term)eliminatee, mds.toTerm(mgdScript.getScript()));
        return result;
    }

    private static Term constructDisjointIndexImplication(ArrayIndex innermostIndex, LinkedList<ArrayIndex> indices, Term innermostValue, Term arr, Script script, int quantifier, ArrayIndexEqualityManager aiem) {
        Term select = new MultiDimensionalSelect(arr, innermostIndex, script).toTerm(script);
        ArrayList<Term> correspondingFiniteJuncts = new ArrayList<Term>(indices.stream().map(x -> aiem.constructDerRelation(script, quantifier, innermostIndex, (ArrayIndex)x)).collect(Collectors.toList()));
        Term selectEqualsValue = QuantifierUtils.applyDerOperator(script, quantifier, select, innermostValue);
        correspondingFiniteJuncts.add(selectEqualsValue);
        Term result = QuantifierUtils.applyCorrespondingFiniteConnective(script, quantifier, correspondingFiniteJuncts);
        return result;
    }

    private static enum DerCase {
        SELF_UPDATE,
        EQ_STORE,
        EQ_SELECT,
        CLASSICAL_DER;

    }
}

