/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayOccurrenceAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArraySelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTaskPlain;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EqualityInformation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ArrayIndexEqualityUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ArrayIndexReplacementConstructor;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.ElimStorePlain;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Elim1Store {
    private static final Comparator<Term> FEWER_VARIABLE_FIRST = new Comparator<Term>(){

        @Override
        public int compare(Term o1, Term o2) {
            return o2.getFreeVars().length - o1.getFreeVars().length;
        }
    };
    private static final Comparator<ArrayIndex> INDEX_WITH_FEWER_VARIABLE_FIRST = new Comparator<ArrayIndex>(){

        @Override
        public int compare(ArrayIndex o1, ArrayIndex o2) {
            return o2.getFreeVars().size() - o1.getFreeVars().size();
        }
    };
    private static final String AUX_VAR_NEW_ARRAY = "arrayElimArr";
    private static final String AUX_VAR_INDEX = "arrayElimIndex";
    private static final String AUX_VAR_ARRAYCELL = "arrayElimCell";
    private final Script mScript;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private static final boolean DEBUG_EXTENDED_RESULT_CHECK = false;
    private static final boolean APPLY_DOUBLE_CASE_SIMPLIFICATION = true;
    private static final boolean APPLY_RESULT_SIMPLIFICATION = false;
    private static final boolean DEBUG_CRASH_ON_LARGE_SIMPLIFICATION_POTENTIAL = false;
    private static final boolean SELECT_OVER_STORE_PREPROCESSING = true;

    public Elim1Store(ManagedScript mgdScript, IUltimateServiceProvider services, int quantifier) {
        this.mScript = mgdScript.getScript();
        this.mMgdScript = mgdScript;
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
    }

    public EliminationTaskPlain elim1(EliminationTaskPlain input) throws ElimStorePlain.ElimStorePlainException {
        Term inputTerm = input.getTerm();
        if (input.getEliminatees().size() != 1) {
            throw new IllegalArgumentException("Can only eliminate one variable");
        }
        int quantifier = input.getQuantifier();
        TermVariable eliminatee = input.getEliminatees().iterator().next();
        Term context = input.getContext();
        assert (UltimateNormalFormUtils.respectsUltimateNormalForm(inputTerm)) : "invalid input";
        QuantifierUtils.getXjunctsOuter(quantifier, inputTerm);
        ArrayOccurrenceAnalysis aoa = new ArrayOccurrenceAnalysis(this.mMgdScript.getScript(), inputTerm, (Term)eliminatee);
        aoa.computeSelectAndStoreDimensions();
        Term polarizedContext = QuantifierUtils.negateIfUniversal(this.mServices, this.mMgdScript, quantifier, context);
        LinkedHashSet<TermVariable> newAuxVars = new LinkedHashSet<TermVariable>();
        Term preprocessedInput = input.getTerm();
        aoa = new ArrayOccurrenceAnalysis(this.mMgdScript.getScript(), preprocessedInput, (Term)eliminatee).downgradeDimensionsIfNecessary(this.mMgdScript.getScript());
        assert (aoa.computeSelectAndStoreDimensions().size() <= 1) : "incompatible";
        List<MultiDimensionalSelect> selectTerms = aoa.getArraySelects();
        List<MultiDimensionalNestedStore> stores = aoa.getNestedArrayStores();
        ThreeValuedEquivalenceRelation<Term> equalityInformation = ArrayIndexEqualityUtils.collectComplimentaryEqualityInformation(this.mMgdScript.getScript(), quantifier, polarizedContext, selectTerms, stores);
        if (equalityInformation == null) {
            Term absobingElement = QuantifierUtils.getNeutralElement(this.mScript, quantifier);
            this.mLogger.warn((Object)("Array PQE input equivalent to " + absobingElement));
            return new EliminationTaskPlain(quantifier, Collections.emptySet(), absobingElement, input.getContext());
        }
        HashSet<ArrayIndex> selectIndices = new HashSet<ArrayIndex>();
        for (MultiDimensionalSelect selectTerm : selectTerms) {
            selectIndices.add(selectTerm.getIndex());
        }
        ArrayIndexEqualityManager aiem = new ArrayIndexEqualityManager(equalityInformation, polarizedContext, quantifier, this.mLogger, this.mMgdScript);
        if (aiem.contextIsAbsorbingElement()) {
            aiem.unlockSolver();
            Term absobingElement = QuantifierUtils.getNeutralElement(this.mScript, quantifier);
            this.mLogger.warn((Object)("Array PQE input equivalent to " + absobingElement));
            return new EliminationTaskPlain(quantifier, Collections.emptySet(), absobingElement, input.getContext());
        }
        long startTime = System.nanoTime();
        ThreeValuedEquivalenceRelation<ArrayIndex> indexEqualityInformation = Elim1Store.analyzeIndexEqualities(quantifier, selectIndices, stores, polarizedContext, equalityInformation, eliminatee, this.mMgdScript, aiem);
        long durationMs = (System.nanoTime() - startTime) / 1000000L;
        if (durationMs > 100L) {
            this.mLogger.info((Object)("Index analysis took " + durationMs + " ms"));
        }
        assert (indexEqualityInformation != null);
        Elim1Store.inferCellEqualitiesViaCongruence(this.mMgdScript, eliminatee, indexEqualityInformation, equalityInformation);
        ArrayList<ArrayIndex> selectIndexRepresentatives = new ArrayList<ArrayIndex>();
        for (ArrayIndex selectIndex : selectIndices) {
            ArrayIndex selectIndexRepresentative = (ArrayIndex)indexEqualityInformation.getRepresentative((Object)selectIndex);
            selectIndexRepresentatives.add(selectIndexRepresentative);
        }
        AuxVarConstructor auxVarConstructor = new AuxVarConstructor();
        IndexMappingProvider imp = new IndexMappingProvider(this.mMgdScript, eliminatee, indexEqualityInformation);
        Map<ArrayIndex, ArrayIndex> indexMapping = imp.getIndexReplacementMapping();
        newAuxVars.addAll(imp.getConstructedAuxVars());
        Term indexAuxVarDefinitionsTerm = imp.constructAuxVarDefinitions(this.mScript, quantifier);
        HashMap<MultiDimensionalNestedStore, Term> newArrayMapping = new HashMap<MultiDimensionalNestedStore, Term>();
        Term preprocessedInputWithContext = QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifier, preprocessedInput, polarizedContext);
        Iterator<MultiDimensionalNestedStore> iterator = stores.iterator();
        while (iterator.hasNext()) {
            EqProvider eqProvider = new EqProvider(preprocessedInputWithContext, eliminatee, quantifier);
            MultiDimensionalNestedStore store = iterator.next();
            Term eqArray = eqProvider.getEqTerm(store.toTerm(this.mScript));
            Object newArray = eqArray != null ? eqArray : auxVarConstructor.constructAuxVar(AUX_VAR_NEW_ARRAY, eliminatee.getSort());
            newArrayMapping.put(store, (Term)newArray);
        }
        Term hiddenWeakArrayEqualities = this.computeHiddenWeakArrayEqualities(this.mScript, quantifier, newArrayMapping);
        assert (!Arrays.asList(hiddenWeakArrayEqualities.getFreeVars()).contains(eliminatee)) : "var is still there: " + eliminatee;
        Map<ArrayIndex, Term> oldCellMapping = Elim1Store.constructOldCellValueMapping(selectIndexRepresentatives, newArrayMapping, equalityInformation, indexMapping, auxVarConstructor, eliminatee, quantifier, indexEqualityInformation, this.mScript);
        newAuxVars.addAll(auxVarConstructor.getConstructedAuxVars());
        HashMap<Term, Term> substitutionMapping = new HashMap<Term, Term>();
        for (Map.Entry entry : newArrayMapping.entrySet()) {
            assert (((MultiDimensionalNestedStore)entry.getKey()).toTerm(this.mScript).getSort() == ((Term)entry.getValue()).getSort()) : "incompatible sorts";
            substitutionMapping.put(((MultiDimensionalNestedStore)entry.getKey()).toTerm(this.mScript), (Term)entry.getValue());
        }
        for (ArrayIndex arrayIndex : selectIndices) {
            Term oldSelect = Elim1Store.constructOldSelectTerm(this.mMgdScript, eliminatee, arrayIndex);
            ArrayIndex indexRepresentative = (ArrayIndex)indexEqualityInformation.getRepresentative((Object)arrayIndex);
            if (oldCellMapping.containsKey(indexRepresentative)) {
                assert (oldSelect.getSort() == oldCellMapping.get(indexRepresentative).getSort()) : "incompatible sorts";
                substitutionMapping.put(oldSelect, oldCellMapping.get(indexRepresentative));
                continue;
            }
            throw new AssertionError((Object)"should be dead code by now");
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> doubleCaseJuncts = new ArrayList<Term>();
        Pair<List<Term>, List<Term>> wc = Elim1Store.constructWriteConstraints2(selectIndexRepresentatives, indexEqualityInformation, this.mMgdScript, indexMapping, oldCellMapping, eliminatee, quantifier, newArrayMapping, substitutionMapping, equalityInformation, aiem);
        arrayList.addAll((Collection)wc.getFirst());
        doubleCaseJuncts.addAll((Collection)wc.getSecond());
        Pair<List<Term>, List<Term>> cc = Elim1Store.constructIndexValueConnection(selectIndexRepresentatives, indexEqualityInformation, this.mMgdScript, indexMapping, oldCellMapping, eliminatee, quantifier, equalityInformation, aiem);
        arrayList.addAll((Collection)cc.getFirst());
        doubleCaseJuncts.addAll((Collection)cc.getSecond());
        aiem.unlockSolver();
        Term indexEqualityInformationTerm = Elim1Store.indexEquivalencesToTerm(this.mScript, indexEqualityInformation, quantifier, aiem);
        assert (indexEqualityInformationTerm == QuantifierUtils.getAbsorbingElement(this.mScript, quantifier)) : "strange equivalences";
        Term intermediateTerm = QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifier, indexAuxVarDefinitionsTerm, preprocessedInput);
        Term singleCaseTerm = QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifier, arrayList);
        Term transformedTerm = Substitution.apply(this.mMgdScript, substitutionMapping, intermediateTerm);
        if (Arrays.asList(transformedTerm.getFreeVars()).contains(eliminatee)) {
            if (QuantifierUtils.isQuantifierFree(inputTerm)) {
                throw new AssertionError((Object)"Unexpected substitution problem.");
            }
            throw new ElimStorePlain.ElimStorePlainException("Subterm of an index is captued by an inner quantifier");
        }
        Term result = QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifier, transformedTerm, singleCaseTerm, hiddenWeakArrayEqualities);
        if (!doubleCaseJuncts.isEmpty()) {
            Term doubleCaseTerm = QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifier, doubleCaseJuncts);
            Term criticalConstraint = SmtUtils.and(this.mScript, QuantifierUtils.negateIfUniversal(this.mServices, this.mMgdScript, quantifier, result), context);
            SmtUtils.ExtendedSimplificationResult esr = SmtUtils.simplifyWithStatistics(this.mMgdScript, doubleCaseTerm, criticalConstraint, this.mServices, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            this.mLogger.info((Object)esr.buildSizeReductionMessage());
            Term doubleCaseTermMod = esr.getSimplifiedTerm();
            result = QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifier, result, doubleCaseTermMod);
        }
        if (Arrays.asList(result.getFreeVars()).contains(eliminatee)) {
            throw new AssertionError((Object)("var is still there: " + eliminatee + " input size " + new DagSizePrinter(result) + " context size " + new DagSizePrinter(result) + " output size " + new DagSizePrinter(result)));
        }
        assert (!Arrays.asList(result.getFreeVars()).contains(eliminatee)) : "var is still there: " + eliminatee + " term size " + new DagSizePrinter(result);
        StringBuilder sb = new StringBuilder();
        sb.append("Elim1");
        if (inputTerm == preprocessedInput) {
            sb.append(" did not use preprocessing");
        } else {
            sb.append(" applied some preprocessing");
        }
        int dim = new MultiDimensionalSort(eliminatee.getSort()).getDimension();
        sb.append(" eliminated variable of array dimension " + dim);
        sb.append(", " + stores.size() + " stores");
        sb.append(", " + selectIndices.size() + " select indices");
        sb.append(", " + selectIndexRepresentatives.size() + " select index equivalence classes");
        int indexPairs = (selectIndexRepresentatives.size() * selectIndexRepresentatives.size() - selectIndexRepresentatives.size()) / 2;
        sb.append(String.format(", %d disjoint index pairs (out of %d index pairs)", equalityInformation.getDisequalities().size(), indexPairs));
        sb.append(String.format(", introduced %d new quantified variables", newAuxVars.size()));
        sb.append(String.format(", introduced %d case distinctions", doubleCaseJuncts.size()));
        sb.append(String.format(", treesize of input %d treesize of output %d", new DAGSize().treesize(inputTerm), new DAGSize().treesize(result)));
        this.mLogger.info((Object)sb.toString());
        EliminationTaskPlain resultEt = new EliminationTaskPlain(quantifier, newAuxVars, result, input.getContext());
        assert (!this.mMgdScript.isLocked()) : "Solver still locked";
        return resultEt;
    }

    private Term computeHiddenWeakArrayEqualities(Script script, int quantifier, Map<MultiDimensionalNestedStore, Term> newArrayMapping) {
        ArrayList<Term> dualJuncts = new ArrayList<Term>();
        ArrayList<Map.Entry<MultiDimensionalNestedStore, Term>> updates = new ArrayList<Map.Entry<MultiDimensionalNestedStore, Term>>(newArrayMapping.entrySet());
        int i = 0;
        while (i < updates.size()) {
            int j = i + 1;
            while (j < updates.size()) {
                Term hwae = this.computeHiddenWeakArrayEquality(script, quantifier, updates.get(i).getKey(), updates.get(i).getValue(), updates.get(j).getKey(), updates.get(j).getValue());
                dualJuncts.add(hwae);
                ++j;
            }
            ++i;
        }
        return QuantifierUtils.applyDualFiniteConnective(script, quantifier, dualJuncts);
    }

    private Term computeHiddenWeakArrayEquality(Script script, int quantifier, MultiDimensionalNestedStore store1, Term array1, MultiDimensionalNestedStore store2, Term array2) {
        ArrayList<Term> indicesOnWhichArraysMayDiffer = new ArrayList<Term>();
        for (ArrayIndex entry : store1.getIndices()) {
            indicesOnWhichArraysMayDiffer.add(entry.get(0));
        }
        for (ArrayIndex entry : store2.getIndices()) {
            indicesOnWhichArraysMayDiffer.add(entry.get(0));
        }
        return Elim1Store.constructWeakArrayEquality(script, quantifier, indicesOnWhichArraysMayDiffer, array1, array2);
    }

    private static Term constructWeakArrayEquality(Script script, int quantifier, List<Term> indicesOnWhichArraysMayDiffer, Term array1, Term array2) {
        Term lhs = array1;
        for (Term index : indicesOnWhichArraysMayDiffer) {
            Term select = SmtUtils.select(script, array2, index);
            lhs = SmtUtils.store(script, lhs, index, select);
        }
        return QuantifierUtils.applyDerOperator(script, quantifier, lhs, array2);
    }

    private static void inferCellEqualitiesViaCongruence(ManagedScript mgdScript, TermVariable eliminatee, ThreeValuedEquivalenceRelation<ArrayIndex> indexEqualityInformation, ThreeValuedEquivalenceRelation<Term> equalityInformation) {
        for (Map.Entry supp : indexEqualityInformation.getSupportingEqualities().entrySet()) {
            ArrayIndex lhsIndex = (ArrayIndex)supp.getKey();
            ArrayIndex rhsIndex = (ArrayIndex)supp.getValue();
            Term lhsSelect = Elim1Store.constructOldSelectTerm(mgdScript, eliminatee, lhsIndex);
            Term rhsSelect = Elim1Store.constructOldSelectTerm(mgdScript, eliminatee, rhsIndex);
            equalityInformation.addElement((Object)lhsSelect);
            equalityInformation.addElement((Object)rhsSelect);
            equalityInformation.reportEquality((Object)lhsSelect, (Object)rhsSelect);
        }
    }

    private static Term indexEquivalencesToTerm(Script script, ThreeValuedEquivalenceRelation<ArrayIndex> tver, int quantifier, ArrayIndexEqualityManager aiem) {
        List elementEqualities = tver.getSupportingEqualities().entrySet().stream().map(en -> aiem.constructDerRelation(script, quantifier, (ArrayIndex)en.getKey(), (ArrayIndex)en.getValue())).collect(Collectors.toList());
        List elementDisequalities = tver.getDisequalities().getSetOfPairs().stream().map(pair -> aiem.constructAntiDerRelation(script, quantifier, (ArrayIndex)pair.getKey(), (ArrayIndex)pair.getValue())).collect(Collectors.toList());
        ArrayList<Term> result = new ArrayList<Term>(elementEqualities.size() + elementDisequalities.size());
        result.addAll(elementEqualities);
        result.addAll(elementDisequalities);
        return QuantifierUtils.applyDualFiniteConnective(script, quantifier, result);
    }

    private static Map<ArrayIndex, Term> constructOldCellValueMapping(List<ArrayIndex> selectIndexRepresentatives, Map<MultiDimensionalNestedStore, Term> newArrayMapping, ThreeValuedEquivalenceRelation<Term> equalityInformation, Map<ArrayIndex, ArrayIndex> indexMapping, final AuxVarConstructor auxVarConstructor, TermVariable eliminatee, int quantifier, ThreeValuedEquivalenceRelation<ArrayIndex> indexEqualityInformation, final Script script) {
        ConstructionCache.IValueConstruction<MultiDimensionalSelect, TermVariable> valueConstruction = new ConstructionCache.IValueConstruction<MultiDimensionalSelect, TermVariable>(){

            public TermVariable constructValue(MultiDimensionalSelect mds) {
                TermVariable oldCell = auxVarConstructor.constructAuxVar(Elim1Store.AUX_VAR_ARRAYCELL, mds.toTerm(script).getSort());
                return oldCell;
            }
        };
        ConstructionCache cc = new ConstructionCache((ConstructionCache.IValueConstruction)valueConstruction);
        HashMap<ArrayIndex, Term> oldCellMapping = new HashMap<ArrayIndex, Term>();
        for (ArrayIndex selectIndexRepresentative : selectIndexRepresentatives) {
            Term oldValueInNewArray = Elim1Store.getOldValueInNewArray(newArrayMapping, indexEqualityInformation, indexMapping, selectIndexRepresentative, script);
            Term oldCellValue = oldValueInNewArray != null ? oldValueInNewArray : Elim1Store.constructOldCellValue(equalityInformation, eliminatee, (ConstructionCache<MultiDimensionalSelect, TermVariable>)cc, selectIndexRepresentative, script);
            oldCellMapping.put(selectIndexRepresentative, oldCellValue);
        }
        return oldCellMapping;
    }

    private static Term getOldValueInNewArray(Map<MultiDimensionalNestedStore, Term> newArrayMapping, ThreeValuedEquivalenceRelation<ArrayIndex> indexEqualityInformation, Map<ArrayIndex, ArrayIndex> indexMapping, ArrayIndex selectIndexRepresentative, Script script) {
        return null;
    }

    private static Term constructOldCellValue(ThreeValuedEquivalenceRelation<Term> equalityInformation, TermVariable eliminatee, ConstructionCache<MultiDimensionalSelect, TermVariable> cc, ArrayIndex selectIndexRepresentative, Script script) {
        Term oldCellValue;
        MultiDimensionalSelect oldSelect = new MultiDimensionalSelect((Term)eliminatee, selectIndexRepresentative, script);
        Term oldSelectRepresentative = (Term)equalityInformation.getRepresentative((Object)oldSelect.toTerm(script));
        Term eqTerm = Elim1Store.findNiceReplacementForRepresentative(oldSelectRepresentative, eliminatee, equalityInformation);
        if (eqTerm != null) {
            oldCellValue = eqTerm;
        } else {
            TermVariable oldCellVariable = (TermVariable)cc.getOrConstruct((Object)oldSelect);
            oldCellValue = oldCellVariable;
        }
        return oldCellValue;
    }

    private static ThreeValuedEquivalenceRelation<ArrayIndex> analyzeIndexEqualities(int mQuantifier, Set<ArrayIndex> selectIndices, List<MultiDimensionalNestedStore> stores, Term preprocessedInput, ThreeValuedEquivalenceRelation<Term> tver, TermVariable eliminatee, ManagedScript mgdScript, ArrayIndexEqualityManager aiem) {
        mgdScript.getScript().echo(new QuotedObject("starting to analyze index equalities"));
        if (aiem.contextIsAbsorbingElement()) {
            aiem.unlockSolver();
            return null;
        }
        ArrayList<ArrayIndex> allIndicesList = new ArrayList<ArrayIndex>(selectIndices);
        for (MultiDimensionalNestedStore store : stores) {
            allIndicesList.addAll(store.getIndices());
        }
        ArrayList<Term> allValues = new ArrayList<Term>();
        HashMap<Term, ArrayIndex> value2selectIndex = new HashMap<Term, ArrayIndex>();
        HashMap<ArrayIndex, Term> selectIndex2value = new HashMap<ArrayIndex, Term>();
        for (ArrayIndex selectIndex : selectIndices) {
            Term oldSelect = Elim1Store.constructOldSelectTerm(mgdScript, eliminatee, selectIndex);
            allValues.add(oldSelect);
            value2selectIndex.put(oldSelect, selectIndex);
            selectIndex2value.put(selectIndex, oldSelect);
        }
        for (MultiDimensionalNestedStore arrayStore : stores) {
            allValues.addAll(arrayStore.getValues());
        }
        ThreeValuedEquivalenceRelation result = new ThreeValuedEquivalenceRelation();
        int i = 0;
        while (i < allIndicesList.size()) {
            result.addElement((Object)allIndicesList.get(i));
            ++i;
        }
        i = 0;
        while (i < allIndicesList.size()) {
            int j = i + 1;
            while (j < allIndicesList.size()) {
                ArrayIndex index1 = allIndicesList.get(i);
                ArrayIndex index2 = allIndicesList.get(j);
                EqualityStatus eq = aiem.checkIndexEquality(index1, index2);
                switch (eq) {
                    case EQUAL: {
                        result.reportEquality((Object)index1, (Object)index2);
                        break;
                    }
                    case NOT_EQUAL: {
                        result.reportDisequality((Object)index1, (Object)index2);
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("illegal EqualityStatus " + eq));
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < allValues.size()) {
            int j = i + 1;
            while (j < allValues.size()) {
                Term value2;
                Term value1 = (Term)allValues.get(i);
                if (tver.getEqualityStatus((Object)value1, (Object)(value2 = (Term)allValues.get(j))) == EqualityStatus.UNKNOWN) {
                    aiem.checkEqualityStatus(value1, value2);
                }
                ++j;
            }
            ++i;
        }
        mgdScript.getScript().echo(new QuotedObject("finished analysis of index equalities"));
        return result;
    }

    private Term constructStoredValueInformation(int quantifier, TermVariable eliminatee, Map<MultiDimensionalStore, Term> newArrayMapping, Map<ArrayIndex, ArrayIndex> indexMapping, Map<Term, Term> substitutionMapping, ThreeValuedEquivalenceRelation<ArrayIndex> indexEqualityInformation) {
        ArrayList<Term> storedValueInformation = new ArrayList<Term>();
        for (Map.Entry<MultiDimensionalStore, Term> entry : newArrayMapping.entrySet()) {
            ArrayIndex indexRepresentative = (ArrayIndex)indexEqualityInformation.getRepresentative((Object)entry.getKey().getIndex());
            ArrayIndex replacementIndex = indexMapping.get(indexRepresentative);
            storedValueInformation.add(QuantifierUtils.applyDerOperator(this.mMgdScript.getScript(), quantifier, new MultiDimensionalSelect(entry.getValue(), replacementIndex, this.mScript).toTerm(this.mScript), Substitution.apply(this.mMgdScript, substitutionMapping, entry.getKey().getValue())));
        }
        return QuantifierUtils.applyDualFiniteConnective(this.mScript, quantifier, storedValueInformation);
    }

    private static boolean occursIn(TermVariable tv, ArrayIndex index) {
        return index.stream().anyMatch(x -> Elim1Store.occursIn(tv, x));
    }

    private static boolean occursIn(TermVariable tv, Term term) {
        return Arrays.asList(term.getFreeVars()).contains(tv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pair<List<Term>, List<Term>> constructIndexValueConnection(List<ArrayIndex> selectIndexRepresentatives, ThreeValuedEquivalenceRelation<ArrayIndex> indexEqualityInformation, ManagedScript mgdScript, Map<ArrayIndex, ArrayIndex> indexMapping, Map<ArrayIndex, Term> oldCellMapping, TermVariable eliminatee, int quantifier, ThreeValuedEquivalenceRelation<Term> equalityInformation, ArrayIndexEqualityManager aiem) {
        ArrayList<Term> resultConjuncts1case = new ArrayList<Term>();
        ArrayList<Term> resultConjuncts2cases = new ArrayList<Term>();
        int i = 0;
        while (i < selectIndexRepresentatives.size()) {
            int j = i + 1;
            while (j < selectIndexRepresentatives.size()) {
                block19: {
                    Term implication;
                    Term valueEqualityTerm;
                    Term indexEqualityTerm;
                    if (!indexEqualityInformation.isRepresentative((Object)selectIndexRepresentatives.get(j))) {
                        throw new AssertionError((Object)"representatives only");
                    }
                    ArrayIndex index1 = selectIndexRepresentatives.get(i);
                    ArrayIndex index2 = selectIndexRepresentatives.get(j);
                    EqualityStatus eqStatus = indexEqualityInformation.getEqualityStatus((Object)index1, (Object)index2);
                    switch (eqStatus) {
                        case EQUAL: {
                            indexEqualityTerm = null;
                            break;
                        }
                        case NOT_EQUAL: {
                            break block19;
                        }
                        case UNKNOWN: {
                            ArrayIndex replacementIndex1 = indexMapping.get(index1);
                            assert (!Elim1Store.occursIn(eliminatee, replacementIndex1)) : "var is still there";
                            ArrayIndex replacementIndex2 = indexMapping.get(index2);
                            assert (!Elim1Store.occursIn(eliminatee, replacementIndex2)) : "var is still there";
                            indexEqualityTerm = aiem.constructDerRelation(mgdScript.getScript(), quantifier, replacementIndex1, replacementIndex2);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    Term oldSelect1 = Elim1Store.constructOldSelectTerm(mgdScript, eliminatee, index1);
                    Term oldSelect2 = Elim1Store.constructOldSelectTerm(mgdScript, eliminatee, index2);
                    EqualityStatus valueEqualityStatus = equalityInformation.getEqualityStatus((Object)oldSelect1, (Object)oldSelect2);
                    switch (valueEqualityStatus) {
                        case EQUAL: {
                            break block19;
                        }
                        case NOT_EQUAL: {
                            if (indexEqualityTerm == null) throw new AssertionError((Object)"input was inconsistent");
                            resultConjuncts1case.add(Elim1Store.notWith1StepPush(mgdScript.getScript(), indexEqualityTerm));
                            break block19;
                        }
                        case UNKNOWN: {
                            Term value1 = oldCellMapping.get(index1);
                            assert (!Elim1Store.occursIn(eliminatee, value1)) : "var is still there";
                            Term value2 = oldCellMapping.get(index2);
                            assert (!Elim1Store.occursIn(eliminatee, value2)) : "var is still there";
                            valueEqualityTerm = QuantifierUtils.applyDerOperator(mgdScript.getScript(), quantifier, value1, value2);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    if (quantifier == 0) {
                        implication = SmtUtils.or(mgdScript.getScript(), Elim1Store.notWith1StepPush(mgdScript.getScript(), indexEqualityTerm), valueEqualityTerm);
                    } else {
                        if (quantifier != 1) throw new AssertionError((Object)"unknown quantifier");
                        implication = SmtUtils.and(mgdScript.getScript(), Elim1Store.notWith1StepPush(mgdScript.getScript(), indexEqualityTerm), valueEqualityTerm);
                    }
                    resultConjuncts2cases.add(implication);
                }
                ++j;
            }
            ++i;
        }
        return new Pair(resultConjuncts1case, resultConjuncts2cases);
    }

    public static Term notWith1StepPush(Script script, Term term) {
        Term libraryPush = NnfTransformer.pushNot1StepInside(script, term, NnfTransformer.QuantifierHandling.CRASH);
        if (libraryPush == null) {
            return SmtUtils.not(script, term);
        }
        return libraryPush;
    }

    private static boolean selectTermsWithsimilarArray(Term term1, Term term2) {
        ArraySelect select1 = ArraySelect.convert(term1);
        if (select1 == null) {
            return false;
        }
        ArraySelect select2 = ArraySelect.convert(term2);
        if (select2 == null) {
            return false;
        }
        return select1.getArray() == select2.getArray();
    }

    private static Pair<List<Term>, List<Term>> constructWriteConstraints(List<ArrayIndex> selectIndexRepresentatives, ThreeValuedEquivalenceRelation<ArrayIndex> indexEqualityInformation, ManagedScript mgdScript, Map<ArrayIndex, ArrayIndex> indexMapping, Map<ArrayIndex, Term> oldCellMapping, TermVariable eliminatee, int quantifier, Map<MultiDimensionalStore, Term> newArrayMapping, Map<Term, Term> substitutionMapping, ThreeValuedEquivalenceRelation<Term> equalityInformation, ArrayIndexEqualityManager aiem) {
        ArrayList<Term> resultConjuncts1case = new ArrayList<Term>();
        ArrayList<Term> resultConjuncts2cases = new ArrayList<Term>();
        for (Map.Entry<MultiDimensionalStore, Term> entry : newArrayMapping.entrySet()) {
            ArrayIndex storeIndex = entry.getKey().getIndex();
            ArrayIndex storeIndexRepresentative = (ArrayIndex)indexEqualityInformation.getRepresentative((Object)storeIndex);
            Term storeValue = entry.getKey().getValue();
            Term newAuxArray = entry.getValue();
            for (ArrayIndex selectIndexRepresentative : selectIndexRepresentatives) {
                assert (indexEqualityInformation.isRepresentative((Object)selectIndexRepresentative)) : "no representative: " + selectIndexRepresentative;
                ArrayIndex replacementStoreIndex = indexMapping.get(storeIndexRepresentative);
                assert (!Elim1Store.occursIn(eliminatee, replacementStoreIndex)) : "var is still there";
                ArrayIndex replacementSelectIndex = indexMapping.get(selectIndexRepresentative);
                assert (!Elim1Store.occursIn(eliminatee, replacementSelectIndex)) : "var is still there";
                Term indexEquality = aiem.constructDerRelation(mgdScript.getScript(), quantifier, replacementStoreIndex, replacementSelectIndex);
                MultiDimensionalSelect newSelect = new MultiDimensionalSelect(newAuxArray, replacementSelectIndex, mgdScript.getScript());
                Term storeValueReplacement = Substitution.apply(mgdScript, substitutionMapping, storeValue);
                Term newValueInCell = QuantifierUtils.applyDerOperator(mgdScript.getScript(), quantifier, newSelect.toTerm(mgdScript.getScript()), storeValueReplacement);
                EqualityStatus indexEqStatus = indexEqualityInformation.getEqualityStatus((Object)storeIndexRepresentative, (Object)selectIndexRepresentative);
                switch (indexEqStatus) {
                    case EQUAL: {
                        resultConjuncts1case.add(newValueInCell);
                        break;
                    }
                    case NOT_EQUAL: {
                        break;
                    }
                    case UNKNOWN: {
                        Term oldSelect = Elim1Store.constructOldSelectTerm(mgdScript, eliminatee, selectIndexRepresentative);
                        if (equalityInformation.getEqualityStatus((Object)oldSelect, (Object)storeValue) == EqualityStatus.EQUAL) {
                            resultConjuncts1case.add(newValueInCell);
                            break;
                        }
                        Term succedent = newValueInCell;
                        Term negatedAntecedent = Elim1Store.notWith1StepPush(mgdScript.getScript(), indexEquality);
                        Term positiveCase = QuantifierUtils.applyCorrespondingFiniteConnective(mgdScript.getScript(), quantifier, negatedAntecedent, succedent);
                        resultConjuncts2cases.add(positiveCase);
                        Term oldCellValue = oldCellMapping.get(selectIndexRepresentative);
                        Term oldValueInCell = QuantifierUtils.applyDerOperator(mgdScript.getScript(), quantifier, newSelect.toTerm(mgdScript.getScript()), oldCellValue);
                        negatedAntecedent = indexEquality;
                        Term negativeCase = QuantifierUtils.applyCorrespondingFiniteConnective(mgdScript.getScript(), quantifier, negatedAntecedent, oldValueInCell);
                        resultConjuncts2cases.add(negativeCase);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        return new Pair(resultConjuncts1case, resultConjuncts2cases);
    }

    private static Pair<List<Term>, List<Term>> constructWriteConstraints2(List<ArrayIndex> selectIndexRepresentatives, ThreeValuedEquivalenceRelation<ArrayIndex> indexEqualityInformation, ManagedScript mgdScript, Map<ArrayIndex, ArrayIndex> indexMapping, Map<ArrayIndex, Term> oldCellMapping, TermVariable eliminatee, int quantifier, Map<MultiDimensionalNestedStore, Term> newArrayMapping, Map<Term, Term> substitutionMapping, ThreeValuedEquivalenceRelation<Term> equalityInformation, ArrayIndexEqualityManager aiem) {
        ArrayList<Term> resultConjuncts1case = new ArrayList<Term>();
        ArrayList<Term> resultConjuncts2cases = new ArrayList<Term>();
        for (Map.Entry<MultiDimensionalNestedStore, Term> entry : newArrayMapping.entrySet()) {
            ArrayList<ArrayIndex> storeIndexReplacements = new ArrayList<ArrayIndex>();
            ArrayList<Term> storeValueReplacements = new ArrayList<Term>();
            Term resArray = entry.getValue();
            int i = 0;
            while (i < entry.getKey().getIndices().size()) {
                ArrayIndex storeIndex = entry.getKey().getIndices().get(i);
                ArrayIndex arrayIndex = (ArrayIndex)indexEqualityInformation.getRepresentative((Object)storeIndex);
                ArrayIndex replacementStoreIndex = indexMapping.get(arrayIndex);
                assert (!Elim1Store.occursIn(eliminatee, replacementStoreIndex)) : "var is still there";
                Term storeValue = entry.getKey().getValues().get(i);
                Term storeValueReplacement = Substitution.apply(mgdScript, substitutionMapping, storeValue);
                storeIndexReplacements.add(replacementStoreIndex);
                storeValueReplacements.add(storeValueReplacement);
                ++i;
            }
            for (ArrayIndex selectIndexRepresentative : selectIndexRepresentatives) {
                assert (indexEqualityInformation.isRepresentative((Object)selectIndexRepresentative)) : "no representative: " + selectIndexRepresentative;
                ArrayIndex selectIndexReplacement = indexMapping.get(selectIndexRepresentative);
                assert (!Elim1Store.occursIn(eliminatee, selectIndexReplacement)) : "var is still there";
                Term inputArrayValue = oldCellMapping.get(selectIndexRepresentative);
                Term constraintForSelectIndex = aiem.constructNestedStoreUpdateConstraint(mgdScript.getScript(), quantifier, resArray, selectIndexReplacement, storeIndexReplacements, storeValueReplacements, inputArrayValue);
                if (SmtUtils.isAtomicFormula(constraintForSelectIndex)) {
                    resultConjuncts1case.add(constraintForSelectIndex);
                    continue;
                }
                resultConjuncts2cases.add(constraintForSelectIndex);
            }
            HashSet<ArrayIndex> storeIndexRepresentatives = new HashSet<ArrayIndex>();
            for (ArrayIndex arrayIndex : entry.getKey().getIndices()) {
                storeIndexRepresentatives.add((ArrayIndex)indexEqualityInformation.getRepresentative((Object)arrayIndex));
            }
            for (ArrayIndex arrayIndex : storeIndexRepresentatives) {
                assert (indexEqualityInformation.isRepresentative((Object)arrayIndex)) : "no representative: " + arrayIndex;
                ArrayIndex storeIndexReplacement = indexMapping.get(arrayIndex);
                assert (!Elim1Store.occursIn(eliminatee, storeIndexReplacement)) : "var is still there";
                Term defaultValue = null;
                Term constraintForStoreIndex = aiem.constructNestedStoreUpdateConstraint(mgdScript.getScript(), quantifier, resArray, storeIndexReplacement, storeIndexReplacements, storeValueReplacements, defaultValue);
                if (SmtUtils.isAtomicFormula(constraintForStoreIndex)) {
                    resultConjuncts1case.add(constraintForStoreIndex);
                    continue;
                }
                resultConjuncts2cases.add(constraintForStoreIndex);
            }
        }
        return new Pair(resultConjuncts1case, resultConjuncts2cases);
    }

    private static Term findNiceReplacementForRepresentative(Term term, TermVariable eliminatee, ThreeValuedEquivalenceRelation<Term> equalityInformation) {
        assert (equalityInformation.isRepresentative((Object)term)) : "Not representative " + term;
        Set eq = equalityInformation.getEquivalenceClass((Object)term);
        List list = eq.stream().filter(x -> !Elim1Store.occursIn(eliminatee, x)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, FEWER_VARIABLE_FIRST);
        return (Term)list.get(0);
    }

    private static ArrayIndex findNiceReplacementForRepresentative(ArrayIndex index, TermVariable eliminatee, ThreeValuedEquivalenceRelation<ArrayIndex> equalityInformation) {
        assert (equalityInformation.isRepresentative((Object)index)) : "Not representative " + index;
        Set eq = equalityInformation.getEquivalenceClass((Object)index);
        List list = eq.stream().filter(x -> !Elim1Store.occursIn(eliminatee, x)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list, INDEX_WITH_FEWER_VARIABLE_FIRST);
        return (ArrayIndex)list.get(0);
    }

    private static Term constructOldSelectTerm(ManagedScript mgdScript, TermVariable eliminatee, ArrayIndex selectIndex) {
        return new MultiDimensionalSelect((Term)eliminatee, selectIndex, mgdScript.getScript()).toTerm(mgdScript.getScript());
    }

    private class AuxVarConstructor {
        private final Set<TermVariable> mConstructedAuxVars = new HashSet<TermVariable>();

        private AuxVarConstructor() {
        }

        public TermVariable constructAuxVar(String purpose, Sort sort) {
            TermVariable auxVar = Elim1Store.this.mMgdScript.constructFreshTermVariable(purpose, sort);
            this.mConstructedAuxVars.add(auxVar);
            return auxVar;
        }

        public Set<TermVariable> getConstructedAuxVars() {
            return this.mConstructedAuxVars;
        }
    }

    private class EqProvider {
        private final Term[] mContext;
        private final TermVariable mEliminatee;
        private final int mQuantifier;

        public EqProvider(Term inputTerm, TermVariable eliminatee, int quantifier) {
            this.mContext = QuantifierUtils.getXjunctsInner(quantifier, inputTerm);
            this.mEliminatee = eliminatee;
            this.mQuantifier = quantifier;
        }

        public Term getEqTerm(Term term) {
            EqualityInformation eqInfo = EqualityInformation.getEqinfo(Elim1Store.this.mScript, term, this.mContext, (Term)this.mEliminatee, this.mQuantifier);
            if (eqInfo == null) {
                return null;
            }
            return eqInfo.getRelatedTerm();
        }
    }

    private static class IndexMappingProvider {
        private final ArrayIndexReplacementConstructor mReplacementConstructor;
        private final Map<ArrayIndex, ArrayIndex> mIndexReplacementMapping = new HashMap<ArrayIndex, ArrayIndex>();

        public IndexMappingProvider(ManagedScript mgdScript, TermVariable eliminatee, ThreeValuedEquivalenceRelation<ArrayIndex> indexEqualityInformation) {
            this.mReplacementConstructor = new ArrayIndexReplacementConstructor(mgdScript, Elim1Store.AUX_VAR_INDEX, eliminatee);
            for (ArrayIndex index : indexEqualityInformation.getAllRepresentatives()) {
                ArrayIndex eqTerm = Elim1Store.findNiceReplacementForRepresentative(index, eliminatee, indexEqualityInformation);
                if (eqTerm != null) {
                    this.mIndexReplacementMapping.put(index, eqTerm);
                    continue;
                }
                ArrayIndex indexRepresentative = (ArrayIndex)indexEqualityInformation.getRepresentative((Object)index);
                ArrayIndex indexReplacement = this.mReplacementConstructor.constructIndexReplacementIfNeeded(indexRepresentative);
                this.mIndexReplacementMapping.put(index, indexReplacement);
            }
        }

        public Map<ArrayIndex, ArrayIndex> getIndexReplacementMapping() {
            return this.mIndexReplacementMapping;
        }

        public Term constructAuxVarDefinitions(Script script, int quantifier) {
            return this.mReplacementConstructor.constructDefinitions(script, quantifier);
        }

        public Set<TermVariable> getConstructedAuxVars() {
            return this.mReplacementConstructor.getConstructedAuxVars();
        }
    }

    public class ValueEqualityChecker {
        final TermVariable mEliminatee;
        final Term mStoreIndex;
        final Term mStoreValue;
        final ThreeValuedEquivalenceRelation<Term> mIndices;
        final ManagedScript mMgdScript;
        final IncrementalPlicationChecker mIncrementalPlicationChecker;
        final Map<Term, Term> mOldCellMapping;
        final List<Term> mValueEqualities = new ArrayList<Term>();

        public ValueEqualityChecker(TermVariable eliminatee, Term storeIndex, Term storeValue, ThreeValuedEquivalenceRelation<Term> indices, ManagedScript mgdScript, IncrementalPlicationChecker incrementalPlicationChecker, Map<Term, Term> oldCellMapping) {
            this.mEliminatee = eliminatee;
            this.mStoreIndex = storeIndex;
            this.mStoreValue = storeValue;
            this.mIndices = indices;
            this.mMgdScript = mgdScript;
            this.mIncrementalPlicationChecker = incrementalPlicationChecker;
            this.mOldCellMapping = oldCellMapping;
        }

        public boolean isDistinguishworthyIndexPair(Term index1, Term index2) {
            Term select1 = SmtUtils.select(this.mMgdScript.getScript(), (Term)this.mEliminatee, index1);
            Term select2 = SmtUtils.select(this.mMgdScript.getScript(), (Term)this.mEliminatee, index2);
            Term eq = SmtUtils.binaryEquality(this.mMgdScript.getScript(), select1, select2);
            IncrementalPlicationChecker.Validity cellEqVal = this.mIncrementalPlicationChecker.checkPlication(eq);
            if (cellEqVal == IncrementalPlicationChecker.Validity.VALID) {
                boolean distinguishworthy1 = this.processStoreIndex(index1, index2, select2);
                boolean distinguishworthy2 = this.processStoreIndex(index2, index1, select1);
                if (distinguishworthy1 && distinguishworthy2) {
                    return true;
                }
                Term cellEq = SmtUtils.binaryEquality(this.mMgdScript.getScript(), this.mOldCellMapping.get(index1), this.mOldCellMapping.get(index2));
                this.mValueEqualities.add(cellEq);
                return false;
            }
            return true;
        }

        private boolean processStoreIndex(Term storeIndexCandidate, Term otherIndex, Term otherSelect) {
            if (this.isStoreIndex(storeIndexCandidate)) {
                Term storeEq = SmtUtils.binaryEquality(this.mMgdScript.getScript(), this.mStoreValue, otherSelect);
                IncrementalPlicationChecker.Validity storeEqVal = this.mIncrementalPlicationChecker.checkPlication(storeEq);
                if (storeEqVal == IncrementalPlicationChecker.Validity.VALID) {
                    Term storeCellEq = SmtUtils.binaryEquality(this.mMgdScript.getScript(), this.mStoreValue, this.mOldCellMapping.get(otherIndex));
                    this.mValueEqualities.add(storeCellEq);
                    return false;
                }
                return true;
            }
            return false;
        }

        boolean isStoreIndex(Term index1) {
            if (this.mStoreIndex == null) {
                return false;
            }
            return ((Term)this.mIndices.getRepresentative((Object)index1)).equals(this.mIndices.getRepresentative((Object)this.mStoreIndex));
        }

        public List<Term> getValueEqualities() {
            return this.mValueEqualities;
        }
    }
}

