/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EqualityInformation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ElimStore3 {
    private int mQuantifier = 0;
    private final Script mScript;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private static final String s_FreshVariableString = "arrayElim";

    public ElimStore3(Script script, ManagedScript mgdScript, IUltimateServiceProvider services, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mScript = script;
        this.mMgdScript = mgdScript;
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
    }

    private static MultiDimensionalStore getArrayStore(Term array, Term term) {
        List<MultiDimensionalStore> all = MultiDimensionalStore.extractArrayStoresDeep(term);
        MultiDimensionalStore result = null;
        for (MultiDimensionalStore asd : all) {
            if (!asd.getArray().equals(array)) continue;
            if (result != null && !result.equals(asd)) {
                throw new UnsupportedOperationException("unsupported: several stores");
            }
            result = asd;
        }
        return result;
    }

    private ArrayUpdate getArrayUpdate(Term array, Term[] terms) {
        ArrayUpdate.ArrayUpdateExtractor aue = new ArrayUpdate.ArrayUpdateExtractor(this.mQuantifier == 1, true, terms);
        ArrayUpdate result = null;
        for (ArrayUpdate au : aue.getArrayUpdates()) {
            if (!au.getNewArray().equals(array)) continue;
            if (result != null && !result.equals(au)) {
                throw new UnsupportedOperationException("unsupported: several updates");
            }
            result = au;
        }
        return result;
    }

    public Term elim(int quantifier, TermVariable inputeliminatee, Term inputterm, Set<TermVariable> newAuxVars) {
        Term othersT;
        Term[] conjuncts;
        this.mQuantifier = quantifier;
        ArrayUpdate writeInto = null;
        ArrayUpdate writtenFrom = null;
        TermVariable eliminatee = inputeliminatee;
        Term term = inputterm;
        term = this.eliminateSelfUpdates(this.mScript, quantifier, term);
        while (true) {
            Term auxRes;
            assert (eliminatee.getSort().isArraySort());
            if (quantifier == 0) {
                conjuncts = SmtUtils.getConjuncts(term);
            } else {
                assert (quantifier == 1);
                conjuncts = SmtUtils.getDisjuncts(term);
            }
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(this.getClass(), "eliminating quantified array variable from " + conjuncts.length + " xjuncts");
            }
            MultiDimensionalStore store = ElimStore3.getArrayStore((Term)eliminatee, term);
            ArrayUpdate update = this.getArrayUpdate((Term)eliminatee, conjuncts);
            HashSet<Term> others = new HashSet<Term>();
            Term[] termArray = conjuncts;
            int n = conjuncts.length;
            int n2 = 0;
            while (n2 < n) {
                Term conjunct = termArray[n2];
                try {
                    ArrayUpdate au = new ArrayUpdate(conjunct, quantifier == 1, false);
                    if (au.getOldArray().equals(eliminatee)) {
                        if (writeInto != null) {
                            throw new UnsupportedOperationException("unsupported: write into several arrays");
                        }
                        writeInto = au;
                        if (au.getNewArray().equals(eliminatee)) {
                            throw new UnsupportedOperationException("unsupported: self update");
                        }
                    } else if (au.getNewArray().equals(eliminatee)) {
                        if (writtenFrom != null) {
                            throw new UnsupportedOperationException("unsupported: written from several arrayas");
                        }
                        writtenFrom = au;
                    } else {
                        others.add(conjunct);
                    }
                }
                catch (ArrayUpdate.ArrayUpdateException arrayUpdateException) {
                    others.add(conjunct);
                }
                ++n2;
            }
            if (writtenFrom != null && writeInto != null) {
                others.add(writeInto.getArrayUpdateTerm());
                writeInto = null;
            }
            if (quantifier == 0) {
                othersT = SmtUtils.and(this.mScript, others.toArray(new Term[others.size()]));
            } else {
                assert (quantifier == 1);
                othersT = SmtUtils.or(this.mScript, others.toArray(new Term[others.size()]));
            }
            if (store == null && update == null || writeInto != null || writtenFrom != null) break;
            TermVariable auxArray = this.mMgdScript.constructFreshTermVariable(s_FreshVariableString, eliminatee.getSort());
            if (store == null) {
                store = update.getMultiDimensionalStore();
            }
            Map<ApplicationTerm, TermVariable> auxMap = Collections.singletonMap(store.getStoreTerm(), auxArray);
            Term auxTerm = Substitution.apply(this.mMgdScript, auxMap, term);
            Term auxVarDef = SmtUtils.binaryEquality(this.mScript, (Term)auxArray, (Term)store.getStoreTerm());
            if (quantifier == 0) {
                auxTerm = SmtUtils.and(this.mScript, auxTerm, auxVarDef);
            } else {
                assert (quantifier == 1);
                auxTerm = SmtUtils.or(this.mScript, auxTerm, SmtUtils.not(this.mScript, auxVarDef));
            }
            HashSet auxAuxVars = new HashSet();
            term = auxRes = this.elim(quantifier, eliminatee, auxTerm, newAuxVars);
            eliminatee = auxArray;
            newAuxVars.addAll(auxAuxVars);
        }
        boolean write = writeInto != null || writtenFrom != null;
        Script script = this.mScript;
        Term intermediateResult = othersT;
        if (writeInto != null) {
            Map<ApplicationTerm, TermVariable> mapping = Collections.singletonMap(writeInto.getMultiDimensionalStore().getStoreTerm(), writeInto.getNewArray());
            intermediateResult = Substitution.apply(this.mMgdScript, mapping, intermediateResult);
        }
        IndicesAndValues iav = new IndicesAndValues(this.mMgdScript, quantifier, eliminatee, conjuncts);
        ArrayList<Term> additionalConjuncs = new ArrayList<Term>();
        intermediateResult = Substitution.apply(this.mMgdScript, iav.getMapping(), intermediateResult);
        if (writtenFrom == null && Arrays.asList(intermediateResult.getFreeVars()).contains(eliminatee)) {
            throw new AssertionError((Object)("var is still there " + eliminatee + "  quantifier " + quantifier + "  term size " + new DagSizePrinter(term) + "   " + term));
        }
        if (write) {
            Term additionalConjuncts;
            Map<TermVariable, Term> writtenFromSubst;
            Term data;
            ArrayIndex idx_write;
            TermVariable a_heir;
            if (writeInto != null) {
                a_heir = writeInto.getNewArray();
                idx_write = writeInto.getIndex();
                data = writeInto.getValue();
            } else {
                assert (writtenFrom != null);
                a_heir = writtenFrom.getOldArray();
                idx_write = writtenFrom.getIndex();
                data = writtenFrom.getValue();
            }
            additionalConjuncs.addAll(this.disjointIndexImpliesValueEquality(quantifier, (Term)a_heir, idx_write, iav, eliminatee));
            ArrayIndex idx_writeRenamed = idx_write.applySubstitution(this.mMgdScript, iav.getMapping());
            Term dataRenamed = Substitution.apply(this.mMgdScript, iav.getMapping(), data);
            if (writeInto != null) {
                assert (writeInto.getOldArray() == eliminatee) : "array not eliminatee";
                Term writtenCellHasNewValue = SmtUtils.binaryEquality(this.mScript, SmtUtils.multiDimensionalSelect(this.mScript, (Term)a_heir, idx_writeRenamed), dataRenamed);
                assert (!Arrays.asList(writtenCellHasNewValue.getFreeVars()).contains(eliminatee)) : "var is still there - maybe you have to switch off the flattening of multi-dimensional arrays";
                additionalConjuncs.add(writtenCellHasNewValue);
            }
            if (writtenFrom != null) {
                Term storeRenamed = SmtUtils.multiDimensionalStore(script, (Term)a_heir, idx_writeRenamed, dataRenamed);
                writtenFromSubst = Collections.singletonMap(eliminatee, storeRenamed);
            } else {
                writtenFromSubst = null;
            }
            if (quantifier == 0) {
                additionalConjuncts = SmtUtils.and(script, additionalConjuncs.toArray(new Term[additionalConjuncs.size()]));
                intermediateResult = SmtUtils.and(script, intermediateResult, additionalConjuncts);
            } else {
                assert (quantifier == 1);
                additionalConjuncts = SmtUtils.or(script, SmtUtils.negateElementwise(this.mScript, additionalConjuncs).toArray(new Term[additionalConjuncs.size()]));
                intermediateResult = SmtUtils.or(script, intermediateResult, additionalConjuncts);
            }
            if (writtenFromSubst != null) {
                intermediateResult = Substitution.apply(this.mMgdScript, writtenFromSubst, intermediateResult);
            }
        }
        ManagedScript mgdScript = this.mMgdScript;
        Pair<List<ArrayIndex>, List<Term>> indicesAndValues = ElimStore3.buildIndicesAndValues(mgdScript, iav);
        List indices = (List)indicesAndValues.getFirst();
        List values = (List)indicesAndValues.getSecond();
        if (writtenFrom != null) {
            assert (writtenFrom.getNewArray() == eliminatee) : "array not eliminatee";
            ArrayIndex idx_writeRenamed = writtenFrom.getIndex().applySubstitution(mgdScript, iav.getMapping());
            Term dataRenamed = Substitution.apply(this.mMgdScript, iav.getMapping(), writtenFrom.getValue());
            indices.add(idx_writeRenamed);
            values.add(dataRenamed);
        }
        ArrayList<Term> indexValueConstraintsFromEliminatee = ElimStore3.constructIndexValueConstraints(script, quantifier, indices, values);
        Term result1 = QuantifierUtils.applyDualFiniteConnective(this.mScript, this.mQuantifier, indexValueConstraintsFromEliminatee);
        assert (!Arrays.asList(result1.getFreeVars()).contains(eliminatee)) : "var is still there";
        Term result = QuantifierUtils.applyDualFiniteConnective(this.mScript, this.mQuantifier, Arrays.asList(result1, intermediateResult));
        this.mMgdScript.getScript().echo(new QuotedObject("started simplification for array quantifier elimination"));
        result = SmtUtils.simplify(this.mMgdScript, result, this.mServices, this.mSimplificationTechnique);
        this.mMgdScript.getScript().echo(new QuotedObject("finished simplification for array quantifier elimination"));
        newAuxVars.addAll(iav.getNewAuxVars());
        return result;
    }

    public static Pair<List<ArrayIndex>, List<Term>> buildIndicesAndValues(ManagedScript mgdScript, IndicesAndValues iav) {
        ArrayList<ArrayIndex> indices1 = new ArrayList<ArrayIndex>();
        ArrayList<Term> values1 = new ArrayList<Term>();
        int i = 0;
        while (i < iav.getIndices().length) {
            ArrayIndex translatedIndex = iav.getIndices()[i].applySubstitution(mgdScript, iav.getMapping());
            Term translatedValue = Substitution.apply(mgdScript, iav.getMapping(), iav.getValues()[i]);
            indices1.add(translatedIndex);
            values1.add(translatedValue);
            ++i;
        }
        Pair result = new Pair(indices1, values1);
        return result;
    }

    public static ArrayList<Term> constructIndexValueConstraints(Script script, int quantifier, List<ArrayIndex> indices, List<Term> values) {
        ArrayList<Term> indexValueConstraints = new ArrayList<Term>();
        int i = 0;
        while (i < indices.size()) {
            int j = i;
            while (j < indices.size()) {
                Term newConjunct = SmtUtils.indexEqualityImpliesValueEquality(script, indices.get(i), indices.get(j), values.get(i), values.get(j));
                if (quantifier == 1) {
                    newConjunct = SmtUtils.not(script, newConjunct);
                }
                indexValueConstraints.add(newConjunct);
                ++j;
            }
            ++i;
        }
        ArrayList<Term> indexValueConstraintsFromEliminatee = indexValueConstraints;
        return indexValueConstraintsFromEliminatee;
    }

    private ArrayList<Term> disjointIndexImpliesValueEquality(int quantifier, Term a_heir, ArrayIndex idx_write, IndicesAndValues iav, TermVariable eliminatee) {
        ArrayList<Term> result = new ArrayList<Term>();
        int i = 0;
        while (i < iav.getIndices().length) {
            Term selectOnHeir = SmtUtils.multiDimensionalSelect(this.mScript, a_heir, iav.getIndices()[i]);
            IndexValueConnection ivc = new IndexValueConnection(iav.getIndices()[i], idx_write, iav.getValues()[i], selectOnHeir, false);
            Term conjunct = ivc.getTerm();
            conjunct = Substitution.apply(this.mMgdScript, iav.getMapping(), conjunct);
            result.add(conjunct);
            assert (!Arrays.asList(conjunct.getFreeVars()).contains(eliminatee)) : "var is still there";
            if (ivc.indexInequality() && !ivc.valueEquality()) assert (!ivc.valueInequality()) : "term would be false!";
            ++i;
        }
        return result;
    }

    private Term eliminateSelfUpdates(Script script, int quantifier, Term term) {
        Term[] conjuncts;
        if (quantifier == 0) {
            conjuncts = SmtUtils.getConjuncts(term);
        } else {
            assert (quantifier == 1);
            conjuncts = SmtUtils.getDisjuncts(term);
        }
        ArrayList<Term> resultConjuncts = new ArrayList<Term>();
        boolean someSelfUpdate = false;
        Term[] termArray = conjuncts;
        int n = conjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                ArrayUpdate au;
                Term conjunct = termArray[n2];
                try {
                    au = new ArrayUpdate(conjunct, false, false);
                }
                catch (ArrayUpdate.ArrayUpdateException arrayUpdateException) {
                    try {
                        au = new ArrayUpdate(conjunct, true, false);
                    }
                    catch (ArrayUpdate.ArrayUpdateException arrayUpdateException2) {
                        resultConjuncts.add(conjunct);
                        break block13;
                    }
                }
                if (ElimStore3.isSelfUpdate(au)) {
                    someSelfUpdate = true;
                    Term select = this.buildEquivalentSelect(script, au);
                    resultConjuncts.add(select);
                } else {
                    resultConjuncts.add(au.getArrayUpdateTerm());
                }
            }
            ++n2;
        }
        if (someSelfUpdate) {
            if (quantifier == 0) {
                return SmtUtils.and(script, resultConjuncts);
            }
            assert (quantifier == 1);
            return SmtUtils.or(script, resultConjuncts);
        }
        return term;
    }

    private Term buildEquivalentSelect(Script script, ArrayUpdate au) {
        assert (ElimStore3.isSelfUpdate(au)) : "no self-update";
        Term selectTerm = SmtUtils.multiDimensionalSelect(this.mScript, (Term)au.getNewArray(), au.getIndex());
        String fun = au.isNegatedEquality() ? "distinct" : "=";
        return script.term(fun, new Term[]{selectTerm, au.getValue()});
    }

    private static boolean isSelfUpdate(ArrayUpdate au) {
        if (au.getOldArray().equals(au.getNewArray())) {
            return true;
        }
        if (Arrays.asList(au.getOldArray().getFreeVars()).contains(au.getNewArray())) {
            throw new UnsupportedOperationException("nested self-update " + au.getArrayUpdateTerm());
        }
        return false;
    }

    private class IndexValueConnection {
        private final ArrayIndex mfstIndex;
        private final ArrayIndex msndIndex;
        private final Term mfstValue;
        private final Term msndValue;
        private final boolean mSelectConnection;
        private final Term mIndexEquality;
        private final Term mValueEquality;

        public IndexValueConnection(ArrayIndex fstIndex, ArrayIndex sndIndex, Term fstValue, Term sndValue, boolean selectConnection) {
            this.mfstIndex = fstIndex;
            this.msndIndex = sndIndex;
            this.mfstValue = fstValue;
            this.msndValue = sndValue;
            this.mSelectConnection = selectConnection;
            this.mIndexEquality = SmtUtils.and(ElimStore3.this.mScript, SmtUtils.pairwiseEquality(ElimStore3.this.mScript, fstIndex, sndIndex));
            this.mValueEquality = SmtUtils.binaryEquality(ElimStore3.this.mScript, fstValue, sndValue);
        }

        public boolean indexInequality() {
            return this.mIndexEquality.equals(ElimStore3.this.mScript.term("false", new Term[0]));
        }

        public boolean valueEquality() {
            return this.mValueEquality.equals(ElimStore3.this.mScript.term("true", new Term[0]));
        }

        public boolean valueInequality() {
            return this.mValueEquality.equals(ElimStore3.this.mScript.term("false", new Term[0]));
        }

        public Term getTerm() {
            Term indexTerm = this.mIndexEquality;
            if (this.mSelectConnection) {
                indexTerm = SmtUtils.not(ElimStore3.this.mScript, indexTerm);
            }
            return SmtUtils.or(ElimStore3.this.mScript, indexTerm, this.mValueEquality);
        }
    }

    public static class IndicesAndValues {
        private final Term[] mSelectTerm;
        private final ArrayIndex[] mIndices;
        private final Term[] mValues;
        private final Set<TermVariable> mNewAuxVars;
        private final Map<Term, Term> mSelectTerm2Value = new HashMap<Term, Term>();
        private final int mQuantifier;
        private final ManagedScript mMgdScript;

        public IndicesAndValues(ManagedScript mgdScript, int quantifier, TermVariable array, Term ... conjuncts) {
            this.mMgdScript = mgdScript;
            this.mQuantifier = quantifier;
            HashSet<MultiDimensionalSelect> set = new HashSet<MultiDimensionalSelect>();
            Term[] termArray = conjuncts;
            int n = conjuncts.length;
            int n2 = 0;
            while (n2 < n) {
                Term conjunct = termArray[n2];
                for (MultiDimensionalSelect mdSelect : MultiDimensionalSelect.extractSelectDeep(conjunct, false)) {
                    if (!mdSelect.getArray().equals(array)) continue;
                    set.add(mdSelect);
                }
                ++n2;
            }
            MultiDimensionalSelect[] arrayReads = set.toArray(new MultiDimensionalSelect[set.size()]);
            this.mSelectTerm = new Term[arrayReads.length];
            this.mIndices = new ArrayIndex[arrayReads.length];
            this.mValues = new Term[arrayReads.length];
            this.mNewAuxVars = new HashSet<TermVariable>();
            int i = 0;
            while (i < arrayReads.length) {
                this.mSelectTerm[i] = arrayReads[i].getSelectTerm();
                this.mIndices[i] = arrayReads[i].getIndex();
                EqualityInformation eqInfo = EqualityInformation.getEqinfo(this.mMgdScript.getScript(), arrayReads[i].getSelectTerm(), conjuncts, (Term)array, this.mQuantifier);
                if (eqInfo == null) {
                    Term select = arrayReads[i].getSelectTerm();
                    TermVariable auxVar = this.mMgdScript.constructFreshTermVariable(ElimStore3.s_FreshVariableString, select.getSort());
                    this.mNewAuxVars.add(auxVar);
                    this.mValues[i] = auxVar;
                } else {
                    this.mValues[i] = eqInfo.getRelatedTerm();
                }
                this.mSelectTerm2Value.put(this.mSelectTerm[i], this.mValues[i]);
                ++i;
            }
        }

        public ArrayIndex[] getIndices() {
            return this.mIndices;
        }

        public Term[] getValues() {
            return this.mValues;
        }

        public Set<TermVariable> getNewAuxVars() {
            return this.mNewAuxVars;
        }

        public Map<Term, Term> getMapping() {
            return this.mSelectTerm2Value;
        }
    }
}

