/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayEqualityExplicator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexBasedCostEstimation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndexEqualityManager;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayOccurrenceAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelectOverStoreEliminationUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTaskPlain;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTaskSimple;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.DerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.arrays.Elim1Store;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TreeHashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class ElimStorePlain {
    private static final boolean RETURN_AFTER_SOS = false;
    private static final boolean TRANSFORM_TO_XNF_ON_SPLIT = false;
    private static final boolean THROW_ELIMINATION_EXCEPTIONS = false;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private int mRecursiveCallCounter = -1;

    public ElimStorePlain(ManagedScript mgdScript, IUltimateServiceProvider services, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mMgdScript = mgdScript;
        this.mServices = services;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
    }

    public EliminationTaskSimple elimAll(EliminationTaskSimple eTask) {
        try {
            Stack<EliminationTaskSimple> taskStack = new Stack<EliminationTaskSimple>();
            ArrayList<Term> resultDisjuncts = new ArrayList<Term>();
            LinkedHashSet<TermVariable> resultEliminatees = new LinkedHashSet<TermVariable>();
            EliminationTaskSimple eliminationTask = new EliminationTaskSimple(eTask.getQuantifier(), eTask.getEliminatees(), eTask.getTerm());
            this.pushTaskOnStack(eliminationTask, taskStack);
            int numberOfRounds = 0;
            while (!taskStack.isEmpty()) {
                EliminationTaskSimple currentETask = taskStack.pop();
                TreeHashRelation<Integer, TermVariable> tr = ElimStorePlain.classifyEliminatees(currentETask.getEliminatees());
                LinkedHashSet<TermVariable> arrayEliminatees = this.getArrayTvSmallDimensionsFirst(tr);
                if (arrayEliminatees.isEmpty()) {
                    resultDisjuncts.add(currentETask.getTerm());
                    resultEliminatees.addAll(currentETask.getEliminatees());
                } else {
                    Iterator it = arrayEliminatees.iterator();
                    TermVariable thisIterationEliminatee = (TermVariable)it.next();
                    it.remove();
                    EliminationTaskPlain etwc = new EliminationTaskPlain(currentETask.getQuantifier(), Collections.singleton(thisIterationEliminatee), currentETask.getTerm(), null);
                    EliminationTaskPlain ssdElimRes = new Elim1Store(this.mMgdScript, this.mServices, eTask.getQuantifier()).elim1(etwc);
                    arrayEliminatees.addAll(ssdElimRes.getEliminatees());
                    arrayEliminatees.addAll(tr.getImage((Object)0));
                    EliminationTaskPlain eliminationTask1 = new EliminationTaskPlain(ssdElimRes.getQuantifier(), (Set<TermVariable>)arrayEliminatees, ssdElimRes.getTerm(), null);
                    EliminationTaskPlain eliminationTask2 = ElimStorePlain.applyNonSddEliminations(this.mServices, this.mMgdScript, eliminationTask1, QuantifierPusher.PqeTechniques.ALL_LOCAL);
                    if (this.mLogger.isInfoEnabled()) {
                        this.mLogger.info((Object)("Start of round: " + this.printVarInfo(tr) + " End of round: " + this.printVarInfo(ElimStorePlain.classifyEliminatees(eliminationTask2.getEliminatees())) + " and " + QuantifierUtils.getXjunctsOuter(eTask.getQuantifier(), eliminationTask2.getTerm()).length + " xjuncts."));
                    }
                    this.pushTaskOnStack(eliminationTask2, taskStack);
                }
                ++numberOfRounds;
            }
            this.mLogger.info((Object)("Needed " + numberOfRounds + " rounds to eliminate " + eTask.getEliminatees().size() + " variables, produced " + resultDisjuncts.size() + " xjuncts"));
            return new EliminationTaskSimple(eTask.getQuantifier(), resultEliminatees, QuantifierUtils.applyCorrespondingFiniteConnective(this.mMgdScript.getScript(), eTask.getQuantifier(), resultDisjuncts));
        }
        catch (ElimStorePlainException e) {
            return new EliminationTaskSimple(eTask.getQuantifier(), new HashSet<TermVariable>(eTask.getEliminatees()), eTask.getTerm());
        }
    }

    public EliminationTaskSimple startRecursiveElimination(EliminationTaskSimple eTask) {
        TreeHashRelation<Integer, TermVariable> tr = ElimStorePlain.classifyEliminatees(eTask.getEliminatees());
        if (tr.isEmpty() || tr.getDomain().size() == 1 && tr.getDomain().contains(0)) {
            return eTask;
        }
        this.mRecursiveCallCounter = 0;
        long inputSize = new DAGSize().treesize(eTask.getTerm());
        Term initialContext = this.mMgdScript.getScript().term("true", new Term[0]);
        try {
            EliminationTaskPlain result = this.doElimAllRec(new EliminationTaskPlain(eTask.getQuantifier(), eTask.getEliminatees(), eTask.getTerm(), initialContext));
            long outputSize = new DAGSize().treesize(result.getTerm());
            this.mLogger.info((Object)String.format("Needed %s recursive calls to eliminate %s variables, input treesize:%s, output treesize:%s", this.mRecursiveCallCounter, eTask.getEliminatees().size(), inputSize, outputSize));
            return result;
        }
        catch (ElimStorePlainException e) {
            assert (!this.mMgdScript.isLocked()) : "Solver still locked";
            return new EliminationTaskSimple(eTask.getQuantifier(), new HashSet<TermVariable>(eTask.getEliminatees()), eTask.getTerm());
        }
    }

    private EliminationTaskPlain doElimOneRec(EliminationTaskPlain eTask) throws ElimStorePlainException {
        EliminationTaskPlain resultOfRecursiveCall;
        if (QuantifierUtils.getXjunctsOuter(eTask.getQuantifier(), eTask.getTerm()).length != 1) {
            throw new AssertionError((Object)"Input not split");
        }
        assert (eTask.getEliminatees().size() == 1);
        TermVariable eliminatee = eTask.getEliminatees().iterator().next();
        assert (SmtSortUtils.isArraySort(eliminatee.getSort()));
        Pair<Term[], Term> split = this.split(eTask.getQuantifier(), eliminatee, eTask.getTerm());
        Term additionalContext = QuantifierUtils.negateIfUniversal(this.mServices, this.mMgdScript, eTask.getQuantifier(), (Term)split.getSecond());
        Term totalContext = SmtUtils.and(this.mMgdScript.getScript(), eTask.getContext(), additionalContext);
        if (((Term[])split.getFirst()).length != 1) {
            resultOfRecursiveCall = this.eliminateOne(new EliminationTaskPlain(eTask.getQuantifier(), eTask.getEliminatees(), QuantifierUtils.applyCorrespondingFiniteConnective(this.mMgdScript.getScript(), eTask.getQuantifier(), (Term[])split.getFirst()), totalContext));
        } else {
            assert (((Term[])split.getFirst()).length == 1);
            EliminationTaskPlain revisedInput = new EliminationTaskPlain(eTask.getQuantifier(), eTask.getEliminatees(), ((Term[])split.getFirst())[0], totalContext);
            EliminationTaskPlain ssdElimRes = ElimStorePlain.applyComplexEliminationRules(this.mServices, this.mLogger, this.mMgdScript, revisedInput);
            EliminationTaskPlain eliminationTask2 = ElimStorePlain.applyNonSddEliminations(this.mServices, this.mMgdScript, ssdElimRes, QuantifierPusher.PqeTechniques.ALL_LOCAL);
            resultOfRecursiveCall = this.doElimAllRec(eliminationTask2);
        }
        Term resultTerm = QuantifierUtils.applyDualFiniteConnective(this.mMgdScript.getScript(), eTask.getQuantifier(), resultOfRecursiveCall.getTerm(), (Term)split.getSecond());
        return new EliminationTaskPlain(resultOfRecursiveCall.getQuantifier(), resultOfRecursiveCall.getEliminatees(), resultTerm, eTask.getContext());
    }

    public static EliminationTaskPlain applyComplexEliminationRules(IUltimateServiceProvider services, ILogger logger, ManagedScript mgdScript, EliminationTaskPlain eTask) throws ElimStorePlainException {
        ArrayOccurrenceAnalysis aoaAfterAntiDerPreprocessing;
        Term termAfterAntiDerPreprocessing;
        ArrayOccurrenceAnalysis aoaAfterDerPreprocessing;
        Term termAfterDerPreprocessing;
        if (!QuantifierUtils.isQuantifierFree(eTask.getTerm())) {
            throw new AssertionError((Object)"Alternating quantifiers not yet supported");
        }
        if (eTask.getEliminatees().size() != 1) {
            throw new AssertionError((Object)"need exactly one eliminatee");
        }
        TermVariable eliminatee = eTask.getEliminatees().iterator().next();
        Term polarizedContext = QuantifierUtils.negateIfUniversal(services, mgdScript, eTask.getQuantifier(), eTask.getContext());
        ArrayOccurrenceAnalysis aoa = new ArrayOccurrenceAnalysis(mgdScript.getScript(), eTask.getTerm(), (Term)eliminatee);
        if (!aoa.getValueOfStore().isEmpty() || !aoa.getOtherFunctionApplications().isEmpty()) {
            return null;
        }
        Term[] dualJuncts = QuantifierUtils.getDualFiniteJunction(eTask.getQuantifier(), eTask.getTerm());
        Map<Boolean, List<Term>> part = Arrays.stream(dualJuncts).collect(Collectors.partitioningBy(x -> QuantifierUtils.isCorrespondingFiniteJunction(eTask.getQuantifier(), x)));
        Term distributers = QuantifierUtils.applyDualFiniteConnective(mgdScript.getScript(), eTask.getQuantifier(), (Collection<Term>)part.get(true));
        ArrayOccurrenceAnalysis resetAoa = new ArrayOccurrenceAnalysis(mgdScript.getScript(), distributers, (Term)eliminatee);
        if (!resetAoa.getDerRelations(eTask.getQuantifier()).isEmpty() || !resetAoa.getAntiDerRelations(eTask.getQuantifier()).isEmpty()) {
            return null;
        }
        LinkedHashSet<TermVariable> newAuxVars = new LinkedHashSet<TermVariable>();
        if (aoa.getDerRelations(eTask.getQuantifier()).isEmpty()) {
            termAfterDerPreprocessing = eTask.getTerm();
            aoaAfterDerPreprocessing = aoa;
        } else {
            DerPreprocessor de;
            ThreeValuedEquivalenceRelation tver = new ThreeValuedEquivalenceRelation();
            ArrayIndexEqualityManager aiem = new ArrayIndexEqualityManager((ThreeValuedEquivalenceRelation<Term>)tver, polarizedContext, eTask.getQuantifier(), logger, mgdScript);
            try {
                de = new DerPreprocessor(services, mgdScript, eTask.getQuantifier(), eliminatee, eTask.getTerm(), aoa.getDerRelations(eTask.getQuantifier()), aiem);
            }
            catch (ElimStorePlainException espe) {
                aiem.unlockSolver();
                throw espe;
            }
            aiem.unlockSolver();
            newAuxVars.addAll(de.getNewAuxVars());
            termAfterDerPreprocessing = de.getResult();
            if (de.introducedDerPossibility()) {
                EliminationTaskPlain afterDer = ElimStorePlain.applyNonSddEliminations(services, mgdScript, new EliminationTaskPlain(eTask.getQuantifier(), Collections.singleton(eliminatee), termAfterDerPreprocessing, eTask.getContext()), QuantifierPusher.PqeTechniques.ONLY_DER);
                if (!afterDer.getEliminatees().isEmpty()) {
                    throw new AssertionError((Object)" unsuccessful DER");
                }
                newAuxVars.addAll(afterDer.getEliminatees());
                return new EliminationTaskPlain(eTask.getQuantifier(), newAuxVars, afterDer.getTerm(), eTask.getContext());
            }
            aoaAfterDerPreprocessing = new ArrayOccurrenceAnalysis(mgdScript.getScript(), termAfterDerPreprocessing, (Term)eliminatee);
            newAuxVars.add(eliminatee);
        }
        if (aoa.getAntiDerRelations(eTask.getQuantifier()).isEmpty()) {
            termAfterAntiDerPreprocessing = termAfterDerPreprocessing;
            aoaAfterAntiDerPreprocessing = aoaAfterDerPreprocessing;
        } else {
            ArrayEqualityExplicator aadk = new ArrayEqualityExplicator(mgdScript, eTask.getQuantifier(), eliminatee, termAfterDerPreprocessing, aoa.getAntiDerRelations(eTask.getQuantifier()));
            termAfterAntiDerPreprocessing = aadk.getResultTerm();
            newAuxVars.addAll(aadk.getNewAuxVars());
            aoaAfterAntiDerPreprocessing = new ArrayOccurrenceAnalysis(mgdScript.getScript(), termAfterAntiDerPreprocessing, (Term)eliminatee);
            if (!ElimStorePlain.varOccurs(eliminatee, termAfterAntiDerPreprocessing)) {
                return new EliminationTaskPlain(eTask.getQuantifier(), newAuxVars, termAfterAntiDerPreprocessing, eTask.getContext());
            }
        }
        ThreeValuedEquivalenceRelation tver = new ThreeValuedEquivalenceRelation();
        ArrayIndexEqualityManager aiem = new ArrayIndexEqualityManager((ThreeValuedEquivalenceRelation<Term>)tver, polarizedContext, eTask.getQuantifier(), logger, mgdScript);
        ArrayOccurrenceAnalysis sosAoa = aoaAfterAntiDerPreprocessing;
        Term sosTerm = termAfterAntiDerPreprocessing;
        while (!sosAoa.getArraySelectOverStores().isEmpty()) {
            Term replacedInNnf;
            MultiDimensionalSelectOverNestedStore mdsos = sosAoa.getArraySelectOverStores().get(0);
            Term replaced = MultiDimensionalSelectOverStoreEliminationUtils.replace(mgdScript, aiem, sosTerm, mdsos);
            sosTerm = replacedInNnf = new NnfTransformer(mgdScript, services, NnfTransformer.QuantifierHandling.KEEP).transform(replaced);
            sosAoa = new ArrayOccurrenceAnalysis(mgdScript.getScript(), sosTerm, (Term)eliminatee);
            if (ElimStorePlain.varOccurs(eliminatee, replacedInNnf)) continue;
            aiem.unlockSolver();
            return new EliminationTaskPlain(eTask.getQuantifier(), newAuxVars, replacedInNnf, eTask.getContext());
        }
        aiem.unlockSolver();
        Term termAfterSos = sosTerm;
        EliminationTaskPlain eTaskForStoreElimination = new EliminationTaskPlain(eTask.getQuantifier(), Collections.singleton(eliminatee), termAfterSos, eTask.getContext());
        EliminationTaskPlain resOfStoreElimination = new Elim1Store(mgdScript, services, eTask.getQuantifier()).elim1(eTaskForStoreElimination);
        newAuxVars.addAll(resOfStoreElimination.getEliminatees());
        EliminationTaskPlain eliminationResult = new EliminationTaskPlain(eTask.getQuantifier(), newAuxVars, resOfStoreElimination.getTerm(), eTask.getContext());
        return eliminationResult;
    }

    private static boolean varOccurs(TermVariable var, Term term) {
        return Arrays.stream(term.getFreeVars()).anyMatch(x -> x == var);
    }

    private EliminationTaskPlain doElimAllRec(EliminationTaskPlain eTask) throws ElimStorePlainException {
        ++this.mRecursiveCallCounter;
        int thisRecursiveCallNumber = this.mRecursiveCallCounter;
        TreeHashRelation<Integer, TermVariable> tr = ElimStorePlain.classifyEliminatees(eTask.getEliminatees());
        Term currentTerm = eTask.getTerm();
        LinkedHashSet<TermVariable> newElimnatees = new LinkedHashSet<TermVariable>();
        Iterator iterator = tr.getDomain().iterator();
        while (iterator.hasNext()) {
            int dim = (Integer)iterator.next();
            if (dim == 0) continue;
            ArrayIndexBasedCostEstimation costs = this.computeCostEstimation(eTask, tr.getImage((Object)dim));
            if (costs.getCost2Eliminatee().getDomain().size() > 1) {
                this.mLogger.info((Object)("Different costs " + costs.getCost2Eliminatee()));
            }
            for (Map.Entry entry : costs.getCost2Eliminatee()) {
                EliminationTaskPlain eTaskForVar = new EliminationTaskPlain(eTask.getQuantifier(), Collections.singleton((TermVariable)entry.getValue()), currentTerm, eTask.getContext());
                if (eTaskForVar.getEliminatees().isEmpty()) {
                    this.mLogger.info((Object)("Eliminatee " + entry.getValue() + " vanished before elimination"));
                    continue;
                }
                EliminationTaskPlain res = this.eliminateOne(eTaskForVar);
                currentTerm = res.getTerm();
                newElimnatees.addAll(res.getEliminatees());
            }
        }
        LinkedHashSet<TermVariable> resultingEliminatees = new LinkedHashSet<TermVariable>(newElimnatees);
        resultingEliminatees.addAll(eTask.getEliminatees());
        EliminationTaskPlain preliminaryResult = new EliminationTaskPlain(eTask.getQuantifier(), (Set<TermVariable>)resultingEliminatees, currentTerm, null);
        EliminationTaskPlain finalResult = ElimStorePlain.applyNonSddEliminations(this.mServices, this.mMgdScript, preliminaryResult, QuantifierPusher.PqeTechniques.ALL_LOCAL);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start of recursive call " + thisRecursiveCallNumber + ": " + this.printVarInfo(tr) + " End of recursive call: " + this.printVarInfo(ElimStorePlain.classifyEliminatees(finalResult.getEliminatees())) + " and " + QuantifierUtils.getXjunctsOuter(finalResult.getQuantifier(), finalResult.getTerm()).length + " xjuncts."));
        }
        return finalResult;
    }

    private ArrayIndexBasedCostEstimation computeCostEstimation(EliminationTaskPlain eTask, Set<TermVariable> eliminatees) throws AssertionError {
        Term polarizedContext;
        int quantifier = eTask.getQuantifier();
        if (quantifier == 0) {
            polarizedContext = eTask.getContext();
        } else if (quantifier == 1) {
            polarizedContext = SmtUtils.not(this.mMgdScript.getScript(), eTask.getContext());
        } else {
            throw new AssertionError((Object)"unknown quantifier");
        }
        ThreeValuedEquivalenceRelation tver = new ThreeValuedEquivalenceRelation();
        ArrayIndexEqualityManager aiem = new ArrayIndexEqualityManager((ThreeValuedEquivalenceRelation<Term>)tver, polarizedContext, quantifier, this.mLogger, this.mMgdScript);
        ArrayIndexBasedCostEstimation costs = new ArrayIndexBasedCostEstimation(this.mMgdScript.getScript(), aiem, eliminatees, eTask.getTerm(), eTask.getEliminatees());
        aiem.unlockSolver();
        return costs;
    }

    private EliminationTaskPlain eliminateOne(EliminationTaskPlain eTaskForVar) throws ElimStorePlainException {
        EliminationTaskPlain res;
        TermVariable eliminatee = eTaskForVar.getEliminatees().iterator().next();
        LinkedHashSet<TermVariable> newElimnateesForVar = new LinkedHashSet<TermVariable>();
        Pair<Term[], Term> split = this.split(eTaskForVar.getQuantifier(), eliminatee, eTaskForVar.getTerm());
        Term[] correspondingJunctiveNormalForm = (Term[])split.getFirst();
        Term dualJunctWithoutEliminatee = (Term)split.getSecond();
        Term additionalContext = QuantifierUtils.negateIfUniversal(this.mServices, this.mMgdScript, eTaskForVar.getQuantifier(), dualJunctWithoutEliminatee);
        Term parentContext = SmtUtils.and(this.mMgdScript.getScript(), eTaskForVar.getContext(), additionalContext);
        Term[] resultingCorrespondingJuncts = new Term[correspondingJunctiveNormalForm.length];
        int i = 0;
        while (i < correspondingJunctiveNormalForm.length) {
            Term correspondingJunct = correspondingJunctiveNormalForm[i];
            if (!Arrays.asList(correspondingJunct.getFreeVars()).contains(eliminatee)) {
                resultingCorrespondingJuncts[i] = correspondingJunctiveNormalForm[i];
            } else {
                Term context = this.addSiblingContext(this.mServices, this.mMgdScript, eTaskForVar.getQuantifier(), resultingCorrespondingJuncts, correspondingJunctiveNormalForm, i, parentContext);
                res = this.doElimOneRec(new EliminationTaskPlain(eTaskForVar.getQuantifier(), Collections.singleton(eliminatee), correspondingJunct, context));
                newElimnateesForVar.addAll(res.getEliminatees());
                resultingCorrespondingJuncts[i] = res.getTerm();
            }
            ++i;
        }
        Term preliminaryResult = this.compose(dualJunctWithoutEliminatee, eTaskForVar.getQuantifier(), Arrays.asList(resultingCorrespondingJuncts));
        SmtUtils.ExtendedSimplificationResult esr = SmtUtils.simplifyWithStatistics(this.mMgdScript, preliminaryResult, eTaskForVar.getContext(), this.mServices, this.mSimplificationTechnique);
        this.mLogger.info((Object)esr.buildSizeReductionMessage());
        Term simplifiedResult = esr.getSimplifiedTerm();
        res = new EliminationTaskPlain(eTaskForVar.getQuantifier(), newElimnateesForVar, simplifiedResult, eTaskForVar.getContext());
        return res;
    }

    private Term addSiblingContext(IUltimateServiceProvider services, ManagedScript mgdScript, int quantifier, Term[] resultingCorrespondingJuncts, Term[] correspondingJunctiveNormalForm, int pos, Term parentContext) {
        ArrayList<Term> contextConjuncts = new ArrayList<Term>();
        contextConjuncts.add(parentContext);
        int i = 0;
        while (i < pos) {
            contextConjuncts.add(QuantifierUtils.negateIfExistential(services, mgdScript, quantifier, resultingCorrespondingJuncts[i]));
            ++i;
        }
        i = pos + 1;
        while (i < correspondingJunctiveNormalForm.length) {
            contextConjuncts.add(QuantifierUtils.negateIfExistential(services, mgdScript, quantifier, correspondingJunctiveNormalForm[i]));
            ++i;
        }
        return SmtUtils.and(mgdScript.getScript(), contextConjuncts);
    }

    private Term compose(Term dualJunct, int quantifier, List<Term> correspondingJuncts) {
        Term correspondingJunction = QuantifierUtils.applyCorrespondingFiniteConnective(this.mMgdScript.getScript(), quantifier, correspondingJuncts);
        Term result = QuantifierUtils.applyDualFiniteConnective(this.mMgdScript.getScript(), quantifier, dualJunct, correspondingJunction);
        return result;
    }

    private Pair<Term[], Term> split(int quantifier, TermVariable eliminatee, Term term) {
        Term[] dualJuncts;
        ArrayList<Term> dualJunctsWithEliminatee = new ArrayList<Term>();
        ArrayList<Term> dualJunctsWithoutEliminatee = new ArrayList<Term>();
        Term[] termArray = dualJuncts = QuantifierUtils.getXjunctsInner(quantifier, term);
        int n = dualJuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term xjunct = termArray[n2];
            if (Arrays.asList(xjunct.getFreeVars()).contains(eliminatee)) {
                dualJunctsWithEliminatee.add(xjunct);
            } else {
                dualJunctsWithoutEliminatee.add(xjunct);
            }
            ++n2;
        }
        Term dualJunctionWithElimantee = QuantifierUtils.applyDualFiniteConnective(this.mMgdScript.getScript(), quantifier, dualJunctsWithEliminatee);
        Term dualJunctionWithoutElimantee = QuantifierUtils.applyDualFiniteConnective(this.mMgdScript.getScript(), quantifier, dualJunctsWithoutEliminatee);
        Term correspondingJunction = dualJunctionWithElimantee;
        Term[] correspodingJuncts = QuantifierUtils.getXjunctsOuter(quantifier, correspondingJunction);
        return new Pair((Object)correspodingJuncts, (Object)dualJunctionWithoutElimantee);
    }

    private String printVarInfo(TreeHashRelation<Integer, TermVariable> tr) {
        StringBuilder sb = new StringBuilder();
        for (Integer dim : tr.getDomain()) {
            sb.append(String.valueOf(tr.getImage((Object)dim).size()) + " dim-" + dim + " vars, ");
        }
        return sb.toString();
    }

    private void pushTaskOnStack(EliminationTaskSimple eTask, Stack<EliminationTaskSimple> taskStack) {
        Term term = eTask.getTerm();
        Term[] disjuncts = QuantifierUtils.getXjunctsOuter(eTask.getQuantifier(), term);
        if (disjuncts.length == 1) {
            taskStack.push(eTask);
        } else {
            Term[] termArray = disjuncts;
            int n = disjuncts.length;
            int n2 = 0;
            while (n2 < n) {
                Term disjunct = termArray[n2];
                taskStack.push(new EliminationTaskSimple(eTask.getQuantifier(), eTask.getEliminatees(), disjunct));
                ++n2;
            }
        }
    }

    public static EliminationTaskPlain applyNonSddEliminations(IUltimateServiceProvider services, ManagedScript mgdScript, EliminationTaskPlain eTask, QuantifierPusher.PqeTechniques techniques) throws ElimStorePlainException {
        Set<TermVariable> eliminatees1;
        Term quantified = SmtUtils.quantifier(mgdScript.getScript(), eTask.getQuantifier(), eTask.getEliminatees(), eTask.getTerm());
        Term pushed = QuantifierPusher.eliminate(services, mgdScript, true, techniques, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, quantified);
        Term pnf = new PrenexNormalForm(mgdScript).transform(pushed);
        QuantifierSequence qs = new QuantifierSequence(mgdScript, pnf);
        Term matrix = qs.getInnerTerm();
        List<QuantifierSequence.QuantifiedVariables> qvs = qs.getQuantifierBlocks();
        if (qvs.isEmpty()) {
            eliminatees1 = Collections.emptySet();
        } else if (qvs.size() == 1) {
            eliminatees1 = qvs.get(0).getVariables();
            if (qvs.get(0).getQuantifier() != eTask.getQuantifier()) {
                throw new ElimStorePlainException("alternation not yet supported");
            }
        } else {
            if (qvs.size() > 1) {
                throw new ElimStorePlainException("alternation not yet supported: " + pnf);
            }
            throw new AssertionError();
        }
        return new EliminationTaskPlain(eTask.getQuantifier(), eliminatees1, matrix, eTask.getContext());
    }

    private LinkedHashSet<TermVariable> getArrayTvSmallDimensionsFirst(TreeHashRelation<Integer, TermVariable> tr) {
        LinkedHashSet<TermVariable> result = new LinkedHashSet<TermVariable>();
        for (Integer dim : tr.getDomain()) {
            if (dim == 0) continue;
            result.addAll(tr.getImage((Object)dim));
        }
        return result;
    }

    private static TreeHashRelation<Integer, TermVariable> classifyEliminatees(Collection<TermVariable> eliminatees) {
        TreeHashRelation tr = new TreeHashRelation();
        for (TermVariable eliminatee : eliminatees) {
            MultiDimensionalSort mds = new MultiDimensionalSort(eliminatee.getSort());
            tr.addPair((Object)mds.getDimension(), (Object)eliminatee);
        }
        return tr;
    }

    private static boolean maxSizeIncrease(TreeHashRelation<Integer, TermVariable> tr1, TreeHashRelation<Integer, TermVariable> tr2) {
        if (tr2.isEmpty()) {
            return false;
        }
        int tr1max = (Integer)tr1.descendingDomain().first();
        int tr2max = (Integer)tr2.descendingDomain().first();
        int max = Math.max(tr1max, tr2max);
        Set maxElemsTr1 = tr1.getImage((Object)max);
        Set maxElemsTr2 = tr2.getImage((Object)max);
        if (maxElemsTr1 == null) {
            assert (maxElemsTr2 != null);
            return true;
        }
        if (maxElemsTr2 == null) {
            assert (maxElemsTr1 != null);
            return false;
        }
        return maxElemsTr2.size() > maxElemsTr1.size();
    }

    public static class ElimStorePlainException
    extends Exception {
        private static final long serialVersionUID = 7719170889993834143L;
        public static final String NON_TOP_LEVEL_DER = "DER that is not on top-level";
        public static final String CAPTURED_INDEX = "Subterm of an index is captued by an inner quantifier";
        private final String mMessage;
        private final TermVariable mEliminatee = null;

        public ElimStorePlainException(String message) {
            super(message);
            this.mMessage = message;
        }

        @Override
        public String getMessage() {
            return this.mMessage;
        }
    }
}

