/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class SimplifyDDAWithTimeout
extends SimplifyDDA {
    private final IUltimateServiceProvider mServices;
    private Term mInputTerm;
    private final Term mContext;
    private long mStartTime;

    public SimplifyDDAWithTimeout(Script script, IUltimateServiceProvider services) {
        this(script, true, services);
    }

    public SimplifyDDAWithTimeout(Script script, boolean simplifyRepeatedly, IUltimateServiceProvider services) {
        this(script, simplifyRepeatedly, services, null);
    }

    public SimplifyDDAWithTimeout(Script script, boolean simplifyRepeatedly, IUltimateServiceProvider services, Term context) {
        super(script, simplifyRepeatedly);
        this.mServices = services;
        this.mContext = context;
    }

    protected SimplifyDDA.Redundancy getRedundancy(Term term) {
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            throw new ToolchainCanceledException(((Object)((Object)this)).getClass(), "simplifying term of DAG size " + new DAGSize().size(this.mInputTerm) + " for " + this.getElapsedTimeInMilliseconds() + "ms.");
        }
        return super.getRedundancy(term);
    }

    public Script.LBool checkEquivalence(Term termA, Term termB) {
        Term equivalentTestTerm = this.mScript.term("=", new Term[]{termA, termB});
        Script.LBool areTermsEquivalent = Util.checkSat((Script)this.mScript, (Term)Util.not((Script)this.mScript, (Term)equivalentTestTerm));
        return areTermsEquivalent;
    }

    public Term getSimplifiedTerm(Term inputTerm) {
        Collection<TermVariable> freeVars;
        this.mInputTerm = inputTerm;
        this.mStartTime = System.nanoTime();
        if (!SmtSortUtils.isBoolSort(inputTerm.getSort())) {
            return inputTerm;
        }
        Term term = inputTerm;
        this.mScript.echo(new QuotedObject("Begin Simplifier"));
        this.mScript.push(1);
        if (this.mContext == null) {
            freeVars = Arrays.asList(inputTerm.getFreeVars());
        } else {
            freeVars = new HashSet<TermVariable>(Arrays.asList(inputTerm.getFreeVars()));
            freeVars.addAll(Arrays.asList(this.mContext.getFreeVars()));
        }
        Map<TermVariable, Term> substitutionMapping = SmtUtils.termVariables2Constants(this.mScript, freeVars, true);
        final TermVariable[] vars = new TermVariable[substitutionMapping.size()];
        final Term[] values = new Term[substitutionMapping.size()];
        int offset = 0;
        for (Map.Entry<TermVariable, Term> entry : substitutionMapping.entrySet()) {
            vars[offset] = entry.getKey();
            values[offset] = entry.getValue();
            ++offset;
        }
        if (this.mContext != null) {
            Term contextClosed = new FormulaUnLet().unlet(this.mScript.let(vars, values, this.mContext));
            this.mScript.assertTerm(contextClosed);
        }
        term = this.mScript.let(vars, values, term);
        term = new FormulaUnLet().unlet(term);
        Term output = this.simplifyOnce(term);
        if (this.mSimplifyRepeatedly) {
            while (output != term) {
                term = output;
                output = this.simplifyOnce(term);
            }
        } else {
            term = output;
        }
        term = new TermTransformer(){

            public void convert(Term tterm) {
                int i = 0;
                while (i < vars.length) {
                    if (tterm == values[i]) {
                        tterm = vars[i];
                    }
                    ++i;
                }
                super.convert(tterm);
            }
        }.transform(term);
        this.mScript.pop(1);
        assert (this.mContext != null || this.checkEquivalence(inputTerm, term) != Script.LBool.SAT) : "Simplification unsound?";
        this.mScript.echo(new QuotedObject("End Simplifier"));
        this.mInputTerm = null;
        return term;
    }

    private long getElapsedTimeInMilliseconds() {
        return (System.nanoTime() - this.mStartTime) / 1000000L;
    }
}

