/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrerBooleanCore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.simplify.SimplifyDDAWithTimeout;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class SimplifyQuick {
    private final IUltimateServiceProvider mServices;
    private final Script mScript;
    private static final int TIMOUT_IN_SECONDS = 10;

    public SimplifyQuick(Script script, IUltimateServiceProvider services) {
        this.mScript = script;
        this.mServices = services;
    }

    public Term getSimplifiedTerm(Term inputTerm) throws SMTLIBException {
        SolverBuilder.SolverSettings settings = SolverBuilder.constructSolverSettings().setSmtInterpolTimeout(10000L);
        Script simplificationScript = SolverBuilder.buildScript(this.mServices, settings);
        simplificationScript.setLogic(Logics.CORE);
        TermTransferrerBooleanCore towards = new TermTransferrerBooleanCore(this.mScript, simplificationScript);
        Term foreign = towards.transform(inputTerm);
        simplificationScript.setOption(":check-type", (Object)"QUICK");
        SimplifyDDAWithTimeout dda = new SimplifyDDAWithTimeout(simplificationScript, false, this.mServices);
        Term foreignsimplified = dda.getSimplifiedTerm(foreign);
        TermTransferrer back = new TermTransferrer(simplificationScript, this.mScript, towards.getBacktranferMapping(), false);
        Term simplified = back.transform(foreignsimplified);
        simplificationScript.exit();
        return simplified;
    }
}

