/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.LoggingScriptForNonIncrementalBenchmarks;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtCommandUtils;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LoggingScriptForMainTrackBenchmarks
extends LoggingScriptForNonIncrementalBenchmarks {
    public static final String SOURCE_INVSYNTH = "(set-info :source |" + System.lineSeparator() + "SMT script generated by Ultimate Automizer [1,2]." + System.lineSeparator() + "Ultimate Automizer is a software verifier for C programs that implements an" + System.lineSeparator() + "automata-based approach [3]." + System.lineSeparator() + "The commands in this SMT scripts are used for a constraint-based synthesis" + System.lineSeparator() + "of invariants [4]." + System.lineSeparator() + System.lineSeparator() + "2016-04-30, Matthias Heizmann (heizmann@informatik.uni-freiburg.de)" + System.lineSeparator() + System.lineSeparator() + System.lineSeparator() + "[1] http://http://ultimate.informatik.uni-freiburg.de/automizer/" + System.lineSeparator() + "[2] Matthias Heizmann, Daniel Dietsch, Marius Greitschus, Jan Leike," + System.lineSeparator() + "Betim Musa, Claus Sch\u00e4tzle, Andreas Podelski: Ultimate Automizer with" + System.lineSeparator() + "Two-track Proofs - (Competition Contribution). TACAS 2016: 950-953" + System.lineSeparator() + "[3] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski: Software Model" + System.lineSeparator() + "Checking for People Who Love Automata. CAV 2013:36-52" + System.lineSeparator() + "[4] Michael Colon, Sriram Sankaranarayanan, Henny Sipma: Linear Invariant" + System.lineSeparator() + "Generation Using Non-linear Constraint Solving. CAV 2003: 420-432" + System.lineSeparator() + System.lineSeparator() + "|)" + System.lineSeparator();
    public static final String SOURCE_GNTA = "(set-info :source |" + System.lineSeparator() + System.lineSeparator() + "SMT script generated by Ultimate LassoRanker [1]." + System.lineSeparator() + "Ultimate LassoRanker is a tool that analyzes termination and nontermination of" + System.lineSeparator() + "lasso-shaped programs. This script contains the SMT commands that Ultimate " + System.lineSeparator() + "LassoRanker used while checking if a lasso-shaped program has a geometric " + System.lineSeparator() + "nontermination argument. (See [2] for a preliminary definition of" + System.lineSeparator() + "geometric nontermination argument.)" + System.lineSeparator() + System.lineSeparator() + "This SMT script belongs to a set of SMT scripts that was generated by applying" + System.lineSeparator() + "Ultimate Buchi Automizer [3,4] to benchmarks from the SV-COMP 2016 [5,6] " + System.lineSeparator() + "which are available at [7]. Ultimate Buchi Automizer takes omega-traces" + System.lineSeparator() + "(lasso-shaped programs) and uses LassoRanker in order to check if the " + System.lineSeparator() + "lasso-shaped program is terminating." + System.lineSeparator() + System.lineSeparator() + "2016-04-30, Matthias Heizmann (heizmann@informatik.uni-freiburg.de)" + System.lineSeparator() + System.lineSeparator() + System.lineSeparator() + "[1] https://ultimate.informatik.uni-freiburg.de/LassoRanker/" + System.lineSeparator() + "[2] Jan Leike, Matthias Heizmann: Geometric Series as Nontermination" + System.lineSeparator() + "Arguments for Linear Lasso Programs. CoRR abs/1405.4413 (2014)" + System.lineSeparator() + "http://arxiv.org/abs/1405.4413" + System.lineSeparator() + "[3] http://ultimate.informatik.uni-freiburg.de/BuchiAutomizer/" + System.lineSeparator() + "[4] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski: Software Model" + System.lineSeparator() + "Checking for People Who Love Automata. CAV 2013:36-52" + System.lineSeparator() + "[5] http://sv-comp.sosy-lab.org/2016/" + System.lineSeparator() + "[6] Dirk Beyer: Reliable and Reproducible Competition Results with BenchExec" + System.lineSeparator() + "and Witnesses (Report on SV-COMP 2016). TACAS 2016: 887-904" + System.lineSeparator() + "[7] https://github.com/dbeyer/sv-benchmarks" + System.lineSeparator() + System.lineSeparator() + "|)" + System.lineSeparator();
    public static final String SOURCE_AUTOMIZER = "|" + System.lineSeparator() + "Generated by the tool Ultimate Automizer [1,2] which implements" + System.lineSeparator() + "an automata theoretic approach [3] to software verification." + System.lineSeparator() + System.lineSeparator() + "This SMT script belongs to a set of SMT scripts that was generated by" + System.lineSeparator() + "applying Ultimate Automizer to benchmarks [4] from the SV-COMP 2019 [5,6]." + System.lineSeparator() + "This script might _not_ contain all SMT commands that are used by" + System.lineSeparator() + "Ultimate Automizer. In order to satisfy the restrictions of" + System.lineSeparator() + "the SMT-COMP we have to drop e.g., the commands for getting" + System.lineSeparator() + "values (resp. models), unsatisfiable cores and interpolants." + System.lineSeparator() + System.lineSeparator() + "2019-04-27, Matthias Heizmann (heizmann@informatik.uni-freiburg.de)" + System.lineSeparator() + System.lineSeparator() + "[1] https://ultimate.informatik.uni-freiburg.de/automizer/" + System.lineSeparator() + "[2] Matthias Heizmann, Yu-Fang Chen, Daniel Dietsch, Marius Greitschus," + System.lineSeparator() + "     Jochen Hoenicke, Yong Li, Alexander Nutz, Betim Musa, Christian" + System.lineSeparator() + "     Schilling, Tanja Schindler, Andreas Podelski: Ultimate Automizer" + System.lineSeparator() + "     and the Search for Perfect Interpolants - (Competition Contribution)." + System.lineSeparator() + "     TACAS (2) 2018: 447-451" + System.lineSeparator() + "[3] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski: Software Model" + System.lineSeparator() + "     Checking for People Who Love Automata. CAV 2013:36-52" + System.lineSeparator() + "[4] https://github.com/sosy-lab/sv-benchmarks" + System.lineSeparator() + "[5] Dirk Beyer: Automatic Verification of C and Java Programs: SV-COMP 2019." + System.lineSeparator() + "     TACAS (3) 2019: 133-155" + System.lineSeparator() + "[6] https://sv-comp.sosy-lab.org/2019/" + System.lineSeparator() + "|";
    public static final String SOURCE_POLYNOMIAL_RELATION_TEST = "|" + System.lineSeparator() + "Generated by a testsuite for polynomials of the Ultimate framework [1]." + System.lineSeparator() + "This testsuite runs transformations on polynomials and uses an SMT solver" + System.lineSeparator() + "to check that the input and the output are logically equivalent." + System.lineSeparator() + "These transformations are mainly used by the quantifier elimination " + System.lineSeparator() + "implemented in Ultimate Eliminator [2] which itself is used by " + System.lineSeparator() + "the software verifier Ultimate Automizer[3,4,5] to generate state " + System.lineSeparator() + "assertions from unsatisfiable cores [6]." + System.lineSeparator() + System.lineSeparator() + "2020-06-14, Matthias Heizmann (heizmann@informatik.uni-freiburg.de)" + System.lineSeparator() + System.lineSeparator() + "[1] https://ultimate.informatik.uni-freiburg.de/" + System.lineSeparator() + "[2] https://ultimate.informatik.uni-freiburg.de/eliminator/" + System.lineSeparator() + "[3] https://ultimate.informatik.uni-freiburg.de/automizer/" + System.lineSeparator() + "[4] Matthias Heizmann, Yu-Fang Chen, Daniel Dietsch, Marius Greitschus," + System.lineSeparator() + "     Jochen Hoenicke, Yong Li, Alexander Nutz, Betim Musa, Christian" + System.lineSeparator() + "     Schilling, Tanja Schindler, Andreas Podelski: Ultimate Automizer" + System.lineSeparator() + "     and the Search for Perfect Interpolants - (Competition Contribution)." + System.lineSeparator() + "     TACAS (2) 2018: 447-451" + System.lineSeparator() + "[5] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski: Software Model" + System.lineSeparator() + "     Checking for People Who Love Automata. CAV 2013:36-52" + System.lineSeparator() + "[6] Daniel Dietsch, Matthias Heizmann, Betim Musa, Alexander Nutz, Andreas Podelski" + System.lineSeparator() + "    Craig vs. Newton in software model checking. ESEC/SIGSOFT FSE 2017: 487-497" + System.lineSeparator() + "|";
    private int mWrittenScriptCounter = 0;
    private final int mBenchmarkTooSimpleThreshold = 10000;
    private final boolean mWriteUnsolvedBenchmarks = true;

    public LoggingScriptForMainTrackBenchmarks(Script script, String baseFilename, String directory) {
        super(script, baseFilename, directory);
    }

    @Override
    public Script.LBool checkSat() throws SMTLIBException {
        boolean solved;
        long timeBefore = System.nanoTime();
        Script.LBool sat = this.mScript.checkSat();
        long durationInMilliseconds = (System.nanoTime() - timeBefore) / 1000L / 1000L;
        boolean bl = solved = sat == Script.LBool.SAT || sat == Script.LBool.UNSAT;
        if (solved && durationInMilliseconds >= 10000L || !solved) {
            File file = this.constructFile(String.valueOf('_') + String.valueOf(this.mWrittenScriptCounter));
            List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> processedCommandStack = this.postprocessCommandStack(this.mCommandStack, sat);
            this.writeCommandStackToFile(file, processedCommandStack);
            ++this.mWrittenScriptCounter;
        }
        return sat;
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        Term nonNamedTerm = term instanceof AnnotatedTerm ? ((AnnotatedTerm)term).getSubterm() : term;
        if (nonNamedTerm != this.mScript.term("true", new Term[0])) {
            this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.AssertCommand(nonNamedTerm));
        }
        return this.mScript.assertTerm(term);
    }

    @Override
    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        return this.mScript.getValue(terms);
    }

    private List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> process(LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> commandStack, Script.LBool status) {
        ArrayList flattenedStack = new ArrayList();
        this.addInvarSynthCommands(flattenedStack, status);
        boolean toKeepCommandsReached = false;
        for (ArrayList arrayList : commandStack) {
            for (SmtCommandUtils.ISmtCommand command : arrayList) {
                if (!toKeepCommandsReached && command.toString().contains("declare-fun")) {
                    toKeepCommandsReached = true;
                }
                if (!toKeepCommandsReached) continue;
                flattenedStack.add(command);
            }
        }
        flattenedStack.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.CheckSatCommand());
        flattenedStack.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.ExitCommand());
        return Collections.singletonList(flattenedStack);
    }

    private void addInvarSynthCommands(ArrayList<SmtCommandUtils.ISmtCommand<?>> flattenedStack, Script.LBool status) {
    }

    public static String getSourceInfo() {
        return SOURCE_POLYNOMIAL_RELATION_TEST;
    }

    public static String getLogic() {
        return "BV";
    }

    private List<SmtCommandUtils.ISmtCommand<?>> buildPreamble(Logics logic, Script.LBool sat, String info) {
        ArrayList result = new ArrayList();
        result.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":smt-lib-version", (Object)new BigDecimal("2.6")));
        result.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetLogicCommand(logic.name()));
        result.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":source", (Object)new QuotedObject(info)));
        result.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":license", (Object)new QuotedObject("https://creativecommons.org/licenses/by/4.0/")));
        result.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":category", (Object)new QuotedObject("industrial")));
        result.add((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetInfoCommand(":status", (Object)new QuotedObject(sat.toString())));
        return result;
    }

    private List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> postprocessCommandStack(LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> commandStack, Script.LBool sat) {
        ArrayDeque<Object> tmp = new ArrayDeque<Object>();
        TermClassifier tc = new TermClassifier();
        Iterator<ArrayList<SmtCommandUtils.ISmtCommand<?>>> it = commandStack.descendingIterator();
        while (it.hasNext()) {
            ArrayList<SmtCommandUtils.ISmtCommand<?>> commands = it.next();
            int i = commands.size() - 1;
            while (i >= 0) {
                SmtCommandUtils.ISmtCommand<?> command = commands.get(i);
                if (command instanceof SmtCommandUtils.AssertCommand) {
                    SmtCommandUtils.AssertCommand ac = (SmtCommandUtils.AssertCommand)command;
                    tc.checkTerm(ac.getTerm());
                    tmp.addFirst(command);
                } else if (command instanceof SmtCommandUtils.DeclareFunCommand) {
                    SmtCommandUtils.DeclareFunCommand dfc = (SmtCommandUtils.DeclareFunCommand)command;
                    if (tc.getOccuringFunctionNames().contains(dfc.getFun())) {
                        tmp.addFirst(command);
                    }
                }
                --i;
            }
        }
        tmp.add(new SmtCommandUtils.CheckSatCommand());
        tmp.add(new SmtCommandUtils.ExitCommand());
        Logics logic = this.determineLogic(tc);
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.buildPreamble(logic, sat, LoggingScriptForMainTrackBenchmarks.getSourceInfo()));
        result.addAll(tmp);
        return Collections.singletonList(result);
    }

    private Logics determineLogic(TermClassifier tc) {
        ArrayList<Logics> remainingCandidates = new ArrayList<Logics>();
        Logics[] logicsArray = Logics.values();
        int n = logicsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Logics logic = logicsArray[n2];
            if (!(logic == Logics.ALL || logic.isDifferenceLogic() || logic.isUF() || logic.isNonLinearArithmetic() != tc.hasNonlinearArithmetic() || tc.getOccuringQuantifiers().isEmpty() == logic.isQuantified() || tc.hasArrays() != logic.isArray() || tc.getOccuringSortNames().contains("Int") != logic.hasIntegers() || tc.getOccuringSortNames().contains("Real") != logic.hasReals() && !tc.getOccuringSortNames().contains("FloatingPoint") || tc.getOccuringSortNames().contains("BitVec") != logic.isBitVector() || (tc.getOccuringSortNames().contains("FloatingPoint") || tc.getOccuringSortNames().contains("RoundingMode")) != logic.isFloatingPoint())) {
                remainingCandidates.add(logic);
            }
            ++n2;
        }
        if (remainingCandidates.isEmpty()) {
            throw new AssertionError((Object)"no applicable logic");
        }
        if (remainingCandidates.size() == 1) {
            return (Logics)remainingCandidates.iterator().next();
        }
        throw new AssertionError((Object)("too many candiate logics " + remainingCandidates));
    }
}

