/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtCommandUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LoggingScriptForNonIncrementalBenchmarks
extends WrapperScript {
    private final PrintTerm mTermPrinter = new PrintTerm();
    private final String mBaseFilename;
    private final String mDirectory;
    protected final LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> mCommandStack;

    public LoggingScriptForNonIncrementalBenchmarks(Script script, String baseFilename, String directory) {
        super(script);
        this.mBaseFilename = baseFilename;
        this.mDirectory = directory;
        this.mCommandStack = new LinkedList();
        this.mCommandStack.push(new ArrayList());
    }

    protected LinkedList<ArrayList<SmtCommandUtils.ISmtCommand<?>>> deepCopyOfCommandStack() {
        LinkedList result = new LinkedList();
        for (ArrayList arrayList : this.mCommandStack) {
            result.add(new ArrayList());
            for (SmtCommandUtils.ISmtCommand command : arrayList) {
                result.getLast().add(command);
            }
        }
        return result;
    }

    protected void addToCurrentAssertionStack(SmtCommandUtils.ISmtCommand<?> smtCommand) {
        this.mCommandStack.getLast().add(smtCommand);
    }

    private void resetAssertionStack() {
        this.mCommandStack.clear();
        this.mCommandStack.add(new ArrayList());
    }

    private static void printCommandStack(PrintWriter pw, List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> commandStack) {
        for (ArrayList<SmtCommandUtils.ISmtCommand<?>> al : commandStack) {
            for (SmtCommandUtils.ISmtCommand<?> command : al) {
                pw.print(String.valueOf(command.toString()) + System.lineSeparator());
            }
        }
    }

    protected void writeCommandStackToFile(File file, List<ArrayList<SmtCommandUtils.ISmtCommand<?>>> commandStack) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)("Unable to write file " + file.getAbsolutePath()));
        }
        PrintWriter pw = new PrintWriter(fw);
        LoggingScriptForNonIncrementalBenchmarks.printCommandStack(pw, commandStack);
        pw.close();
    }

    protected File constructFile(String suffix) {
        String filename = String.valueOf(this.mDirectory) + File.separator + this.mBaseFilename + suffix + ".smt2";
        File file = new File(filename);
        return file;
    }

    private static final Term formatTerm(Term input) {
        return input;
    }

    public void setLogic(String logic) throws UnsupportedOperationException, SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(set-logic " + logic + ")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetLogicCommand(logic));
        this.mScript.setLogic(logic);
    }

    public void setLogic(Logics logic) throws UnsupportedOperationException, SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(set-logic " + logic.name() + ")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetLogicCommand(logic.name()));
        this.mScript.setLogic(logic);
    }

    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(set-option ");
        mPw.print(opt);
        mPw.print(' ');
        mPw.print(PrintTerm.quoteObjectIfString((Object)value));
        mPw.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetOptionCommand(opt, value));
        this.mScript.setOption(opt, value);
    }

    public void setInfo(String info, Object value) {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(set-info ");
        mPw.print(info);
        mPw.print(' ');
        mPw.print(PrintTerm.quoteObjectIfString((Object)value));
        mPw.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.SetOptionCommand(info, value));
        this.mScript.setInfo(info, value);
    }

    public void declareSort(String sort, int arity) throws SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(declare-sort ");
        mPw.print(PrintTerm.quoteIdentifier((String)sort));
        mPw.print(' ');
        mPw.print(arity);
        mPw.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.DeclareSortCommand(sort, arity));
        this.mScript.declareSort(sort, arity);
    }

    public void defineSort(String sort, Sort[] sortParams, Sort definition) throws SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(define-sort ");
        mPw.print(PrintTerm.quoteIdentifier((String)sort));
        mPw.print(" (");
        String sep = "";
        Sort[] sortArray = sortParams;
        int n = sortParams.length;
        int n2 = 0;
        while (n2 < n) {
            Sort p = sortArray[n2];
            mPw.print(sep);
            this.mTermPrinter.append((Appendable)mPw, p);
            sep = " ";
            ++n2;
        }
        mPw.print(") ");
        this.mTermPrinter.append((Appendable)mPw, definition);
        mPw.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.DefineSortCommand(sort, sortParams, definition));
        this.mScript.defineSort(sort, sortParams, definition);
    }

    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(declare-fun ");
        mPw.print(PrintTerm.quoteIdentifier((String)fun));
        mPw.print(" (");
        String sep = "";
        Sort[] sortArray = paramSorts;
        int n = paramSorts.length;
        int n2 = 0;
        while (n2 < n) {
            Sort p = sortArray[n2];
            mPw.print(sep);
            this.mTermPrinter.append((Appendable)mPw, p);
            sep = " ";
            ++n2;
        }
        mPw.print(") ");
        this.mTermPrinter.append((Appendable)mPw, resultSort);
        mPw.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.DeclareFunCommand(fun, paramSorts, resultSort));
        this.mScript.declareFun(fun, paramSorts, resultSort);
    }

    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(define-fun ");
        mPw.print(PrintTerm.quoteIdentifier((String)fun));
        mPw.print(" (");
        String sep = "(";
        TermVariable[] termVariableArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable t = termVariableArray[n2];
            mPw.print(sep);
            mPw.print(t);
            mPw.print(' ');
            this.mTermPrinter.append((Appendable)mPw, t.getSort());
            mPw.print(')');
            sep = " (";
            ++n2;
        }
        mPw.print(") ");
        this.mTermPrinter.append((Appendable)mPw, resultSort);
        mPw.print(' ');
        this.mTermPrinter.append((Appendable)mPw, LoggingScriptForNonIncrementalBenchmarks.formatTerm(definition));
        mPw.println(")");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.DefineFunCommand(fun, params, resultSort, definition));
        this.mScript.defineFun(fun, params, resultSort, definition);
    }

    public void push(int levels) throws SMTLIBException {
        int i = 0;
        while (i < levels) {
            this.mCommandStack.add(new ArrayList());
            ++i;
        }
        this.mScript.push(levels);
    }

    public void pop(int levels) throws SMTLIBException {
        int i = 0;
        while (i < levels) {
            this.mCommandStack.removeLast();
            ++i;
        }
        this.mScript.pop(levels);
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.AssertCommand(term));
        return this.mScript.assertTerm(term);
    }

    public Script.LBool checkSat() throws SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(check-sat)");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.CheckSatCommand());
        return this.mScript.checkSat();
    }

    public Term[] getAssertions() throws SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(get-assertions)");
        System.out.println("Logging script will ignore the get-assertions command.");
        return this.mScript.getAssertions();
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(get-proof)");
        System.out.println("Logging script will ignore the get-proof command.");
        return this.mScript.getProof();
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(get-unsat-core)");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.GetUnsatCoreCommand());
        return this.mScript.getUnsatCore();
    }

    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(get-value (");
        String sep = "";
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            mPw.print(sep);
            this.mTermPrinter.append((Appendable)mPw, LoggingScriptForNonIncrementalBenchmarks.formatTerm(t));
            sep = " ";
            ++n2;
        }
        mPw.println("))");
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.GetValueCommand(terms));
        return this.mScript.getValue(terms);
    }

    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(get-assignment)");
        System.out.println("Logging script will ignore the get-assignment command.");
        return this.mScript.getAssignment();
    }

    public Object getOption(String opt) throws UnsupportedOperationException {
        System.out.println("Logging script will ignore the get-option command.");
        return this.mScript.getOption(opt);
    }

    public Object getInfo(String info) throws UnsupportedOperationException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(get-info " + info + ")");
        System.out.println("Logging script will ignore the get-info command.");
        return this.mScript.getInfo(info);
    }

    public Term simplify(Term term) throws SMTLIBException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(simplify ");
        this.mTermPrinter.append((Appendable)mPw, term);
        mPw.println(")");
        System.out.println("Logging script will ignore the simplify command.");
        return this.mScript.simplify(term);
    }

    public void reset() {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(reset)");
        this.resetAssertionStack();
        this.mScript.reset();
    }

    public Term[] getInterpolants(Term[] partition) throws SMTLIBException, UnsupportedOperationException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(get-interpolants");
        Term[] termArray = partition;
        int n = partition.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            mPw.print(' ');
            this.mTermPrinter.append((Appendable)mPw, t);
            ++n2;
        }
        mPw.println(')');
        System.out.println("Logging script will ignore the get-interpolants command.");
        return this.mScript.getInterpolants(partition);
    }

    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException, UnsupportedOperationException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(get-interpolants ");
        this.mTermPrinter.append((Appendable)mPw, partition[0]);
        int i = 1;
        while (i < partition.length) {
            int prevStart = startOfSubtree[i - 1];
            while (startOfSubtree[i] < prevStart) {
                mPw.print(')');
                prevStart = startOfSubtree[prevStart - 1];
            }
            mPw.print(' ');
            if (startOfSubtree[i] == i) {
                mPw.print('(');
            }
            this.mTermPrinter.append((Appendable)mPw, partition[i]);
            ++i;
        }
        mPw.println(')');
        System.out.println("Logging script will ignore the get-interpolants command.");
        return this.mScript.getInterpolants(partition, startOfSubtree);
    }

    public void exit() {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(exit)");
        mPw.flush();
        mPw.close();
        System.out.println("Logging script will ignore the exit command.");
        this.mScript.exit();
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.println("(get-model)");
        System.out.println("Logging script will ignore the get-model command.");
        return this.mScript.getModel();
    }

    public Iterable<Term[]> checkAllsat(Term[] predicates) throws SMTLIBException, UnsupportedOperationException {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        PrintTerm pt = new PrintTerm();
        mPw.print("(check-allsat (");
        String spacer = "";
        Term[] termArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            Term p = termArray[n2];
            mPw.print(spacer);
            pt.append((Appendable)mPw, p);
            spacer = " ";
            ++n2;
        }
        mPw.println("))");
        System.out.println("Logging script will ignore the check-allsat command.");
        return this.mScript.checkAllsat(predicates);
    }

    public Term[] findImpliedEquality(Term[] x, Term[] y) {
        Term p;
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        PrintTerm pt = new PrintTerm();
        mPw.print("(find-implied-equality (");
        String spacer = "";
        Term[] termArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            p = termArray[n2];
            mPw.print(spacer);
            pt.append((Appendable)mPw, p);
            spacer = " ";
            ++n2;
        }
        mPw.print(") (");
        spacer = "";
        termArray = x;
        n = x.length;
        n2 = 0;
        while (n2 < n) {
            p = termArray[n2];
            mPw.print(spacer);
            pt.append((Appendable)mPw, p);
            spacer = " ";
            ++n2;
        }
        mPw.println("))");
        System.out.println("Logging script will ignore the find-implied-equality command.");
        return this.mScript.findImpliedEquality(x, y);
    }

    public QuotedObject echo(QuotedObject msg) {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("(echo ");
        mPw.print(msg);
        mPw.println(')');
        this.addToCurrentAssertionStack((SmtCommandUtils.ISmtCommand<?>)new SmtCommandUtils.EchoCommand(msg));
        return this.mScript.echo(msg);
    }

    public void comment(String comment) {
        StringWriter sw = new StringWriter();
        PrintWriter mPw = new PrintWriter(sw);
        mPw.print("; ");
        mPw.println(comment);
        System.out.println("Logging script will ignore the comment command.");
    }

    public Script.LBool checkSatAssuming(Term ... assumptions) throws SMTLIBException {
        throw new UnsupportedOperationException("Introduced in SMTInterpol 2.1-324-ga0525a0, not yet supported");
    }

    public Term[] getUnsatAssumptions() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Introduced in SMTInterpol 2.1-324-ga0525a0, not yet supported");
    }

    public void resetAssertions() {
        throw new UnsupportedOperationException("Introduced in SMTInterpol 2.1-324-ga0525a0, not yet supported");
    }
}

