/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SMTFeature {
    public int numberOfFunctions = 0;
    public int numberOfQuantifiers = 0;
    public int numberOfVariables = 0;
    public int numberOfArrays = 0;
    public int numberOfSelectFunctions = 0;
    public int numberOfStoreFunctions = 0;
    public int dagsize = 0;
    public long treesize = 0L;
    public int dependencyScore = 0;
    public ArrayList<Integer> variableEquivalenceClassSizes;
    public int biggestEquivalenceClass;
    public Map<String, Integer> occuringSorts = new HashMap<String, Integer>();
    public Map<String, Integer> occuringFunctions = new HashMap<String, Integer>();
    public Map<Integer, Integer> occuringQuantifiers = new HashMap<Integer, Integer>();
    public boolean containsArrays = false;
    public ArrayList<String> assertionStack = new ArrayList();
    public int assertionStackHashCode = 0;
    public String solverresult = "";
    public String solvername = "";
    public double solvertime = 0.0;

    public String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n" + SMTFeature.getCsvHeader(";") + "\n");
            sb.append(this.toCsv(";"));
            return sb.toString();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return "";
        }
    }

    private String mapToJson(Map<?, ?> map) {
        return "{" + map.entrySet().stream().map(e -> "\"" + e.getKey() + "\"" + ":" + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + "}";
    }

    public String toCsv(String delimiter) throws IllegalAccessException {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        values.add(String.valueOf(this.numberOfFunctions));
        values.add(String.valueOf(this.numberOfQuantifiers));
        values.add(String.valueOf(this.numberOfVariables));
        values.add(String.valueOf(this.numberOfArrays));
        values.add(String.valueOf(this.dagsize));
        values.add(String.valueOf(this.treesize));
        values.add(String.valueOf(this.dependencyScore));
        values.add(String.valueOf(this.variableEquivalenceClassSizes));
        values.add(String.valueOf(this.biggestEquivalenceClass));
        values.add(this.mapToJson(this.occuringSorts));
        values.add(this.mapToJson(this.occuringFunctions));
        values.add(this.mapToJson(this.occuringQuantifiers));
        values.add(String.valueOf(this.containsArrays));
        values.add(String.valueOf(this.assertionStack));
        values.add(String.valueOf(this.assertionStackHashCode));
        values.add(String.valueOf(this.solverresult));
        values.add(String.valueOf(this.solvername));
        values.add(String.valueOf(this.solvertime));
        sb.append(String.join((CharSequence)delimiter, values));
        return sb.toString();
    }

    public static String getCsvHeader(String delimiter) throws IllegalAccessException {
        StringBuilder sb = new StringBuilder();
        Field[] fields = SMTFeature.class.getFields();
        ArrayList<String> names = new ArrayList<String>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            names.add(field.getName());
            ++n2;
        }
        sb.append(String.join((CharSequence)delimiter, names));
        return sb.toString();
    }

    public static SMTFeature chooseLooser(SMTFeature feature1, SMTFeature feature2) {
        String[] fieldnames;
        int score1 = 0;
        int score2 = 0;
        String[] stringArray = fieldnames = new String[]{"numberOfFunctions", "numberOfArrays", "dagsize", "numberOfVariables", "dependencyScore", "biggestEquivalenceClass", "numberOfSelectFunctions", "numberOfStoreFunctions"};
        int n = fieldnames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldname = stringArray[n2];
            int fieldvalue1 = 0;
            try {
                fieldvalue1 = (Integer)feature1.getClass().getField(fieldname).get(feature1);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            int fieldvalue2 = 0;
            try {
                fieldvalue2 = (Integer)feature2.getClass().getField(fieldname).get(feature2);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            if (fieldvalue1 < fieldvalue2) {
                ++score1;
            } else if (fieldvalue2 < fieldvalue1) {
                ++score2;
            }
            ++n2;
        }
        if (score1 > score2) {
            return feature2;
        }
        return feature1;
    }
}

