/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SMTFeatureExtractionTermClassifier
extends NonRecursive {
    private Set<Term> mTermsInWhichWeAlreadyDescended;
    private final Map<String, Integer> mOccuringSortNames = new HashMap<String, Integer>();
    private final Map<String, Integer> mOccuringFunctionNames = new HashMap<String, Integer>();
    private final Map<Integer, Integer> mOccuringQuantifiers = new HashMap<Integer, Integer>();
    private boolean mHasArrays = false;
    private int mNumberOfArrays = 0;
    private int mNumberOfVariables = 0;
    private int mNumberOfFunctions = 0;
    private int mNumberOfQuantifiers = 0;
    private int mDAGSize = 0;
    private long mTreeSize = 0L;
    private final UnionFind<Term> mVariableEquivalenceClasses;
    private Map<Integer, Set<Term>> mTermsets;
    private int mBiggestEquivalenceClass = 0;
    private final ArrayList<String> mAssertionStack = new ArrayList();
    private final Map<Term, Integer> mVariableToCount;

    public SMTFeatureExtractionTermClassifier() {
        this.mVariableEquivalenceClasses = new UnionFind();
        this.mTermsets = new HashMap<Integer, Set<Term>>();
        this.mVariableToCount = new HashMap<Term, Integer>();
    }

    public void checkTerm(Term term) {
        this.mTermsInWhichWeAlreadyDescended = new HashSet<Term>();
        this.mAssertionStack.add(term.toString());
        this.mDAGSize += new DAGSize().size(term);
        this.mTreeSize += new DAGSize().treesize(term);
        this.run((NonRecursive.Walker)new MyWalker(term));
        this.mTermsInWhichWeAlreadyDescended = null;
    }

    public int getDAGSize() {
        return this.mDAGSize;
    }

    public int getNumberOfFunctions() {
        return this.mNumberOfFunctions;
    }

    public int getNumberOfQuantifiers() {
        return this.mNumberOfQuantifiers;
    }

    public int getNumberOfVariables() {
        return this.mNumberOfVariables;
    }

    public int getNumberOfArrays() {
        return this.mNumberOfArrays;
    }

    public Map<String, Integer> getOccuringFunctionNames() {
        return this.mOccuringFunctionNames;
    }

    public Map<Integer, Integer> getOccuringQuantifiers() {
        return this.mOccuringQuantifiers;
    }

    public Map<String, Integer> getOccuringSortNames() {
        return this.mOccuringSortNames;
    }

    public ArrayList<Integer> getVariableEquivalenceClassSizes() {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        this.mVariableEquivalenceClasses.getAllEquivalenceClasses().forEach(e -> sizes.add(e.size()));
        return sizes;
    }

    public int getBiggestEquivalenceClass() {
        return this.mBiggestEquivalenceClass;
    }

    public ArrayList<String> getAssertionStack() {
        return this.mAssertionStack;
    }

    public long getTreeSize() {
        return this.mTreeSize;
    }

    public boolean hasArrays() {
        return this.mHasArrays;
    }

    public int getDependencyScore() {
        return this.calcDependencyScore();
    }

    public UnionFind<Term> getEquivalenceClasses() {
        return this.mVariableEquivalenceClasses;
    }

    public static double normalize(double score, double lower_bound, double upper_bound) {
        double normalized_score = 1.0 - 1.0 / (score != 0.0 ? score : 1.0);
        double range = upper_bound - lower_bound;
        return normalized_score * range + lower_bound;
    }

    public double getScore(ScoringMethod scoringMethod) {
        int score = 0;
        if (scoringMethod == ScoringMethod.DEPENDENCY) {
            score = this.getDependencyScore();
        } else if (scoringMethod == ScoringMethod.NUM_FUNCTIONS) {
            score = this.getNumberOfFunctions();
        } else if (scoringMethod == ScoringMethod.NUM_VARIABLES) {
            score = this.getNumberOfVariables();
        } else if (scoringMethod == ScoringMethod.DAGSIZE) {
            score = this.getDAGSize();
        } else if (scoringMethod == ScoringMethod.BIGGEST_EQUIVALENCE_CLASS) {
            score = this.getBiggestEquivalenceClass();
        } else if (scoringMethod == ScoringMethod.AVERAGE_EQUIVALENCE_CLASS) {
            score = (int)this.getVariableEquivalenceClassSizes().stream().mapToInt(val -> val).average().orElse(0.0);
        } else if (scoringMethod == ScoringMethod.NUMBER_OF_EQUIVALENCE_CLASSES) {
            score = this.getVariableEquivalenceClassSizes().size();
        } else if (scoringMethod == ScoringMethod.NUMBER_OF_SELECT_FUNCTIONS) {
            score = this.getOccuringFunctionNames().getOrDefault("select", 0);
        } else if (scoringMethod == ScoringMethod.NUMBER_OF_STORE_FUNCTIONS) {
            score = this.getOccuringFunctionNames().getOrDefault("store", 0);
        } else if (scoringMethod == ScoringMethod.COMPARE_FEATURES) {
            score = 1;
        }
        return SMTFeatureExtractionTermClassifier.normalize(score, 0.5, 1.0);
    }

    private static boolean isApplicationTermWithArityZero(Term term) {
        ApplicationTerm appterm;
        return term instanceof ApplicationTerm && (appterm = (ApplicationTerm)term).getParameters().length == 0;
    }

    private int calcDependencyScore() {
        int score = 0;
        for (Set eqclass : this.mVariableEquivalenceClasses.getAllEquivalenceClasses()) {
            int classSize = eqclass.size();
            if (classSize > this.mBiggestEquivalenceClass) {
                this.mBiggestEquivalenceClass = classSize;
            }
            score = (int)((double)score + Math.pow(classSize, 2.0));
        }
        return score;
    }

    private class MyWalker
    extends NonRecursive.TermWalker {
        MyWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker) {
            if (!SMTFeatureExtractionTermClassifier.this.mTermsInWhichWeAlreadyDescended.contains(this.getTerm())) {
                Term term = this.getTerm();
                if (!term.toStringDirect().equals("true") && !term.toStringDirect().equals("false") && (term instanceof TermVariable || SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term))) {
                    Sort currentSort = term.getSort();
                    String currentSortName = term.getSort().toString();
                    if (SMTFeatureExtractionTermClassifier.this.mOccuringSortNames.containsKey(currentSortName)) {
                        SMTFeatureExtractionTermClassifier.this.mOccuringSortNames.put(currentSortName, SMTFeatureExtractionTermClassifier.this.mOccuringSortNames.get(currentSortName) + 1);
                    } else {
                        SMTFeatureExtractionTermClassifier.this.mOccuringSortNames.put(currentSortName, 1);
                    }
                    if (currentSort.isArraySort()) {
                        SMTFeatureExtractionTermClassifier.this.mHasArrays = true;
                        ++SMTFeatureExtractionTermClassifier.this.mNumberOfArrays;
                    }
                }
                super.walk(walker);
            }
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            SMTFeatureExtractionTermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)term);
            walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getSubterm()));
        }

        private void createAndAddToTermset(int eq_class_id, Term ... terms) {
            HashSet<Term> termset = new HashSet<Term>(Arrays.asList(terms));
            termset.addAll(SMTFeatureExtractionTermClassifier.this.mTermsets.getOrDefault(eq_class_id, Collections.emptySet()));
            SMTFeatureExtractionTermClassifier.this.mTermsets.put(eq_class_id, termset);
        }

        private void collectVariables(ApplicationTerm term, String functionname, int eq_class_id) {
            Term[] termParameters = term.getParameters();
            if (termParameters.length == 1) {
                this.createAndAddToTermset(eq_class_id, termParameters[0]);
            }
            int i = 0;
            while (i < termParameters.length - 1) {
                int new_class_id;
                Term term1 = termParameters[i];
                Term term2 = termParameters[i + 1];
                if ((SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term1) || term1 instanceof TermVariable) && (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term2) || term2 instanceof TermVariable)) {
                    if (functionname.equals("or")) {
                        this.createAndAddToTermset(eq_class_id, term1);
                        this.createAndAddToTermset(SMTFeatureExtractionTermClassifier.this.mTermsets.size() + 1, term2);
                    } else {
                        this.createAndAddToTermset(eq_class_id, term1, term2);
                    }
                } else if (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term1) && term2 instanceof ConstantTerm) {
                    this.createAndAddToTermset(eq_class_id, term1);
                } else if (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term2) && term1 instanceof ConstantTerm) {
                    this.createAndAddToTermset(eq_class_id, term2);
                } else if (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term1) || term1 instanceof TermVariable) {
                    this.createAndAddToTermset(eq_class_id, term1);
                    int n = new_class_id = functionname.equals("or") ? SMTFeatureExtractionTermClassifier.this.mTermsets.size() + 1 : eq_class_id;
                    if (term2 instanceof ApplicationTerm) {
                        this.collectVariables((ApplicationTerm)term2, ((ApplicationTerm)term2).getFunction().getName(), new_class_id);
                    }
                } else if (SMTFeatureExtractionTermClassifier.isApplicationTermWithArityZero(term2) || term2 instanceof TermVariable) {
                    this.createAndAddToTermset(eq_class_id, term2);
                    int n = new_class_id = functionname.equals("or") ? SMTFeatureExtractionTermClassifier.this.mTermsets.size() + 1 : eq_class_id;
                    if (term1 instanceof ApplicationTerm) {
                        this.collectVariables((ApplicationTerm)term1, ((ApplicationTerm)term1).getFunction().getName(), new_class_id);
                    }
                } else if (term1 instanceof ApplicationTerm && term2 instanceof ApplicationTerm) {
                    this.collectVariables((ApplicationTerm)term1, ((ApplicationTerm)term1).getFunction().getName(), eq_class_id);
                    new_class_id = functionname.equals("or") ? SMTFeatureExtractionTermClassifier.this.mTermsets.size() + 1 : eq_class_id;
                    this.collectVariables((ApplicationTerm)term2, ((ApplicationTerm)term2).getFunction().getName(), new_class_id);
                }
                ++i;
            }
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            if (term.getParameters().length > 0) {
                String functionName = term.getFunction().getName();
                if (SMTFeatureExtractionTermClassifier.this.mOccuringFunctionNames.containsKey(functionName)) {
                    SMTFeatureExtractionTermClassifier.this.mOccuringFunctionNames.put(functionName, SMTFeatureExtractionTermClassifier.this.mOccuringFunctionNames.get(functionName) + 1);
                } else {
                    SMTFeatureExtractionTermClassifier.this.mOccuringFunctionNames.put(functionName, 1);
                }
                SMTFeatureExtractionTermClassifier.this.mTermsets = new HashMap<Integer, Set<Term>>();
                this.collectVariables(term, functionName, 0);
                SMTFeatureExtractionTermClassifier.this.mTermsets.forEach((k, v) -> {
                    v.forEach(e -> SMTFeatureExtractionTermClassifier.this.mVariableEquivalenceClasses.findAndConstructEquivalenceClassIfNeeded(e));
                    SMTFeatureExtractionTermClassifier.this.mVariableEquivalenceClasses.union((Collection)v);
                });
                ++SMTFeatureExtractionTermClassifier.this.mNumberOfFunctions;
            } else {
                ++SMTFeatureExtractionTermClassifier.this.mNumberOfVariables;
            }
            SMTFeatureExtractionTermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)term);
            Term[] termArray = term.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(t));
                ++n2;
            }
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        public void walk(NonRecursive walker, LetTerm term) {
            SMTFeatureExtractionTermClassifier.this.mTermsInWhichWeAlreadyDescended.add((Term)term);
            walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getSubTerm()));
            Term[] termArray = term.getValues();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term v = termArray[n2];
                walker.enqueueWalker((NonRecursive.Walker)new MyWalker(v));
                ++n2;
            }
        }

        public void walk(NonRecursive walker, MatchTerm term) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            int quantifier = term.getQuantifier();
            if (SMTFeatureExtractionTermClassifier.this.mOccuringQuantifiers.containsKey(term.getQuantifier())) {
                SMTFeatureExtractionTermClassifier.this.mOccuringQuantifiers.put(quantifier, SMTFeatureExtractionTermClassifier.this.mOccuringQuantifiers.get(quantifier) + 1);
            } else {
                SMTFeatureExtractionTermClassifier.this.mOccuringQuantifiers.put(quantifier, 1);
            }
            ++SMTFeatureExtractionTermClassifier.this.mNumberOfQuantifiers;
            walker.enqueueWalker((NonRecursive.Walker)new MyWalker(term.getSubformula()));
        }

        public void walk(NonRecursive walker, TermVariable term) {
            if (SMTFeatureExtractionTermClassifier.this.mVariableToCount.containsKey(term)) {
                SMTFeatureExtractionTermClassifier.this.mVariableToCount.put((Term)term, SMTFeatureExtractionTermClassifier.this.mVariableToCount.get(term) + 1);
            } else {
                SMTFeatureExtractionTermClassifier.this.mVariableToCount.put((Term)term, 1);
                ++SMTFeatureExtractionTermClassifier.this.mNumberOfVariables;
            }
        }

        public void walk(NonRecursive walker, LambdaTerm term) {
            throw new UnsupportedOperationException();
        }
    }

    public static enum ScoringMethod {
        NUM_FUNCTIONS,
        NUM_VARIABLES,
        DAGSIZE,
        DEPENDENCY,
        BIGGEST_EQUIVALENCE_CLASS,
        AVERAGE_EQUIVALENCE_CLASS,
        NUMBER_OF_EQUIVALENCE_CLASSES,
        NUMBER_OF_SELECT_FUNCTIONS,
        NUMBER_OF_STORE_FUNCTIONS,
        COMPARE_FEATURES;

    }
}

