/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeature;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractionTermClassifier;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class SMTFeatureExtractor {
    private final ILogger mLogger;
    private final List<SMTFeature> mFeatures;
    private final Path mDumpPath;
    private final Path mFilename;
    private final boolean mDumpFeatures;

    public SMTFeatureExtractor(ILogger logger, String dump_path, boolean dump_features) {
        this.mLogger = logger;
        this.mFeatures = new ArrayList<SMTFeature>();
        this.mDumpFeatures = dump_features;
        if (dump_features) {
            this.mDumpPath = new File(dump_path).toPath();
            String timestamp = ZonedDateTime.now().format(DateTimeFormatter.ofPattern("uuuu-MM-dd"));
            this.mFilename = this.mDumpPath.resolve(String.valueOf(timestamp) + "-smtfeatures.csv");
            this.createDumpFile();
        } else {
            this.mDumpPath = null;
            this.mFilename = null;
        }
    }

    public SMTFeature extractFeatureRaw(Term term) {
        SMTFeatureExtractionTermClassifier tc = new SMTFeatureExtractionTermClassifier();
        tc.checkTerm(term);
        SMTFeature feature = new SMTFeature();
        feature.containsArrays = tc.hasArrays();
        feature.occuringFunctions = tc.getOccuringFunctionNames();
        feature.occuringQuantifiers = tc.getOccuringQuantifiers();
        feature.occuringSorts = tc.getOccuringSortNames();
        feature.numberOfFunctions = tc.getNumberOfFunctions();
        feature.numberOfQuantifiers = tc.getNumberOfQuantifiers();
        feature.numberOfVariables = tc.getNumberOfVariables();
        feature.numberOfArrays = tc.getNumberOfArrays();
        feature.numberOfSelectFunctions = tc.getOccuringFunctionNames().getOrDefault("select", 0);
        feature.numberOfStoreFunctions = tc.getOccuringFunctionNames().getOrDefault("store", 0);
        feature.dagsize = tc.getDAGSize();
        feature.dependencyScore = tc.getDependencyScore();
        feature.variableEquivalenceClassSizes = tc.getVariableEquivalenceClassSizes();
        feature.biggestEquivalenceClass = tc.getBiggestEquivalenceClass();
        return feature;
    }

    public void extractFeature(List<Term> assertions, double time, String result, String solvername) throws IllegalAccessException, IOException {
        SMTFeatureExtractionTermClassifier tc = new SMTFeatureExtractionTermClassifier();
        for (Term term : assertions) {
            tc.checkTerm(term);
        }
        SMTFeature feature = new SMTFeature();
        feature.assertionStackHashCode = tc.getAssertionStack().hashCode();
        feature.containsArrays = tc.hasArrays();
        feature.occuringFunctions = tc.getOccuringFunctionNames();
        feature.occuringQuantifiers = tc.getOccuringQuantifiers();
        feature.occuringSorts = tc.getOccuringSortNames();
        feature.numberOfFunctions = tc.getNumberOfFunctions();
        feature.numberOfQuantifiers = tc.getNumberOfQuantifiers();
        feature.numberOfVariables = tc.getNumberOfVariables();
        feature.numberOfArrays = tc.getNumberOfArrays();
        feature.dagsize = tc.getDAGSize();
        feature.treesize = tc.getTreeSize();
        feature.dependencyScore = tc.getDependencyScore();
        feature.variableEquivalenceClassSizes = tc.getVariableEquivalenceClassSizes();
        feature.biggestEquivalenceClass = tc.getBiggestEquivalenceClass();
        feature.solverresult = result;
        feature.solvertime = time;
        feature.solvername = solvername;
        this.mFeatures.add(feature);
        if (this.mDumpFeatures) {
            this.dumpFeature(feature);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dumpFeature(SMTFeature feature) throws IllegalAccessException, IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileWriter fw = new FileWriter(this.mFilename.toString(), true);
                try {
                    block21: {
                        BufferedWriter bw = new BufferedWriter(fw);
                        try {
                            try (PrintWriter out = new PrintWriter(bw);){
                                if (this.mLogger.isDebugEnabled()) {
                                    this.mLogger.debug((Object)"################## SMT DUMP #####################");
                                    this.mLogger.debug((Object)("Writing to file:" + this.mFilename));
                                    this.mLogger.debug((Object)SMTFeature.getCsvHeader(";"));
                                    this.mLogger.debug((Object)("FEATURE: " + feature));
                                    this.mLogger.debug((Object)"#################################################");
                                }
                                out.println(feature.toCsv(";"));
                            }
                            if (bw == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (bw == null) throw throwable;
                            bw.close();
                            throw throwable;
                        }
                        bw.close();
                    }
                    if (fw == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (fw == null) throw throwable;
                    fw.close();
                    throw throwable;
                }
                fw.close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createDumpFile() {
        File f = new File(this.mFilename.toString());
        if (f.exists()) return;
        try {
            f.createNewFile();
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try {
                    FileWriter fw = new FileWriter(this.mFilename.toString(), true);
                    try {
                        block22: {
                            BufferedWriter bw = new BufferedWriter(fw);
                            try {
                                try (PrintWriter out = new PrintWriter(bw);){
                                    String header = SMTFeature.getCsvHeader(";");
                                    out.println(header);
                                }
                                if (bw == null) break block22;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (bw == null) throw throwable;
                                bw.close();
                                throw throwable;
                            }
                            bw.close();
                        }
                        if (fw == null) return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fw == null) throw throwable;
                        fw.close();
                        throw throwable;
                    }
                    fw.close();
                    return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (IOException | IllegalAccessException e) {
                this.mLogger.error((Object)e);
                return;
            }
        }
        catch (IOException e) {
            this.mLogger.error((Object)e);
        }
    }
}

