/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractor;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Collectors;

public class SMTFeatureExtractorScript
extends WrapperScript {
    private final SMTFeatureExtractor mFeatureExtractor;
    private final Deque<Term> mCurrentAssertionStack;
    private final ILogger mLogger;

    public SMTFeatureExtractorScript(Script script, ILogger logger, String dumpPath) {
        super(script);
        this.mLogger = logger;
        this.mFeatureExtractor = new SMTFeatureExtractor(logger, dumpPath, true);
        this.mCurrentAssertionStack = new ArrayDeque<Term>();
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mCurrentAssertionStack.add(term);
        return super.assertTerm(term);
    }

    public void push(int levels) throws SMTLIBException {
        super.push(levels);
        int i = levels;
        while (i >= 0) {
            this.mCurrentAssertionStack.add(StackMarker.INSTANCE);
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void pop(int levels) throws SMTLIBException {
        super.pop(levels);
        iter = this.mCurrentAssertionStack.descendingIterator();
        currentTerm = null;
        i = levels;
        ** GOTO lbl11
        {
            currentTerm = iter.next();
            iter.remove();
            do {
                if (currentTerm != StackMarker.INSTANCE) continue block0;
                --i;
lbl11:
                // 2 sources

            } while (i >= 0);
        }
    }

    public Script.LBool checkSat() throws SMTLIBException {
        double start = System.nanoTime();
        Script.LBool sat = this.mScript.checkSat();
        double analysisTime = ((double)System.nanoTime() - start) / 1000.0;
        try {
            this.mFeatureExtractor.extractFeature(this.mCurrentAssertionStack.stream().filter(a -> a != StackMarker.INSTANCE).collect(Collectors.toList()), analysisTime, sat.toString(), this.mScript.getInfo(":name").toString());
        }
        catch (IOException | IllegalAccessException e) {
            this.mLogger.error((Object)e);
        }
        return sat;
    }

    private static final class StackMarker
    extends Term {
        private static final StackMarker INSTANCE = new StackMarker();

        protected StackMarker() {
            super(-1);
        }

        public Sort getSort() {
            throw new UnsupportedOperationException();
        }

        protected void toStringHelper(ArrayDeque<Object> todo) {
            throw new UnsupportedOperationException();
        }
    }
}

