/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;

public class ScriptWithTermConstructionChecks
extends WrapperScript {
    public ScriptWithTermConstructionChecks(Script script) {
        super(script);
    }

    public Term term(String funcname, Term ... params) {
        this.checkIfsomeParamUsesDifferentTheory(params);
        return this.mScript.term(funcname, params);
    }

    private void checkIfsomeParamUsesDifferentTheory(Term[] params) {
        Term[] termArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Term param = termArray[n2];
            Theory paramTheory = ScriptWithTermConstructionChecks.getTheory(param);
            if (paramTheory != this.getThisScriptsTheory()) {
                throw new IllegalArgumentException("Param was constructed with different Script: " + param);
            }
            ++n2;
        }
    }

    private static Theory getTheory(Term param) {
        return param.getSort().getTheory();
    }

    private Theory getThisScriptsTheory() {
        return SmtSortUtils.getBoolSort(this.mScript).getTheory();
    }

    public Term term(String funcname, String[] indices, Sort returnSort, Term ... params) {
        this.checkIfsomeParamUsesDifferentTheory(params);
        return this.mScript.term(funcname, indices, returnSort, params);
    }

    public Script.LBool checkSatAssuming(Term ... assumptions) {
        throw new UnsupportedOperationException("Introduced in SMTInterpol 2.1-324-ga0525a0, not yet supported");
    }

    public Term[] getUnsatAssumptions() {
        throw new UnsupportedOperationException("Introduced in SMTInterpol 2.1-324-ga0525a0, not yet supported");
    }

    public void resetAssertions() {
        throw new UnsupportedOperationException("Introduced in SMTInterpol 2.1-324-ga0525a0, not yet supported");
    }
}

