/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.HistoryRecordingScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.DiffWrapperScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.LoggingScriptForMainTrackBenchmarks;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.LoggingScriptForUnsatCoreBenchmarks;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractorScript;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.muses.MusEnumerationScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.NonIncrementalScriptor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Scriptor;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.ScriptorWithGetInterpolants;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.SmtInterpolLogProxyWrapper;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class SolverBuilder {
    public static final boolean USE_DIFF_WRAPPER_SCRIPT = true;
    private static final boolean USE_WRAPPER_SCRIPT_WITH_TERM_CONSTRUCTION_CHECKS = false;

    private SolverBuilder() {
    }

    public static SolverSettings constructSolverSettings() throws AssertionError {
        return new SolverSettings(SolverMode.Internal_SMTInterpol, false, false, null, null, -1L, null, false, false, false, null, null, false, false, null, false, Collections.emptyMap(), null, false);
    }

    public static Script buildScript(IUltimateServiceProvider services, SolverSettings settings) {
        Object script;
        ILogger localLogger = services.getLoggingService().getLogger(SolverBuilder.class);
        ILogger solverLogger = SolverBuilder.getSolverLogger(services, settings);
        if (settings.useExternalSolver()) {
            script = SolverBuilder.createExternalSolver(services, settings, solverLogger, localLogger);
        } else {
            localLogger.info("Constructing new instance of SMTInterpol with explicit timeout %s ms and remaining time %s ms", new Object[]{settings.getTimeoutSmtInterpol(), services.getProgressMonitorService().remainingTime()});
            SmtInterpolLogProxyWrapper loggerWrapper = new SmtInterpolLogProxyWrapper(solverLogger);
            SMTInterpolTerminationRequest termRequest = new SMTInterpolTerminationRequest(services.getProgressMonitorService());
            script = settings.useMinimalUnsatCoreEnumerationForSmtInterpol() ? new MusEnumerationScript(new SMTInterpol((LogProxy)loggerWrapper, (TerminationRequest)termRequest)) : new SMTInterpol((LogProxy)loggerWrapper, (TerminationRequest)termRequest);
            if (settings.dumpSmtScriptToFile()) {
                script = SolverBuilder.wrapScriptWithLoggingScript(services, script, localLogger, settings.constructFullPathOfDumpedScript());
            }
            if (settings.getTimeoutSmtInterpol() != -1L) {
                script.setOption(":timeout", (Object)settings.getTimeoutSmtInterpol());
            }
            script = new SelfDestructingSolverStorable((Script)script, services.getStorage());
        }
        if (settings.dumpFeatureExtractionVector()) {
            script = new SMTFeatureExtractorScript((Script)script, SolverBuilder.getSolverLogger(services, settings), settings.getFeatureVectorDumpPath());
        }
        if (settings.dumpUnsatCoreTrackBenchmark()) {
            script = new LoggingScriptForUnsatCoreBenchmarks((Script)script, settings.getBaseNameOfDumpedScript(), settings.getPathOfDumpedScript());
        }
        if (settings.dumpMainTrackBenchmark()) {
            script = new LoggingScriptForMainTrackBenchmarks((Script)script, settings.getBaseNameOfDumpedScript(), settings.getPathOfDumpedScript());
        }
        return new HistoryRecordingScript((Script)script);
    }

    private static Script createExternalSolver(IUltimateServiceProvider services, SolverSettings settings, ILogger solverLogger, ILogger localLogger) {
        Object script;
        String fullPathOfDumpedFile;
        assert (settings.getSolverMode() == null || settings.getSolverMode() != SolverMode.Internal_SMTInterpol) : "You set solver mode to Internal* and enabled useExternalSolver";
        String command = settings.getCommandExternalSolver();
        localLogger.info("Constructing external solver with command: %s", new Object[]{settings.getCommandExternalSolver()});
        if (settings.dumpSmtScriptToFile()) {
            fullPathOfDumpedFile = settings.constructFullPathOfDumpedScript();
            localLogger.info((Object)("Dumping SMT script to " + fullPathOfDumpedFile));
        } else {
            fullPathOfDumpedFile = null;
        }
        try {
            ScriptorWithGetInterpolants.ExternalInterpolator externalInterpolator = settings.getExternalInterpolator();
            if (externalInterpolator == null) {
                script = settings.fakeNonIncrementalScript() ? new NonIncrementalScriptor(command, solverLogger, services, "External_FakeNonIncremental", settings.dumpSmtScriptToFile(), settings.getPathOfDumpedScript(), settings.getBaseNameOfDumpedScript(), fullPathOfDumpedFile) : new Scriptor(command, solverLogger, services, "External", fullPathOfDumpedFile);
            } else {
                localLogger.info((Object)("external solver will use " + externalInterpolator + " interpolation mode"));
                script = new ScriptorWithGetInterpolants(command, solverLogger, services, externalInterpolator, "ExternalInterpolator", fullPathOfDumpedFile);
            }
            if (settings.useDiffWrapper()) {
                script = new DiffWrapperScript((Script)script);
            }
        }
        catch (IOException e) {
            localLogger.fatal("Unable to construct solver: %s", new Object[]{e.getMessage()});
            throw new RuntimeException(e);
        }
        return script;
    }

    public static Script buildAndInitializeSolver(IUltimateServiceProvider services, SolverSettings solverSettings, String solverId) throws AssertionError {
        if (solverSettings.getSolverMode() == null) {
            throw new IllegalArgumentException("You cannot initialize a solver without specifying the solver mode in the solver settings instance");
        }
        Script script = SolverBuilder.buildScript(services, solverSettings);
        if (!solverSettings.getAdditionalOptions().isEmpty()) {
            for (Map.Entry<String, String> setting : solverSettings.getAdditionalOptions().entrySet()) {
                script.setOption(":" + setting.getKey(), (Object)setting.getValue());
            }
        }
        SolverBuilder.setSolverModeDependentOptions(solverSettings, script);
        String advertising = "SMT script generated on " + CoreUtil.getIsoUtcTimestampWithUtcOffset() + " by Ultimate (https://ultimate.informatik.uni-freiburg.de/)";
        script.setInfo(":source", (Object)advertising);
        script.setInfo(":smt-lib-version", (Object)new BigDecimal("2.5"));
        script.setInfo(":category", (Object)new QuotedObject("industrial"));
        script.setInfo(":ultimate-id", (Object)solverId);
        return script;
    }

    private static Script wrapScriptWithLoggingScript(IUltimateServiceProvider services, Script script, ILogger localLogger, String fullPathOfDumpedFile) {
        SelfDestructingSolverStorable wrappedScript;
        try {
            wrappedScript = new SelfDestructingSolverStorable((Script)new LoggingScript(script, fullPathOfDumpedFile, true), services.getStorage());
            localLogger.info((Object)("Dumping SMT script to " + fullPathOfDumpedFile));
        }
        catch (IOException e) {
            localLogger.error((Object)("Unable dump SMT script to " + fullPathOfDumpedFile));
            throw new RuntimeException(e);
        }
        return wrappedScript;
    }

    private static ILogger getSolverLogger(IUltimateServiceProvider services, SolverSettings settings) {
        if (settings.getSolverLogger() != null) {
            return settings.getSolverLogger();
        }
        return services.getLoggingService().getLoggerForExternalTool(SolverBuilder.class);
    }

    private static void setSolverModeDependentOptions(SolverSettings solverSettings, Script script) throws AssertionError {
        Logics logic = solverSettings.getSolverLogics();
        switch (solverSettings.getSolverMode()) {
            case External_DefaultMode: {
                if (logic == null) break;
                script.setLogic(logic);
                break;
            }
            case External_ModelsMode: {
                script.setOption(":produce-models", (Object)true);
                if (logic == null) break;
                script.setLogic(logic);
                break;
            }
            case External_ModelsAndUnsatCoreMode: {
                script.setOption(":produce-models", (Object)true);
                script.setOption(":produce-unsat-cores", (Object)true);
                if (logic == null) break;
                script.setLogic(logic);
                break;
            }
            case External_PrincessInterpolationMode: 
            case External_SMTInterpolInterpolationMode: 
            case External_MathsatInterpolationMode: {
                script.setOption(":produce-models", (Object)true);
                script.setOption(":produce-interpolants", (Object)true);
                if (logic == null) break;
                script.setLogic(logic);
                break;
            }
            case External_Z3InterpolationMode: {
                script.setOption(":produce-models", (Object)true);
                script.setOption(":produce-interpolants", (Object)true);
                if (logic == null) break;
                script.setLogic(logic);
                if (logic.isArray()) {
                    Sort indexSort = SmtSortUtils.getIntSort(script);
                    Sort intSort = SmtSortUtils.getIntSort(script);
                    Sort intArraySort = SmtSortUtils.getArraySort(script, indexSort, intSort);
                    script.declareFun("array-ext", new Sort[]{intArraySort, intArraySort}, indexSort);
                    break;
                }
                logic.isBitVector();
                break;
            }
            case Internal_SMTInterpol: {
                script.setOption(":produce-models", (Object)true);
                script.setOption(":produce-unsat-cores", (Object)true);
                script.setOption(":produce-interpolants", (Object)true);
                script.setOption(":interpolant-check-mode", (Object)true);
                script.setOption(":proof-transformation", (Object)"LU");
                if (logic == null) {
                    throw new AssertionError((Object)"SMTInterpol requires explicit logic");
                }
                script.setLogic(logic);
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown solver");
            }
        }
    }

    public static enum ExternalSolver {
        Z3("z3 -smt2 -in SMTLIB2_COMPLIANT=true", "z3 -smt2 -in SMTLIB2_COMPLIANT=true -t:%d", Logics.ALL),
        CVC4("cvc4 --incremental --print-success --lang smt", "cvc4 --incremental --print-success --lang smt --tlimit-per=%d", Logics.ALL),
        MATHSAT("mathsat -unsat_core_generation=3", null, Logics.ALL),
        MATHSAT_INTERPOLATION("mathsat -theory.bv.eager=false -theory.fp.enabled=false", null, Logics.ALL),
        SMTINTERPOL(null, null, Logics.ALL),
        PRINCESS(null, null, null);

        private final String mSolverCommand;
        private final String mSolverCommandTimeoutFormatString;
        private final Logics mDefaultLogic;

        private ExternalSolver(String solverCommand, String solverCommandTimeoutFormatString, Logics defaultLogic) {
            this.mSolverCommand = solverCommand;
            this.mSolverCommandTimeoutFormatString = solverCommandTimeoutFormatString;
            this.mDefaultLogic = defaultLogic;
        }

        public String getSolverCommand() {
            if (this.mSolverCommand == null) {
                throw new UnsupportedOperationException("Unknown or not implemented solver command: " + (Object)((Object)this));
            }
            return this.mSolverCommand;
        }

        public String getSolverCommand(long timeout) {
            if (timeout == -1L) {
                return this.getSolverCommand();
            }
            if (timeout < 0L) {
                throw new IllegalArgumentException("Timeout must be non-negative");
            }
            if (this.mSolverCommandTimeoutFormatString == null) {
                throw new UnsupportedOperationException("Unknown or not implemented solver command with timeouts: " + (Object)((Object)this));
            }
            return String.format(this.mSolverCommandTimeoutFormatString, timeout);
        }

        public Logics getDefaultLogic() {
            return this.mDefaultLogic;
        }
    }

    private static final class SMTInterpolTerminationRequest
    implements TerminationRequest {
        private final IProgressMonitorService mMonitor;

        SMTInterpolTerminationRequest(IProgressMonitorService monitor) {
            this.mMonitor = monitor;
        }

        public boolean isTerminationRequested() {
            return !this.mMonitor.continueProcessing();
        }
    }

    private static final class SelfDestructingSolverStorable
    extends WrapperScript
    implements IStorable {
        private static int sCounter = 0;
        private final int mId = sCounter++;
        private IToolchainStorage mStorage;

        protected SelfDestructingSolverStorable(Script wrappedScript, IToolchainStorage storage) {
            super(wrappedScript);
            this.mStorage = storage;
            this.mStorage.putStorable(this.getKey(), (IStorable)this);
        }

        public void destroy() {
            if (this.mStorage != null) {
                super.exit();
                this.removeFromStorage();
            }
        }

        public void exit() {
            super.exit();
            this.removeFromStorage();
        }

        private void removeFromStorage() {
            if (this.mStorage != null) {
                this.mStorage.removeStorable(this.getKey());
                this.mStorage = null;
            }
        }

        private String getKey() {
            return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + this.mId;
        }
    }

    public static enum SolverMode {
        Internal_SMTInterpol(false),
        External_PrincessInterpolationMode(true),
        External_SMTInterpolInterpolationMode(true),
        External_Z3InterpolationMode(true),
        External_MathsatInterpolationMode(true),
        External_ModelsAndUnsatCoreMode(true),
        External_ModelsMode(true),
        External_DefaultMode(true);

        private final boolean mIsExternal;

        private SolverMode(boolean isExternal) {
            this.mIsExternal = isExternal;
        }

        public boolean isExternal() {
            return this.mIsExternal;
        }
    }

    public static final class SolverSettings {
        private final ILogger mSolverLogger;
        private final boolean mFakeNonIncrementalScript;
        private final boolean mUseExternalSolver;
        private final String mExternalSolverCommand;
        private final long mTimeoutSmtInterpol;
        private final ScriptorWithGetInterpolants.ExternalInterpolator mExternalInterpolator;
        private final boolean mDumpSmtScriptToFile;
        private final String mPathOfDumpedScript;
        private final String mBaseNameOfDumpedScript;
        private final boolean mUseDiffWrapper;
        private final boolean mDumpFeatureVector;
        private final String mFeatureVectorDumpPath;
        private final boolean mDumpUnsatCoreTrackBenchmark;
        private final boolean mDumpMainTrackBenchmark;
        private final SolverMode mSolverMode;
        private final Logics mSolverLogics;
        private final boolean mCompressDumpedScript;
        private final Map<String, String> mAdditionalOptions;
        private final boolean mUseMinimalUnsatCoreEnumerationForSmtInterpol;

        private SolverSettings(SolverMode solverMode, boolean fakeNonIncrementalScript, boolean useExternalSolver, String commandExternalSolver, Logics solverLogic, long timeoutSmtInterpol, ScriptorWithGetInterpolants.ExternalInterpolator externalInterpolator, boolean dumpSmtScriptToFile, boolean dumpUnsatCoreTrackBenchmark, boolean dumpMainTrackBenchmark, String pathOfDumpedScript, String baseNameOfDumpedScript, boolean useDiffWrapper, boolean dumpFeatureVector, String featureVectorDumpPath, boolean compressDumpedScript, Map<String, String> additionalOptions, ILogger logger, boolean useMinimalUnsatCoreEnumerationForSmtInterpol) {
            this.mSolverMode = solverMode;
            this.mFakeNonIncrementalScript = fakeNonIncrementalScript;
            this.mUseExternalSolver = useExternalSolver;
            this.mExternalSolverCommand = commandExternalSolver;
            this.mSolverLogics = solverLogic;
            this.mTimeoutSmtInterpol = timeoutSmtInterpol;
            this.mExternalInterpolator = externalInterpolator;
            this.mDumpSmtScriptToFile = dumpSmtScriptToFile;
            this.mDumpUnsatCoreTrackBenchmark = dumpUnsatCoreTrackBenchmark;
            this.mDumpMainTrackBenchmark = dumpMainTrackBenchmark;
            this.mPathOfDumpedScript = pathOfDumpedScript;
            this.mBaseNameOfDumpedScript = baseNameOfDumpedScript;
            this.mUseDiffWrapper = useDiffWrapper;
            this.mDumpFeatureVector = dumpFeatureVector;
            this.mFeatureVectorDumpPath = featureVectorDumpPath;
            this.mCompressDumpedScript = compressDumpedScript;
            this.mAdditionalOptions = additionalOptions;
            this.mSolverLogger = logger;
            this.mUseMinimalUnsatCoreEnumerationForSmtInterpol = useMinimalUnsatCoreEnumerationForSmtInterpol;
        }

        public boolean fakeNonIncrementalScript() {
            return this.mFakeNonIncrementalScript;
        }

        public boolean useExternalSolver() {
            return this.mUseExternalSolver;
        }

        public Map<String, String> getAdditionalOptions() {
            return this.mAdditionalOptions;
        }

        public String getCommandExternalSolver() {
            return this.mExternalSolverCommand;
        }

        public long getTimeoutSmtInterpol() {
            return this.mTimeoutSmtInterpol;
        }

        public ScriptorWithGetInterpolants.ExternalInterpolator getExternalInterpolator() {
            return this.mExternalInterpolator;
        }

        public Logics getSolverLogics() {
            return this.mSolverLogics;
        }

        public boolean dumpSmtScriptToFile() {
            return this.mDumpSmtScriptToFile;
        }

        public boolean compressDumpedScript() {
            return this.mCompressDumpedScript;
        }

        public boolean dumpUnsatCoreTrackBenchmark() {
            return this.mDumpUnsatCoreTrackBenchmark;
        }

        public boolean dumpMainTrackBenchmark() {
            return this.mDumpMainTrackBenchmark;
        }

        public String getPathOfDumpedScript() {
            return this.mPathOfDumpedScript;
        }

        public String getBaseNameOfDumpedScript() {
            return this.mBaseNameOfDumpedScript;
        }

        public boolean useDiffWrapper() {
            return this.mUseDiffWrapper;
        }

        public boolean useMinimalUnsatCoreEnumerationForSmtInterpol() {
            return this.mUseMinimalUnsatCoreEnumerationForSmtInterpol;
        }

        public boolean dumpFeatureExtractionVector() {
            return this.mDumpFeatureVector;
        }

        public String getFeatureVectorDumpPath() {
            return this.mFeatureVectorDumpPath;
        }

        public SolverMode getSolverMode() {
            return this.mSolverMode;
        }

        public ILogger getSolverLogger() {
            return this.mSolverLogger;
        }

        public String constructFullPathOfDumpedScript() {
            StringBuilder sb = new StringBuilder();
            sb.append(CoreUtil.addFileSeparator((String)this.getPathOfDumpedScript()));
            sb.append(this.getBaseNameOfDumpedScript());
            if (this.compressDumpedScript()) {
                sb.append(".smt2.gz");
            } else {
                sb.append(".smt2");
            }
            return sb.toString();
        }

        public SolverSettings setDumpSmtScriptToFile(boolean enabled, String folderPathOfDumpedFile, String basenameOfDumpedFile, boolean compressScript) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, enabled, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, folderPathOfDumpedFile, basenameOfDumpedFile, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, compressScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setDumpUnsatCoreTrackBenchmark(boolean enable) {
            assert (!enable || this.mDumpSmtScriptToFile && this.mPathOfDumpedScript != null && this.mBaseNameOfDumpedScript != null);
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, enable, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setDumpMainTrackBenchmark(boolean enable) {
            assert (!enable || this.mDumpSmtScriptToFile && this.mPathOfDumpedScript != null && this.mBaseNameOfDumpedScript != null);
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, enable, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setDumpFeatureVectors(boolean enabled, String dumpPath) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, enabled, dumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setSmtInterpolTimeout(long timeoutInMsSmtInterpol) {
            if (timeoutInMsSmtInterpol < 0L && timeoutInMsSmtInterpol != -1L) {
                throw new IllegalArgumentException("Timeout for SMTInterpol must be non-negative or -1 to disable timeout");
            }
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, timeoutInMsSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setUseExternalSolver(boolean enable, String externalSolverCommand, Logics externalSolverLogics) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, enable, externalSolverCommand, externalSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setUseExternalSolver(ExternalSolver solver) {
            return this.setUseExternalSolver(true, solver.getSolverCommand(), solver.getDefaultLogic());
        }

        public SolverSettings setUseExternalSolver(ExternalSolver solver, Logics logic, long timeout) {
            return this.setUseExternalSolver(true, solver.getSolverCommand(timeout), logic);
        }

        public SolverSettings setUseExternalSolver(ExternalSolver solver, Logics logic) {
            return this.setUseExternalSolver(true, solver.getSolverCommand(), logic);
        }

        public SolverSettings setUseExternalSolver(ExternalSolver solver, long timeout) {
            return this.setUseExternalSolver(true, solver.getSolverCommand(timeout), solver.getDefaultLogic());
        }

        public SolverSettings setUseFakeIncrementalScript(boolean enable) {
            return new SolverSettings(this.mSolverMode, enable, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setSolverLogics(Logics logics) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, logics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setUseMinimalUnsatCoreEnumerationForSmtInterpol(boolean enable) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, enable);
        }

        public SolverSettings setSolverMode(SolverMode solverMode) {
            Logics logics;
            boolean useDiffWrapper;
            ScriptorWithGetInterpolants.ExternalInterpolator externalInterpolator;
            int timeoutSmtInterpol;
            boolean useExternalSolver;
            if (solverMode == null) {
                return new SolverSettings(solverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
            }
            switch (solverMode) {
                case External_ModelsAndUnsatCoreMode: 
                case External_ModelsMode: 
                case External_DefaultMode: {
                    useExternalSolver = true;
                    timeoutSmtInterpol = -1;
                    externalInterpolator = null;
                    useDiffWrapper = true;
                    logics = this.mSolverLogics;
                    break;
                }
                case External_PrincessInterpolationMode: {
                    useExternalSolver = true;
                    timeoutSmtInterpol = -1;
                    externalInterpolator = ScriptorWithGetInterpolants.ExternalInterpolator.PRINCESS;
                    useDiffWrapper = true;
                    logics = this.mSolverLogics;
                    break;
                }
                case External_SMTInterpolInterpolationMode: {
                    useExternalSolver = true;
                    timeoutSmtInterpol = -1;
                    externalInterpolator = ScriptorWithGetInterpolants.ExternalInterpolator.SMTINTERPOL;
                    useDiffWrapper = false;
                    logics = this.mSolverLogics;
                    break;
                }
                case External_Z3InterpolationMode: {
                    useExternalSolver = true;
                    timeoutSmtInterpol = -1;
                    externalInterpolator = ScriptorWithGetInterpolants.ExternalInterpolator.IZ3;
                    useDiffWrapper = true;
                    logics = this.mSolverLogics;
                    break;
                }
                case External_MathsatInterpolationMode: {
                    useExternalSolver = true;
                    timeoutSmtInterpol = -1;
                    externalInterpolator = ScriptorWithGetInterpolants.ExternalInterpolator.MATHSAT;
                    useDiffWrapper = true;
                    logics = this.mSolverLogics;
                    break;
                }
                case Internal_SMTInterpol: {
                    useExternalSolver = false;
                    timeoutSmtInterpol = -1;
                    externalInterpolator = null;
                    useDiffWrapper = false;
                    logics = ExternalSolver.SMTINTERPOL.getDefaultLogic();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown solver mode " + (Object)((Object)solverMode)));
                }
            }
            return new SolverSettings(solverMode, this.mFakeNonIncrementalScript, useExternalSolver, this.mExternalSolverCommand, logics, timeoutSmtInterpol, externalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, useDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setAdditionalOptions(Map<String, String> additionalOptions) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, Objects.requireNonNull(additionalOptions), this.mSolverLogger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public SolverSettings setSolverLogger(ILogger logger) {
            return new SolverSettings(this.mSolverMode, this.mFakeNonIncrementalScript, this.mUseExternalSolver, this.mExternalSolverCommand, this.mSolverLogics, this.mTimeoutSmtInterpol, this.mExternalInterpolator, this.mDumpSmtScriptToFile, this.mDumpUnsatCoreTrackBenchmark, this.mDumpMainTrackBenchmark, this.mPathOfDumpedScript, this.mBaseNameOfDumpedScript, this.mUseDiffWrapper, this.mDumpFeatureVector, this.mFeatureVectorDumpPath, this.mCompressDumpedScript, this.mAdditionalOptions, logger, this.mUseMinimalUnsatCoreEnumerationForSmtInterpol);
        }

        public String toString() {
            return ReflectionUtil.instanceFieldsToString((Object)this);
        }
    }
}

