/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.IdentityTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Objects;

public class AxiomsAdderIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final BasicIcfg<OUTLOC> mResult;

    public AxiomsAdderIcfgTransformer(ILogger logger, String resultName, Class<OUTLOC> outLocClazz, IIcfg<INLOC> inputCfg, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Term additionalAxioms) {
        CfgSmtToolkit inputCfgCsToolkit = inputCfg.getCfgSmtToolkit();
        ManagedScript mgdScript = inputCfgCsToolkit.getManagedScript();
        SmtFunctionsAndAxioms newSmtSymbols = inputCfgCsToolkit.getSmtFunctionsAndAxioms().addAxiom(additionalAxioms);
        CfgSmtToolkit newToolkit = new CfgSmtToolkit(inputCfgCsToolkit.getModifiableGlobalsTable(), mgdScript, inputCfgCsToolkit.getSymbolTable(), inputCfgCsToolkit.getProcedures(), inputCfgCsToolkit.getInParams(), inputCfgCsToolkit.getOutParams(), inputCfgCsToolkit.getIcfgEdgeFactory(), inputCfgCsToolkit.getConcurrencyInformation(), newSmtSymbols);
        IdentityTransformer noopTransformulaTransformer = new IdentityTransformer(inputCfgCsToolkit);
        IcfgTransformer<INLOC, OUTLOC> noopIcfgTransformer = new IcfgTransformer<INLOC, OUTLOC>(Objects.requireNonNull(logger), inputCfg, funLocFac, backtranslationTracker, outLocClazz, resultName, noopTransformulaTransformer);
        BasicIcfg copiedIcfg = (BasicIcfg)noopIcfgTransformer.getResult();
        copiedIcfg.setCfgSmtToolkit(newToolkit);
        this.mResult = copiedIcfg;
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }
}

