/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.lib.translation.DefaultTranslator;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class IcfgTransformationBacktranslator
extends DefaultTranslator<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>, Term, Term, String, String> {
    private final Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> mEdgeMapping = new HashMap<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>>();
    private final ILogger mLogger;
    private final ArrayList<Function<Term, Term>> mExpressionBacktranslations;

    public IcfgTransformationBacktranslator(Class<? extends IIcfgTransition<IcfgLocation>> traceElementType, Class<Term> expressionType, ILogger logger) {
        super(traceElementType, traceElementType, expressionType, expressionType);
        this.mLogger = logger;
        this.mExpressionBacktranslations = new ArrayList();
    }

    public IProgramExecution<IIcfgTransition<IcfgLocation>, Term> translateProgramExecution(IProgramExecution<IIcfgTransition<IcfgLocation>, Term> programExecution) {
        Map[] oldBranchEncoders = null;
        if (programExecution instanceof IcfgProgramExecution) {
            oldBranchEncoders = ((IcfgProgramExecution)programExecution).getBranchEncoders();
        }
        ArrayList<IIcfgTransition<IcfgLocation>> newTrace = new ArrayList<IIcfgTransition<IcfgLocation>>();
        HashMap<Integer, IProgramExecution.ProgramState<Term>> newValues = new HashMap<Integer, IProgramExecution.ProgramState<Term>>();
        ArrayList<Map> newBranchEncoders = new ArrayList<Map>();
        this.addProgramState(-1, newValues, (IProgramExecution.ProgramState<Term>)programExecution.getInitialProgramState());
        int i = 0;
        while (i < programExecution.getLength()) {
            AtomicTraceElement currentATE = programExecution.getTraceElement(i);
            IIcfgTransition<IcfgLocation> mappedEdge = this.mEdgeMapping.get(currentATE.getTraceElement());
            if (mappedEdge == null) {
                this.mLogger.warn((Object)("Skipped ATE because there is no mapping: [" + ((IIcfgTransition)currentATE.getTraceElement()).hashCode() + "] " + currentATE.getTraceElement()));
            } else {
                newTrace.add(mappedEdge);
                this.addProgramState(i, newValues, (IProgramExecution.ProgramState<Term>)programExecution.getProgramState(i));
                if (oldBranchEncoders != null && oldBranchEncoders.length > i) {
                    newBranchEncoders.add(oldBranchEncoders[i]);
                }
            }
            ++i;
        }
        return IcfgProgramExecution.create(newTrace, newValues, (Map[])newBranchEncoders.toArray(new Map[newBranchEncoders.size()]));
    }

    private void addProgramState(Integer i, Map<Integer, IProgramExecution.ProgramState<Term>> newValues, IProgramExecution.ProgramState<Term> programState) {
        newValues.put(i, (IProgramExecution.ProgramState<Term>)this.translateProgramState(programState));
    }

    public Term translateExpression(Term expression) {
        Term current = expression;
        int i = this.mExpressionBacktranslations.size() - 1;
        while (i >= 0) {
            current = this.mExpressionBacktranslations.get(i).apply(current);
            --i;
        }
        return current;
    }

    public void mapEdges(IIcfgTransition<IcfgLocation> newEdge, IIcfgTransition<IcfgLocation> originalEdge) {
        IIcfgTransition<IcfgLocation> realOriginalEdge = this.mEdgeMapping.get(originalEdge);
        if (realOriginalEdge != null) {
            this.mEdgeMapping.put(newEdge, realOriginalEdge);
        } else {
            this.mEdgeMapping.put(newEdge, originalEdge);
        }
    }

    public void addExpressionBacktranslation(Function<Term, Term> backtranslation) {
        this.mExpressionBacktranslations.add(backtranslation);
    }

    @Deprecated
    public Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> getEdgeMapping() {
        return Collections.unmodifiableMap(this.mEdgeMapping);
    }
}

