/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

public class IcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final IIcfg<OUTLOC> mResultIcfg;
    private final ILogger mLogger;

    public IcfgTransformer(ILogger logger, IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier, ITransformulaTransformer transformer) {
        this.mLogger = Objects.requireNonNull(logger);
        this.mResultIcfg = this.transform(originalIcfg, funLocFac, backtranslationTracker, outLocationClass, newIcfgIdentifier, transformer);
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier, ITransformulaTransformer transformer) {
        transformer.preprocessIcfg(originalIcfg);
        BasicIcfg resultIcfg = new BasicIcfg(newIcfgIdentifier, originalIcfg.getCfgSmtToolkit(), outLocationClass);
        TransformedIcfgBuilder<INLOC, OUTLOC> lst = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, funLocFac, backtranslationTracker, transformer, originalIcfg, resultIcfg);
        this.processLocations(originalIcfg.getInitialNodes(), lst);
        lst.finish();
        return resultIcfg;
    }

    private void processLocations(Set<INLOC> init, TransformedIcfgBuilder<INLOC, OUTLOC> lst) {
        IcfgLocationIterator iter = new IcfgLocationIterator(init);
        ArrayList<Triple> rtrTransitions = new ArrayList<Triple>();
        while (iter.hasNext()) {
            IcfgLocation oldSource = iter.next();
            OUTLOC newSource = lst.createNewLocation(oldSource);
            for (IcfgEdge oldTransition : oldSource.getOutgoingEdges()) {
                OUTLOC newTarget = lst.createNewLocation((IcfgLocation)oldTransition.getTarget());
                if (oldTransition instanceof IIcfgReturnTransition) {
                    rtrTransitions.add(new Triple(newSource, newTarget, (Object)oldTransition));
                    continue;
                }
                lst.createNewTransition(newSource, newTarget, oldTransition);
            }
        }
        rtrTransitions.forEach(a -> {
            IcfgEdge icfgEdge = lst.createNewTransition((IcfgLocation)a.getFirst(), (IcfgLocation)a.getSecond(), (IcfgEdge)a.getThird());
        });
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }
}

