/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class IcfgTransformerSequence<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final IIcfg<OUTLOC> mResultIcfg;
    private final String mIdentifier;

    public IcfgTransformerSequence(ILogger logger, IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFacFirst, ILocationFactory<OUTLOC, OUTLOC> funLocFacRest, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier, List<ITransformulaTransformer> transformers) {
        this.mLogger = Objects.requireNonNull(logger);
        this.mIdentifier = newIcfgIdentifier;
        Iterator<ITransformulaTransformer> iter = Objects.requireNonNull(transformers).iterator();
        if (!iter.hasNext()) {
            throw new IllegalArgumentException("Cannot transform witout transformers");
        }
        ITransformulaTransformer first = iter.next();
        String ident = this.getIdentifier(iter, 1);
        BasicIcfg<OUTLOC> intermediateIcfg = IcfgTransformerSequence.transform(logger, originalIcfg, funLocFacFirst, backtranslationTracker, outLocationClass, ident, first);
        this.mResultIcfg = this.transformRest(intermediateIcfg, funLocFacRest, backtranslationTracker, outLocationClass, iter);
    }

    private BasicIcfg<OUTLOC> transformRest(BasicIcfg<OUTLOC> outIcfg, ILocationFactory<OUTLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, Iterator<ITransformulaTransformer> transformerIter) {
        BasicIcfg<OUTLOC> currentIcfg = outIcfg;
        int iteration = 1;
        while (transformerIter.hasNext()) {
            ITransformulaTransformer transformer = transformerIter.next();
            currentIcfg = IcfgTransformerSequence.transform(this.mLogger, currentIcfg, funLocFac, backtranslationTracker, outLocationClass, this.getIdentifier(transformerIter, ++iteration), transformer);
        }
        return currentIcfg;
    }

    private static <IN extends IcfgLocation, OUT extends IcfgLocation> BasicIcfg<OUT> transform(ILogger logger, IIcfg<IN> originalIcfg, ILocationFactory<IN, OUT> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUT> outLocationClass, String newIcfgIdentifier, ITransformulaTransformer transformer) {
        transformer.preprocessIcfg(originalIcfg);
        BasicIcfg resultIcfg = new BasicIcfg(newIcfgIdentifier, originalIcfg.getCfgSmtToolkit(), outLocationClass);
        TransformedIcfgBuilder<IN, OUT> lst = new TransformedIcfgBuilder<IN, OUT>(logger, funLocFac, backtranslationTracker, transformer, originalIcfg, resultIcfg);
        IcfgTransformerSequence.processLocations(originalIcfg.getInitialNodes(), lst);
        lst.finish();
        return resultIcfg;
    }

    private static <IN extends IcfgLocation, OUT extends IcfgLocation> void processLocations(Set<IN> init, TransformedIcfgBuilder<IN, OUT> lst) {
        ArrayDeque<IN> open = new ArrayDeque<IN>(init);
        HashSet<IcfgLocation> closed = new HashSet<IcfgLocation>();
        ArrayList<Triple> later = new ArrayList<Triple>();
        while (!open.isEmpty()) {
            IcfgLocation oldSource = (IcfgLocation)open.removeFirst();
            if (!closed.add(oldSource)) continue;
            OUT newSource = lst.createNewLocation(oldSource);
            for (IcfgEdge oldTransition : oldSource.getOutgoingEdges()) {
                IcfgLocation oldTarget = (IcfgLocation)oldTransition.getTarget();
                open.add(oldTarget);
                OUT newTarget = lst.createNewLocation(oldTarget);
                if (oldTransition instanceof IIcfgReturnTransition) {
                    later.add(new Triple(newSource, newTarget, (Object)oldTransition));
                    continue;
                }
                lst.createNewTransition(newSource, newTarget, oldTransition);
            }
        }
        later.forEach(a -> {
            IcfgEdge icfgEdge = lst.createNewTransition((IcfgLocation)a.getFirst(), (IcfgLocation)a.getSecond(), (IcfgEdge)a.getThird());
        });
    }

    private String getIdentifier(Iterator<ITransformulaTransformer> iter, int iteration) {
        if (iter.hasNext()) {
            return String.valueOf(this.mIdentifier) + "_" + iteration;
        }
        return this.mIdentifier;
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }
}

