/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.BvToIntTransformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationManager;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class LocalTransformer2
implements ITransformulaTransformer {
    private final ManagedScript mMgdScript;
    private final Function<Sort, Sort> mSortTranslation;
    private HashRelation<String, IProgramNonOldVar> mNewModifiableGlobals;
    private VariableTranslation mVarTrans;
    private IIcfgSymbolTable mNewSymbolTable;
    private final TranslationConstrainer.ConstraintsForBitwiseOperations mCfbo;

    public LocalTransformer2(ManagedScript managedScript, TranslationConstrainer.ConstraintsForBitwiseOperations cfbo) {
        this.mMgdScript = Objects.requireNonNull(managedScript);
        this.mSortTranslation = x -> BvToIntTransformation.bvToIntSort(this.mMgdScript, x);
        this.mCfbo = cfbo;
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> oldEdge, UnmodifiableTransFormula tf) {
        if (!tf.getBranchEncoders().isEmpty()) {
            throw new UnsupportedOperationException("Branch encoders");
        }
        HashMap<Term, Term> translationMap = new HashMap<Term, Term>(this.mVarTrans.getIProgramConstTermMap());
        HashMap<IProgramVar, TermVariable> inVars = new HashMap<IProgramVar, TermVariable>();
        HashMap<IProgramVar, TermVariable> outVars = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry entry : tf.getInVars().entrySet()) {
            IProgramVar newProgramVar = this.mVarTrans.translateProgramVar((IProgramVar)entry.getKey());
            boolean isInVarAndOutVar = entry.getValue() == tf.getOutVars().get(entry.getKey());
            String suffix = isInVarAndOutVar ? "InAndOut" : "In";
            TermVariable tv = this.mMgdScript.constructFreshTermVariable(String.valueOf(newProgramVar.getTermVariable().getName()) + suffix, newProgramVar.getSort());
            inVars.put(newProgramVar, tv);
            if (isInVarAndOutVar) {
                outVars.put(newProgramVar, tv);
            }
            translationMap.put((Term)tf.getInVars().get(entry.getKey()), (Term)tv);
        }
        for (Map.Entry entry : tf.getOutVars().entrySet()) {
            boolean isInVarAndOutVar;
            boolean bl = isInVarAndOutVar = entry.getValue() == tf.getInVars().get(entry.getKey());
            if (isInVarAndOutVar) continue;
            IProgramVar newProgramVar = this.mVarTrans.translateProgramVar((IProgramVar)entry.getKey());
            TermVariable tv = this.mMgdScript.constructFreshTermVariable(String.valueOf(newProgramVar.getTermVariable().getName()) + "Out", newProgramVar.getSort());
            outVars.put(newProgramVar, tv);
            translationMap.put((Term)tf.getOutVars().get(entry.getKey()), (Term)tv);
        }
        Set newProgramConstants = tf.getNonTheoryConsts().isEmpty() ? null : tf.getNonTheoryConsts().stream().map(x -> this.mVarTrans.translateProgramConst((IProgramConst)x)).collect(Collectors.toSet());
        TransFormulaBuilder tfb = new TransFormulaBuilder(inVars, outVars, tf.getNonTheoryConsts().isEmpty(), newProgramConstants, true, null, false);
        for (TermVariable auxVar : tf.getAuxVars()) {
            TermVariable newAuxVar = this.mMgdScript.constructFreshTermVariable(String.valueOf(auxVar.getName()) + "Int", this.mSortTranslation.apply(auxVar.getSort()));
            translationMap.put((Term)auxVar, (Term)newAuxVar);
            tfb.addAuxVar(newAuxVar);
        }
        Term term = tf.getFormula();
        Triple<Term, Set<TermVariable>, Boolean> translated = this.translateTerm(this.mMgdScript, translationMap, term);
        for (TermVariable newAuxVar : (Set)translated.getSecond()) {
            tfb.addAuxVar(newAuxVar);
        }
        tfb.setFormula((Term)translated.getFirst());
        tfb.setInfeasibility(tf.isInfeasible());
        UnmodifiableTransFormula resultTf = tfb.finishConstruction(this.mMgdScript);
        return new ITransformulaTransformer.TransformulaTransformationResult(resultTf, (Boolean)translated.getThird());
    }

    private Triple<Term, Set<TermVariable>, Boolean> translateTerm(ManagedScript mgdScript, Map<Term, Term> translationMap, Term term) {
        TranslationManager translationManager = new TranslationManager(mgdScript, this.mCfbo);
        translationManager.setReplacementVarMaps(new LinkedHashMap<Term, Term>(translationMap));
        Triple translated = translationManager.translateBvtoInt(term);
        return translated;
    }

    @Override
    public ITransformulaTransformer.AxiomTransformationResult transform(IPredicate oldAxioms) {
        Triple<Term, Set<TermVariable>, Boolean> result = this.translateTerm(this.mMgdScript, new HashMap<Term, Term>(this.mVarTrans.getIProgramConstTermMap()), oldAxioms.getFormula());
        Term withoutAuxVars = SmtUtils.quantifier((Script)this.mMgdScript.getScript(), (int)0, (Collection)((Collection)result.getSecond()), (Term)((Term)result.getFirst()));
        BasicPredicate transformedAxiom = new BasicPredicate(0, new String[0], withoutAuxVars, Collections.emptySet(), withoutAuxVars);
        boolean isOverappoximation = (Boolean)result.getThird();
        return new ITransformulaTransformer.AxiomTransformationResult((IPredicate)transformedAxiom, isOverappoximation);
    }

    @Override
    public String getName() {
        return "BvToInt";
    }

    @Override
    public IIcfgSymbolTable getNewIcfgSymbolTable() {
        return this.mNewSymbolTable;
    }

    @Override
    public void preprocessIcfg(IIcfg<?> icfg) {
        CfgSmtToolkit csToolkit = icfg.getCfgSmtToolkit();
        this.mVarTrans = new VariableTranslation("Int");
        this.mNewModifiableGlobals = LocalTransformer2.constructNewProc2Globals((HashRelation<String, IProgramNonOldVar>)csToolkit.getModifiableGlobalsTable().getProcToGlobals(), this.mMgdScript, this.mMgdScript, this.mVarTrans);
        this.mNewSymbolTable = LocalTransformer2.constructNewSymbolTable(csToolkit.getSymbolTable(), csToolkit.getProcedures(), this.mVarTrans);
    }

    private CfgSmtToolkit constructNewCfgSmtToolkit(CfgSmtToolkit csToolkit, ManagedScript oldMgdScript, ManagedScript newMgdScript) {
        VariableTranslation varTrans = new VariableTranslation("Int");
        HashRelation<String, IProgramNonOldVar> proc2globals = LocalTransformer2.constructNewProc2Globals((HashRelation<String, IProgramNonOldVar>)csToolkit.getModifiableGlobalsTable().getProcToGlobals(), oldMgdScript, newMgdScript, varTrans);
        ModifiableGlobalsTable modifiableGlobalsTable = new ModifiableGlobalsTable(proc2globals);
        IIcfgSymbolTable symbolTable = LocalTransformer2.constructNewSymbolTable(csToolkit.getSymbolTable(), csToolkit.getProcedures(), varTrans);
        Map<String, List<ILocalProgramVar>> inParams = LocalTransformer2.constructNewParams(csToolkit.getInParams(), varTrans);
        Map<String, List<ILocalProgramVar>> outParams = LocalTransformer2.constructNewParams(csToolkit.getOutParams(), varTrans);
        SmtFunctionsAndAxioms smtFunctionsAndAxioms = null;
        return new CfgSmtToolkit(modifiableGlobalsTable, newMgdScript, symbolTable, csToolkit.getProcedures(), inParams, outParams, csToolkit.getIcfgEdgeFactory(), csToolkit.getConcurrencyInformation(), smtFunctionsAndAxioms);
    }

    private static Map<String, List<ILocalProgramVar>> constructNewParams(Map<String, List<ILocalProgramVar>> inParams, VariableTranslation variableTranslation) {
        HashMap<String, List<ILocalProgramVar>> result = new HashMap<String, List<ILocalProgramVar>>();
        for (Map.Entry<String, List<ILocalProgramVar>> entry : inParams.entrySet()) {
            List newList = entry.getValue().stream().map(x -> variableTranslation.getOrConstruct((ILocalProgramVar)x)).collect(Collectors.toList());
            result.put(entry.getKey(), newList);
        }
        return result;
    }

    private static IIcfgSymbolTable constructNewSymbolTable(IIcfgSymbolTable symbolTable, Set<String> procedures, VariableTranslation varTrans) {
        DefaultIcfgSymbolTable result = new DefaultIcfgSymbolTable();
        for (IProgramConst c : symbolTable.getConstants()) {
            result.add((IProgramVarOrConst)varTrans.getOrConstruct(c));
        }
        for (IProgramNonOldVar g : symbolTable.getGlobals()) {
            result.add((IProgramVarOrConst)varTrans.getOrConstruct(g));
        }
        for (String proc : procedures) {
            for (ILocalProgramVar l : symbolTable.getLocals(proc)) {
                result.add((IProgramVarOrConst)varTrans.getOrConstruct(l));
            }
        }
        return result;
    }

    private static HashRelation<String, IProgramNonOldVar> constructNewProc2Globals(HashRelation<String, IProgramNonOldVar> procToGlobals, ManagedScript oldMgdScript, ManagedScript newMgdScript, VariableTranslation variableTranslation) {
        HashRelation result = new HashRelation();
        for (Map.Entry entry : procToGlobals.entrySet()) {
            for (IProgramNonOldVar old : (HashSet)entry.getValue()) {
                IProgramNonOldVar newVar = variableTranslation.getOrConstruct(old);
                result.addPair((Object)((String)entry.getKey()), (Object)newVar);
            }
        }
        return result;
    }

    @Override
    public HashRelation<String, IProgramNonOldVar> getNewModifiedGlobals() {
        return this.mNewModifiableGlobals;
    }

    public Map<Term, Term> getBacktranslationMap() {
        return this.mVarTrans.getBacktranslationMap();
    }

    public class VariableTranslation {
        private final String mVarSuffix;
        private final ConstructionCache<ILocalProgramVar, ILocalProgramVar> mILocalProgramVarCC;
        private final ConstructionCache<IProgramNonOldVar, IProgramNonOldVar> mIProgramNonOldVarCC;
        private final ConstructionCache<IProgramConst, IProgramConst> mIProgramConstCC;
        private final Map<Term, Term> mBacktranslation;

        public VariableTranslation(String varSuffix) {
            this.mVarSuffix = varSuffix;
            this.mBacktranslation = new HashMap<Term, Term>();
            this.mILocalProgramVarCC = new ConstructionCache((ConstructionCache.IValueConstruction)new ConstructionCache.IValueConstruction<ILocalProgramVar, ILocalProgramVar>(){

                public ILocalProgramVar constructValue(ILocalProgramVar oldPv) {
                    ((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mMgdScript.lock((Object)this);
                    String newIdentifier = oldPv + VariableTranslation.this.mVarSuffix;
                    Sort newSort = ((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mSortTranslation.apply(oldPv.getSort());
                    ILocalProgramVar newPv = ProgramVarUtils.constructLocalProgramVar((String)newIdentifier, (String)oldPv.getProcedure(), (Sort)newSort, (ManagedScript)((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mMgdScript, (Object)this);
                    ((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mMgdScript.unlock((Object)this);
                    VariableTranslation.this.mBacktranslation.put(newPv.getTerm(), oldPv.getTerm());
                    return newPv;
                }
            });
            this.mIProgramNonOldVarCC = new ConstructionCache((ConstructionCache.IValueConstruction)new ConstructionCache.IValueConstruction<IProgramNonOldVar, IProgramNonOldVar>(){

                public IProgramNonOldVar constructValue(IProgramNonOldVar oldPv) {
                    ((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mMgdScript.lock((Object)this);
                    String newIdentifier = oldPv + VariableTranslation.this.mVarSuffix;
                    Sort newSort = ((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mSortTranslation.apply(oldPv.getSort());
                    ProgramNonOldVar newPv = ProgramVarUtils.constructGlobalProgramVarPair((String)newIdentifier, (Sort)newSort, (ManagedScript)((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mMgdScript, (Object)this);
                    ((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mMgdScript.unlock((Object)this);
                    VariableTranslation.this.mBacktranslation.put(newPv.getTerm(), oldPv.getTerm());
                    VariableTranslation.this.mBacktranslation.put(newPv.getOldVar().getTerm(), oldPv.getOldVar().getTerm());
                    return newPv;
                }
            });
            this.mIProgramConstCC = new ConstructionCache((ConstructionCache.IValueConstruction)new ConstructionCache.IValueConstruction<IProgramConst, IProgramConst>(){

                public IProgramConst constructValue(IProgramConst oldPv) {
                    String newIdentifier = String.valueOf(oldPv.getIdentifier()) + VariableTranslation.this.mVarSuffix;
                    Sort newSort = ((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mSortTranslation.apply(oldPv.getSort());
                    ((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mMgdScript.declareFun(null, newIdentifier, new Sort[0], newSort);
                    ApplicationTerm newSmtConstant = (ApplicationTerm)((VariableTranslation)VariableTranslation.this).LocalTransformer2.this.mMgdScript.term(null, newIdentifier, new Term[0]);
                    VariableTranslation.this.mBacktranslation.put((Term)newSmtConstant, (Term)oldPv.getDefaultConstant());
                    return new ProgramConst(newIdentifier, newSmtConstant, false);
                }
            });
        }

        public ILocalProgramVar getOrConstruct(ILocalProgramVar key) {
            return (ILocalProgramVar)this.mILocalProgramVarCC.getOrConstruct((Object)key);
        }

        public IProgramNonOldVar getOrConstruct(IProgramNonOldVar key) {
            return (IProgramNonOldVar)this.mIProgramNonOldVarCC.getOrConstruct((Object)key);
        }

        public IProgramOldVar getOrConstruct(IProgramOldVar key) {
            return ((IProgramNonOldVar)this.mIProgramNonOldVarCC.getOrConstruct((Object)key.getNonOldVar())).getOldVar();
        }

        public IProgramConst getOrConstruct(IProgramConst key) {
            return (IProgramConst)this.mIProgramConstCC.getOrConstruct((Object)key);
        }

        public Map<ILocalProgramVar, ILocalProgramVar> getILocalProgramVarMap() {
            return Collections.unmodifiableMap(this.mILocalProgramVarCC);
        }

        public Map<IProgramNonOldVar, IProgramNonOldVar> getIProgramNonOldVarMap() {
            return Collections.unmodifiableMap(this.mIProgramNonOldVarCC);
        }

        public Map<IProgramConst, IProgramConst> getIProgramConstMap() {
            return Collections.unmodifiableMap(this.mIProgramConstCC);
        }

        public Map<Term, Term> getIProgramConstTermMap() {
            return this.getIProgramConstMap().entrySet().stream().collect(Collectors.toMap(x -> ((IProgramConst)x.getKey()).getDefaultConstant(), x -> ((IProgramConst)x.getValue()).getDefaultConstant()));
        }

        public IProgramVar translateProgramVar(IProgramVar pv) {
            IProgramVar result;
            if (pv instanceof ILocalProgramVar) {
                result = (IProgramVar)this.getILocalProgramVarMap().get(pv);
            } else if (pv instanceof IProgramNonOldVar) {
                result = (IProgramVar)this.getIProgramNonOldVarMap().get(pv);
            } else if (pv instanceof IProgramOldVar) {
                result = this.getIProgramNonOldVarMap().get(((IProgramOldVar)pv).getNonOldVar()).getOldVar();
            } else {
                throw new UnsupportedOperationException(pv.getClass().getSimpleName());
            }
            return result;
        }

        public IProgramConst translateProgramConst(IProgramConst pc) {
            return this.getIProgramConstMap().get(pc);
        }

        public Map<Term, Term> getBacktranslationMap() {
            return Collections.unmodifiableMap(this.mBacktranslation);
        }
    }
}

