/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityAnalysisResultProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MapEliminationTransformer
implements ITransformulaTransformer {
    private final IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> mEqualityProvider;
    private final Map<TransFormula, ModifiableTransFormula> mTransFormulas;
    private final Map<TransFormula, IcfgLocation> mSourceLocations;
    private final Map<TransFormula, IcfgLocation> mTargetLocations;
    private MapEliminator mMapEliminator = null;
    private final ManagedScript mManagedScript;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final IIcfgSymbolTable mSymbolTable;
    private final MapEliminationSettings mSettings;

    public MapEliminationTransformer(IUltimateServiceProvider services, ILogger logger, ManagedScript managedScript, IIcfgSymbolTable symbolTable, ReplacementVarFactory replacementVarFactory, MapEliminationSettings settings, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> equalityProvider) {
        this.mServices = services;
        this.mLogger = logger;
        this.mSymbolTable = symbolTable;
        this.mSettings = settings;
        this.mEqualityProvider = equalityProvider;
        this.mTransFormulas = new HashMap<TransFormula, ModifiableTransFormula>();
        this.mSourceLocations = new HashMap<TransFormula, IcfgLocation>();
        this.mTargetLocations = new HashMap<TransFormula, IcfgLocation>();
        this.mManagedScript = Objects.requireNonNull(managedScript);
        this.mReplacementVarFactory = Objects.requireNonNull(replacementVarFactory);
    }

    @Override
    public void preprocessIcfg(IIcfg<?> icfg) {
        IcfgEdgeIterator iter = new IcfgEdgeIterator(icfg);
        while (iter.hasNext()) {
            IcfgEdge transition = iter.next();
            IcfgLocation sourceLocation = transition.getSource();
            IcfgLocation targetLocation = transition.getTarget();
            if (transition instanceof IIcfgReturnTransition) {
                IIcfgReturnTransition retTrans = (IIcfgReturnTransition)transition;
                this.saveTransformula((TransFormula)retTrans.getAssignmentOfReturn(), sourceLocation, targetLocation);
                this.saveTransformula((TransFormula)retTrans.getLocalVarsAssignmentOfCall(), sourceLocation, targetLocation);
                continue;
            }
            UnmodifiableTransFormula transformula = IcfgUtils.getTransformula((IIcfgTransition)transition);
            this.saveTransformula((TransFormula)transformula, sourceLocation, targetLocation);
        }
        this.mMapEliminator = new MapEliminator(this.mServices, this.mLogger, this.mManagedScript, this.mSymbolTable, this.mReplacementVarFactory, this.mTransFormulas.values(), this.mSettings);
        this.mEqualityProvider.preprocess(icfg);
    }

    private void saveTransformula(TransFormula transformula, IcfgLocation sourceLocation, IcfgLocation targetLocation) {
        ModifiableTransFormula modifiable = ModifiableTransFormulaUtils.buildTransFormula((TransFormula)transformula, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mManagedScript);
        this.mTransFormulas.put(transformula, modifiable);
        this.mSourceLocations.put(transformula, sourceLocation);
        this.mTargetLocations.put(transformula, targetLocation);
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> oldEdge, UnmodifiableTransFormula transformula) {
        ModifiableTransFormula modifiable = this.mTransFormulas.get(transformula);
        EqualityAnalysisResult equalityAnalysisBefore = this.mEqualityProvider.getAnalysisResult((Object)this.mSourceLocations.get(transformula), this.mMapEliminator.getDoubletons());
        EqualityAnalysisResult equalityAnalysisAfter = this.mEqualityProvider.getAnalysisResult((Object)this.mTargetLocations.get(transformula), this.mMapEliminator.getDoubletons());
        ModifiableTransFormula newTf = this.mMapEliminator.eliminateMaps(modifiable, equalityAnalysisBefore, equalityAnalysisAfter);
        return new ITransformulaTransformer.TransformulaTransformationResult(TransFormulaBuilder.constructCopy((ManagedScript)this.mManagedScript, (TransFormula)newTf, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap()), true);
    }

    @Override
    public String getName() {
        return MapEliminationTransformer.class.getSimpleName();
    }

    @Override
    public IIcfgSymbolTable getNewIcfgSymbolTable() {
        return this.mReplacementVarFactory.constructIIcfgSymbolTable();
    }

    @Override
    public HashRelation<String, IProgramNonOldVar> getNewModifiedGlobals() {
        return this.mReplacementVarFactory.constructModifiableGlobalsTable().getProcToGlobals();
    }
}

