/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.CopyingTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.TransitiveClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TransformedIcfgBuilder<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> {
    private final Map<INLOC, OUTLOC> mOldLoc2NewLoc;
    private final Map<IIcfgCallTransition<INLOC>, IcfgCallTransition> mOldCalls2NewCalls;
    private final Set<IProgramVarOrConst> mNewVars;
    private final HashRelation<String, IProgramNonOldVar> mNewModifiedGlobals;
    private final ILocationFactory<INLOC, OUTLOC> mLocationFactory;
    private final IcfgTransformationBacktranslator mBacktranslationTracker;
    private final ITransformulaTransformer mTransformer;
    private final IIcfg<INLOC> mOriginalIcfg;
    private final BasicIcfg<OUTLOC> mResultIcfg;
    private final IcfgEdgeFactory mEdgeFactory;
    private final Collection<IPredicate> mAdditionalAxioms;
    private boolean mIsFinished;
    private ILogger mLogger;

    public TransformedIcfgBuilder(ILogger logger, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, IIcfg<INLOC> originalIcfg, BasicIcfg<OUTLOC> resultIcfg) {
        this(logger, funLocFac, backtranslationTracker, new CopyingTransformulaTransformer(logger, originalIcfg.getCfgSmtToolkit().getManagedScript(), originalIcfg.getCfgSmtToolkit()), originalIcfg, resultIcfg, Collections.emptySet());
    }

    public TransformedIcfgBuilder(ILogger logger, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, ITransformulaTransformer transformer, IIcfg<INLOC> originalIcfg, BasicIcfg<OUTLOC> resultIcfg) {
        this(logger, funLocFac, backtranslationTracker, transformer, originalIcfg, resultIcfg, Collections.emptySet());
    }

    public TransformedIcfgBuilder(ILogger logger, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, ITransformulaTransformer transformer, IIcfg<INLOC> originalIcfg, BasicIcfg<OUTLOC> resultIcfg, Collection<IPredicate> additionalAxioms) {
        this.mLogger = Objects.requireNonNull(logger);
        this.mLocationFactory = Objects.requireNonNull(funLocFac);
        this.mBacktranslationTracker = Objects.requireNonNull(backtranslationTracker);
        this.mTransformer = Objects.requireNonNull(transformer);
        this.mOriginalIcfg = Objects.requireNonNull(originalIcfg);
        this.mResultIcfg = Objects.requireNonNull(resultIcfg);
        this.mOldLoc2NewLoc = new HashMap<INLOC, OUTLOC>();
        this.mOldCalls2NewCalls = new HashMap<IIcfgCallTransition<INLOC>, IcfgCallTransition>();
        this.mNewVars = new HashSet<IProgramVarOrConst>();
        this.mNewModifiedGlobals = new HashRelation();
        this.mIsFinished = false;
        this.mEdgeFactory = originalIcfg.getCfgSmtToolkit().getIcfgEdgeFactory();
        this.mAdditionalAxioms = Objects.requireNonNull(additionalAxioms);
    }

    public IcfgEdge createNewTransition(OUTLOC newSource, OUTLOC newTarget, IcfgEdge oldTransition) {
        IcfgInternalTransition newTransition;
        assert (!this.mIsFinished);
        if (oldTransition instanceof IIcfgInternalTransition) {
            if (oldTransition instanceof Summary && ((Summary)oldTransition).calledProcedureHasImplementation()) {
                return null;
            }
            newTransition = this.createNewLocalTransition((IcfgLocation)newSource, (IcfgLocation)newTarget, (IIcfgInternalTransition<INLOC>)((IIcfgInternalTransition)oldTransition));
        } else if (oldTransition instanceof IIcfgCallTransition) {
            newTransition = this.createNewCallTransition((IcfgLocation)newSource, (IcfgLocation)newTarget, (IIcfgCallTransition<INLOC>)((IIcfgCallTransition)oldTransition));
        } else if (oldTransition instanceof IIcfgReturnTransition) {
            newTransition = this.createNewReturnTransition((IcfgLocation)newSource, (IcfgLocation)newTarget, (IIcfgReturnTransition<INLOC, ?>)((IIcfgReturnTransition)oldTransition));
        } else {
            throw new IllegalArgumentException("Unknown edge type " + oldTransition.getClass().getSimpleName());
        }
        newSource.addOutgoing((IModifiableMultigraphEdge)newTransition);
        newTarget.addIncoming((IModifiableMultigraphEdge)newTransition);
        this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)newTransition, (IIcfgTransition<IcfgLocation>)oldTransition);
        return newTransition;
    }

    public IcfgEdge createNewTransitionWithNewProgramVars(OUTLOC newSource, OUTLOC newTarget, IcfgEdge oldTransition) {
        IcfgEdge newTransition = this.createNewTransition(newSource, newTarget, oldTransition);
        this.rememberNewVariables(newTransition.getTransformula(), newSource.getProcedure());
        return newTransition;
    }

    public boolean isCorrespondingCallContained(IIcfgReturnTransition<?, ?> oldTransition) {
        IIcfgCallTransition oldCorrespondingCall = oldTransition.getCorrespondingCall();
        IcfgCallTransition newCorrespondingCall = this.mOldCalls2NewCalls.get(oldCorrespondingCall);
        return newCorrespondingCall != null;
    }

    public IcfgInternalTransition createNewInternalTransition(OUTLOC source, OUTLOC target, UnmodifiableTransFormula transformula, boolean isOverapprox) {
        return this.createNewInternalTransition(source, target, transformula, null, isOverapprox);
    }

    public IcfgInternalTransition createNewInternalTransition(OUTLOC source, OUTLOC target, UnmodifiableTransFormula transformula, IPayload payload, boolean isOverapprox) {
        assert (!this.mIsFinished);
        IcfgInternalTransition localTrans = this.createNewLocalTransition((IcfgLocation)source, (IcfgLocation)target, new ITransformulaTransformer.TransformulaTransformationResult(transformula, isOverapprox), payload);
        source.addOutgoing((IModifiableMultigraphEdge)localTrans);
        target.addIncoming((IModifiableMultigraphEdge)localTrans);
        this.rememberNewVariables(transformula, source.getProcedure());
        return localTrans;
    }

    public OUTLOC createNewLocation(INLOC oldLoc) {
        boolean isInitial = this.mOriginalIcfg.getInitialNodes().contains(oldLoc);
        return this.createNewLocation(oldLoc, isInitial);
    }

    public OUTLOC createNewLocation(INLOC oldLoc, boolean isInitial) {
        assert (!this.mIsFinished);
        IcfgLocation alreadyCreated = (IcfgLocation)this.mOldLoc2NewLoc.get(oldLoc);
        if (alreadyCreated != null) {
            return (OUTLOC)alreadyCreated;
        }
        String proc = oldLoc.getProcedure();
        OUTLOC freshLoc = this.mLocationFactory.createLocation(oldLoc, oldLoc.getDebugIdentifier(), proc);
        Set errorLocs = (Set)this.mOriginalIcfg.getProcedureErrorNodes().get(proc);
        boolean isError = errorLocs != null && errorLocs.contains(oldLoc);
        boolean isProcEntry = oldLoc.equals(this.mOriginalIcfg.getProcedureEntryNodes().get(proc));
        boolean isProcExit = oldLoc.equals(this.mOriginalIcfg.getProcedureExitNodes().get(proc));
        boolean isLoopLocation = this.mOriginalIcfg.getLoopLocations().contains(oldLoc);
        this.mResultIcfg.addLocation(freshLoc, isInitial, isError, isProcEntry, isProcExit, isLoopLocation);
        this.mOldLoc2NewLoc.put(oldLoc, freshLoc);
        return freshLoc;
    }

    public boolean hasNewLoc(INLOC oldLoc) {
        return this.mOldLoc2NewLoc.get(oldLoc) == null;
    }

    public void finish() {
        ModifiableGlobalsTable newModifiedGlobals;
        IIcfgSymbolTable newSymbolTable;
        this.mIsFinished = true;
        CfgSmtToolkit oldToolkit = this.mOriginalIcfg.getCfgSmtToolkit();
        if (this.mNewVars.isEmpty()) {
            newSymbolTable = this.mTransformer.getNewIcfgSymbolTable();
            newModifiedGlobals = new ModifiableGlobalsTable(this.computeClosure(this.mTransformer.getNewModifiedGlobals(), this.computeCallGraph(), oldToolkit.getProcedures()));
        } else {
            DefaultIcfgSymbolTable result = new DefaultIcfgSymbolTable(this.mTransformer.getNewIcfgSymbolTable(), oldToolkit.getProcedures());
            this.mNewVars.forEach(arg_0 -> ((DefaultIcfgSymbolTable)result).add(arg_0));
            newSymbolTable = result;
            HashRelation modGlob = new HashRelation((AbstractRelation)oldToolkit.getModifiableGlobalsTable().getProcToGlobals());
            this.mNewModifiedGlobals.forEach(en -> {
                boolean bl = modGlob.addPair((Object)((String)en.getKey()), (Object)((IProgramNonOldVar)en.getValue()));
            });
            newModifiedGlobals = new ModifiableGlobalsTable(this.computeClosure((HashRelation<String, IProgramNonOldVar>)modGlob, this.computeCallGraph(), oldToolkit.getProcedures()));
        }
        SmtFunctionsAndAxioms transformedSymbols = this.transformSmtFunctionsAndAxioms(oldToolkit.getSmtFunctionsAndAxioms());
        CfgSmtToolkit csToolkit = new CfgSmtToolkit(newModifiedGlobals, oldToolkit.getManagedScript(), newSymbolTable, oldToolkit.getProcedures(), oldToolkit.getInParams(), oldToolkit.getOutParams(), oldToolkit.getIcfgEdgeFactory(), oldToolkit.getConcurrencyInformation(), transformedSymbols);
        this.mResultIcfg.setCfgSmtToolkit(csToolkit);
    }

    private void rememberNewVariables(UnmodifiableTransFormula transformula, String procedure) {
        transformula.getInVars().entrySet().stream().map(Map.Entry::getKey).filter(a -> !this.oldSymbolTableContains((IProgramVar)a)).forEach(this.mNewVars::add);
        Iterator iter = transformula.getOutVars().entrySet().stream().map(Map.Entry::getKey).filter(a -> !this.oldSymbolTableContains((IProgramVar)a)).iterator();
        while (iter.hasNext()) {
            IProgramVarOrConst var = (IProgramVarOrConst)iter.next();
            this.mNewVars.add(var);
            if (!(var instanceof IProgramNonOldVar) || !transformula.getAssignedVars().contains(var)) continue;
            this.mNewModifiedGlobals.addPair((Object)procedure, (Object)((IProgramNonOldVar)var));
        }
        HashSet unknownConsts = new HashSet(transformula.getNonTheoryConsts());
        unknownConsts.removeAll(this.mOriginalIcfg.getCfgSmtToolkit().getSymbolTable().getConstants());
        this.mNewVars.addAll(unknownConsts);
    }

    private boolean oldSymbolTableContains(IProgramVar invar) {
        if (invar instanceof IProgramOldVar) {
            return true;
        }
        IIcfgSymbolTable symbolTable = this.mOriginalIcfg.getCfgSmtToolkit().getSymbolTable();
        if (invar.getProcedure() == null) {
            return symbolTable.getGlobals().contains(invar);
        }
        return symbolTable.getLocals(invar.getProcedure()).contains(invar);
    }

    private HashRelation<String, IProgramNonOldVar> computeClosure(HashRelation<String, IProgramNonOldVar> newModifiedGlobals, HashRelation<String, String> callGraph, Set<String> allProcedures) {
        assert (this.mIsFinished);
        HashRelation revertedCallGraph = new HashRelation();
        for (Map.Entry en : callGraph) {
            revertedCallGraph.addPair((Object)((String)en.getValue()), (Object)((String)en.getKey()));
        }
        SccComputation.ISuccessorProvider successorProvider = node -> revertedCallGraph.getImage(node).iterator();
        Function<String, Set> procToModGlobals = arg_0 -> newModifiedGlobals.getImage(arg_0);
        HashRelation result = new HashRelation();
        Map closed = TransitiveClosure.computeClosure((ILogger)this.mLogger, allProcedures, procToModGlobals, (SccComputation.ISuccessorProvider)successorProvider);
        for (Map.Entry en : closed.entrySet()) {
            for (IProgramNonOldVar pv : (Set)en.getValue()) {
                result.addPair((Object)((String)en.getKey()), (Object)pv);
            }
        }
        return result;
    }

    private HashRelation<String, String> computeCallGraph() {
        assert (this.mIsFinished);
        HashRelation result = new HashRelation();
        for (Map.Entry en : this.mResultIcfg.getProcedureEntryNodes().entrySet()) {
            for (IcfgEdge callEdge : ((IcfgLocation)en.getValue()).getIncomingEdges()) {
                if (!(callEdge instanceof IcfgCallTransition)) continue;
                result.addPair((Object)callEdge.getPrecedingProcedure(), (Object)callEdge.getSucceedingProcedure());
            }
        }
        return result;
    }

    private IcfgReturnTransition createNewReturnTransition(IcfgLocation source, IcfgLocation target, IIcfgReturnTransition<INLOC, ?> oldTransition) {
        IIcfgCallTransition oldCorrespondingCall = oldTransition.getCorrespondingCall();
        IcfgCallTransition newCorrespondingCall = this.mOldCalls2NewCalls.get(oldCorrespondingCall);
        assert (newCorrespondingCall != null) : "The Icfg has been traversed out of order (found return before having found the corresponding call)";
        ITransformulaTransformer.TransformulaTransformationResult retAssign = this.mTransformer.transform((IIcfgTransition<? extends IcfgLocation>)oldTransition, oldTransition.getAssignmentOfReturn());
        IcfgReturnTransition newTrans = this.mEdgeFactory.createReturnTransition(source, target, (IIcfgCallTransition)newCorrespondingCall, TransformedIcfgBuilder.getPayloadIfAvailable(oldTransition), retAssign.getTransformula(), newCorrespondingCall.getTransformula());
        if (retAssign.isOverapproximation()) {
            this.annotateOverapprox((IElement)newTrans);
        }
        return newTrans;
    }

    private IcfgCallTransition createNewCallTransition(IcfgLocation source, IcfgLocation target, IIcfgCallTransition<INLOC> oldTransition) {
        ITransformulaTransformer.TransformulaTransformationResult unmodTf = this.mTransformer.transform((IIcfgTransition<? extends IcfgLocation>)oldTransition, oldTransition.getLocalVarsAssignment());
        IcfgCallTransition newTrans = this.mEdgeFactory.createCallTransition(source, target, TransformedIcfgBuilder.getPayloadIfAvailable(oldTransition), unmodTf.getTransformula());
        this.mOldCalls2NewCalls.put(oldTransition, newTrans);
        if (unmodTf.isOverapproximation()) {
            this.annotateOverapprox((IElement)newTrans);
        }
        return newTrans;
    }

    private IcfgInternalTransition createNewLocalTransition(IcfgLocation source, IcfgLocation target, IIcfgInternalTransition<INLOC> oldTransition) {
        ITransformulaTransformer.TransformulaTransformationResult unmodTf = this.mTransformer.transform((IIcfgTransition<? extends IcfgLocation>)oldTransition, oldTransition.getTransformula());
        IPayload payload = TransformedIcfgBuilder.getPayloadIfAvailable(oldTransition);
        return this.createNewLocalTransition(source, target, unmodTf, payload);
    }

    private IcfgInternalTransition createNewLocalTransition(IcfgLocation source, IcfgLocation target, ITransformulaTransformer.TransformulaTransformationResult unmodTf, IPayload payload) {
        IcfgInternalTransition newTrans = this.mEdgeFactory.createInternalTransition(source, target, payload, unmodTf.getTransformula());
        if (unmodTf.isOverapproximation()) {
            this.annotateOverapprox((IElement)newTrans);
        }
        return newTrans;
    }

    private void annotateOverapprox(IElement newTrans) {
        new Overapprox(this.mTransformer.getName(), null).annotate(newTrans);
    }

    private static IPayload getPayloadIfAvailable(IElement elem) {
        if (elem == null) {
            return null;
        }
        if (elem.hasPayload()) {
            return elem.getPayload();
        }
        return null;
    }

    private SmtFunctionsAndAxioms transformSmtFunctionsAndAxioms(SmtFunctionsAndAxioms smtSymbols) {
        ITransformulaTransformer.AxiomTransformationResult translationResult = this.mTransformer.transform(smtSymbols.getAxioms());
        if (translationResult.isOverapproximation()) {
            throw new UnsupportedOperationException("overapproximation of axioms is not yet supported");
        }
        ManagedScript script = this.mOriginalIcfg.getCfgSmtToolkit().getManagedScript();
        if (this.mAdditionalAxioms.isEmpty()) {
            return new SmtFunctionsAndAxioms(translationResult.getAxiom(), script);
        }
        List newAxiomsClosed = this.mAdditionalAxioms.stream().map(IPredicate::getClosedFormula).collect(Collectors.toList());
        newAxiomsClosed.add(translationResult.getAxiom().getClosedFormula());
        Term newAxioms = SmtUtils.and((Script)script.getScript(), newAxiomsClosed);
        return new SmtFunctionsAndAxioms(newAxioms, new String[0], script);
    }
}

