/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityLocUpdateInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class BuildStoreInfos
extends NonRecursive {
    private final EdgeInfo mEdge;
    private final Map<Term, ArrayGroup> mTermToArrayGroup;
    private final ManagedScript mMgdScript;
    private final Map<SubtreePosition, StoreInfo> mCollectedStoreInfos = new HashMap<SubtreePosition, StoreInfo>();
    private final MemlocArrayManager mLocArrayManager;
    private int mSiidCtr;
    private final Map<SubtreePosition, ArrayEqualityLocUpdateInfo> mPositionToLocArrayUpdateInfos = new HashMap<SubtreePosition, ArrayEqualityLocUpdateInfo>();
    private final Map<HeapSepProgramConst, StoreInfo> mLocLitToStoreInfo = new HashMap<HeapSepProgramConst, StoreInfo>();
    private final Set<IProgramVar> mDefinitelyUnconstrainedVariables;

    BuildStoreInfos(EdgeInfo edge, Map<Term, ArrayGroup> termToArrayGroup, ManagedScript mgdScript, MemlocArrayManager locArrayManager, int storeInfoCounter, Set<IProgramVar> definitelyUnconstrainedVariables) {
        this.mEdge = edge;
        this.mTermToArrayGroup = termToArrayGroup;
        this.mMgdScript = mgdScript;
        this.mLocArrayManager = locArrayManager;
        this.mSiidCtr = storeInfoCounter;
        this.mDefinitelyUnconstrainedVariables = definitelyUnconstrainedVariables;
    }

    public Map<HeapSepProgramConst, StoreInfo> getLocLitToStoreInfo() {
        return this.mLocLitToStoreInfo;
    }

    public Map<SubtreePosition, ArrayEqualityLocUpdateInfo> getLocArrayUpdateInfos() {
        return this.mPositionToLocArrayUpdateInfos;
    }

    public void buildStoreInfos() {
        this.run((NonRecursive.Walker)new BuildStoreInfoWalker(this.mEdge.getEdge().getTransformula().getFormula(), new SubtreePosition(), new ArrayIndex(), null, null));
    }

    public Map<SubtreePosition, ArrayEqualityLocUpdateInfo> getPositionToLocArrayUpdateInfos() {
        return this.mPositionToLocArrayUpdateInfos;
    }

    public int getStoreInfoCounter() {
        return this.mSiidCtr;
    }

    private int getNextStoreInfoId() {
        ++this.mSiidCtr;
        return this.mSiidCtr;
    }

    private HeapSepProgramConst constructLocationLiteral(EdgeInfo edgeInfo, int storeInfoId, int storeDim) {
        assert (storeInfoId > 0) : "use a long if this may overflow";
        this.mMgdScript.lock((Object)this);
        String locLitName = this.getLocationLitName(edgeInfo, storeInfoId);
        Sort sort = this.mLocArrayManager.getMemlocSort(storeDim);
        this.mMgdScript.declareFun((Object)this, locLitName, new Sort[0], sort);
        ApplicationTerm locLitTerm = (ApplicationTerm)this.mMgdScript.term((Object)this, locLitName, new Term[0]);
        this.mMgdScript.unlock((Object)this);
        return new HeapSepProgramConst(locLitTerm);
    }

    private String getLocationLitName(EdgeInfo location, int storeInfoId) {
        return "lit_" + location.getSourceLocation() + "_" + storeInfoId;
    }

    private class BuildStoreInfoWalker
    extends NonRecursive.TermWalker {
        private final ArrayIndex mEnclosingStoreIndices;
        private final SubtreePosition mSubTreePosition;
        private final SubtreePosition mRelativePosition;
        private final ArrayEqualityLocUpdateInfo mEnclosingEquality;

        public BuildStoreInfoWalker(Term term, SubtreePosition position, ArrayIndex enclosingStoreIndices, ArrayEqualityLocUpdateInfo enclosingEquality, SubtreePosition relativePosition) {
            super(term);
            this.mEnclosingStoreIndices = enclosingStoreIndices;
            this.mSubTreePosition = position;
            this.mEnclosingEquality = enclosingEquality;
            this.mRelativePosition = relativePosition;
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(term.getSubterm(), this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, this.mEnclosingEquality, this.mRelativePosition.append(0)));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            String funcName;
            switch (funcName = term.getFunction().getName()) {
                case "store": {
                    ArrayGroup arrayGroup = BuildStoreInfos.this.mTermToArrayGroup.get(SmtUtils.getBasicArrayTerm((Term)term));
                    if (arrayGroup == null) break;
                    int siId = BuildStoreInfos.this.getNextStoreInfoId();
                    int siDim = this.mEnclosingStoreIndices.size() + 1;
                    HeapSepProgramConst locLit = BuildStoreInfos.this.constructLocationLiteral(BuildStoreInfos.this.mEdge, siId, siDim);
                    StoreInfo si = StoreInfo.buildStoreInfo(siId, BuildStoreInfos.this.mEdge, this.mSubTreePosition, term, arrayGroup, this.mEnclosingStoreIndices, (IProgramConst)locLit, this.mEnclosingEquality, this.mRelativePosition);
                    BuildStoreInfos.this.mLocLitToStoreInfo.put(locLit, si);
                    BuildStoreInfos.this.mCollectedStoreInfos.put(this.mSubTreePosition, si);
                    walker.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(term.getParameters()[0], this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, this.mEnclosingEquality, this.mRelativePosition.append(0)));
                    ArrayIndex newEnclosingStoreIndicesForValue = this.mEnclosingStoreIndices.append(term.getParameters()[1]);
                    walker.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(term.getParameters()[2], this.mSubTreePosition.append(2), newEnclosingStoreIndicesForValue, this.mEnclosingEquality, this.mRelativePosition.append(2)));
                    break;
                }
                case "=": {
                    if (!term.getParameters()[0].getSort().isArraySort()) break;
                    assert (this.mEnclosingEquality == null);
                    ArrayEqualityLocUpdateInfo newEnclosingEquality = new ArrayEqualityLocUpdateInfo(BuildStoreInfos.this.mMgdScript, term, BuildStoreInfos.this.mEdge, BuildStoreInfos.this.mLocArrayManager, BuildStoreInfos.this.mDefinitelyUnconstrainedVariables);
                    walker.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(term.getParameters()[0], this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, newEnclosingEquality, new SubtreePosition().append(0)));
                    walker.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(term.getParameters()[1], this.mSubTreePosition.append(1), this.mEnclosingStoreIndices, newEnclosingEquality, new SubtreePosition().append(1)));
                    BuildStoreInfos.this.mPositionToLocArrayUpdateInfos.put(this.mSubTreePosition, newEnclosingEquality);
                    break;
                }
                default: {
                    if (!"Bool".equals(term.getSort().getName()) || !SmtUtils.allParamsAreBool((ApplicationTerm)term)) break;
                    assert (this.mEnclosingEquality == null);
                    int i = 0;
                    while (i < term.getParameters().length) {
                        Term param = term.getParameters()[i];
                        walker.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(param, this.mSubTreePosition.append(i), this.mEnclosingStoreIndices, null, null));
                        ++i;
                    }
                    break block4;
                }
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            walker.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(term.getSubTerm(), this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, this.mEnclosingEquality, this.mRelativePosition.append(0)));
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            assert (this.mEnclosingEquality == null);
            walker.enqueueWalker((NonRecursive.Walker)new BuildStoreInfoWalker(term.getSubformula(), this.mSubTreePosition.append(0), this.mEnclosingStoreIndices, null, null));
        }

        public void walk(NonRecursive walker, TermVariable term) {
        }

        public void walk(NonRecursive walker, MatchTerm term) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive walker, LambdaTerm term) {
            throw new UnsupportedOperationException();
        }
    }
}

