/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSepSettings;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class ComputeMemlocInitializingTransformula {
    private final ManagedScript mMgdScript;
    private Term mInitializingTerm;
    private Map<IProgramVar, TermVariable> mMemlocInVars;
    private Map<IProgramVar, TermVariable> mMemlocOutVars;
    private final HeapSepSettings mSettings;
    private final MemlocArrayManager mMemlocArrayManager;
    private final UnmodifiableTransFormula mResult;

    ComputeMemlocInitializingTransformula(MemlocArrayManager memlocArrayManager, IProgramVar validArray, HeapSepSettings settings, ManagedScript mgdScript) {
        this.mMgdScript = mgdScript;
        this.mSettings = Objects.requireNonNull(settings);
        this.mMemlocArrayManager = memlocArrayManager;
        this.computeInitializingTerm(Objects.requireNonNull(memlocArrayManager), Objects.requireNonNull(validArray));
        this.mResult = this.computeInitializingTransformula();
    }

    private void computeInitializingTerm(MemlocArrayManager memlocArrayManager, IProgramVar validArray) {
        this.mMemlocInVars = new HashMap<IProgramVar, TermVariable>();
        this.mMemlocOutVars = new HashMap<IProgramVar, TermVariable>();
        Set<IProgramNonOldVar> globalLocArrays = memlocArrayManager.getGlobalLocArrays();
        this.mMgdScript.lock((Object)this);
        ArrayList<Term> initializingEquations = new ArrayList<Term>();
        for (IProgramNonOldVar locArray : globalLocArrays) {
            TermVariable memlocArrayTv = this.mMgdScript.constructFreshTermVariable(locArray.getGloballyUniqueId(), locArray.getSort());
            Term initConstArray = this.mMemlocArrayManager.getInitConstArrayForGlobalLocArray(locArray, this);
            initializingEquations.add(SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)memlocArrayTv, (Term)initConstArray));
            this.mMemlocInVars.put((IProgramVar)locArray, memlocArrayTv);
            this.mMemlocOutVars.put((IProgramVar)locArray, memlocArrayTv);
        }
        this.mInitializingTerm = SmtUtils.and((Script)this.mMgdScript.getScript(), initializingEquations);
        this.mMgdScript.unlock((Object)this);
    }

    Map<IProgramVar, TermVariable> getMemlocInVars() {
        return this.mMemlocInVars;
    }

    Map<IProgramVar, TermVariable> getMemlocOutVars() {
        return this.mMemlocOutVars;
    }

    public UnmodifiableTransFormula computeInitializingTransformula() {
        Map<IProgramVar, TermVariable> newInVars = this.getMemlocInVars();
        Map<IProgramVar, TermVariable> newOutVars = this.getMemlocOutVars();
        HashSet<HeapSepProgramConst> newNonTheoryConstants = new HashSet<HeapSepProgramConst>(this.mMemlocArrayManager.getInitLocLits());
        TransFormulaBuilder newTfBuilder = new TransFormulaBuilder(newInVars, newOutVars, newNonTheoryConstants.isEmpty(), newNonTheoryConstants, true, null, true);
        Term newFormula = this.mInitializingTerm;
        newTfBuilder.setFormula(newFormula);
        newTfBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        UnmodifiableTransFormula newTransformula = newTfBuilder.finishConstruction(this.mMgdScript);
        return newTransformula;
    }

    public UnmodifiableTransFormula getResult() {
        return this.mResult;
    }
}

