/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.BuildStoreInfos;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityAllowStores;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityLocUpdateInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ComputeStoreInfosAndArrayGroups<LOC extends IcfgLocation> {
    private final Map<IProgramVarOrConst, ArrayGroup> mArrayToArrayGroup = new HashMap<IProgramVarOrConst, ArrayGroup>();
    private final NestedMap2<EdgeInfo, Term, ArrayGroup> mEdgeToTermToArrayGroup = new NestedMap2();
    private int mStoreInfoCounter;
    private final MemlocArrayManager mLocArrayManager;
    private final ManagedScript mMgdScript;
    private final NestedMap2<EdgeInfo, SubtreePosition, ArrayEqualityLocUpdateInfo> mEdgeToPositionToLocUpdateInfo = new NestedMap2();
    private final HashRelation<EdgeInfo, TermVariable> mEdgeToUnconstrainedVariables = new HashRelation();
    private final Map<HeapSepProgramConst, StoreInfo> mLocLitToStoreInfo = new HashMap<HeapSepProgramConst, StoreInfo>();
    private boolean mFrozen;
    private final Map<Term, HeapSepProgramConst> mLocLitTermToLocLitPvoc = new HashMap<Term, HeapSepProgramConst>();
    private final NestedMap2<EdgeInfo, SubtreePosition, StoreInfo> mEdgeToPositionToStoreInfo = new NestedMap2();
    private final List<IProgramVarOrConst> mHeapArrays;

    public ComputeStoreInfosAndArrayGroups(IIcfg<LOC> icfg, List<IProgramVarOrConst> heapArrays, ManagedScript mgdScript) {
        this.mMgdScript = mgdScript;
        this.mLocArrayManager = new MemlocArrayManager(mgdScript, this);
        this.mHeapArrays = heapArrays;
        this.run(icfg, heapArrays);
    }

    private void run(IIcfg<LOC> icfg, List<IProgramVarOrConst> heapArrays) throws AssertionError {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        UnionFind globalArrayPartition = new UnionFind();
        heapArrays.forEach(arg_0 -> ((UnionFind)globalArrayPartition).findAndConstructEquivalenceClassIfNeeded(arg_0));
        Map<EdgeInfo, UnionFind<Term>> edgeToPerEdgeArrayPartition = this.computeEdgeLevelArrayGroups(icfg, (UnionFind<IProgramVarOrConst>)globalArrayPartition);
        this.computeProgramLevelArrayGroups(heapArrays, (UnionFind<IProgramVarOrConst>)globalArrayPartition, edgeToPerEdgeArrayPartition);
        IcfgEdgeIterator it = new IcfgEdgeIterator(icfg);
        while (it.hasNext()) {
            IcfgEdge edge = it.next();
            EdgeInfo edgeInfo = new EdgeInfo(edge);
            Map termToArrayGroupForCurrentEdge = this.mEdgeToTermToArrayGroup.get((Object)edgeInfo);
            BuildStoreInfos bsi = new BuildStoreInfos(edgeInfo, termToArrayGroupForCurrentEdge, this.mMgdScript, this.mLocArrayManager, this.mStoreInfoCounter, this.collectDefinitelyUnconstrainedVariables(edgeInfo));
            bsi.buildStoreInfos();
            for (Map.Entry<SubtreePosition, ArrayEqualityLocUpdateInfo> en : bsi.getLocArrayUpdateInfos().entrySet()) {
                this.mEdgeToPositionToLocUpdateInfo.put((Object)edgeInfo, (Object)en.getKey(), (Object)en.getValue());
            }
            this.mLocLitToStoreInfo.putAll(bsi.getLocLitToStoreInfo());
            bsi.getLocLitToStoreInfo().keySet().forEach(hspc -> {
                HeapSepProgramConst heapSepProgramConst = this.mLocLitTermToLocLitPvoc.put(hspc.getTerm(), (HeapSepProgramConst)hspc);
            });
            bsi.getLocLitToStoreInfo().values().forEach(si -> {
                Object object = this.mEdgeToPositionToStoreInfo.put((Object)edgeInfo, (Object)si.getPosition(), si);
            });
            this.mStoreInfoCounter = bsi.getStoreInfoCounter();
        }
        this.mFrozen = true;
    }

    private Set<IProgramVar> collectDefinitelyUnconstrainedVariables(EdgeInfo edgeInfo) {
        HashSet<IProgramVar> result = new HashSet<IProgramVar>();
        for (IProgramVar invar : edgeInfo.getInVars().keySet()) {
            if (!this.isDefinitelyUnconstrained(invar, edgeInfo)) continue;
            result.add(invar);
        }
        return result;
    }

    private boolean isDefinitelyUnconstrained(IProgramVar var, EdgeInfo edgeInfo) {
        IcfgEdge currentEdge = edgeInfo.getEdge();
        do {
            List inEdges;
            if ((inEdges = ((IcfgLocation)currentEdge.getSource()).getIncomingEdges()).size() != 1) {
                return false;
            }
            currentEdge = (IcfgEdge)inEdges.get(0);
            if (!currentEdge.getTransformula().getAssignedVars().contains(var)) continue;
            return !currentEdge.getTransformula().getInVars().containsKey(var) && SmtUtils.isTrueLiteral((Term)currentEdge.getTransformula().getFormula());
        } while (!currentEdge.getTransformula().getOutVars().containsKey(var));
        return false;
    }

    private void computeProgramLevelArrayGroups(List<IProgramVarOrConst> heapArrays, UnionFind<IProgramVarOrConst> globalArrayPartition, Map<EdgeInfo, UnionFind<Term>> edgeToPerEdgeArrayPartition) throws AssertionError {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        HashSet<ArrayGroup> arrayGroups = new HashSet<ArrayGroup>();
        for (Set block : globalArrayPartition.getAllEquivalenceClasses()) {
            arrayGroups.add(new ArrayGroup(block));
        }
        for (ArrayGroup ag : arrayGroups) {
            if (DataStructureUtils.intersection(new HashSet<IProgramVarOrConst>(heapArrays), ag.getArrays()).isEmpty()) continue;
            for (IProgramVarOrConst a : ag.getArrays()) {
                this.mArrayToArrayGroup.put(a, ag);
            }
        }
        for (Map.Entry<EdgeInfo, UnionFind<Term>> en : edgeToPerEdgeArrayPartition.entrySet()) {
            EdgeInfo edgeInfo = en.getKey();
            for (Set block : en.getValue().getAllEquivalenceClasses()) {
                Optional<IProgramVarOrConst> opt = block.stream().map(t -> edgeInfo.getProgramVarOrConstForTerm((Term)t)).filter(pvoc -> pvoc != null).findAny();
                if (!opt.isPresent()) {
                    throw new AssertionError((Object)"see comment");
                }
                ArrayGroup arrayGroup = this.mArrayToArrayGroup.get(opt.get());
                for (Term t2 : block) {
                    this.mEdgeToTermToArrayGroup.put((Object)edgeInfo, (Object)t2, (Object)arrayGroup);
                }
            }
        }
    }

    private Map<EdgeInfo, UnionFind<Term>> computeEdgeLevelArrayGroups(IIcfg<LOC> icfg, UnionFind<IProgramVarOrConst> globalArrayPartition) {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        HashMap<EdgeInfo, UnionFind<Term>> edgeToPerEdgeArrayPartition = new HashMap<EdgeInfo, UnionFind<Term>>();
        IcfgEdgeIterator edgeIt = new IcfgEdgeIterator(icfg);
        while (edgeIt.hasNext()) {
            IcfgEdge edge = edgeIt.next();
            UnmodifiableTransFormula tf = edge.getTransformula();
            EdgeInfo edgeInfo = new EdgeInfo(edge);
            UnionFind perTfArrayPartition = new UnionFind();
            Set baseArrayTerms = SubTermFinder.find((Term)tf.getFormula(), SmtUtils::isBasicArrayTerm, (boolean)false);
            baseArrayTerms.forEach(arg_0 -> ((UnionFind)perTfArrayPartition).findAndConstructEquivalenceClassIfNeeded(arg_0));
            List<ArrayEqualityAllowStores> aeass = ArrayEqualityAllowStores.extractArrayEqualityAllowStores(tf.getFormula());
            for (ArrayEqualityAllowStores aeas : aeass) {
                Term lhsArrayTerm = SmtUtils.getBasicArrayTerm((Term)aeas.getLhsArray());
                Term rhsArrayTerm = SmtUtils.getBasicArrayTerm((Term)aeas.getRhsArray());
                perTfArrayPartition.union((Object)lhsArrayTerm, (Object)rhsArrayTerm);
            }
            edgeToPerEdgeArrayPartition.put(edgeInfo, (UnionFind<Term>)perTfArrayPartition);
            for (Set eqc : perTfArrayPartition.getAllEquivalenceClasses()) {
                Set<IProgramVarOrConst> eqcPvocs = eqc.stream().map(term -> TransFormulaUtils.getProgramVarOrConstForTerm((TransFormula)tf, (Term)term)).filter(pvoc -> pvoc != null).collect(Collectors.toSet());
                eqcPvocs.forEach(arg_0 -> globalArrayPartition.findAndConstructEquivalenceClassIfNeeded(arg_0));
                globalArrayPartition.union(eqcPvocs);
            }
            Set<TermVariable> unconstrainedVars = this.computeUnconstrainedVariables(tf, aeass);
            this.mEdgeToUnconstrainedVariables.addAllPairs((Object)edgeInfo, unconstrainedVars);
        }
        return edgeToPerEdgeArrayPartition;
    }

    private Set<TermVariable> computeUnconstrainedVariables(UnmodifiableTransFormula tf, List<ArrayEqualityAllowStores> aeass) {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        HashSet<TermVariable> constrainedVars = new HashSet<TermVariable>();
        HashSet<TermVariable> unconstrainedVars = new HashSet<TermVariable>(Arrays.asList(tf.getFormula().getFreeVars()));
        boolean goOn = true;
        while (goOn) {
            goOn = false;
            for (ArrayEqualityAllowStores aeas : aeass) {
                boolean neitherIsAStore;
                Term lhsArrayTerm = SmtUtils.getBasicArrayTerm((Term)aeas.getLhsArray());
                Term rhsArrayTerm = SmtUtils.getBasicArrayTerm((Term)aeas.getRhsArray());
                TermVariable lhsArrayTv = lhsArrayTerm instanceof TermVariable ? (TermVariable)lhsArrayTerm : null;
                TermVariable rhsArrayTv = rhsArrayTerm instanceof TermVariable ? (TermVariable)rhsArrayTerm : null;
                boolean lhsIsAStore = lhsArrayTerm != aeas.getLhsArray();
                boolean rhsIsAStore = rhsArrayTerm != aeas.getRhsArray();
                boolean bl = neitherIsAStore = !lhsIsAStore && !rhsIsAStore;
                if (lhsArrayTv == null && rhsArrayTv != null) {
                    goOn |= this.markAsConstrainedIfNecessary(constrainedVars, unconstrainedVars, rhsArrayTv);
                }
                if (rhsArrayTv == null && lhsArrayTv != null) {
                    goOn |= this.markAsConstrainedIfNecessary(constrainedVars, unconstrainedVars, lhsArrayTv);
                }
                if (tf.getInVars().containsValue(lhsArrayTv)) {
                    goOn |= this.markAsConstrainedIfNecessary(constrainedVars, unconstrainedVars, lhsArrayTv);
                }
                if (tf.getInVars().containsValue(rhsArrayTv)) {
                    goOn |= this.markAsConstrainedIfNecessary(constrainedVars, unconstrainedVars, rhsArrayTv);
                }
                if (neitherIsAStore && constrainedVars.contains(lhsArrayTv) && rhsArrayTv != null) {
                    goOn |= this.markAsConstrainedIfNecessary(constrainedVars, unconstrainedVars, rhsArrayTv);
                }
                if (neitherIsAStore && constrainedVars.contains(rhsArrayTv) && lhsArrayTv != null) {
                    goOn |= this.markAsConstrainedIfNecessary(constrainedVars, unconstrainedVars, lhsArrayTv);
                }
                if (lhsIsAStore && rhsArrayTv != null && unconstrainedVars.contains(rhsArrayTv)) {
                    goOn |= this.markAsConstrainedIfNecessary(constrainedVars, unconstrainedVars, rhsArrayTv);
                }
                if (!rhsIsAStore || lhsArrayTv == null || !unconstrainedVars.contains(lhsArrayTv)) continue;
                goOn |= this.markAsConstrainedIfNecessary(constrainedVars, unconstrainedVars, lhsArrayTv);
            }
        }
        return unconstrainedVars;
    }

    private boolean markAsConstrainedIfNecessary(Set<TermVariable> constrainedVars, Set<TermVariable> unconstrainedVars, TermVariable tv) {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        if (constrainedVars.contains(tv)) {
            assert (!unconstrainedVars.contains(tv));
            return false;
        }
        unconstrainedVars.remove(tv);
        constrainedVars.add(tv);
        return true;
    }

    public MemlocArrayManager getLocArrayManager() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return this.mLocArrayManager;
    }

    public NestedMap2<EdgeInfo, SubtreePosition, ArrayEqualityLocUpdateInfo> getEdgeToPositionToLocUpdateInfo() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return this.mEdgeToPositionToLocUpdateInfo;
    }

    public Map<HeapSepProgramConst, StoreInfo> getLocLitToStoreInfo() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return Collections.unmodifiableMap(this.mLocLitToStoreInfo);
    }

    public Set<HeapSepProgramConst> getLocLiterals() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return Collections.unmodifiableSet(this.mLocLitToStoreInfo.keySet());
    }

    public HashRelation<EdgeInfo, TermVariable> getEdgeToUnconstrainedVariables() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return this.mEdgeToUnconstrainedVariables;
    }

    public StoreInfo getStoreInfoForLocLitTerm(Term locLitTerm) {
        HeapSepProgramConst hspc = this.getLocLitPvocForLocLitTerm(locLitTerm);
        if (this.mLocArrayManager.isInitLocPvoc(hspc)) {
            return this.mLocArrayManager.getNoStoreInfo(hspc);
        }
        assert (hspc != null);
        return this.mLocLitToStoreInfo.get(hspc);
    }

    private HeapSepProgramConst getLocLitPvocForLocLitTerm(Term locLitTerm) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        HeapSepProgramConst initLocLitPvoc = this.mLocArrayManager.getInitLocLitPvocForLocLitTerm(locLitTerm);
        if (initLocLitPvoc != null) {
            return initLocLitPvoc;
        }
        return this.mLocLitTermToLocLitPvoc.get(locLitTerm);
    }

    public ArrayGroup getArrayGroupForTermInEdge(EdgeInfo edgeInfo, Term term) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        ArrayGroup result = (ArrayGroup)this.mEdgeToTermToArrayGroup.get((Object)edgeInfo, (Object)term);
        if (result == null) {
            throw new AssertionError();
        }
        return result;
    }

    public StoreInfo getStoreInfoForStoreTermAtPositionInEdge(EdgeInfo edgeInfo, SubtreePosition pos) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return (StoreInfo)this.mEdgeToPositionToStoreInfo.get((Object)edgeInfo, (Object)pos);
    }

    public boolean isArrayTermSubjectToSeparation(EdgeInfo edgeInfo, Term term) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        ArrayGroup ag = (ArrayGroup)this.mEdgeToTermToArrayGroup.get((Object)edgeInfo, (Object)term);
        return this.mArrayToArrayGroup.containsValue(ag);
    }

    public ArrayGroup getArrayGroupForArrayPvoc(IProgramVarOrConst pvoc) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        ArrayGroup result = this.mArrayToArrayGroup.get(pvoc);
        assert (result != null);
        return result;
    }

    public Collection<ArrayGroup> getArrayGroups() {
        return Collections.unmodifiableCollection(this.mArrayToArrayGroup.values());
    }

    public List<StoreInfo> getStoreInfosForDimensionAndArrayGroup(int dim, ArrayGroup arrayGroup) {
        return this.mLocLitToStoreInfo.values().stream().filter(si -> si.getDimension() == dim && si.getArrayGroup().equals(arrayGroup)).collect(Collectors.toList());
    }
}

