/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayCellAccess;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityAllowStores;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SelectInfo;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FindSelects {
    private final HashRelation<EdgeInfo, ArrayUpdate> mEdgeToCellUpdates;
    private final HashRelation<EdgeInfo, ArrayEqualityAllowStores> mEdgeToArrayRelations;
    private final ManagedScript mMgdScript;
    private final Set<SelectInfo> mSelectInfos;
    private Set<ArrayGroup> mArrayGroups;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final ILogger mLogger;
    private final HeapSeparatorBenchmark mStatistics;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;

    public FindSelects(ILogger logger, ManagedScript mgdScript, List<IProgramVarOrConst> heapArrays, HeapSeparatorBenchmark statistics, ComputeStoreInfosAndArrayGroups<?> csiag) {
        this.mMgdScript = mgdScript;
        this.mLogger = logger;
        this.mStatistics = statistics;
        this.mHeapArrays = heapArrays;
        this.mEdgeToCellUpdates = new HashRelation();
        this.mEdgeToArrayRelations = new HashRelation();
        this.mSelectInfos = new HashSet<SelectInfo>();
        this.mCsiag = csiag;
    }

    public void processEdge(IcfgEdge edge) {
        Set selectsInMdSelects;
        Set allSelects;
        UnmodifiableTransFormula tf = edge.getTransformula();
        EdgeInfo edgeInfo = new EdgeInfo(edge);
        List mdSelects = MultiDimensionalSelect.extractSelectShallow((Term)tf.getFormula(), (boolean)true);
        if (!mdSelects.isEmpty() && !(allSelects = new ApplicationTermFinder("select", false).findMatchingSubterms(tf.getFormula())).equals(selectsInMdSelects = mdSelects.stream().map(mds -> new ApplicationTermFinder("select", false).findMatchingSubterms(mds.getSelectTerm())).reduce((s1, s2) -> DataStructureUtils.union((Set)s1, (Set)s2)).get())) {
            throw new AssertionError();
        }
        for (MultiDimensionalSelect mds2 : mdSelects) {
            ArrayCellAccess aca = new ArrayCellAccess(mds2);
            if (!this.mCsiag.isArrayTermSubjectToSeparation(edgeInfo, aca.getArray())) continue;
            ArrayGroup ag = this.mCsiag.getArrayGroupForTermInEdge(edgeInfo, aca.getArray());
            SelectInfo si = new SelectInfo(aca, edgeInfo, ag, this.mMgdScript);
            this.mSelectInfos.add(si);
        }
    }

    public Set<SelectInfo> getSelectInfos() {
        if (this.mSelectInfos == null) {
            throw new IllegalStateException("call finish first");
        }
        return this.mSelectInfos;
    }

    public void finish() {
    }
}

