/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorStatistics;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.NoStoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SelectInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreLocationBlock;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityProvidingIntermediateState;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HeapPartitionManager {
    private final NestedMap2<SelectInfo, Integer, StoreLocationBlock> mSelectInfoToDimensionToLocationBlock;
    private final NestedMap2<ArrayGroup, Integer, UnionFind<StoreInfo>> mArrayGroupToDimensionToStoreIndexInfoPartition;
    NestedMap2<SelectInfo, Integer, StoreInfo> mSelectInfoToDimensionToToSampleStoreIndexInfo;
    private boolean mIsFinished = false;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final ILogger mLogger;
    private final NestedMap3<Set<StoreInfo>, ArrayGroup, Integer, StoreLocationBlock> mStoreIndexInfosToArrayGroupToDimensionToLocationBlock;
    private final HeapSeparatorBenchmark mStatistics;
    private final ManagedScript mMgdScript;
    private final MemlocArrayManager mMemLocArrayManager;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiaag;

    public HeapPartitionManager(ILogger logger, ManagedScript mgdScript, List<IProgramVarOrConst> heapArrays, HeapSeparatorBenchmark statistics, MemlocArrayManager memlocArrayManager, ComputeStoreInfosAndArrayGroups<?> csiaag) {
        this.mMgdScript = mgdScript;
        this.mLogger = logger;
        this.mHeapArrays = heapArrays;
        this.mStatistics = statistics;
        this.mMemLocArrayManager = memlocArrayManager;
        this.mCsiaag = csiaag;
        this.mArrayGroupToDimensionToStoreIndexInfoPartition = new NestedMap2();
        this.mSelectInfoToDimensionToLocationBlock = new NestedMap2();
        this.mSelectInfoToDimensionToToSampleStoreIndexInfo = new NestedMap2();
        this.mStoreIndexInfosToArrayGroupToDimensionToLocationBlock = new NestedMap3();
    }

    void processSelect(SelectInfo selectInfo, IEqualityProvidingIntermediateState eps) {
        if (eps.isBottom()) {
            this.mLogger.warn((Object)("equality analysis on preprocessed graph computed array read to be unreachable: " + selectInfo));
        }
        ArrayIndex selectIndex = selectInfo.getIndex();
        int dim = 1;
        while (dim <= selectIndex.size()) {
            ArrayIndex indexForCurrentDim = selectIndex.getFirst(dim);
            LocArrayInfo locArray = this.mMemLocArrayManager.getOrConstructLocArray(selectInfo.getEdgeInfo(), selectInfo.getArrayCellAccess().getArray(), dim, true);
            this.mMgdScript.lock((Object)this);
            Term locArraySelect = SmtUtils.multiDimensionalSelect((Script)this.mMgdScript.getScript(), (Term)locArray.getTerm(), (ArrayIndex)indexForCurrentDim);
            this.mMgdScript.unlock((Object)this);
            Set setConstraint = eps.getSetConstraintForExpression(locArraySelect);
            if (setConstraint == null) {
                this.mLogger.warn((Object)("No literal set constraint found for loc-array access " + locArraySelect + " at " + locArray.getEdge()));
                List<StoreInfo> allStoreInfos = this.mCsiaag.getStoreInfosForDimensionAndArrayGroup(dim, selectInfo.getArrayGroup());
                this.mergeBlocks(selectInfo, dim, allStoreInfos);
            } else {
                List<StoreInfo> setConstraintAsStoreInfos = setConstraint.stream().map(t -> this.mCsiaag.getStoreInfoForLocLitTerm((Term)t)).collect(Collectors.toList());
                this.mergeBlocks(selectInfo, dim, setConstraintAsStoreInfos);
            }
            ++dim;
        }
    }

    private void mergeBlocks(SelectInfo selectInfo, int dim, List<StoreInfo> setConstraintAsStoreInfos) {
        assert (setConstraintAsStoreInfos != null && !setConstraintAsStoreInfos.isEmpty());
        ArrayGroup arrayGroup = selectInfo.getArrayGroup();
        this.createPartitionAndBlockIfNecessary(selectInfo, dim, setConstraintAsStoreInfos.iterator().next());
        UnionFind partition = (UnionFind)this.mArrayGroupToDimensionToStoreIndexInfoPartition.get((Object)arrayGroup, (Object)dim);
        if (partition == null) {
            throw new AssertionError((Object)"should have been created in createBlockIfNecessary");
        }
        partition.findAndConstructEquivalenceClassIfNeeded((Object)setConstraintAsStoreInfos.get(0));
        int i = 1;
        while (i < setConstraintAsStoreInfos.size()) {
            StoreInfo si1 = setConstraintAsStoreInfos.get(i - 1);
            StoreInfo si2 = setConstraintAsStoreInfos.get(i);
            partition.findAndConstructEquivalenceClassIfNeeded((Object)si2);
            if (!(si1 instanceof NoStoreInfo) && !(si2 instanceof NoStoreInfo)) {
                partition.union((Object)si1, (Object)si2);
            }
            ++i;
        }
    }

    private void createPartitionAndBlockIfNecessary(SelectInfo selectInfo, int dim, StoreInfo sample) {
        ArrayGroup arrayGroup = selectInfo.getArrayGroup();
        assert (selectInfo.getArrayGroup().equals(sample.getArrayGroup()) || sample instanceof NoStoreInfo);
        UnionFind partition = (UnionFind)this.mArrayGroupToDimensionToStoreIndexInfoPartition.get((Object)arrayGroup, (Object)dim);
        if (partition == null) {
            partition = new UnionFind();
            this.mArrayGroupToDimensionToStoreIndexInfoPartition.put((Object)arrayGroup, (Object)dim, (Object)partition);
        }
        this.mSelectInfoToDimensionToToSampleStoreIndexInfo.put((Object)selectInfo, (Object)dim, (Object)sample);
        partition.findAndConstructEquivalenceClassIfNeeded((Object)sample);
    }

    public void finish() {
        for (Triple en : this.mSelectInfoToDimensionToToSampleStoreIndexInfo.entrySet()) {
            StoreInfo sampleSii = (StoreInfo)en.getThird();
            SelectInfo selectInfo = (SelectInfo)en.getFirst();
            Integer dim = (Integer)en.getSecond();
            ArrayGroup arrayGroup = selectInfo.getArrayGroup();
            UnionFind partition = (UnionFind)this.mArrayGroupToDimensionToStoreIndexInfoPartition.get((Object)arrayGroup, (Object)dim);
            ImmutableSet eqc = partition.getEquivalenceClassMembers((Object)sampleSii);
            StoreLocationBlock locationBlock = this.getOrConstructLocationBlock((Set<StoreInfo>)eqc, arrayGroup, dim);
            this.mSelectInfoToDimensionToLocationBlock.put((Object)selectInfo, (Object)dim, (Object)locationBlock);
            this.mLogger.debug((Object)("adding LocationBlock " + locationBlock));
            this.mLogger.debug((Object)("\t at dimension " + dim + " for " + selectInfo));
            this.mLogger.debug((Object)("\t write locations: " + locationBlock.getLocations()));
        }
        this.mLogger.info((Object)"partitioning result:");
        for (ArrayGroup arrayGroup : this.mCsiaag.getArrayGroups()) {
            this.mStatistics.registerArrayGroup(arrayGroup);
            this.mLogger.info((Object)("\t location blocks for array group " + arrayGroup));
            int dim = 1;
            while (dim <= arrayGroup.getDimensionality()) {
                UnionFind partition = (UnionFind)this.mArrayGroupToDimensionToStoreIndexInfoPartition.get((Object)arrayGroup, (Object)dim);
                int noWrites = partition == null ? 0 : partition.getAllElements().size();
                int noBlocks = partition == null ? 0 : partition.getAllEquivalenceClasses().size();
                this.mLogger.info((Object)("\t at dimension " + dim));
                this.mLogger.info((Object)("\t # array writes (possibly including 1 dummy write/NoStoreIndexInfo) : " + noWrites));
                this.mLogger.info((Object)("\t # location blocks :" + noBlocks));
                this.mStatistics.registerPerArrayAndDimensionInfo(arrayGroup, dim, HeapSeparatorStatistics.COUNT_ARRAY_WRITES, noWrites);
                this.mStatistics.registerPerArrayAndDimensionInfo(arrayGroup, dim, HeapSeparatorStatistics.COUNT_BLOCKS, noBlocks);
                this.mLogger.debug((Object)"\t location block contents:");
                if (this.mLogger.isDebugEnabled() && partition != null) {
                    for (Set eqc : partition.getAllEquivalenceClasses()) {
                        this.mLogger.debug((Object)("\t\t " + eqc));
                    }
                }
                ++dim;
            }
        }
        this.mIsFinished = true;
        assert (this.sanityCheck());
    }

    private StoreLocationBlock getOrConstructLocationBlock(Set<StoreInfo> eqc, ArrayGroup arrayGroup, Integer dim) {
        StoreLocationBlock result = (StoreLocationBlock)this.mStoreIndexInfosToArrayGroupToDimensionToLocationBlock.get(eqc, (Object)arrayGroup, (Object)dim);
        if (result == null) {
            result = new StoreLocationBlock(eqc, arrayGroup, dim);
            this.mStoreIndexInfosToArrayGroupToDimensionToLocationBlock.put(eqc, (Object)arrayGroup, (Object)dim, (Object)result);
            this.mLogger.debug((Object)("creating LocationBlock " + result));
            this.mLogger.debug((Object)("\t with contents " + result.getLocations()));
        }
        return result;
    }

    private boolean sanityCheck() {
        return true;
    }

    public NestedMap2<SelectInfo, Integer, StoreLocationBlock> getSelectInfoToDimensionToLocationBlock() {
        if (!this.mIsFinished) {
            throw new AssertionError();
        }
        return this.mSelectInfoToDimensionToLocationBlock;
    }

    public StoreLocationBlock getLocationBlock(SelectInfo si, Integer dim) {
        if (!this.mIsFinished) {
            throw new AssertionError();
        }
        return (StoreLocationBlock)this.mSelectInfoToDimensionToLocationBlock.get((Object)si, (Object)dim);
    }
}

