/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.AxiomsAdderIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeMemlocInitializingTransformula;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.FindSelects;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapPartitionManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSepSettings;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SelectInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.AddInitializingEdgesIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.MemlocArrayUpdaterTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PartitionProjectionTransitionTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.CongruenceClosureSmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityAnalysisResultProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityProvidingIntermediateState;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HeapSepIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private IIcfg<OUTLOC> mResultIcfg;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final ILogger mLogger;
    private final HeapSeparatorBenchmark mStatistics;
    private final ManagedScript mMgdScript;
    private final HeapSepSettings mSettings;
    private final IUltimateServiceProvider mServices;
    public static final String MEMORY = "#memory";

    public HeapSepIcfgTransformer(ILogger logger, IUltimateServiceProvider services, IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, ReplacementVarFactory replacementVarFactory, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> equalityProvider, IProgramNonOldVar validArray) {
        assert (logger != null);
        this.mStatistics = new HeapSeparatorBenchmark();
        this.mMgdScript = originalIcfg.getCfgSmtToolkit().getManagedScript();
        this.mLogger = logger;
        this.mServices = services;
        this.mSettings = new HeapSepSettings();
        this.mHeapArrays = originalIcfg.getCfgSmtToolkit().getSymbolTable().getGlobals().stream().filter(pvoc -> pvoc.getGloballyUniqueId().startsWith(MEMORY)).collect(Collectors.toList());
        this.mLogger.info((Object)"HeapSepIcfgTransformer: Starting heap partitioning");
        this.mLogger.info((Object)("To be partitioned heap arrays found " + this.mHeapArrays));
        this.computeResult(originalIcfg, funLocFac, replacementVarFactory, backtranslationTracker, outLocationClass, newIcfgIdentifier, equalityProvider, validArray);
    }

    private void computeResult(IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, ReplacementVarFactory replacementVarFactory, IcfgTransformationBacktranslator heapSepBacktranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> equalityProvider, IProgramNonOldVar validArray) {
        this.mSettings.isDumpPrograms();
        ILocationFactory<BoogieIcfgLocation, BoogieIcfgLocation> outToOutLocFac = HeapSepIcfgTransformer.createIcfgLocationToIcfgLocationFactory();
        ComputeStoreInfosAndArrayGroups<INLOC> csiiaag = new ComputeStoreInfosAndArrayGroups<INLOC>(originalIcfg, this.mHeapArrays, this.mMgdScript);
        MemlocArrayManager locArrayManager = csiiaag.getLocArrayManager();
        this.mLogger.info((Object)"Heap separator: starting loc-array-style preprocessing");
        HashMap<IcfgEdge, IcfgEdge> originalEdgeToTransformedEdgeMapping = new HashMap<IcfgEdge, IcfgEdge>();
        MemlocArrayUpdaterTransformulaTransformer mauit = new MemlocArrayUpdaterTransformulaTransformer(this.mServices, this.mLogger, originalIcfg.getCfgSmtToolkit(), locArrayManager, this.mHeapArrays, csiiaag.getEdgeToPositionToLocUpdateInfo());
        IcfgTransformationBacktranslator preprocBtt = new IcfgTransformationBacktranslator(IcfgEdge.class, Term.class, this.mLogger);
        IcfgTransformer<INLOC, OUTLOC> icgtf = new IcfgTransformer<INLOC, OUTLOC>(this.mLogger, originalIcfg, funLocFac, preprocBtt, outLocationClass, "icfg_with_locarrays", mauit);
        IIcfg<OUTLOC> icfgWithMemlocUpdates = icgtf.getResult();
        for (Map.Entry<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> entry : preprocBtt.getEdgeMapping().entrySet()) {
            originalEdgeToTransformedEdgeMapping.put((IcfgEdge)entry.getValue(), (IcfgEdge)entry.getKey());
        }
        locArrayManager.freeze();
        this.mLogger.info((Object)"finished MemlocArrayUpdater");
        ComputeMemlocInitializingTransformula mlit = new ComputeMemlocInitializingTransformula(locArrayManager, (IProgramVar)validArray, this.mSettings, this.mMgdScript);
        AddInitializingEdgesIcfgTransformer<BoogieIcfgLocation, BoogieIcfgLocation> initTf = new AddInitializingEdgesIcfgTransformer<BoogieIcfgLocation, BoogieIcfgLocation>(this.mLogger, icfgWithMemlocUpdates.getCfgSmtToolkit(), outToOutLocFac, heapSepBacktranslationTracker, outLocationClass, icfgWithMemlocUpdates, mlit.getResult(), "icfg_with_initialized_loc_arrays");
        IIcfg<BoogieIcfgLocation> icfgWMemlocInitialized = initTf.getResult();
        HashSet<HeapSepProgramConst> locLiterals = new HashSet<HeapSepProgramConst>();
        locLiterals.addAll(csiiaag.getLocLiterals());
        locLiterals.addAll(locArrayManager.getInitLocLits());
        equalityProvider.announceAdditionalLiterals(locLiterals);
        Set<Term> literalTerms = locLiterals.stream().map(pvoc -> pvoc.getTerm()).collect(Collectors.toSet());
        assert (this.mSettings.isAssertFreezeVarLitDisequalitiesIntoScript() != this.mSettings.isAddLiteralDisequalitiesAsAxioms()) : "exactly one solution for literals in script should be enabled";
        if (this.mSettings.isAssertFreezeVarLitDisequalitiesIntoScript()) {
            this.assertLiteralDisequalitiesIntoScript(literalTerms);
        }
        if (this.mSettings.isAddLiteralDisequalitiesAsAxioms()) {
            Term allLiteralDisequalities = SmtUtils.and((Script)this.mMgdScript.getScript(), (Collection)CongruenceClosureSmtUtils.createDisequalityTermsForNonTheoryLiterals((Script)this.mMgdScript.getScript(), literalTerms));
            icfgWMemlocInitialized = new AxiomsAdderIcfgTransformer<BoogieIcfgLocation, BoogieIcfgLocation>(this.mLogger, "icfg_with_memloc_updates_and_literal_axioms", outLocationClass, icfgWithMemlocUpdates, outToOutLocFac, heapSepBacktranslationTracker, allLiteralDisequalities).getResult();
        }
        IIcfg<BoogieIcfgLocation> preprocessedIcfg = icfgWMemlocInitialized;
        this.mLogger.info((Object)"finished preprocessing for the equality analysis");
        ArrayList<String> trackedArraySubstrings = new ArrayList<String>();
        trackedArraySubstrings.add("#loc");
        trackedArraySubstrings.add("valid");
        equalityProvider.setTrackedArrays(trackedArraySubstrings);
        equalityProvider.preprocess(preprocessedIcfg);
        this.mLogger.info((Object)"finished equality analysis");
        FindSelects findSelects = new FindSelects(this.mLogger, this.mMgdScript, this.mHeapArrays, this.mStatistics, csiiaag);
        new IcfgEdgeIterator(originalIcfg).forEachRemaining(edge -> findSelects.processEdge((IcfgEdge)edge));
        findSelects.finish();
        this.mLogger.info((Object)"Finished detection of select terms (\"array reads\")");
        HeapPartitionManager partitionManager = new HeapPartitionManager(this.mLogger, this.mMgdScript, this.mHeapArrays, this.mStatistics, locArrayManager, csiiaag);
        for (SelectInfo si : findSelects.getSelectInfos()) {
            IcfgEdge preprocessedEdge = (IcfgEdge)originalEdgeToTransformedEdgeMapping.get(si.getEdgeInfo().getEdge());
            partitionManager.processSelect(si, this.getEqualityProvidingIntermediateState(preprocessedEdge, equalityProvider));
        }
        partitionManager.finish();
        PartitionProjectionTransitionTransformer heapSeparatingTransformer = new PartitionProjectionTransitionTransformer(this.mLogger, partitionManager.getSelectInfoToDimensionToLocationBlock(), csiiaag, this.mHeapArrays, this.mStatistics, originalIcfg.getCfgSmtToolkit());
        IcfgTransformer<INLOC, OUTLOC> icfgtf = new IcfgTransformer<INLOC, OUTLOC>(this.mLogger, originalIcfg, funLocFac, heapSepBacktranslationTracker, outLocationClass, "memPartitionedIcfg", heapSeparatingTransformer);
        this.mResultIcfg = icfgtf.getResult();
    }

    public void assertLiteralDisequalitiesIntoScript(Set<Term> literalTerms) {
        this.mMgdScript.lock((Object)this);
        Term allLiteralDisequalities = SmtUtils.and((Script)this.mMgdScript.getScript(), (Collection)CongruenceClosureSmtUtils.createDisequalityTermsForNonTheoryLiterals((Script)this.mMgdScript.getScript(), literalTerms));
        this.mMgdScript.assertTerm((Object)this, allLiteralDisequalities);
        this.mMgdScript.unlock((Object)this);
    }

    private IEqualityProvidingIntermediateState getEqualityProvidingIntermediateState(IcfgEdge edge, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> equalityProvider) {
        return equalityProvider.getEqualityProvidingIntermediateState(edge);
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }

    public HeapSeparatorBenchmark getStatistics() {
        return this.mStatistics;
    }

    private static ILocationFactory<BoogieIcfgLocation, BoogieIcfgLocation> createIcfgLocationToIcfgLocationFactory() {
        return (oldLocation, debugIdentifier, procedure) -> {
            BoogieIcfgLocation rtr = new BoogieIcfgLocation(debugIdentifier, procedure, oldLocation.isErrorLocation(), oldLocation.getBoogieASTNode());
            ModelUtils.copyAnnotations((IElement)oldLocation, (IElement)rtr);
            return rtr;
        };
    }
}

