/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorStatistics;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.HashSet;
import java.util.Set;

public class HeapSeparatorBenchmark
extends BenchmarkWithCounters {
    private final Set<ArrayGroup> mHeapArrayGroups = new HashSet<ArrayGroup>();
    private final NestedMap3<ArrayGroup, Integer, HeapSeparatorStatistics, Number> mPerArrayAndDimensionInfo = new NestedMap3();
    private final NestedMap2<ArrayGroup, HeapSeparatorStatistics, Number> mPerArrayInfo = new NestedMap2();

    protected void generateColumnTitlesAndResults() {
        int n;
        if (this.mAlreadyGeneratedColumnTitlesAndResults) {
            return;
        }
        super.generateColumnTitlesAndResults();
        for (ArrayGroup heapArrayGroup : this.mHeapArrayGroups) {
            int dim = 0;
            while (dim < heapArrayGroup.getDimensionality()) {
                HeapSeparatorStatistics[] heapSeparatorStatisticsArray = HeapSeparatorStatistics.values();
                int n2 = heapSeparatorStatisticsArray.length;
                n = 0;
                while (n < n2) {
                    HeapSeparatorStatistics v = heapSeparatorStatisticsArray[n];
                    if (v == HeapSeparatorStatistics.COUNT_BLOCKS || v == HeapSeparatorStatistics.COUNT_ARRAY_WRITES) {
                        this.mColumnTitles.add(String.valueOf(v.name()) + "_for_" + heapArrayGroup + "_at_dim_" + dim);
                        this.mResults.add((Number)this.mPerArrayAndDimensionInfo.get((Object)heapArrayGroup, (Object)dim, (Object)v));
                    }
                    ++n;
                }
                ++dim;
            }
        }
        for (ArrayGroup heapArrayGroup : this.mHeapArrayGroups) {
            HeapSeparatorStatistics[] heapSeparatorStatisticsArray = HeapSeparatorStatistics.values();
            n = heapSeparatorStatisticsArray.length;
            int n3 = 0;
            while (n3 < n) {
                HeapSeparatorStatistics v = heapSeparatorStatisticsArray[n3];
                if (v == HeapSeparatorStatistics.COUNT_ARRAY_READS) {
                    this.mColumnTitles.add(String.valueOf(v.name()) + " for " + heapArrayGroup);
                    this.mResults.add((Number)this.mPerArrayInfo.get((Object)heapArrayGroup, (Object)v));
                }
                ++n3;
            }
        }
    }

    void registerArrayGroup(ArrayGroup ag) {
        boolean newlyAdded = this.mHeapArrayGroups.add(ag);
        if (newlyAdded) {
            this.registerCounter(this.getNewArrayVarCounterName(ag));
        }
    }

    private String getNewArrayVarCounterName(ArrayGroup ag) {
        return String.valueOf(HeapSeparatorStatistics.COUNT_NEW_ARRAY_VARS.name()) + "_" + ag;
    }

    void registerPerArrayInfo(ArrayGroup ag, HeapSeparatorStatistics hss, Number value) {
        this.mPerArrayInfo.put((Object)ag, (Object)hss, (Object)value);
    }

    void registerPerArrayAndDimensionInfo(ArrayGroup ag, int dim, HeapSeparatorStatistics hss, Number value) {
        this.mPerArrayAndDimensionInfo.put((Object)ag, (Object)dim, (Object)hss, (Object)value);
    }

    public String toString() {
        this.generateColumnTitlesAndResults();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        int i = 0;
        while (i < this.mColumnTitles.size()) {
            sb.append(String.format("%-80s : %7d %n", this.mColumnTitles.get(i), this.mResults.get(i)));
            ++i;
        }
        return sb.toString();
    }

    public void incrementNewArrayVarCounter(ArrayGroup arrayGroup) {
        super.incrementCounter(this.getNewArrayVarCounterName(arrayGroup));
    }
}

