/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayReadInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.NoStoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MemlocArrayManager {
    private boolean mFrozen;
    public static final String LOC_ARRAY_PREFIX = "#loc";
    public static final String LOC_SORT_PREFIX = "#locsort";
    public static final String INITLOCLIT_PREFIX = "#initloclit";
    private final ManagedScript mMgdScript;
    private final Map<Integer, Sort> mDimToLocSort = new HashMap<Integer, Sort>();
    private final NestedMap3<EdgeInfo, Term, Integer, LocArrayInfo> mEdgeToArrayTermToDimToLocArray = new NestedMap3();
    private final NestedMap2<IProgramVarOrConst, Integer, IProgramVarOrConst> mArrayPvocToDimToLocArrayPvoc = new NestedMap2();
    private final Map<Sort, HeapSepProgramConst> mLocArraySortToInitLocLit = new HashMap<Sort, HeapSepProgramConst>();
    private final Set<IProgramNonOldVar> mGlobalLocArrays = new HashSet<IProgramNonOldVar>();
    private final Map<Term, HeapSepProgramConst> mInitLocLitTermToPvoc = new HashMap<Term, HeapSepProgramConst>();
    private final Map<HeapSepProgramConst, NoStoreInfo> mInitLocPvocToNoStoreInfo = new HashMap<HeapSepProgramConst, NoStoreInfo>();
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;
    private int mNoStoreInfoCounter = -1;

    public MemlocArrayManager(ManagedScript mgdScript, ComputeStoreInfosAndArrayGroups<?> computeStoreInfosAndArrayGroups) {
        this.mMgdScript = mgdScript;
        this.mFrozen = false;
        this.mCsiag = computeStoreInfosAndArrayGroups;
    }

    public Sort getMemlocSort(int dim) {
        Sort result = this.mDimToLocSort.get(dim);
        if (result == null) {
            String name = LOC_SORT_PREFIX + dim;
            this.mMgdScript.getScript().declareSort(name, 0);
            result = this.mMgdScript.getScript().sort(name, new Sort[0]);
            this.mDimToLocSort.put(dim, result);
        }
        return result;
    }

    public Set<HeapSepProgramConst> getInitLocLits() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return new HashSet<HeapSepProgramConst>(this.mLocArraySortToInitLocLit.values());
    }

    public LocArrayInfo getOrConstructLocArray(EdgeInfo edgeInfo, Term baseArrayTerm, int dim) {
        return this.getOrConstructLocArray(edgeInfo, baseArrayTerm, dim, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LocArrayInfo getOrConstructLocArray(EdgeInfo edgeInfo, Term baseArrayTerm, int dim, boolean calledFromProcessSelect) {
        LocArrayInfo result = (LocArrayInfo)this.mEdgeToArrayTermToDimToLocArray.get((Object)edgeInfo, (Object)baseArrayTerm, (Object)dim);
        if (result != null) return result;
        if (calledFromProcessSelect) {
            IProgramVarOrConst pvoc = edgeInfo.getProgramVarOrConstForTerm(baseArrayTerm);
            assert (edgeInfo.getOutVar(baseArrayTerm) == pvoc);
            assert (edgeInfo.getInVar(baseArrayTerm) == pvoc);
            assert (!edgeInfo.getEdge().getTransformula().getAssignedVars().contains(pvoc));
            Sort locArraySort = this.computeLocArraySort(baseArrayTerm.getSort(), dim);
            this.mMgdScript.lock((Object)this);
            IProgramVarOrConst locPvoc = this.getLocArrayPvocForArrayPvoc(pvoc, dim, locArraySort);
            this.mMgdScript.unlock((Object)this);
            result = new LocArrayReadInfo(edgeInfo, locPvoc, locPvoc.getTerm());
            this.mEdgeToArrayTermToDimToLocArray.put((Object)edgeInfo, (Object)baseArrayTerm, (Object)dim, (Object)result);
            return result;
        } else {
            TermVariable term;
            IProgramVarOrConst pvoc;
            assert (!this.mFrozen);
            this.mMgdScript.lock((Object)this);
            Sort locArraySort = this.computeLocArraySort(baseArrayTerm.getSort(), dim);
            if (!(baseArrayTerm instanceof TermVariable)) throw new UnsupportedOperationException("todo: deal with constants");
            IProgramVar invar = edgeInfo.getInVar(baseArrayTerm);
            IProgramVar outvar = edgeInfo.getOutVar(baseArrayTerm);
            boolean isAuxVar = edgeInfo.getAuxVars().contains(baseArrayTerm);
            if (invar != null) {
                pvoc = this.getLocArrayPvocForArrayPvoc((IProgramVarOrConst)invar, dim, locArraySort);
                term = this.mMgdScript.constructFreshTermVariable(this.sanitizeVarName(LOC_ARRAY_PREFIX + baseArrayTerm + "_" + dim), locArraySort);
            } else if (outvar != null) {
                pvoc = this.getLocArrayPvocForArrayPvoc((IProgramVarOrConst)outvar, dim, locArraySort);
                term = this.mMgdScript.constructFreshTermVariable(this.sanitizeVarName(LOC_ARRAY_PREFIX + baseArrayTerm + "_" + dim), locArraySort);
            } else {
                if (!isAuxVar) throw new AssertionError();
                pvoc = null;
                term = this.mMgdScript.constructFreshTermVariable(this.sanitizeVarName(LOC_ARRAY_PREFIX + baseArrayTerm + "_" + dim), locArraySort);
            }
            HeapSepProgramConst initLocLit = this.getOrConstructInitLocLitForLocArraySort(locArraySort, dim);
            result = new LocArrayInfo(edgeInfo, pvoc, (Term)term, this.computeInitConstantArrayForLocArray(initLocLit, locArraySort, this));
            this.mMgdScript.unlock((Object)this);
            this.mEdgeToArrayTermToDimToLocArray.put((Object)edgeInfo, (Object)baseArrayTerm, (Object)dim, (Object)result);
        }
        return result;
    }

    public Term getInitConstArrayForGlobalLocArray(IProgramNonOldVar pnov, Object lockOwner) {
        Sort locArraySort = pnov.getSort();
        int dim = new MultiDimensionalSort(locArraySort).getDimension();
        HeapSepProgramConst initLocLit = this.getOrConstructInitLocLitForLocArraySort(locArraySort, dim);
        return this.computeInitConstantArrayForLocArray(initLocLit, locArraySort, lockOwner);
    }

    public Set<IProgramNonOldVar> getGlobalLocArrays() {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        return Collections.unmodifiableSet(this.mGlobalLocArrays);
    }

    private HeapSepProgramConst getOrConstructInitLocLitForLocArraySort(Sort locArraySort, int dim) {
        assert (new MultiDimensionalSort(locArraySort).getDimension() == dim);
        HeapSepProgramConst result = this.mLocArraySortToInitLocLit.get(locArraySort);
        if (result == null) {
            assert (this.mMgdScript.isLockOwner((Object)this));
            String litName = INITLOCLIT_PREFIX + dim;
            this.mMgdScript.declareFun((Object)this, litName, new Sort[0], this.getMemlocSort(dim));
            ApplicationTerm locLitTerm = (ApplicationTerm)this.mMgdScript.term((Object)this, litName, new Term[0]);
            result = new HeapSepProgramConst(locLitTerm);
            this.mInitLocLitTermToPvoc.put((Term)locLitTerm, result);
            this.mLocArraySortToInitLocLit.put(locArraySort, result);
            this.mInitLocPvocToNoStoreInfo.put(result, new NoStoreInfo(this.mNoStoreInfoCounter--));
        }
        return result;
    }

    private IProgramVarOrConst getLocArrayPvocForArrayPvoc(IProgramVarOrConst pvoc, int dim, Sort locArraySort) {
        assert (this.mMgdScript.isLockOwner((Object)this)) : "locking before calling this, by convention (unclear if there are compelling arguments for the convention)";
        IProgramVarOrConst result = (IProgramVarOrConst)this.mArrayPvocToDimToLocArrayPvoc.get((Object)pvoc, (Object)dim);
        if (result == null) {
            if (pvoc instanceof IProgramNonOldVar) {
                result = ProgramVarUtils.constructGlobalProgramVarPair((String)this.sanitizeVarName("#loc_" + pvoc + "_" + locArraySort), (Sort)locArraySort, (ManagedScript)this.mMgdScript, (Object)this);
                this.mGlobalLocArrays.add((IProgramNonOldVar)result);
            } else if (pvoc instanceof ILocalProgramVar) {
                result = ProgramVarUtils.constructLocalProgramVar((String)this.sanitizeVarName("#loc_" + pvoc + "_" + locArraySort), (String)((ILocalProgramVar)pvoc).getProcedure(), (Sort)locArraySort, (ManagedScript)this.mMgdScript, (Object)this);
            } else {
                if (pvoc instanceof IProgramConst) {
                    throw new UnsupportedOperationException("todo: deal with constants");
                }
                throw new AssertionError((Object)"unforseen case");
            }
            this.mArrayPvocToDimToLocArrayPvoc.put((Object)pvoc, (Object)dim, (Object)result);
        }
        return result;
    }

    private String sanitizeVarName(String string) {
        String result = string.replaceAll("\\|", "").replaceAll("\\ ", "-");
        if (result.isEmpty()) {
            throw new AssertionError();
        }
        return result;
    }

    private Sort computeLocArraySort(Sort sort, int dim) {
        MultiDimensionalSort mds = new MultiDimensionalSort(sort);
        assert (mds.getDimension() > 0);
        ArrayDeque sortDeque = new ArrayDeque(mds.getIndexSorts());
        int i = 0;
        while (i < mds.getDimension() - dim) {
            sortDeque.pollLast();
            ++i;
        }
        assert (sortDeque.size() == dim);
        Sort resultSort = this.getMemlocSort(dim);
        while (!sortDeque.isEmpty()) {
            Sort last = (Sort)sortDeque.pollLast();
            resultSort = SmtSortUtils.getArraySort((Script)this.mMgdScript.getScript(), (Sort)last, (Sort)resultSort);
        }
        return resultSort;
    }

    private Term computeInitConstantArrayForLocArray(HeapSepProgramConst locLit, Sort locArraySort, Object lockOwner) {
        MultiDimensionalSort mds = new MultiDimensionalSort(locArraySort);
        if (mds.getDimension() == 1) {
            return this.mMgdScript.term(lockOwner, "const", null, locArraySort, new Term[]{locLit.getTerm()});
        }
        assert (!locArraySort.getArguments()[0].isArraySort());
        Term inner = this.computeInitConstantArrayForLocArray(locLit, locArraySort.getArguments()[1], lockOwner);
        return this.mMgdScript.term(lockOwner, "const", null, locArraySort, new Term[]{inner});
    }

    public LocArrayInfo getLocArray(EdgeInfo edgeInfo, Term array, int dim) {
        if (!this.mFrozen) {
            throw new AssertionError();
        }
        LocArrayInfo result = (LocArrayInfo)this.mEdgeToArrayTermToDimToLocArray.get((Object)edgeInfo, (Object)array, (Object)dim);
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public HeapSepProgramConst getInitLocLitPvocForLocLitTerm(Term locLitTerm) {
        return this.mInitLocLitTermToPvoc.get(locLitTerm);
    }

    public boolean isInitLocPvoc(HeapSepProgramConst hspc) {
        boolean result = this.mInitLocPvocToNoStoreInfo.containsKey(hspc);
        assert (result == this.mInitLocLitTermToPvoc.values().contains(hspc));
        return result;
    }

    public StoreInfo getNoStoreInfo(HeapSepProgramConst hspc) {
        return this.mInitLocPvocToNoStoreInfo.get(hspc);
    }

    public void freeze() {
        if (this.mFrozen) {
            throw new AssertionError();
        }
        this.mFrozen = true;
    }

    public boolean isArrayTermSubjectToSeparation(EdgeInfo edge, Term bat) {
        return this.mCsiag.isArrayTermSubjectToSeparation(edge, bat);
    }
}

