/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreLocationBlock;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IntraproceduralReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.LocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SubArrayManager {
    private final NestedMap2<IProgramVarOrConst, List<StoreLocationBlock>, IProgramVarOrConst> mArrayToLocationBlockListToSubArray;
    Set<IProgramVarOrConst> mAllSubArrays;
    private final ManagedScript mManagedScript;
    private final HeapSeparatorBenchmark mStatistics;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;

    public SubArrayManager(CfgSmtToolkit csToolkit, HeapSeparatorBenchmark statistics, ComputeStoreInfosAndArrayGroups<?> csiag) {
        this.mManagedScript = csToolkit.getManagedScript();
        this.mStatistics = statistics;
        this.mCsiag = csiag;
        this.mArrayToLocationBlockListToSubArray = new NestedMap2();
        this.mAllSubArrays = new HashSet<IProgramVarOrConst>();
    }

    public String toString() {
        return "NewArrayIdProvider";
    }

    public IProgramVarOrConst getSubArray(IProgramVarOrConst programVar, List<StoreLocationBlock> projectList) {
        ArrayGroup arrayGroup = this.mCsiag.getArrayGroupForArrayPvoc(programVar);
        assert (Objects.nonNull(arrayGroup));
        if (projectList.size() != arrayGroup.getDimensionality()) {
            throw new AssertionError((Object)"list of location blocks does not have the right length for the given array!");
        }
        IProgramVarOrConst subArray = (IProgramVarOrConst)this.mArrayToLocationBlockListToSubArray.get((Object)programVar, projectList);
        if (subArray == null) {
            subArray = this.constructFreshProgramVarsForIndexPartition(programVar, projectList);
            this.mArrayToLocationBlockListToSubArray.put((Object)programVar, projectList, (Object)subArray);
            this.mAllSubArrays.add(subArray);
            this.mStatistics.incrementNewArrayVarCounter(arrayGroup);
        }
        return subArray;
    }

    private IProgramVarOrConst constructFreshProgramVarsForIndexPartition(IProgramVarOrConst arrayPv, List<StoreLocationBlock> projectList) {
        ProgramNonOldVar freshVar = null;
        if (arrayPv instanceof LocalProgramVar) {
            LocalProgramVar lbv = (LocalProgramVar)arrayPv;
            String newId = String.valueOf(lbv.getIdentifier()) + "_part_" + this.constructIndexName(projectList);
            TermVariable newTv = this.mManagedScript.constructFreshCopy(lbv.getTermVariable());
            this.mManagedScript.lock((Object)this);
            String constString = String.valueOf(newId) + "_const";
            this.mManagedScript.getScript().declareFun(constString, new Sort[0], newTv.getSort());
            ApplicationTerm newConst = (ApplicationTerm)this.mManagedScript.term((Object)this, constString, new Term[0]);
            String constPrimedString = String.valueOf(newId) + "_const_primed";
            this.mManagedScript.getScript().declareFun(constPrimedString, new Sort[0], newTv.getSort());
            ApplicationTerm newPrimedConst = (ApplicationTerm)this.mManagedScript.term((Object)this, constPrimedString, new Term[0]);
            freshVar = new LocalProgramVar(newId, lbv.getProcedure(), newTv, newConst, newPrimedConst);
            this.mManagedScript.unlock((Object)this);
            return freshVar;
        }
        if (arrayPv instanceof ProgramNonOldVar) {
            ProgramNonOldVar bnovNew;
            ProgramNonOldVar bnovOld = (ProgramNonOldVar)arrayPv;
            String newId = String.valueOf(bnovOld.getIdentifier()) + "_part_" + this.constructIndexName(projectList);
            this.mManagedScript.lock((Object)this);
            freshVar = bnovNew = ProgramVarUtils.constructGlobalProgramVarPair((String)newId, (Sort)bnovOld.getSort(), (ManagedScript)this.mManagedScript, (Object)this);
            this.mManagedScript.unlock((Object)this);
            return freshVar;
        }
        if (arrayPv instanceof ProgramOldVar) {
            ProgramOldVar bovOld = (ProgramOldVar)arrayPv;
            String newId = String.valueOf(bovOld.getGloballyUniqueId()) + "_part_" + this.constructIndexName(projectList);
            this.mManagedScript.lock((Object)this);
            ProgramNonOldVar bnovNew = ProgramVarUtils.constructGlobalProgramVarPair((String)newId, (Sort)bovOld.getSort(), (ManagedScript)this.mManagedScript, (Object)this);
            freshVar = bnovNew.getOldVar();
            assert (freshVar != null);
            this.mManagedScript.unlock((Object)this);
            return freshVar;
        }
        if (arrayPv instanceof IntraproceduralReplacementVar) {
            throw new AssertionError((Object)"TODO: implement");
        }
        if (arrayPv instanceof ProgramConst) {
            throw new AssertionError((Object)"TODO: implement");
        }
        throw new AssertionError((Object)"case missing --> add it?");
    }

    private String constructIndexName(List<StoreLocationBlock> projectList) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (StoreLocationBlock lb : projectList) {
            sb.append(sep);
            sb.append(lb.toString());
            sep = "_";
        }
        return sb.toString();
    }

    public boolean isSubArray(IProgramVar key) {
        return this.mAllSubArrays.contains(key);
    }
}

