/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ArrayCellAccess {
    private final MultiDimensionalSelect mMdSelect;
    private final Term mSimpleArrayTerm;

    public ArrayCellAccess(MultiDimensionalSelect mdSelect) {
        this.mMdSelect = mdSelect;
        Term innerArrayTerm = mdSelect.getArray();
        while (SmtUtils.isFunctionApplication((Term)innerArrayTerm, (String)"store")) {
            innerArrayTerm = ((ApplicationTerm)innerArrayTerm).getParameters()[0];
        }
        this.mSimpleArrayTerm = innerArrayTerm;
    }

    public static List<ArrayCellAccess> extractArrayCellAccesses(Term formula) {
        ArrayList<ArrayCellAccess> result = new ArrayList<ArrayCellAccess>();
        List mdSelects = MultiDimensionalSelect.extractSelectShallow((Term)formula, (boolean)true);
        mdSelects.forEach(mds -> {
            boolean bl = result.add(new ArrayCellAccess((MultiDimensionalSelect)mds));
        });
        return result;
    }

    public Term getArray() {
        return this.mMdSelect.getArray();
    }

    public Term getSimpleArray() {
        return this.mSimpleArrayTerm;
    }

    public ArrayIndex getIndex() {
        return this.mMdSelect.getIndex();
    }

    public Term getTerm() {
        return this.mMdSelect.getSelectTerm();
    }

    public String toString() {
        return this.mMdSelect.toString();
    }

    public Set<Integer> getDimensionsOfIndexTerm(Term indexSubterm) {
        HashSet<Integer> result = new HashSet<Integer>();
        int dim = 0;
        while (dim < this.mMdSelect.getIndex().size()) {
            if (indexSubterm.equals(this.mMdSelect.getIndex().get(dim))) {
                result.add(dim);
            }
            ++dim;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mMdSelect == null ? 0 : this.mMdSelect.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayCellAccess other = (ArrayCellAccess)obj;
        return !(this.mMdSelect == null ? other.mMdSelect != null : !this.mMdSelect.equals((Object)other.mMdSelect));
    }
}

