/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayEquality;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayUpdate;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ArrayEqualityAllowStores {
    ArrayUpdate mArrayUpdate;
    ArrayEquality mArrayEquality;
    boolean mOtherIsNegated;
    Pair<Term, Term> mOther;

    public ArrayEqualityAllowStores(ArrayUpdate arrayUpdate) {
        this.mArrayUpdate = arrayUpdate;
        this.mArrayEquality = null;
        this.mOtherIsNegated = false;
        this.mOther = null;
    }

    public ArrayEqualityAllowStores(ArrayEquality arrayEquality) {
        this.mArrayUpdate = null;
        this.mArrayEquality = arrayEquality;
        this.mOtherIsNegated = false;
        this.mOther = null;
    }

    public ArrayEqualityAllowStores(Term lhs, Term rhs, boolean isNegated) {
        this.mArrayUpdate = null;
        this.mArrayEquality = null;
        this.mOtherIsNegated = isNegated;
        this.mOther = new Pair((Object)lhs, (Object)rhs);
    }

    public Term getTerm(Script script) {
        if (this.mArrayUpdate != null) {
            return this.mArrayUpdate.getArrayUpdateTerm();
        }
        if (this.mArrayEquality != null) {
            return this.mArrayEquality.getOriginalTerm();
        }
        assert (this.mOther != null);
        Term result = SmtUtils.binaryEquality((Script)script, (Term)((Term)this.mOther.getFirst()), (Term)((Term)this.mOther.getSecond()));
        if (this.mOtherIsNegated) {
            result = SmtUtils.not((Script)script, (Term)result);
        }
        return result;
    }

    public static List<ArrayEqualityAllowStores> extractArrayEqualityAllowStores(Term formula) {
        HashSet<String> functionSymbolNames = new HashSet<String>(3);
        functionSymbolNames.add("=");
        functionSymbolNames.add("distinct");
        functionSymbolNames.add("not");
        ArrayList<ArrayEqualityAllowStores> result = new ArrayList<ArrayEqualityAllowStores>();
        ApplicationTermFinder atf = new ApplicationTermFinder(functionSymbolNames, false);
        for (ApplicationTerm subterm : atf.findMatchingSubterms(formula)) {
            Term rhs;
            Term lhs;
            boolean isNegated;
            ArrayEqualityAllowStores arrayRel = null;
            boolean bl = isNegated = subterm.getFunction().getName().equals("not") || subterm.getFunction().getName().equals("distinct");
            if (subterm.getFunction().getName().equals("not")) {
                ApplicationTerm notArgAt;
                Term notArg = subterm.getParameters()[0];
                if (!(notArg instanceof ApplicationTerm) || !(notArgAt = (ApplicationTerm)notArg).getFunction().getName().equals("=")) continue;
                lhs = notArgAt.getParameters()[0];
                rhs = notArgAt.getParameters()[1];
                if (!lhs.getSort().isArraySort()) {
                    continue;
                }
            } else {
                lhs = subterm.getParameters()[0];
                rhs = subterm.getParameters()[1];
                if (!lhs.getSort().isArraySort()) continue;
            }
            try {
                arrayRel = new ArrayEqualityAllowStores(new ArrayUpdate((Term)subterm, isNegated, false));
                result.add(arrayRel);
            }
            catch (ArrayUpdate.ArrayUpdateException arrayUpdateException) {
                try {
                    arrayRel = new ArrayEqualityAllowStores(new ArrayEquality((Term)subterm, true, true));
                    result.add(arrayRel);
                }
                catch (ArrayEquality.ArrayEqualityException arrayEqualityException) {
                    result.add(new ArrayEqualityAllowStores(lhs, rhs, isNegated));
                }
            }
        }
        return result;
    }

    public Term getLhsArray() {
        if (this.mArrayUpdate != null) {
            return this.mArrayUpdate.getNewArray();
        }
        if (this.mArrayEquality != null) {
            return this.mArrayEquality.getLhs();
        }
        if (this.mOther != null) {
            throw new UnsupportedOperationException("implement this, when it occurs..");
        }
        throw new AssertionError();
    }

    public Term getRhsArray() {
        if (this.mArrayUpdate != null) {
            return this.mArrayUpdate.getOldArray();
        }
        if (this.mArrayEquality != null) {
            return this.mArrayEquality.getRhs();
        }
        if (this.mOther != null) {
            throw new UnsupportedOperationException("implement this, when it occurs..");
        }
        throw new AssertionError();
    }
}

