/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PositionAwareSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ArrayEqualityLocUpdateInfo {
    private final Map<SubtreePosition, StoreInfo> mRelPositionToInnerStoreInfo = new HashMap<SubtreePosition, StoreInfo>();
    private boolean mFinalized;
    private final EdgeInfo mEdge;
    private final MemlocArrayManager mLocArrayManager;
    private Term mFormulaWithLocUpdates;
    private final Map<IProgramVar, TermVariable> mExtraInVars = new HashMap<IProgramVar, TermVariable>();
    private final Map<IProgramVar, TermVariable> mExtraOutVars = new HashMap<IProgramVar, TermVariable>();
    private final Collection<TermVariable> mExtraAuxVars = new HashSet<TermVariable>();
    private final Collection<IProgramConst> mExtraConstants = new HashSet<IProgramConst>();
    private final ApplicationTerm mEquality;
    private final ManagedScript mMgdScript;
    private final Set<IProgramVar> mDefinitelyUnconstrainedVariables;

    public ArrayEqualityLocUpdateInfo(ManagedScript mgdScript, ApplicationTerm equality, EdgeInfo edge, MemlocArrayManager locArrayManager, Set<IProgramVar> definitelyUnconstrainedVariables) {
        this.mMgdScript = mgdScript;
        this.mEdge = edge;
        this.mLocArrayManager = locArrayManager;
        this.mEquality = equality;
        this.mDefinitelyUnconstrainedVariables = definitelyUnconstrainedVariables;
    }

    public void addEnclosedStoreInfo(StoreInfo storeInfo, SubtreePosition posRelativeToEquality) {
        if (this.mFinalized) {
            throw new AssertionError();
        }
        this.mRelPositionToInnerStoreInfo.put(posRelativeToEquality, storeInfo);
    }

    private void computeResult() {
        assert (!this.mFinalized);
        Set<Term> baseArrayTermsRaw = ArrayEqualityLocUpdateInfo.extractBaseArrayTerms(this.mEquality);
        Set baseArrayTerms = baseArrayTermsRaw.stream().filter(bat -> this.mLocArrayManager.isArrayTermSubjectToSeparation(this.mEdge, (Term)bat)).collect(Collectors.toSet());
        int dimensionality = this.computeDimensionality();
        ArrayList<Object> conjuncts = new ArrayList<Object>();
        conjuncts.add(this.mEquality);
        int dim = 1;
        while (dim <= dimensionality) {
            int currentDim = dim;
            HashMap<Term, Term> termSubstitutionMapping = new HashMap<Term, Term>();
            for (Term bat2 : baseArrayTerms) {
                LocArrayInfo locArray = this.mLocArrayManager.getOrConstructLocArray(this.mEdge, bat2, currentDim);
                termSubstitutionMapping.put(bat2, locArray.getTerm());
                if (this.mEdge.getInVars().containsValue(bat2) && (!this.isDefinitelyUnconstrained(bat2) || this.mEdge.getOutVar(bat2) != this.mEdge.getInVar(bat2))) {
                    this.mExtraInVars.put((IProgramVar)locArray.getPvoc(), (TermVariable)locArray.getTerm());
                }
                if (this.mEdge.getOutVars().containsValue(bat2)) {
                    this.mExtraOutVars.put((IProgramVar)locArray.getPvoc(), (TermVariable)locArray.getTerm());
                }
                if (this.mEdge.getAuxVars().contains(bat2)) {
                    this.mExtraAuxVars.add((TermVariable)locArray.getTerm());
                }
                if (!this.mEdge.getNonTheoryConsts().stream().map(ntc -> ntc.getTerm()).anyMatch(t -> t.equals(bat2))) continue;
                this.mExtraConstants.add((IProgramConst)locArray.getPvoc());
            }
            List storeInfosForCurrentDimension = this.mRelPositionToInnerStoreInfo.values().stream().filter(si -> si.getDimension() == currentDim).collect(Collectors.toList());
            HashMap<SubtreePosition, Term> positionSubstitutionMapping = new HashMap<SubtreePosition, Term>();
            for (StoreInfo si2 : storeInfosForCurrentDimension) {
                positionSubstitutionMapping.put(si2.getPositionOfStoredValueRelativeToEquality(), si2.getLocLiteral().getTerm());
                this.mExtraConstants.add(si2.getLocLiteral());
            }
            Term equalityWithLocArraysAndLocLiterals = new PositionAwareSubstitution(this.mMgdScript, positionSubstitutionMapping, termSubstitutionMapping).transform((Term)this.mEquality);
            conjuncts.add(equalityWithLocArraysAndLocLiterals);
            ++dim;
        }
        this.mFormulaWithLocUpdates = SmtUtils.and((Script)this.mMgdScript.getScript(), conjuncts);
        this.mFinalized = true;
    }

    private boolean isDefinitelyUnconstrained(Term baseArrayTerm) {
        IProgramVar invar;
        return baseArrayTerm instanceof TermVariable && this.mDefinitelyUnconstrainedVariables.contains(invar = this.mEdge.getInVar(baseArrayTerm));
    }

    public int computeDimensionality() {
        int dimensionality = new MultiDimensionalSort(this.mEquality.getParameters()[0].getSort()).getDimension();
        assert (this.mRelPositionToInnerStoreInfo.get(new SubtreePosition().append(0)) == null || dimensionality == this.mRelPositionToInnerStoreInfo.get(new SubtreePosition().append(0)).getArrayGroup().getDimensionality());
        assert (this.mRelPositionToInnerStoreInfo.get(new SubtreePosition().append(1)) == null || dimensionality == this.mRelPositionToInnerStoreInfo.get(new SubtreePosition().append(1)).getArrayGroup().getDimensionality());
        return dimensionality;
    }

    private static Set<Term> extractBaseArrayTerms(ApplicationTerm equality) {
        Predicate<Term> pred = subterm -> SmtUtils.isBasicArrayTerm((Term)subterm);
        return SubTermFinder.find((Term)equality, pred, (boolean)false);
    }

    public Term getFormulaWithLocUpdates() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mFormulaWithLocUpdates;
    }

    public Map<? extends IProgramVar, ? extends TermVariable> getExtraInVars() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mExtraInVars;
    }

    public Map<? extends IProgramVar, ? extends TermVariable> getExtraOutVars() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mExtraOutVars;
    }

    public Collection<? extends TermVariable> getExtraAuxVars() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mExtraAuxVars;
    }

    public Collection<? extends IProgramConst> getExtraConstants() {
        if (!this.mFinalized) {
            this.computeResult();
        }
        return this.mExtraConstants;
    }

    public String toString() {
        return "ArrayEqualityLocUpdateInfo [mEquality=" + this.mEquality + "]";
    }
}

