/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import java.util.Collections;
import java.util.Set;

public class ArrayGroup {
    private final Set<IProgramVarOrConst> mArraysInThisGroup;
    private final int mDimensionality;

    public ArrayGroup(Set<IProgramVarOrConst> block) {
        this.mArraysInThisGroup = Collections.unmodifiableSet(block);
        MultiDimensionalSort mdSort = new MultiDimensionalSort(block.iterator().next().getSort());
        this.mDimensionality = mdSort.getDimension();
    }

    public Set<IProgramVarOrConst> getArrays() {
        return this.mArraysInThisGroup;
    }

    public String toString() {
        return this.mArraysInThisGroup.toString();
    }

    public int getDimensionality() {
        return this.mDimensionality;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mArraysInThisGroup == null ? 0 : this.mArraysInThisGroup.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayGroup other = (ArrayGroup)obj;
        return !(this.mArraysInThisGroup == null ? other.mArraysInThisGroup != null : !this.mArraysInThisGroup.equals(other.mArraysInThisGroup));
    }

    public static ArrayGroup getNoArrayGroup() {
        return new NoArrayGroup();
    }

    private static class NoArrayGroup
    extends ArrayGroup {
        public NoArrayGroup() {
            super(Collections.emptySet());
        }

        @Override
        public Set<IProgramVarOrConst> getArrays() {
            return Collections.emptySet();
        }

        @Override
        public String toString() {
            return "NoArrayGroup";
        }

        @Override
        public int getDimensionality() {
            return -1;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof NoArrayGroup;
        }
    }
}

