/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Map;
import java.util.Set;

public class EdgeInfo {
    IcfgEdge mEdge;

    public EdgeInfo(IcfgEdge edge) {
        this.mEdge = edge;
    }

    public IProgramVarOrConst getProgramVarOrConstForTerm(Term term) {
        return TransFormulaUtils.getProgramVarOrConstForTerm((TransFormula)this.mEdge.getTransformula(), (Term)term);
    }

    public IcfgLocation getSourceLocation() {
        return (IcfgLocation)this.mEdge.getSource();
    }

    public IcfgEdge getEdge() {
        return this.mEdge;
    }

    public String toString() {
        return "(" + this.mEdge + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mEdge == null ? 0 : this.mEdge.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EdgeInfo other = (EdgeInfo)obj;
        return !(this.mEdge == null ? other.mEdge != null : !this.mEdge.equals(other.mEdge));
    }

    public IProgramVar getInVar(Term term) {
        if (!(term instanceof TermVariable)) {
            return null;
        }
        for (Map.Entry en : this.mEdge.getTransformula().getInVars().entrySet()) {
            if (!((TermVariable)en.getValue()).equals(term)) continue;
            return (IProgramVar)en.getKey();
        }
        return null;
    }

    public IProgramVar getOutVar(Term term) {
        if (!(term instanceof TermVariable)) {
            return null;
        }
        for (Map.Entry en : this.mEdge.getTransformula().getOutVars().entrySet()) {
            if (!((TermVariable)en.getValue()).equals(term)) continue;
            return (IProgramVar)en.getKey();
        }
        return null;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mEdge.getTransformula().getInVars();
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mEdge.getTransformula().getOutVars();
    }

    public Set<TermVariable> getAuxVars() {
        return this.mEdge.getTransformula().getAuxVars();
    }

    public Set<IProgramConst> getNonTheoryConsts() {
        return this.mEdge.getTransformula().getNonTheoryConsts();
    }
}

