/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityLocUpdateInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.NoStoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Objects;

public class StoreInfo {
    private final EdgeInfo mEdgeInfo;
    private final Term mStoreTerm;
    private final ArrayGroup mArrayGroup;
    private final ArrayIndex mEnclosingIndices;
    private final Term mStoreIndex;
    private final int mId;
    private final IProgramConst mLocLit;
    private final SubtreePosition mSubtreePosition;
    private final ArrayEqualityLocUpdateInfo mEnclosingEquality;
    private final SubtreePosition mPositionOfStoredValueRelativeToEquality;

    public StoreInfo(int id, EdgeInfo edgeInfo, SubtreePosition subTreePosition, Term storeTerm, ArrayGroup array, ArrayIndex enclosingIndices, IProgramConst locLit, ArrayEqualityLocUpdateInfo enclosingEquality, SubtreePosition posRelativeToEquality) {
        assert (this instanceof NoStoreInfo || Objects.nonNull(edgeInfo) && Objects.nonNull(storeTerm) && Objects.nonNull(array) && Objects.nonNull(locLit) && id >= 0);
        this.mEdgeInfo = edgeInfo;
        this.mSubtreePosition = subTreePosition;
        this.mStoreTerm = storeTerm;
        this.mArrayGroup = array;
        this.mEnclosingIndices = enclosingIndices;
        this.mLocLit = locLit;
        this.mEnclosingEquality = enclosingEquality;
        if (this instanceof NoStoreInfo) {
            this.mPositionOfStoredValueRelativeToEquality = null;
            this.mStoreIndex = null;
        } else {
            Term stIndex;
            this.mPositionOfStoredValueRelativeToEquality = posRelativeToEquality.append(2);
            assert (this.mEnclosingEquality != null);
            assert (SmtUtils.isFunctionApplication((Term)storeTerm, (String)"store")) : "expecting store term";
            this.mEnclosingEquality.addEnclosedStoreInfo(this, posRelativeToEquality);
            ApplicationTerm at = (ApplicationTerm)storeTerm;
            this.mStoreIndex = stIndex = at.getParameters()[1];
        }
        this.mId = id;
    }

    public EdgeInfo getEdgeInfo() {
        return this.mEdgeInfo;
    }

    public Term getStoreTerm() {
        return this.mStoreTerm;
    }

    public Term getStoreIndex() {
        return this.mStoreIndex;
    }

    public ArrayIndex getEnclosingIndices() {
        return this.mEnclosingIndices;
    }

    public ArrayGroup getArrayGroup() {
        return this.mArrayGroup;
    }

    public Integer getDimension() {
        return this.mEnclosingIndices.size() + 1;
    }

    public String toString() {
        return "(Store [" + this.mId + "] at" + this.mEdgeInfo + " with " + this.mStoreTerm + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.mId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoreInfo other = (StoreInfo)obj;
        return this.mId == other.mId;
    }

    public IProgramConst getLocLiteral() {
        return this.mLocLit;
    }

    public int getId() {
        return this.mId;
    }

    public boolean isOutermost() {
        return this.getDimension() == 1;
    }

    public SubtreePosition getPositionOfStoredValueRelativeToEquality() {
        return this.mPositionOfStoredValueRelativeToEquality;
    }

    public SubtreePosition getPosition() {
        return this.mSubtreePosition;
    }

    public static StoreInfo buildStoreInfo(int siId, EdgeInfo edge, SubtreePosition subTreePosition, ApplicationTerm term, ArrayGroup arrayGroup, ArrayIndex enclosingStoreIndices, IProgramConst locLit, ArrayEqualityLocUpdateInfo enclosingEquality, SubtreePosition posRelativeToOutermost) {
        return new StoreInfo(siId, edge, subTreePosition, (Term)term, arrayGroup, enclosingStoreIndices, locLit, enclosingEquality, posRelativeToOutermost);
    }
}

