/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.IdentityTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.SuffixedDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class AddInitializingEdgesIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final BasicIcfg<OUTLOC> mResultIcfg;
    final TransformedIcfgBuilder<INLOC, OUTLOC> mBuilder;
    private final UnmodifiableTransFormula mInitializingTransformula;
    private final IIcfg<INLOC> mInputIcfg;

    public AddInitializingEdgesIcfgTransformer(ILogger logger, CfgSmtToolkit oldCsToolkit, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, IIcfg<INLOC> originalIcfg, UnmodifiableTransFormula initTf, String newIcfgName) {
        this.mInitializingTransformula = initTf;
        IdentityTransformer transformer = new IdentityTransformer(oldCsToolkit);
        this.mResultIcfg = new BasicIcfg(newIcfgName, originalIcfg.getCfgSmtToolkit(), outLocationClass);
        this.mBuilder = new TransformedIcfgBuilder<INLOC, OUTLOC>(logger, funLocFac, backtranslationTracker, transformer, originalIcfg, this.mResultIcfg);
        this.mInputIcfg = originalIcfg;
        this.process(originalIcfg, funLocFac, backtranslationTracker, outLocationClass);
    }

    private void process(IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass) {
        this.processLocationsOmitInitEdges(originalIcfg.getInitialNodes(), this.mBuilder);
        this.mBuilder.finish();
    }

    private void processLocationsOmitInitEdges(Set<INLOC> initLocations, TransformedIcfgBuilder<INLOC, OUTLOC> lst) {
        HashSet<IcfgEdge> initEdges = new HashSet<IcfgEdge>();
        HashRelation edgesSucceedingInitEdges = new HashRelation();
        IcfgLocationIterator iter = new IcfgLocationIterator(initLocations);
        ArrayList<Triple> rtrTransitions = new ArrayList<Triple>();
        while (iter.hasNext()) {
            IcfgLocation oldSource = iter.next();
            block1: for (IcfgEdge oldTransition : oldSource.getOutgoingEdges()) {
                if (initLocations.contains(oldSource)) {
                    initEdges.add(oldTransition);
                    continue;
                }
                for (IcfgEdge incomingEdge : oldSource.getIncomingEdges()) {
                    if (!initLocations.contains(incomingEdge.getSource())) continue;
                    edgesSucceedingInitEdges.addPair((Object)incomingEdge, (Object)oldTransition);
                    continue block1;
                }
                OUTLOC newTarget = lst.createNewLocation((IcfgLocation)oldTransition.getTarget());
                OUTLOC newSource = lst.createNewLocation(oldSource);
                if (oldTransition instanceof IIcfgReturnTransition) {
                    rtrTransitions.add(new Triple(newSource, newTarget, (Object)oldTransition));
                    continue;
                }
                lst.createNewTransition(newSource, newTarget, oldTransition);
            }
        }
        assert (initEdges.stream().map(e -> (IcfgLocation)e.getTarget()).collect(Collectors.toSet()).size() == initEdges.size()) : "two init edges leading to the same location??";
        for (IcfgEdge initEdge : initEdges) {
            if (initEdge instanceof IcfgCallTransition) {
                IcfgLocation oldInitTarget = (IcfgLocation)initEdge.getTarget();
                assert (oldInitTarget.getIncomingEdges().size() == 1);
                OUTLOC initEdgeSource = this.mBuilder.createNewLocation((IcfgLocation)initEdge.getSource());
                String succeedingProcedureAfterInitEdge = initEdge.getSucceedingProcedure();
                Pair<OUTLOC, OUTLOC> split = this.splitLocation(oldInitTarget, succeedingProcedureAfterInitEdge);
                this.mBuilder.createNewTransition((IcfgLocation)initEdgeSource, (IcfgLocation)split.getFirst(), initEdge);
                this.mBuilder.createNewInternalTransition((IcfgLocation)split.getFirst(), (IcfgLocation)split.getSecond(), this.mInitializingTransformula, false);
                for (IcfgEdge succEdge : edgesSucceedingInitEdges.getImage((Object)initEdge)) {
                    this.mBuilder.createNewTransition((IcfgLocation)split.getSecond(), (IcfgLocation)this.mBuilder.createNewLocation((IcfgLocation)succEdge.getTarget()), succEdge);
                }
                continue;
            }
            if (initEdge instanceof IcfgInternalTransition) {
                IcfgLocation oldInitSource = (IcfgLocation)initEdge.getSource();
                IcfgLocation oldInitTarget = (IcfgLocation)initEdge.getTarget();
                Pair<OUTLOC, OUTLOC> split = this.splitLocation(oldInitSource, initEdge.getSucceedingProcedure());
                this.mBuilder.createNewInternalTransition((IcfgLocation)split.getFirst(), (IcfgLocation)split.getSecond(), this.mInitializingTransformula, false);
                this.mBuilder.createNewTransition((IcfgLocation)split.getSecond(), (IcfgLocation)this.mBuilder.createNewLocation(oldInitTarget), initEdge);
                for (IcfgEdge succEdge : edgesSucceedingInitEdges.getImage((Object)initEdge)) {
                    this.mBuilder.createNewTransition(this.mBuilder.createNewLocation(oldInitTarget), this.mBuilder.createNewLocation((IcfgLocation)succEdge.getTarget()), succEdge);
                }
                continue;
            }
            throw new AssertionError((Object)"init edge is neither call nor internal transition");
        }
        rtrTransitions.forEach(a -> {
            IcfgEdge icfgEdge = lst.createNewTransition((IcfgLocation)a.getFirst(), (IcfgLocation)a.getSecond(), (IcfgEdge)a.getThird());
        });
    }

    private Pair<OUTLOC, OUTLOC> splitLocation(INLOC oldInitTarget, String containingprocedure) {
        boolean wasProcedureEntryNode = !this.mInputIcfg.getProcedureEntryNodes().isEmpty() && ((IcfgLocation)this.mInputIcfg.getProcedureEntryNodes().get(containingprocedure)).equals(oldInitTarget);
        OUTLOC s1 = this.createAndAddNewLocation(oldInitTarget, this.mInputIcfg.getInitialNodes().contains(oldInitTarget), false, wasProcedureEntryNode, false, false, (DebugIdentifier)new SuffixedDebugIdentifier(oldInitTarget.getDebugIdentifier(), "_split-1"));
        boolean wasProcedureExitNode = !this.mInputIcfg.getProcedureExitNodes().isEmpty() && ((IcfgLocation)this.mInputIcfg.getProcedureExitNodes().get(containingprocedure)).equals(oldInitTarget);
        OUTLOC s2 = this.createAndAddNewLocation(oldInitTarget, false, ((Set)this.mInputIcfg.getProcedureErrorNodes().get(containingprocedure)).contains(oldInitTarget), false, wasProcedureExitNode, this.mInputIcfg.getLoopLocations().contains(oldInitTarget), (DebugIdentifier)new SuffixedDebugIdentifier(oldInitTarget.getDebugIdentifier(), "_split-2"));
        Pair p = new Pair(s1, s2);
        return p;
    }

    private OUTLOC createAndAddNewLocation(INLOC originalInitNode, boolean isInitial, boolean isError, boolean isProcEntry, boolean isProcExit, boolean isLoopLocation, DebugIdentifier locName) {
        BoogieIcfgLocation freshLoc = new BoogieIcfgLocation(locName, originalInitNode.getProcedure(), false, ((BoogieIcfgLocation)originalInitNode).getBoogieASTNode());
        this.mResultIcfg.addLocation((IcfgLocation)freshLoc, isInitial, isError, isProcEntry, isProcExit, isLoopLocation);
        return (OUTLOC)freshLoc;
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }
}

