/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.LocArrayInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.MemlocArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayEqualityLocUpdateInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PositionAwareSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemlocArrayUpdaterTransformulaTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements ITransformulaTransformer {
    private final Map<StoreInfo, IProgramConst> mStoreInfoToLocLiteral;
    private final NestedMap2<EdgeInfo, SubtreePosition, ArrayEqualityLocUpdateInfo> mEdgeToPositionToLocUpdateInfo;
    private final int mMemLocLitCounter = 0;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final MemlocArrayManager mLocArrayManager;
    ManagedScript mMgdScript;
    private final DefaultIcfgSymbolTable mNewSymbolTable;
    private boolean mQueriedStoreAndLitInfo;
    private final HashRelation<String, IProgramNonOldVar> mNewModifiableGlobals;
    private final HashRelation<EdgeInfo, TermVariable> mEdgeToUnconstrainedVars = new HashRelation();
    private final IUltimateServiceProvider mServices;

    public MemlocArrayUpdaterTransformulaTransformer(IUltimateServiceProvider services, ILogger logger, CfgSmtToolkit oldCsToolkit, MemlocArrayManager memlocArrayManager, List<IProgramVarOrConst> heapArrays, NestedMap2<EdgeInfo, SubtreePosition, ArrayEqualityLocUpdateInfo> edgeToPositionToLocUpdateInfo) {
        this.mMgdScript = oldCsToolkit.getManagedScript();
        this.mEdgeToPositionToLocUpdateInfo = edgeToPositionToLocUpdateInfo;
        this.mLocArrayManager = memlocArrayManager;
        this.mStoreInfoToLocLiteral = new HashMap<StoreInfo, IProgramConst>();
        this.mHeapArrays = heapArrays;
        this.mNewSymbolTable = new DefaultIcfgSymbolTable(oldCsToolkit.getSymbolTable(), oldCsToolkit.getProcedures());
        this.mNewModifiableGlobals = new HashRelation((AbstractRelation)oldCsToolkit.getModifiableGlobalsTable().getProcToGlobals());
        this.mServices = services;
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> oldEdge, UnmodifiableTransFormula tf) {
        Term transitionFormulaWithLocUpdates;
        assert (!this.mQueriedStoreAndLitInfo);
        EdgeInfo edgeInfo = new EdgeInfo((IcfgEdge)oldEdge);
        if (this.mEdgeToPositionToLocUpdateInfo.get((Object)edgeInfo) == null && this.mEdgeToUnconstrainedVars.getImage((Object)edgeInfo) == null) {
            return new ITransformulaTransformer.TransformulaTransformationResult(tf);
        }
        HashMap<? extends IProgramVar, ? extends TermVariable> extraInVars = new HashMap<IProgramVar, TermVariable>();
        HashMap<? extends IProgramVar, ? extends TermVariable> extraOutVars = new HashMap<IProgramVar, TermVariable>();
        HashSet<? extends IProgramConst> extraConstants = new HashSet<IProgramConst>();
        HashSet<? extends TermVariable> extraAuxVars = new HashSet<TermVariable>();
        Map posToLocUpdateInfo = this.mEdgeToPositionToLocUpdateInfo.get((Object)edgeInfo);
        if (posToLocUpdateInfo != null) {
            HashMap<SubtreePosition, Term> arrayEqualityPosToTermWithLocUpdates = new HashMap<SubtreePosition, Term>();
            for (Map.Entry en : posToLocUpdateInfo.entrySet()) {
                arrayEqualityPosToTermWithLocUpdates.put((SubtreePosition)en.getKey(), ((ArrayEqualityLocUpdateInfo)en.getValue()).getFormulaWithLocUpdates());
                extraInVars.putAll(((ArrayEqualityLocUpdateInfo)en.getValue()).getExtraInVars());
                extraOutVars.putAll(((ArrayEqualityLocUpdateInfo)en.getValue()).getExtraOutVars());
                extraAuxVars.addAll(((ArrayEqualityLocUpdateInfo)en.getValue()).getExtraAuxVars());
                extraConstants.addAll(((ArrayEqualityLocUpdateInfo)en.getValue()).getExtraConstants());
            }
            transitionFormulaWithLocUpdates = new PositionAwareSubstitution(this.mMgdScript, arrayEqualityPosToTermWithLocUpdates).transform(tf.getFormula());
        } else {
            transitionFormulaWithLocUpdates = tf.getFormula();
        }
        ArrayList<Term> disjunctsWithLocUpdatesAndLocInitialization = new ArrayList<Term>();
        Term[] termArray = SmtUtils.getDisjuncts((Term)SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)tf.getFormula(), (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION));
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term disjunct = termArray[n2];
            if (!(SmtUtils.isAtomicFormula((Term)disjunct) || SmtUtils.isNNF((Term)disjunct) && !SmtUtils.containsFunctionApplication((Term)disjunct, (String)"or"))) {
                throw new AssertionError((Object)"the code below only works for conjunctive formulas");
            }
            Set unconstrainedVars = this.mEdgeToUnconstrainedVars.getImage((Object)edgeInfo);
            ArrayList<Term> tfWithUpdatesAndInitConjuncts = new ArrayList<Term>();
            tfWithUpdatesAndInitConjuncts.add(transitionFormulaWithLocUpdates);
            Iterator iterator = unconstrainedVars.iterator();
            while (iterator.hasNext()) {
                TermVariable ucv = (TermVariable)iterator.next();
                MultiDimensionalSort mds = new MultiDimensionalSort(ucv.getSort());
                int dimensionality = mds.getDimension();
                assert (dimensionality > 0);
                int dim = 1;
                while (dim <= dimensionality) {
                    LocArrayInfo locArray = this.mLocArrayManager.getOrConstructLocArray(edgeInfo, (Term)ucv, dim);
                    Term initConjunct = SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)locArray.getTerm(), (Term)locArray.getInitializingConstantArray());
                    tfWithUpdatesAndInitConjuncts.add(initConjunct);
                    ++dim;
                }
            }
            Term term = SmtUtils.and((Script)this.mMgdScript.getScript(), tfWithUpdatesAndInitConjuncts);
            disjunctsWithLocUpdatesAndLocInitialization.add(term);
            ++n2;
        }
        Term transitionFormulaWithLocUpdatesAndLocInitialization = SmtUtils.or((Script)this.mMgdScript.getScript(), disjunctsWithLocUpdatesAndLocInitialization);
        HashMap<? extends IProgramVar, ? extends TermVariable> newInVars = new HashMap<IProgramVar, TermVariable>(tf.getInVars());
        newInVars.putAll(extraInVars);
        for (IProgramVar iv : extraInVars.keySet()) {
            if (iv instanceof IProgramOldVar) continue;
            this.mNewSymbolTable.add((IProgramVarOrConst)iv);
        }
        HashMap<? extends IProgramVar, ? extends TermVariable> newOutVars = new HashMap<IProgramVar, TermVariable>(tf.getOutVars());
        newOutVars.putAll(extraOutVars);
        for (IProgramVar ov : extraOutVars.keySet()) {
            if (ov instanceof IProgramOldVar) continue;
            this.mNewSymbolTable.add((IProgramVarOrConst)ov);
        }
        HashSet<? extends IProgramConst> newNonTheoryConsts = new HashSet<IProgramConst>(tf.getNonTheoryConsts());
        newNonTheoryConsts.addAll(extraConstants);
        for (IProgramConst iProgramConst : extraConstants) {
            this.mNewSymbolTable.add((IProgramVarOrConst)iProgramConst);
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(newInVars, newOutVars, newNonTheoryConsts.isEmpty(), newNonTheoryConsts, tf.getBranchEncoders().isEmpty(), (Collection)tf.getBranchEncoders(), tf.getAuxVars().isEmpty() && extraAuxVars.isEmpty());
        transFormulaBuilder.setFormula(transitionFormulaWithLocUpdatesAndLocInitialization);
        transFormulaBuilder.setInfeasibility(tf.isInfeasible());
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(DataStructureUtils.union((Set)tf.getAuxVars(), extraAuxVars), this.mMgdScript);
        UnmodifiableTransFormula newTf = transFormulaBuilder.finishConstruction(this.mMgdScript);
        assert (SmtUtils.checkSatTerm((Script)this.mMgdScript.getScript(), (Term)oldEdge.getTransformula().getClosedFormula()) == Script.LBool.UNSAT || SmtUtils.checkSatTerm((Script)this.mMgdScript.getScript(), (Term)newTf.getClosedFormula()) != Script.LBool.UNSAT);
        return new ITransformulaTransformer.TransformulaTransformationResult(newTf);
    }

    @Override
    public void preprocessIcfg(IIcfg<?> icfg) {
    }

    @Override
    public String getName() {
        return "withMemlocArrayUpdates";
    }

    @Override
    public IIcfgSymbolTable getNewIcfgSymbolTable() {
        return this.mNewSymbolTable;
    }

    @Override
    public HashRelation<String, IProgramNonOldVar> getNewModifiedGlobals() {
        return this.mNewModifiableGlobals;
    }
}

