/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.SubArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayCellAccess;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreLocationBlock;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PositionAwareTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class PartitionProjectionTermTransformer
extends PositionAwareTermTransformer {
    private final Stack<List<StoreLocationBlock>> mProjectLists;
    private final ManagedScript mMgdScript;
    private final NestedMap2<ArrayCellAccess, Integer, StoreLocationBlock> mArrayCellAccessToIntegerToLocationBlock;
    private final HashRelation3<ArrayGroup, Integer, StoreLocationBlock> mArrayGroupToDimensionToLocationBlocks;
    private final SubArrayManager mSubArrayManager;
    private final HashMap<IProgramVar, TermVariable> mNewInVars;
    private final HashMap<IProgramVar, TermVariable> mNewOutVars;
    private final EdgeInfo mEdgeInfo;
    private final NestedMap2<Term, IProgramVarOrConst, Term> mOriginalTermToSubArrayToReplacementTerm;
    private final List<IProgramVarOrConst> mHeapArrays;
    private boolean mIsFinished;
    private final Set<IProgramVar> mInVarsWithATermVar;
    private final Set<IProgramVar> mOutVarsWithATermVar;
    private final ILogger mLogger;
    private final Set<IProgramVarOrConst> mUpdatedSubarrays;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;

    public PartitionProjectionTermTransformer(ILogger logger, ManagedScript mgdScript, SubArrayManager subArrayManager, NestedMap2<ArrayCellAccess, Integer, StoreLocationBlock> arrayCellAccessToDimensionToLocationBlock, EdgeInfo edgeInfo, HashRelation3<ArrayGroup, Integer, StoreLocationBlock> arrayGroupToDimensionToLocationBlocks, ComputeStoreInfosAndArrayGroups<?> csiag, List<IProgramVarOrConst> heapArrays) {
        this.mLogger = Objects.requireNonNull(logger);
        this.mMgdScript = Objects.requireNonNull(mgdScript);
        this.mSubArrayManager = Objects.requireNonNull(subArrayManager);
        this.mHeapArrays = Objects.requireNonNull(heapArrays);
        this.mCsiag = csiag;
        assert (Objects.nonNull(arrayCellAccessToDimensionToLocationBlock) || !ArrayCellAccess.extractArrayCellAccesses(edgeInfo.getEdge().getTransformula().getFormula()).stream().anyMatch(aca -> this.mHeapArrays.contains(edgeInfo.getProgramVarOrConstForTerm(aca.getSimpleArray())))) : "this input map must be non-null if we have a select on a heap array inside the edge";
        this.mArrayCellAccessToIntegerToLocationBlock = arrayCellAccessToDimensionToLocationBlock;
        this.mArrayGroupToDimensionToLocationBlocks = arrayGroupToDimensionToLocationBlocks;
        this.mEdgeInfo = edgeInfo;
        this.mNewInVars = new HashMap();
        this.mNewOutVars = new HashMap();
        this.mInVarsWithATermVar = new HashSet<IProgramVar>();
        this.mOutVarsWithATermVar = new HashSet<IProgramVar>();
        this.mProjectLists = new Stack();
        this.mProjectLists.push(Collections.emptyList());
        this.mOriginalTermToSubArrayToReplacementTerm = new NestedMap2();
        this.mUpdatedSubarrays = new HashSet<IProgramVarOrConst>();
    }

    @Override
    protected void convert(Term term, SubtreePosition pos) {
        assert (this.mProjectLists.stream().allMatch(l -> l.stream().allMatch(Objects::nonNull)));
        List<StoreLocationBlock> projectList = this.mProjectLists.peek();
        if (term instanceof ConstantTerm || term instanceof TermVariable) {
            IProgramVar outvar;
            IProgramVar invar = this.mEdgeInfo.getInVar(term);
            if (invar != null) {
                this.mInVarsWithATermVar.add(invar);
            }
            if ((outvar = this.mEdgeInfo.getOutVar(term)) != null) {
                this.mOutVarsWithATermVar.add(outvar);
            }
            if (this.isPartitionedArray(term)) {
                Term subArrayTerm = this.getSubArrayReplacementTerm(term, projectList);
                this.setResult(subArrayTerm);
            } else {
                this.setResult(term);
            }
        } else if (term instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)term;
            String functionName = at.getFunction().getName();
            if (functionName.equals("=") && at.getFunction().getParameterSorts().length == 2 && at.getParameters()[0].getSort().isArraySort()) {
                assert (projectList.isEmpty()) : "We should not have an active projection on the Boolean level.";
                Term lhs = at.getParameters()[0];
                Term rhs = at.getParameters()[1];
                Term lhsBaseArray = this.extractSimpleArrayTerm(lhs);
                Term rhsBaseArray = this.extractSimpleArrayTerm(rhs);
                if (!this.mCsiag.isArrayTermSubjectToSeparation(this.mEdgeInfo, lhsBaseArray)) {
                    assert (!this.mCsiag.isArrayTermSubjectToSeparation(this.mEdgeInfo, rhsBaseArray));
                    super.convert(term, pos);
                    return;
                }
                assert (this.mCsiag.isArrayTermSubjectToSeparation(this.mEdgeInfo, rhsBaseArray));
                ArrayGroup arrayGroup = this.mCsiag.getArrayGroupForTermInEdge(this.mEdgeInfo, lhsBaseArray);
                List<List<StoreLocationBlock>> locationBlockTuples = this.getAllLocationBlockTuplesForHeapArray(arrayGroup);
                this.enqueueWalker(new BuildConjunction(locationBlockTuples.size(), this.mMgdScript.getScript()));
                for (List<StoreLocationBlock> lbt : locationBlockTuples) {
                    this.enqueueWalker(new EndScope());
                    this.enqueueWalker(new PositionAwareTermTransformer.BuildApplicationTerm((ApplicationTerm)term, pos));
                    this.pushTerms(at.getParameters(), pos);
                    this.enqueueWalker(new BeginScope(Collections.unmodifiableList(lbt)));
                }
            } else if (functionName.equals("select")) {
                Term array = at.getParameters()[0];
                IProgramVarOrConst arrayPvoc = this.mEdgeInfo.getProgramVarOrConstForTerm(this.extractSimpleArrayTerm(array));
                if (!this.mHeapArrays.contains(arrayPvoc)) {
                    super.convert(term, pos);
                    return;
                }
                ArrayCellAccess aca = new ArrayCellAccess(new MultiDimensionalSelect(term));
                this.enqueueWalker(new BuildArrayCellAccessTerm(aca, this.mMgdScript.getScript()));
                this.enqueueWalker(new EndScope());
                this.pushTerms((Term[])aca.getIndex().toArray((Object[])new Term[aca.getIndex().size()]), pos.append(1));
                this.enqueueWalker(new BeginScope(Collections.emptyList()));
                ArrayList<StoreLocationBlock> locationBlockList = new ArrayList<StoreLocationBlock>();
                int dim = 1;
                while (dim <= aca.getIndex().size()) {
                    StoreLocationBlock locationBlock = (StoreLocationBlock)this.mArrayCellAccessToIntegerToLocationBlock.get((Object)aca, (Object)dim);
                    assert (locationBlock != null);
                    locationBlockList.add(locationBlock);
                    ++dim;
                }
                this.enqueueWalker(new EndScope());
                this.pushTerm(aca.getArray(), pos.append(2));
                this.enqueueWalker(new BeginScope(this.append(locationBlockList, projectList)));
            } else if (functionName.equals("store")) {
                Term arraySubterm = at.getParameters()[0];
                Term indexSubterm = at.getParameters()[1];
                Term valueSubterm = at.getParameters()[2];
                Term baseArray = this.extractSimpleArrayTerm(arraySubterm);
                IProgramVarOrConst baseArrayPvoc = this.mEdgeInfo.getProgramVarOrConstForTerm(baseArray);
                if (!this.mHeapArrays.contains(baseArrayPvoc)) {
                    super.convert(term, pos);
                    return;
                }
                assert (projectList.size() > 0) : "(IndexOutOfBoundsExceptions are hard to catch somehow..";
                if (this.fallsInto(pos, term, projectList.get(0))) {
                    if (baseArray == arraySubterm) {
                        assert (new MultiDimensionalSort(baseArray.getSort()).getDimension() == projectList.size());
                        IProgramVarOrConst subArrayPvoc = this.mSubArrayManager.getSubArray(baseArrayPvoc, projectList);
                        this.mUpdatedSubarrays.add(subArrayPvoc);
                    }
                    this.enqueueWalker(new PositionAwareTermTransformer.BuildApplicationTerm((ApplicationTerm)term, pos));
                    this.enqueueWalker(new EndScope());
                    this.pushTerm(valueSubterm, pos.append(2));
                    this.enqueueWalker(new BeginScope(PartitionProjectionTermTransformer.dropFirst(projectList)));
                    this.enqueueWalker(new EndScope());
                    this.pushTerm(indexSubterm, pos.append(1));
                    this.enqueueWalker(new BeginScope(Collections.emptyList()));
                    this.enqueueWalker(new EndScope());
                    this.pushTerm(arraySubterm, pos.append(0));
                    this.enqueueWalker(new BeginScope(projectList));
                } else {
                    this.pushTerm(arraySubterm, pos.append(0));
                }
            } else {
                this.enqueueWalker(new PositionAwareTermTransformer.BuildApplicationTerm((ApplicationTerm)term, pos));
                this.pushTerms(((ApplicationTerm)term).getParameters(), pos);
            }
        } else if (term instanceof LetTerm) {
            super.convert(term, pos);
        } else if (term instanceof QuantifiedFormula) {
            super.convert(term, pos);
        } else if (term instanceof AnnotatedTerm) {
            super.convert(term, pos);
        } else {
            throw new AssertionError((Object)("Unknown Term: " + term.toStringDirect()));
        }
    }

    private List<StoreLocationBlock> append(List<StoreLocationBlock> locationBlockList, List<StoreLocationBlock> projectList) {
        ArrayList<StoreLocationBlock> result = new ArrayList<StoreLocationBlock>();
        result.addAll(locationBlockList);
        result.addAll(projectList);
        assert (PartitionProjectionTermTransformer.assertIsSortedByDimensions(result));
        return result;
    }

    static boolean isSorted(List<Integer> collect) {
        ArrayList<Integer> copy = new ArrayList<Integer>(collect);
        Collections.sort(copy);
        return collect.equals(copy);
    }

    private Term extractSimpleArrayTerm(Term term) {
        if (!term.getSort().isArraySort()) {
            throw new IllegalArgumentException();
        }
        Term currentTerm = term;
        while (SmtUtils.isFunctionApplication((Term)currentTerm, (String)"store") || SmtUtils.isFunctionApplication((Term)currentTerm, (String)"select")) {
            currentTerm = ((ApplicationTerm)currentTerm).getParameters()[0];
        }
        assert (!(currentTerm instanceof ApplicationTerm) || ((ApplicationTerm)currentTerm).getParameters().length == 0);
        return currentTerm;
    }

    private Term getSubArrayReplacementTerm(Term originalTerm, List<StoreLocationBlock> projectList) {
        IProgramVarOrConst originalTermPvoc = this.mEdgeInfo.getProgramVarOrConstForTerm(originalTerm);
        IProgramVarOrConst subArrayPv = this.mSubArrayManager.getSubArray(originalTermPvoc, projectList);
        return this.getOrConstructSubArrayTermAndUpdateInOutVarMappings(originalTerm, originalTermPvoc, subArrayPv);
    }

    private Term getOrConstructSubArrayTermAndUpdateInOutVarMappings(Term originalTerm, IProgramVarOrConst originalTermPvoc, IProgramVarOrConst subArrayPvoc) {
        Term result = (Term)this.mOriginalTermToSubArrayToReplacementTerm.get((Object)originalTerm, (Object)subArrayPvoc);
        if (result == null) {
            if (!(originalTerm instanceof TermVariable)) {
                throw new UnsupportedOperationException("TODO: if this occurs, extend below code to replace a constant term by a constant term");
            }
            result = this.mMgdScript.constructFreshTermVariable(subArrayPvoc.getGloballyUniqueId(), subArrayPvoc.getSort());
            this.mOriginalTermToSubArrayToReplacementTerm.put((Object)originalTerm, (Object)subArrayPvoc, (Object)result);
            if (subArrayPvoc instanceof IProgramVar) {
                Term origOutVarTerm;
                assert (originalTermPvoc instanceof IProgramVar);
                IProgramVar subArrayPv = (IProgramVar)subArrayPvoc;
                Term origInVarTerm = (Term)this.mEdgeInfo.getEdge().getTransformula().getInVars().get(originalTermPvoc);
                if (origInVarTerm == originalTerm) {
                    this.mNewInVars.put(subArrayPv, (TermVariable)result);
                }
                if ((origOutVarTerm = (Term)this.mEdgeInfo.getEdge().getTransformula().getOutVars().get(originalTermPvoc)) == originalTerm) {
                    this.mNewOutVars.put(subArrayPv, (TermVariable)result);
                }
            }
        }
        return result;
    }

    private boolean isPartitionedArray(Term term) {
        if (!term.getSort().isArraySort()) {
            return false;
        }
        return this.mCsiag.isArrayTermSubjectToSeparation(this.mEdgeInfo, term);
    }

    private List<Set<StoreLocationBlock>> getLocationBlocksForArrayGroup(ArrayGroup arrayGroup) {
        ArrayList<Set<StoreLocationBlock>> result = new ArrayList<Set<StoreLocationBlock>>();
        int dim = 1;
        while (dim <= arrayGroup.getDimensionality()) {
            result.add(this.mArrayGroupToDimensionToLocationBlocks.projectToTrd((Object)arrayGroup, (Object)dim));
            ++dim;
        }
        return result;
    }

    private static <E> List<E> addToFront(E locationBlockForIndex, List<E> projectList) {
        ArrayList<E> newList = new ArrayList<E>();
        newList.add(locationBlockForIndex);
        newList.addAll(projectList);
        return Collections.unmodifiableList(newList);
    }

    private static <E> List<E> dropFirst(List<E> projectList) {
        ArrayList<E> newList = new ArrayList<E>();
        newList.addAll(projectList.subList(1, projectList.size()));
        return Collections.unmodifiableList(newList);
    }

    private boolean fallsInto(SubtreePosition pos, Term storeTerm, StoreLocationBlock locationBlock) {
        assert (SmtUtils.isFunctionApplication((Term)storeTerm, (String)"store"));
        StoreInfo sii = this.mCsiag.getStoreInfoForStoreTermAtPositionInEdge(this.mEdgeInfo, pos);
        return locationBlock.contains(sii);
    }

    private void pushLocationBlockList(List<StoreLocationBlock> newList) {
        assert (Objects.nonNull(newList));
        assert (newList.stream().allMatch(Objects::nonNull));
        this.mProjectLists.push(Collections.unmodifiableList(newList));
    }

    private void popLocationBlockList() {
        this.mProjectLists.pop();
    }

    static boolean assertIsSortedByDimensions(List<StoreLocationBlock> list) {
        return PartitionProjectionTermTransformer.isSorted(list.stream().map(lb -> lb.getDimension()).collect(Collectors.toList()));
    }

    public Map<IProgramVar, TermVariable> getNewInVars() {
        if (!this.mIsFinished) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableMap(this.mNewInVars);
    }

    public Map<IProgramVar, TermVariable> getNewOutVars() {
        if (!this.mIsFinished) {
            throw new IllegalStateException();
        }
        return Collections.unmodifiableMap(this.mNewOutVars);
    }

    public void finish() {
        TermVariable freshTv;
        IProgramVar subarray;
        List<List<StoreLocationBlock>> locationBlockTuples;
        for (Map.Entry<IProgramVar, TermVariable> en : this.mEdgeInfo.getInVars().entrySet()) {
            if (this.mHeapArrays.contains(en.getKey())) continue;
            this.mNewInVars.put(en.getKey(), en.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> en : this.mEdgeInfo.getOutVars().entrySet()) {
            if (this.mHeapArrays.contains(en.getKey())) continue;
            this.mNewOutVars.put(en.getKey(), en.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> en : this.mEdgeInfo.getInVars().entrySet()) {
            if (this.mInVarsWithATermVar.contains(en.getKey()) || !this.mHeapArrays.contains(en.getKey())) continue;
            locationBlockTuples = this.getAllLocationBlockTuplesForHeapArray(this.mCsiag.getArrayGroupForArrayPvoc((IProgramVarOrConst)en.getKey()));
            for (List<StoreLocationBlock> lbt : locationBlockTuples) {
                subarray = (IProgramVar)this.mSubArrayManager.getSubArray((IProgramVarOrConst)en.getKey(), lbt);
                freshTv = this.mMgdScript.constructFreshCopy(subarray.getTermVariable());
                assert (!this.mNewInVars.containsKey(subarray));
                this.mNewInVars.put(subarray, freshTv);
            }
        }
        for (Map.Entry<IProgramVar, TermVariable> en : this.mEdgeInfo.getOutVars().entrySet()) {
            if (this.mOutVarsWithATermVar.contains(en.getKey()) || !this.mHeapArrays.contains(en.getKey())) continue;
            locationBlockTuples = this.getAllLocationBlockTuplesForHeapArray(this.mCsiag.getArrayGroupForArrayPvoc((IProgramVarOrConst)en.getKey()));
            for (List<StoreLocationBlock> lbt : locationBlockTuples) {
                subarray = (IProgramVar)this.mSubArrayManager.getSubArray((IProgramVarOrConst)en.getKey(), lbt);
                freshTv = this.mMgdScript.constructFreshCopy(subarray.getTermVariable());
                assert (!this.mNewOutVars.containsKey(subarray));
                this.mNewOutVars.put(subarray, freshTv);
            }
        }
        for (Map.Entry<IProgramVar, TermVariable> en : this.mNewInVars.entrySet()) {
            if (!this.mHeapArrays.contains(en.getKey())) continue;
            throw new IllegalStateException();
        }
        for (Map.Entry<IProgramVar, TermVariable> en : this.mNewOutVars.entrySet()) {
            if (!this.mHeapArrays.contains(en.getKey())) continue;
            throw new IllegalStateException();
        }
        this.mIsFinished = true;
    }

    private List<List<StoreLocationBlock>> getAllLocationBlockTuplesForHeapArray(ArrayGroup arrayGroup) {
        assert (arrayGroup != null && !DataStructureUtils.intersection(new HashSet<IProgramVarOrConst>(this.mHeapArrays), arrayGroup.getArrays()).isEmpty());
        List<Set<StoreLocationBlock>> locationBlocks = this.getLocationBlocksForArrayGroup(arrayGroup);
        List locationBlockTuples = CrossProducts.crossProductOfSets(locationBlocks);
        return locationBlockTuples;
    }

    public Set<IProgramVarOrConst> getUpdatedSubarrays() {
        return this.mUpdatedSubarrays;
    }

    protected static class BeginScope
    implements NonRecursive.Walker {
        private final List<StoreLocationBlock> mLocBlockList;

        public BeginScope(List<StoreLocationBlock> locBlockList) {
            assert (Objects.nonNull(locBlockList));
            assert (locBlockList.stream().allMatch(Objects::nonNull));
            assert (PartitionProjectionTermTransformer.assertIsSortedByDimensions(locBlockList));
            this.mLocBlockList = locBlockList;
        }

        public void walk(NonRecursive engine) {
            PartitionProjectionTermTransformer ttf = (PartitionProjectionTermTransformer)engine;
            ttf.beginScope();
            ttf.pushLocationBlockList(this.mLocBlockList);
        }
    }

    protected static class BuildArrayCellAccessTerm
    implements NonRecursive.Walker {
        private final Script mScript;
        private final ArrayCellAccess mArrayCellAccess;

        BuildArrayCellAccessTerm(ArrayCellAccess aca, Script script) {
            this.mArrayCellAccess = aca;
            this.mScript = script;
        }

        public void walk(NonRecursive engine) {
            PartitionProjectionTermTransformer transformer = (PartitionProjectionTermTransformer)engine;
            Term[] indexEntries = new Term[this.mArrayCellAccess.getIndex().size()];
            int i = this.mArrayCellAccess.getIndex().size() - 1;
            while (i >= 0) {
                indexEntries[i] = transformer.getConverted();
                --i;
            }
            ArrayIndex index = new ArrayIndex(Arrays.asList(indexEntries));
            Term array = transformer.getConverted();
            Term mdsTerm = new MultiDimensionalSelect(array, index, this.mScript).getSelectTerm();
            transformer.setResult(mdsTerm);
        }
    }

    protected static class BuildConjunction
    implements NonRecursive.Walker {
        int mNumberOfConjuncts;
        Script mScript;

        public BuildConjunction(int noConjuncts, Script script) {
            this.mNumberOfConjuncts = noConjuncts;
            this.mScript = script;
        }

        public void walk(NonRecursive engine) {
            PartitionProjectionTermTransformer transformer = (PartitionProjectionTermTransformer)engine;
            Term[] conjuncts = new Term[this.mNumberOfConjuncts];
            int i = 0;
            while (i < this.mNumberOfConjuncts) {
                conjuncts[i] = transformer.getConverted();
                ++i;
            }
            transformer.setResult(SmtUtils.and((Script)this.mScript, (Term[])conjuncts));
        }

        public String toString() {
            return "and\\^" + this.mNumberOfConjuncts;
        }
    }

    protected static class EndScope
    implements NonRecursive.Walker {
        protected EndScope() {
        }

        public void walk(NonRecursive engine) {
            PartitionProjectionTermTransformer ttf = (PartitionProjectionTermTransformer)engine;
            ttf.endScope();
            ttf.popLocationBlockList();
        }
    }
}

