/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.ComputeStoreInfosAndArrayGroups;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSeparatorBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.SubArrayManager;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayCellAccess;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.ArrayGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.EdgeInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SelectInfo;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.StoreLocationBlock;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PartitionProjectionTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class PartitionProjectionTransitionTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements ITransformulaTransformer {
    private final SubArrayManager mSubArrayManager;
    private final HashRelation3<ArrayGroup, Integer, StoreLocationBlock> mArrayGroupToDimensionToLocationBlocks;
    private final ComputeStoreInfosAndArrayGroups<?> mCsiag;
    private final NestedMap3<EdgeInfo, ArrayCellAccess, Integer, StoreLocationBlock> mEdgeInfoToArrayCellAccessToDimensionToLocationBlock;
    private final List<IProgramVarOrConst> mHeapArrays;
    private final HeapSeparatorBenchmark mStatistics;
    ManagedScript mMgdScript;
    DefaultIcfgSymbolTable mNewSymbolTable;
    private final ILogger mLogger;
    private final CfgSmtToolkit mOldCsToolkit;
    private final HashRelation<String, IProgramNonOldVar> mNewModifiableGlobals;

    public PartitionProjectionTransitionTransformer(ILogger logger, NestedMap2<SelectInfo, Integer, StoreLocationBlock> selectInfoToDimensionToLocationBlock, ComputeStoreInfosAndArrayGroups<?> csiag, List<IProgramVarOrConst> heapArrays, HeapSeparatorBenchmark statistics, CfgSmtToolkit inputCfgCsToolkit) {
        this.mMgdScript = inputCfgCsToolkit.getManagedScript();
        this.mOldCsToolkit = inputCfgCsToolkit;
        logger.info((Object)"executing heap partitioning transformation");
        this.mLogger = logger;
        this.mHeapArrays = heapArrays;
        this.mStatistics = statistics;
        this.mEdgeInfoToArrayCellAccessToDimensionToLocationBlock = new NestedMap3();
        this.mArrayGroupToDimensionToLocationBlocks = new HashRelation3();
        for (Triple triple : selectInfoToDimensionToLocationBlock.entrySet()) {
            this.mEdgeInfoToArrayCellAccessToDimensionToLocationBlock.put((Object)((SelectInfo)triple.getFirst()).getEdgeInfo(), (Object)((SelectInfo)triple.getFirst()).getArrayCellAccess(), (Object)((Integer)triple.getSecond()), (Object)((StoreLocationBlock)triple.getThird()));
            Integer dim = (Integer)triple.getSecond();
            assert (dim.intValue() == ((StoreLocationBlock)triple.getThird()).getDimension());
            this.mArrayGroupToDimensionToLocationBlocks.addTriple((Object)((SelectInfo)triple.getFirst()).getArrayGroup(), (Object)dim, (Object)((StoreLocationBlock)triple.getThird()));
        }
        this.mSubArrayManager = new SubArrayManager(inputCfgCsToolkit, this.mStatistics, csiag);
        this.mCsiag = csiag;
        this.mNewSymbolTable = new DefaultIcfgSymbolTable();
        this.mNewModifiableGlobals = new HashRelation((AbstractRelation)this.mOldCsToolkit.getModifiableGlobalsTable().getProcToGlobals());
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> oldEdge, UnmodifiableTransFormula tf) {
        EdgeInfo edgeInfo = new EdgeInfo((IcfgEdge)oldEdge);
        NestedMap2 arrayCellAccessToDimensionToLocationBlock = this.mEdgeInfoToArrayCellAccessToDimensionToLocationBlock.get((Object)edgeInfo);
        PartitionProjectionTermTransformer partitionProjectionTermTransformer = new PartitionProjectionTermTransformer(this.mLogger, this.mMgdScript, this.mSubArrayManager, (NestedMap2<ArrayCellAccess, Integer, StoreLocationBlock>)arrayCellAccessToDimensionToLocationBlock, edgeInfo, this.mArrayGroupToDimensionToLocationBlocks, this.mCsiag, this.mHeapArrays);
        Term transformedFormulaRaw = partitionProjectionTermTransformer.transform(tf.getFormula());
        partitionProjectionTermTransformer.finish();
        IdentityHashMap<Term, Term> substitutionMapping = new IdentityHashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : partitionProjectionTermTransformer.getNewOutVars().entrySet()) {
            if (!this.mSubArrayManager.isSubArray(entry.getKey()) || partitionProjectionTermTransformer.getUpdatedSubarrays().contains(entry.getKey())) continue;
            TermVariable inTv = partitionProjectionTermTransformer.getNewInVars().get(entry.getKey());
            TermVariable outTv = entry.getValue();
            assert (outTv != null);
            if (inTv == null || inTv.equals(outTv)) continue;
            Term eq1 = this.mMgdScript.getScript().term("=", new Term[]{inTv, outTv});
            substitutionMapping.put(eq1, this.mMgdScript.getScript().term("true", new Term[0]));
            Term eq2 = this.mMgdScript.getScript().term("=", new Term[]{outTv, inTv});
            substitutionMapping.put(eq2, this.mMgdScript.getScript().term("true", new Term[0]));
        }
        Term transformedFormula = Substitution.apply((ManagedScript)this.mMgdScript, substitutionMapping, (Term)transformedFormulaRaw);
        HashMap<IProgramVar, TermVariable> inVars = new HashMap<IProgramVar, TermVariable>(partitionProjectionTermTransformer.getNewInVars());
        for (Map.Entry<IProgramVar, TermVariable> entry : partitionProjectionTermTransformer.getNewInVars().entrySet()) {
            if (!this.mSubArrayManager.isSubArray(entry.getKey()) || Arrays.asList(transformedFormula.getFreeVars()).contains(entry.getValue())) continue;
            inVars.remove(entry.getKey());
        }
        HashMap<IProgramVar, TermVariable> outVars = new HashMap<IProgramVar, TermVariable>(partitionProjectionTermTransformer.getNewOutVars());
        for (Map.Entry<IProgramVar, TermVariable> entry : partitionProjectionTermTransformer.getNewOutVars().entrySet()) {
            if (!this.mSubArrayManager.isSubArray(entry.getKey()) || Arrays.asList(transformedFormula.getFreeVars()).contains(entry.getValue())) continue;
            outVars.remove(entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : inVars.entrySet()) {
            if (!this.mSubArrayManager.isSubArray((IProgramVar)entry.getKey()) || outVars.containsKey(entry.getKey())) continue;
            outVars.put((IProgramVar)entry.getKey(), (TermVariable)entry.getValue());
        }
        for (Map.Entry entry : inVars.entrySet()) {
            if (entry.getKey() instanceof IProgramOldVar) continue;
            this.mNewSymbolTable.add((IProgramVarOrConst)entry.getKey());
        }
        for (Map.Entry entry : outVars.entrySet()) {
            if (entry.getKey() instanceof IProgramOldVar) continue;
            this.mNewSymbolTable.add((IProgramVarOrConst)entry.getKey());
            if (!oldEdge.getPrecedingProcedure().equals(oldEdge.getSucceedingProcedure()) || !(entry.getKey() instanceof IProgramNonOldVar) || ((TermVariable)entry.getValue()).equals(inVars.get(entry.getKey()))) continue;
            this.mNewModifiableGlobals.addPair((Object)oldEdge.getPrecedingProcedure(), (Object)((IProgramNonOldVar)entry.getKey()));
        }
        for (IProgramConst iProgramConst : tf.getNonTheoryConsts()) {
            this.mNewSymbolTable.add((IProgramVarOrConst)iProgramConst);
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(inVars, outVars, tf.getNonTheoryConsts().isEmpty(), tf.getNonTheoryConsts(), tf.getBranchEncoders().isEmpty(), (Collection)tf.getBranchEncoders(), tf.getAuxVars().isEmpty());
        transFormulaBuilder.setFormula(transformedFormula);
        transFormulaBuilder.setInfeasibility(tf.isInfeasible());
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(tf.getAuxVars(), this.mMgdScript);
        UnmodifiableTransFormula newTransformula = transFormulaBuilder.finishConstruction(this.mMgdScript);
        assert (oldEdge.getPrecedingProcedure().equals(oldEdge.getSucceedingProcedure()) || newTransformula.getAssignedVars().stream().allMatch(pv -> pv instanceof ILocalProgramVar)) : "how to deal with a call or return transition that modifies a global variable??";
        this.log(tf, newTransformula);
        return new ITransformulaTransformer.TransformulaTransformationResult(newTransformula);
    }

    @Override
    public void preprocessIcfg(IIcfg<?> icfg) {
    }

    @Override
    public String getName() {
        return "HeapPartitionedCfg";
    }

    @Override
    public IIcfgSymbolTable getNewIcfgSymbolTable() {
        return this.mNewSymbolTable;
    }

    private void log(UnmodifiableTransFormula oldTf, UnmodifiableTransFormula newTf) {
        if (!this.mLogger.isDebugEnabled()) {
            return;
        }
        boolean formulaHasChanged = !oldTf.getFormula().equals(newTf.getFormula());
        boolean inVarsHaveChanged = !oldTf.getInVars().equals(newTf.getInVars());
        boolean outVarsHaveChanged = !oldTf.getOutVars().equals(newTf.getOutVars());
        this.mLogger.debug((Object)"transformed transition");
        this.mLogger.debug((Object)("\t " + newTf));
        if (!(formulaHasChanged || inVarsHaveChanged || outVarsHaveChanged)) {
            this.mLogger.debug((Object)"\t transformula unchanged");
        }
        if (formulaHasChanged) {
            this.mLogger.debug((Object)"\t formula has changed");
            this.mLogger.debug((Object)"\t old formula:");
            this.mLogger.debug((Object)oldTf.getFormula());
            this.mLogger.debug((Object)"\t new formula:");
            this.mLogger.debug((Object)newTf.getFormula());
        }
        if (inVarsHaveChanged) {
            this.mLogger.debug((Object)"\t invars have changed");
            this.mLogger.debug((Object)"\t old invars:");
            this.mLogger.debug((Object)oldTf.getInVars());
            this.mLogger.debug((Object)"\t new invars:");
            this.mLogger.debug((Object)newTf.getInVars());
        }
        if (outVarsHaveChanged) {
            this.mLogger.debug((Object)"\t outvars have changed");
            this.mLogger.debug((Object)"\t old outvars:");
            this.mLogger.debug((Object)oldTf.getOutVars());
            this.mLogger.debug((Object)"\t new outvars:");
            this.mLogger.debug((Object)newTf.getOutVars());
        }
        this.mLogger.debug((Object)"");
    }

    @Override
    public HashRelation<String, IProgramNonOldVar> getNewModifiedGlobals() {
        return this.mNewModifiableGlobals;
    }
}

