/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers.PositionAwareTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PositionAwareSubstitution
extends PositionAwareTermTransformer {
    private final ScopedHashMap<SubtreePosition, Term> mScopedPositionSubstitutionMapping = new ScopedHashMap();
    private final ScopedHashMap<Term, Term> mScopedTermSubstitutionMapping;

    public PositionAwareSubstitution(Script script, Map<? extends SubtreePosition, ? extends Term> positionSubstitution, Map<Term, Term> termSubstitution) {
        this.mScopedPositionSubstitutionMapping.putAll(positionSubstitution);
        this.mScopedTermSubstitutionMapping = new ScopedHashMap();
        this.mScopedTermSubstitutionMapping.putAll(termSubstitution);
    }

    public PositionAwareSubstitution(ManagedScript mgdScript, Map<? extends SubtreePosition, ? extends Term> positionSubstitution, Map<Term, Term> termSubstitution) {
        this(mgdScript.getScript(), positionSubstitution, termSubstitution);
    }

    public PositionAwareSubstitution(Script script, Map<? extends SubtreePosition, ? extends Term> positionBasedSubstitution) {
        this(script, positionBasedSubstitution, Collections.emptyMap());
    }

    public PositionAwareSubstitution(ManagedScript mgdScript, Map<? extends SubtreePosition, ? extends Term> positionBasedSubstitution) {
        this(mgdScript, positionBasedSubstitution, Collections.emptyMap());
    }

    @Override
    protected void convert(Term term, SubtreePosition pos) {
        if (this.mScopedPositionSubstitutionMapping.containsKey((Object)pos)) {
            this.setResult((Term)this.mScopedPositionSubstitutionMapping.get((Object)pos));
        } else if (this.mScopedTermSubstitutionMapping.containsKey((Object)term)) {
            this.setResult((Term)this.mScopedTermSubstitutionMapping.get((Object)term));
        } else {
            if (term instanceof QuantifiedFormula) {
                this.mScopedPositionSubstitutionMapping.beginScope();
                this.mScopedTermSubstitutionMapping.beginScope();
                throw new UnsupportedOperationException("quantified formulas are not yet supported by this class");
            }
            if (term instanceof LetTerm) {
                throw new UnsupportedOperationException("LetTerm not supported");
            }
            super.convert(term, pos);
        }
    }

    private Term renameQuantifiedVarsThatOccurInValues(QuantifiedFormula qFormula) {
        DataStructureUtils.union(PositionAwareSubstitution.varsOccuringInValues(qFormula.getVariables(), this.mScopedPositionSubstitutionMapping), PositionAwareSubstitution.varsOccuringInValues(qFormula.getVariables(), this.mScopedTermSubstitutionMapping));
        throw new UnsupportedOperationException("quantified formulas are not yet supported by this class");
    }

    private void removeQuantifiedVarContainingKeys(QuantifiedFormula qFormula) {
        throw new UnsupportedOperationException("quantified formulas are not yet supported by this class");
    }

    private static Set<TermVariable> varsOccuringInValues(TermVariable[] vars, Map<?, Term> map) {
        Set<TermVariable> result = null;
        for (Term term : map.values()) {
            TermVariable[] termVariableArray = term.getFreeVars();
            int n = termVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable tv = termVariableArray[n2];
                if (Arrays.asList(vars).contains(tv)) {
                    result = PositionAwareSubstitution.addToSet(tv, result);
                }
                ++n2;
            }
        }
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    private static Set<TermVariable> addToSet(TermVariable tv, Set<TermVariable> set) {
        if (set == null) {
            set = new HashSet<TermVariable>();
        }
        set.add(tv);
        return set;
    }

    @Override
    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        throw new UnsupportedOperationException("quantified formulas are not yet supported by this class");
    }

    public String toString() {
        return "Substitution " + this.mScopedPositionSubstitutionMapping.toString();
    }

    public List<Term> transform(List<Term> terms) {
        ArrayList<Term> result = new ArrayList<Term>();
        for (Term term : terms) {
            result.add(this.transform(term));
        }
        return result;
    }
}

