/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.transformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.datastructures.SubtreePosition;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;
import java.util.Arrays;

class PositionAwareTermTransformer
extends NonRecursive {
    private final ArrayDeque<Term> mConverted = new ArrayDeque();

    PositionAwareTermTransformer() {
    }

    protected final void pushTerms(Term[] terms, SubtreePosition pos) {
        int i = terms.length - 1;
        while (i >= 0) {
            this.pushTerm(terms[i], pos.append(i));
            --i;
        }
    }

    protected final void pushTerm(Term term, SubtreePosition pos) {
        this.enqueueWalker(new Convert(term, pos));
    }

    protected final void setResult(Term term) {
        this.mConverted.addLast(term);
    }

    protected void convert(Term term, SubtreePosition pos) {
        if (term instanceof ConstantTerm || term instanceof TermVariable) {
            this.mConverted.addLast(term);
        } else if (term instanceof ApplicationTerm) {
            this.enqueueWalker(new BuildApplicationTerm((ApplicationTerm)term, pos));
            this.pushTerms(((ApplicationTerm)term).getParameters(), pos);
        } else if (term instanceof LetTerm) {
            this.enqueueWalker(new StartLetTerm((LetTerm)term, pos));
            this.pushTerms(((LetTerm)term).getValues(), pos);
        } else if (term instanceof QuantifiedFormula) {
            this.enqueueWalker(new BuildQuantifier((QuantifiedFormula)term, pos));
            this.pushTerm(((QuantifiedFormula)term).getSubformula(), pos.append(0));
            this.beginScope();
        } else {
            if (term instanceof AnnotatedTerm) {
                AnnotatedTerm annterm = (AnnotatedTerm)term;
                this.enqueueWalker(new BuildAnnotation(annterm, pos));
                Annotation[] annots = annterm.getAnnotations();
                int i = annots.length - 1;
                while (i >= 0) {
                    Object value = annots[i].getValue();
                    if (value instanceof Term) {
                        this.pushTerm((Term)value, pos.append(i));
                    } else if (value instanceof Term[]) {
                        this.pushTerms((Term[])value, pos.append(i));
                    }
                    --i;
                }
                this.pushTerm(annterm.getSubterm(), pos.append(annots.length));
                return;
            }
            throw new AssertionError((Object)("Unknown Term: " + term.toStringDirect()));
        }
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs, SubtreePosition pos) {
        ApplicationTerm newTerm = appTerm;
        if (newArgs != appTerm.getParameters()) {
            FunctionSymbol fun = appTerm.getFunction();
            Theory theory = fun.getTheory();
            Sort[] paramTypes = new Sort[newArgs.length];
            int i = 0;
            while (i < newArgs.length) {
                paramTypes[i] = newArgs[i].getSort();
                ++i;
            }
            FunctionSymbol newFun = theory.getFunction(fun.getName(), paramTypes);
            assert (newFun != null) : "could not find an instance for the polymorphic function";
            newTerm = theory.term(newFun, newArgs);
        }
        this.setResult((Term)newTerm);
    }

    public void preConvertLet(LetTerm oldLet, Term[] newValues, SubtreePosition pos) {
        this.beginScope();
        this.enqueueWalker(new BuildLetTerm(oldLet, newValues, pos));
        this.pushTerm(oldLet.getSubTerm(), pos);
    }

    public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
        LetTerm result = oldLet;
        if (oldLet.getValues() != newValues || oldLet.getSubTerm() != newBody) {
            result = oldLet.getTheory().let(oldLet.getVariables(), newValues, newBody);
        }
        this.setResult((Term)result);
    }

    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        QuantifiedFormula newFormula = old;
        if (newBody != old.getSubformula()) {
            Theory theory = old.getTheory();
            TermVariable[] vars = old.getVariables();
            newFormula = old.getQuantifier() == 0 ? theory.exists(vars, newBody) : theory.forall(vars, newBody);
        }
        this.setResult((Term)newFormula);
    }

    public void postConvertAnnotation(AnnotatedTerm old, Annotation[] newAnnots, Term newBody) {
        Annotation[] annots = old.getAnnotations();
        AnnotatedTerm result = old;
        if (newBody != old.getSubterm() || newAnnots != annots) {
            result = old.getTheory().annotatedTerm(newAnnots, newBody);
        }
        this.setResult((Term)result);
    }

    protected void beginScope() {
    }

    protected void endScope() {
    }

    public final Term transform(Term term) {
        this.beginScope();
        this.run(new Convert(term, new SubtreePosition()));
        this.endScope();
        return this.mConverted.removeLast();
    }

    protected final Term getConverted() {
        return this.mConverted.removeLast();
    }

    protected final Term[] getConverted(Term[] oldArgs) {
        Term[] newArgs = oldArgs;
        int i = oldArgs.length - 1;
        while (i >= 0) {
            Term newTerm = this.getConverted();
            if (newTerm != oldArgs[i]) {
                if (newArgs == oldArgs) {
                    newArgs = (Term[])oldArgs.clone();
                }
                newArgs[i] = newTerm;
            }
            --i;
        }
        return newArgs;
    }

    public void reset() {
        super.reset();
        this.mConverted.clear();
    }

    protected static class BuildAnnotation
    implements NonRecursive.Walker {
        private final AnnotatedTerm mAnnotatedTerm;
        private final SubtreePosition mPos;

        public BuildAnnotation(AnnotatedTerm term, SubtreePosition pos) {
            this.mAnnotatedTerm = term;
            this.mPos = pos;
        }

        public void walk(NonRecursive engine) {
            Annotation[] annots;
            PositionAwareTermTransformer transformer = (PositionAwareTermTransformer)engine;
            Annotation[] newAnnots = annots = this.mAnnotatedTerm.getAnnotations();
            int i = annots.length - 1;
            while (i >= 0) {
                Object value = annots[i].getValue();
                Object newValue = value instanceof Term ? transformer.getConverted() : (value instanceof Term[] ? transformer.getConverted((Term[])value) : value);
                if (newValue != value) {
                    if (annots == newAnnots) {
                        newAnnots = (Annotation[])annots.clone();
                    }
                    newAnnots[i] = new Annotation(annots[i].getKey(), newValue);
                }
                --i;
            }
            Term sub = transformer.getConverted();
            transformer.postConvertAnnotation(this.mAnnotatedTerm, newAnnots, sub);
        }

        public String toString() {
            return "annotate";
        }
    }

    protected static class BuildApplicationTerm
    implements NonRecursive.Walker {
        private final ApplicationTerm mAppTerm;
        private final SubtreePosition mPos;

        public BuildApplicationTerm(ApplicationTerm term, SubtreePosition pos) {
            this.mAppTerm = term;
            this.mPos = pos;
        }

        public void walk(NonRecursive engine) {
            PositionAwareTermTransformer transformer = (PositionAwareTermTransformer)engine;
            Term[] oldArgs = this.mAppTerm.getParameters();
            Term[] newArgs = transformer.getConverted(oldArgs);
            transformer.convertApplicationTerm(this.mAppTerm, newArgs, this.mPos);
        }

        public String toString() {
            return this.mAppTerm.getFunction().getApplicationString();
        }
    }

    protected static class BuildLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;
        private final Term[] mNewValues;
        private final SubtreePosition mPos;

        public BuildLetTerm(LetTerm term, Term[] newValues, SubtreePosition pos) {
            this.mLetTerm = term;
            this.mNewValues = newValues;
            this.mPos = pos;
        }

        public void walk(NonRecursive engine) {
            PositionAwareTermTransformer transformer = (PositionAwareTermTransformer)engine;
            Term newBody = transformer.getConverted();
            transformer.postConvertLet(this.mLetTerm, this.mNewValues, newBody);
            transformer.endScope();
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }

    protected static class BuildQuantifier
    implements NonRecursive.Walker {
        private final QuantifiedFormula mQuant;
        private final SubtreePosition mPos;

        public BuildQuantifier(QuantifiedFormula term, SubtreePosition pos) {
            this.mQuant = term;
            this.mPos = pos;
        }

        public void walk(NonRecursive engine) {
            PositionAwareTermTransformer transformer = (PositionAwareTermTransformer)engine;
            Term sub = transformer.getConverted();
            transformer.postConvertQuantifier(this.mQuant, sub);
            transformer.endScope();
        }

        public String toString() {
            return this.mQuant.getQuantifier() == 0 ? "exists" : "forall";
        }
    }

    private static class Convert
    implements NonRecursive.Walker {
        private final Term mTerm;
        private final SubtreePosition mPos;

        public Convert(Term term, SubtreePosition pos) {
            this.mTerm = term;
            this.mPos = pos;
        }

        public String toString() {
            return "Convert " + this.mTerm.toStringDirect();
        }

        public void walk(NonRecursive walker) {
            ((PositionAwareTermTransformer)walker).convert(this.mTerm, this.mPos);
        }
    }

    protected static class StartLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;
        private final SubtreePosition mPos;

        public StartLetTerm(LetTerm term, SubtreePosition pos) {
            this.mLetTerm = term;
            this.mPos = pos;
        }

        public void walk(NonRecursive engine) {
            PositionAwareTermTransformer transformer = (PositionAwareTermTransformer)engine;
            Term[] values = transformer.getConverted(this.mLetTerm.getValues());
            transformer.preConvertLet(this.mLetTerm, values, this.mPos);
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }
}

