/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.Objects;

public class CopyingTransformulaTransformer
implements ITransformulaTransformer {
    private final ILogger mLogger;
    private final ManagedScript mManagedScript;
    private final IIcfgSymbolTable mOldSymbolTable;
    private final ModifiableGlobalsTable mOldModifiableGlobalsTable;

    public CopyingTransformulaTransformer(ILogger logger, ManagedScript managedScript, CfgSmtToolkit oldToolkit) {
        this.mLogger = logger;
        this.mManagedScript = Objects.requireNonNull(managedScript);
        this.mOldSymbolTable = oldToolkit.getSymbolTable();
        this.mOldModifiableGlobalsTable = oldToolkit.getModifiableGlobalsTable();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ITransformulaTransformer.TransformulaTransformationResult transform(IIcfgTransition<? extends IcfgLocation> oldEdge, UnmodifiableTransFormula tf) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Creating copy for " + tf));
        }
        return new ITransformulaTransformer.TransformulaTransformationResult(TransFormulaBuilder.constructCopy((ManagedScript)this.mManagedScript, (TransFormula)tf, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap()));
    }

    @Override
    public IIcfgSymbolTable getNewIcfgSymbolTable() {
        return this.mOldSymbolTable;
    }

    @Override
    public void preprocessIcfg(IIcfg<?> icfg) {
    }

    @Override
    public HashRelation<String, IProgramNonOldVar> getNewModifiedGlobals() {
        return this.mOldModifiableGlobalsTable.getProcToGlobals();
    }
}

