/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.Arrays;

public class LoopAccelerationUtils {
    private LoopAccelerationUtils() {
    }

    public static boolean checkSomePropertiesOfLoopAccelerationFormula(IUltimateServiceProvider services, ManagedScript mgdScript, UnmodifiableTransFormula loopTransFormula, UnmodifiableTransFormula accelerationResult, boolean isAlsoReflexive) {
        UnmodifiableTransFormula negated;
        Script.LBool lbool;
        UnmodifiableTransFormula and;
        ILogger logger = services.getLoggingService().getLogger(LoopAccelerationUtils.class);
        mgdScript.getScript().echo(new QuotedObject("Check if formula equivalent to false"));
        if (Util.checkSat((Script)mgdScript.getScript(), (Term)accelerationResult.getClosedFormula()) == Script.LBool.UNSAT) {
            logger.warn((Object)"Reflexive-transitive closure is equivalent to false");
        }
        UnmodifiableTransFormula neg = TransFormulaUtils.negate((UnmodifiableTransFormula)accelerationResult, (ManagedScript)mgdScript, (IUltimateServiceProvider)services);
        if (isAlsoReflexive) {
            and = TransFormulaUtils.intersect((ManagedScript)mgdScript, (UnmodifiableTransFormula[])new UnmodifiableTransFormula[]{loopTransFormula, neg});
            lbool = Util.checkSat((Script)mgdScript.getScript(), (Term)and.getClosedFormula());
            if (lbool == Script.LBool.SAT) {
                throw new AssertionError((Object)"Not reflexive");
            }
            if (lbool == Script.LBool.UNKNOWN) {
                logger.warn((Object)"Insufficient resources to check reflexivity");
            }
        }
        and = TransFormulaUtils.intersect((ManagedScript)mgdScript, (UnmodifiableTransFormula[])new UnmodifiableTransFormula[]{loopTransFormula, neg});
        lbool = Util.checkSat((Script)mgdScript.getScript(), (Term)and.getClosedFormula());
        if (lbool == Script.LBool.SAT) {
            throw new AssertionError((Object)"Input relation is not a subset of the result");
        }
        if (lbool == Script.LBool.UNKNOWN) {
            logger.warn((Object)"Insufficient resources to check whether input relation is a subset of the result");
        }
        UnmodifiableTransFormula loop2 = TransFormulaUtils.sequentialComposition((ILogger)logger, (IUltimateServiceProvider)services, (ManagedScript)mgdScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, Arrays.asList(loopTransFormula, loopTransFormula));
        UnmodifiableTransFormula and2 = TransFormulaUtils.intersect((ManagedScript)mgdScript, (UnmodifiableTransFormula[])new UnmodifiableTransFormula[]{loop2, neg});
        Script.LBool lbool2 = Util.checkSat((Script)mgdScript.getScript(), (Term)and2.getClosedFormula());
        if (lbool2 == Script.LBool.SAT) {
            throw new AssertionError((Object)"Concatenation of input relation with itself is not a subset of the result");
        }
        if (lbool2 == Script.LBool.UNKNOWN) {
            logger.warn((Object)"Insufficient resources to check whether concatenation of input relation with itself is a subset of the result");
        }
        UnmodifiableTransFormula guardedHavoc = TransFormulaUtils.computeGuardedHavoc((UnmodifiableTransFormula)loopTransFormula, (ManagedScript)mgdScript, (IUltimateServiceProvider)services, (boolean)true);
        if (isAlsoReflexive) {
            UnmodifiableTransFormula reflexiveClosure = TransFormulaBuilder.getTrivialTransFormula((ManagedScript)mgdScript);
            UnmodifiableTransFormula guardedHavocOrReflexiveClosure = TransFormulaUtils.parallelComposition((ILogger)logger, (IUltimateServiceProvider)services, (ManagedScript)mgdScript, null, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (boolean)false, (UnmodifiableTransFormula[])new UnmodifiableTransFormula[]{guardedHavoc, reflexiveClosure});
            negated = TransFormulaUtils.negate((UnmodifiableTransFormula)guardedHavocOrReflexiveClosure, (ManagedScript)mgdScript, (IUltimateServiceProvider)services);
        } else {
            negated = TransFormulaUtils.negate((UnmodifiableTransFormula)guardedHavoc, (ManagedScript)mgdScript, (IUltimateServiceProvider)services);
        }
        UnmodifiableTransFormula and3 = TransFormulaUtils.intersect((ManagedScript)mgdScript, (UnmodifiableTransFormula[])new UnmodifiableTransFormula[]{accelerationResult, negated});
        Script.LBool lbool3 = Util.checkSat((Script)mgdScript.getScript(), (Term)and3.getClosedFormula());
        if (lbool3 == Script.LBool.SAT) {
            throw new AssertionError((Object)"Result is not a subset of the input relation's guarded havoc");
        }
        if (lbool3 == Script.LBool.UNKNOWN) {
            logger.warn((Object)"Insufficient resources to check whether result is a subset of the input relation's guarded havoc");
        }
        return true;
    }
}

